c
c
      subroutine getifa (ifail)
c
c action: adjust ifail, etc.
c author: w.g.bardsley, university of manchester, u.k., 24/02/2005
c         25/01/2011 creates nagifail.txt in ...\My Documents\Simfit\res
c
c         This routine is called on entry to every simfit NAG type
c         routine before any action is taken to call true NAG code.
c         So, by editing this subroutine, virtually any type of error
c         message output can be generated from NAG, as follows:
c
c         idfolt = default ifail entry value
c         iounit = error/message output unit
c          fname = error/message file
c
c         note: simfit uses units 3, 4 all the time and 10 to 100
c               some of the time. The optimisation and DE solving
c               simfit routines use units 5 and 6 for monitoring.
c               Hence iounit = 101 as the default.
c               Further, iounit cannot be used for write after the
c               call to x04acf as ftn95 does not recognise it as
c               connected.
c
c
      implicit   none
c
c argument: ifail (input/output)
c
      integer    ifail
c
c locals
c
      integer*2  error_code
      integer    csidl, k
      integer    ierr, iflag, nadv, nerr
      integer    idfolt, iounit, mode
      parameter (idfolt = -1, iounit = 101, mode = 1)
      character  csidl_path*1024, full_path*1024
      character  fname*12
      parameter (fname = 'nagifail.txt')
      character  blank*1, bslash*1 
      parameter (blank = ' ', bslash = '\')
      logical    first
      external   x04aaf, x04abf, x04acf
      
      external   mkdir@
      STDCALL mydoc 'SHGetSpecialFolderPathA' (VAL, OUTSTRING(1024),
     +VAL, VAL): LOGICAL 
      intrinsic  leng
c
c make absolutely sure that first is saved
c
      save       first
      data       first / .true. /
c
c initialise ifail every time
c
      ifail = idfolt
c
c rest of code only executed first time
c
      if (first) then
        
         first = .false.
         
         csidl = 5
         call mydoc (0, csidl_path, csidl, 0)
         k = leng(csidl_path)
         if (k.gt.0) then
            if (csidl_path(k:k).eq.bslash) then
               csidl_path(k:k) = blank
               k = k - 1
            endif   
         endif   
         if (k.le.0) then
            full_path = fname
         else   
            csidl_path(k + 1:k + 7) = '\Simfit'
            k = k + 7
            call mkdir@(csidl_path, error_code)
            csidl_path(k + 1:k + 4) = '\res'
            k = k + 4
            call mkdir@(csidl_path, error_code)
            full_path = csidl_path(1:k)//bslash//fname
         endif
         
         
c
c try to open message file
c
         ierr = 0
         call x04acf (iounit, full_path, mode, ierr)
c
c divert all output to message file by setting nerr = nadv = iounit
c
         iflag = 1
         nerr = iounit
         call x04aaf (iflag, nerr)
         iflag = 1
         nadv = iounit
         call x04abf (iflag, nadv)
      endif
      end
c
c
