
c action: replacement C05 subroutines for mark25
c author: w.g.bardsley, university of manchester, u.k., 10/07/2016 

c c05adf$
c

C
C
      SUBROUTINE C05ADF$(A, B, EPS, ETA, F, X, IFAIL)
C
C ACTION : use C05AZF$ to solve F = 0
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/8/97
C          10/07/2016 replaced C05AZF$ by C05AZF for NAG version at mark 25
C
      IMPLICIT NONE
      INTEGER  IFAIL
      INTEGER  IND, IR
      DOUBLE PRECISION A, B, EPS, ETA, X
      DOUBLE PRECISION ABSFX, FA, FB
      DOUBLE PRECISION F
      DOUBLE PRECISION C(17), FX, Y
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL  F, C05AZF
      INTRINSIC ABS
C
C check input parameters
C
      IFAIL = 0
      FA = F(A)
      ABSFX = ABS(FA)
      IF (ABSFX.LE.ETA .OR. ABSFX.LE.ZERO) THEN
         X = A
         RETURN
      ENDIF
      FB = F(B)
      ABSFX = ABS(FB)
      IF (ABSFX.LE.ETA .OR. ABSFX.LE.ZERO) THEN
         X = B
         RETURN
      ENDIF
      IF (ABS(A - B).LE.ZERO .OR. EPS.LE.ZERO .OR. FA*FB.GT.ZERO) THEN
         IFAIL = 1
         RETURN
      ENDIF
      C(1) = FA
      X = B
      Y = A
      FX = FB
      IFAIL = 1
      IR = 1
      IND = - 1
   20 CONTINUE
      CALL C05AZF (X, Y, FX, EPS, IR, C, IND, IFAIL)
      IF (IND.EQ.0) GOTO 40
      FX = F(X)
      ABSFX = ABS(FX)
      IF (ABSFX.GE.ETA .AND. ABSFX.GT.ZERO) GO TO 20
      IFAIL = 0
   40 CONTINUE
      IF (IFAIL.EQ.1 .OR. IFAIL.EQ.2 .OR. IFAIL.EQ.3) THEN
         IFAIL = 4
      ELSEIF (IFAIL.EQ.4) THEN
         IFAIL = 3
      ELSEIF (IFAIL.EQ.5) THEN
         IFAIL = 2
      ENDIF
      END
C
C
      