C
C This routine allows QNFIT, DEQSOL, and MAKDAT to use the D02 integrators
C DTOL is copied into TOL as D02 routines can change TOL
C
      SUBROUTINE D02WGB (MSSAGE,
     +                   X, XEND, N, Y, FCN, PEDERV, DTOL, RELABS,
     +                   OUTPUT, W, IW, IFAIL)
      IMPLICIT NONE
      INTEGER  N, IW, IFAIL
      DOUBLE PRECISION X, XEND, Y(N), DTOL, W(IW)
      DOUBLE PRECISION TOL
      CHARACTER (LEN = *) MSSAGE, RELABS
      EXTERNAL FCN, PEDERV, OUTPUT
      EXTERNAL D02CJW, D02EJW, D02EJY
      EXTERNAL D02CJF, D02EJF
      EXTERNAL GETIFA
      CALL GETIFA (IFAIL) 
      TOL = DTOL
      IF (MSSAGE.EQ.'D02CJF') THEN
         CALL D02CJF (X, XEND, N, Y, FCN, TOL, RELABS,
     +                OUTPUT, D02CJW, W, IFAIL)
      ELSEIF (MSSAGE.EQ.'D02EJF_FINITE') THEN
         CALL D02EJF (X, XEND, N, Y, FCN, D02EJY, TOL, RELABS,
     +                OUTPUT, D02EJW, W, IW, IFAIL)
      ELSE
         CALL D02EJF (X, XEND, N, Y, FCN, PEDERV, TOL, RELABS,
     +                OUTPUT, D02EJW, W, IW, IFAIL)
      ENDIF  
      END
C
C
