c
c 13/11/2014 program to check f02_mark23
c
c      program    main
c      implicit   none
c      integer    i, ia, ib, itype, j, ldvi, ldvr, ifail, lwork, n
c      parameter (ia = 100, ib = 100, ldvi = 100, ldvr = 100, 
c     +           lwork = 6400)
c      integer    intgr(ia)
c      double precision a(ia,ia), b(ib,ib), rr(ia), ri(ia), w(ia)
c      double precision vi(ldvi,10), vr(ldvr,10), work(lwork)
c      external   f02aaf$, f02aff$, f02ebf$, f02fdf$
c
c f02aaf$
c      
c      n = 4
c      a(1,1) =   0.5d+00
c      a(1,2) =   0.0d+00
c      a(1,3) =   2.3d+00
c      a(1,4) =  -2.6d+00
c      a(2,1) =   0.0d+00
c      a(2,2) =   0.5d+00
c      a(2,3) =  -1.4d+00
c      a(2,4) =  -0.7d+00
c      a(3,1) =   2.3d+00
c      a(3,2) =  -1.4d+00
c      a(3,3) =   0.5d+00
c      a(3,4) =   0.0d+00
c      a(4,1) =  -2.6d+00
c      a(4,2) =  -0.7d+00
c      a(4,3) =   0.0d+00
c      a(4,4) =   0.5d+00
c      ifail = 1
c      call f02aaf$ (a, ia, n, rr, w, ifail)
c      write (*,'(a,i6)') 'from f02aaf$ ifail =', ifail
c      do i = 1, n
c         write (*,'(f8.4)') rr(i)
c      enddo 
c      write (*,'(a)') '......'  
c
c f02aff$
c      
c      n = 4
c      a(1,1) =   1.5d+00
c      a(1,2) =   0.1d+00
c      a(1,3) =   4.5d+00
c      a(1,4) =  -1.5d+00
c      a(2,1) = -22.5d+00
c      a(2,2) =   3.5d+00
c      a(2,3) =  12.5d+00
c      a(2,4) =  -2.5d+00
c      a(3,1) =  -2.5d+00
c      a(3,2) =   0.3d+00
c      a(3,3) =  4.5d+00
c      a(3,4) = -2.5d+00
c      a(4,1) = -2.5d+00
c      a(4,2) =  0.1d+00
c      a(4,3) =  4.5d+00
c      a(4,4) =  2.5d+00
c      ifail = 1
c      call f02aff$ (a, ia, n, rr, ri, intgr, ifail)  
c      write (*,'(a,i6)') 'from f02aff$ ifail =', ifail
c      do i = 1, n
c         write (*,'(2f8.4)') rr(i), ri(i)
c      enddo 
c      write (*,'(a)') '......'  
c
c f02ebf$
c
c      n = 4
c      a(1,1) =   0.35d+00
c      a(1,2) =   0.45d+00
c      a(1,3) =  -0.14d+00
c      a(1,4) =  -0.17d+00
c      a(2,1) =   0.09d+00
c      a(2,2) =   0.07d+00
c      a(2,3) =  -0.54d+00
c      a(2,4) =   0.35d+00
c      a(3,1) =  -0.44d+00
c      a(3,2) =  -0.33d+00
c      a(3,3) =  -0.03d+00
c      a(3,4) =   0.17d+00
c      a(4,1) =   0.25d+00
c      a(4,2) =  -0.32d+00
c      a(4,3) =  -0.13d+00
c      a(4,4) =   0.11d+00
c      ifail = 1
c      call f02ebf$ ('V', n, a, ia, rr, ri, vr, ldvr, vi, ldvi, 
c     +              work, lwork, ifail)  
c      write (*,'(a,i6)') 'from f02ebf$ ifail =', ifail
c      do i = 1, n
c         write (*,'(2f8.4)') rr(i), ri(i)
c      enddo   
c      do i = 1, n
c         write (*,'(10f8.4)') (vr(i,j), vi(i,j), j = 1, n)
c      enddo
c      write (*,'(a)') '......'  
c
c f02fdf$
c
c      n = 4
c      a(1,1) =   0.24d+00
c      a(1,2) =   0.39d+00
c      a(1,3) =   0.42d+00
c      a(1,4) =  -0.16d+00
c      a(2,1) =   0.39d+00
c      a(2,2) =  -0.11d+00
c      a(2,3) =   0.79d+00
c      a(2,4) =   0.63d+00
c      a(3,1) =   0.42d+00
c      a(3,2) =   0.79d+00
c      a(3,3) =  -0.25d+00
c      a(3,4) =   0.48d+00
c      a(4,1) =  -0.16d+00
c      a(4,2) =   0.63d+00
c      a(4,3) =   0.48d+00
c      a(4,4) =  -0.03d+00c
c
c 
c      b(1,1) =   4.16d+00
c      b(1,2) =  -3.12d+00
c      b(1,3) =   0.56d+00
c      b(1,4) =  -0.10d+00
c      b(2,1) =  -3.12d+00
c      b(2,2) =   5.03d+00
c      b(2,3) =  -0.83d+00
c      b(2,4) =   1.09d+00
c      b(3,1) =   0.56d+00
c      b(3,2) =  -0.83d+00
c      b(3,3) =   0.76d+00
c      b(3,4) =   0.34d+00
c      b(4,1) =  -0.10d+00
c      b(4,2) =   1.09d+00
c      b(4,3) =   0.34d+00
c      b(4,4) =   1.18d+00  
c      itype = 1    
c      ifail = 1
c      call f02fdf$ (itype, 'V', 'L', n, a, ia, b, ib, rr, work, lwork,
c     +              ifail)  
c      write (*,'(a,i6)') 'from f02fdf$ ifail =', ifail
c      do i = 1, n
c         write (*,'(2f8.4)') rr(i)
c      enddo   
c      do i = 1, n
c         write (*,'(10f8.4)') (a(i,j), j = 1, n)
c      enddo
c      write (*,'(a)') '......'  
c      end         
c       
c

C
C NAG F02 routines upgraded for replacement at mark 23
C
C F02AAF$
C F02AFF$
C F02EBF$
C F02FDF$
C
C LAPACK equivalents
C f08faf = dsyev
c f08naf = dgeev
c f08saf = dsygv
C 
C 13/11/2014 Code corrected and checked 
C
C----------------------------------------------------------------------------------
C
      SUBROUTINE F02AAF$(A, IA, N, R, E, IFAIL)
C
C ACTION : eigenvalues only of a symmetric matrix
C AUTHOR : W.G.Bardsley, University of Manchester, 16/7/97
C          14/01/2006 introduced local allocatable workspace
C          16/07/2011 replaced F02FAF by F08FAF
C          Note: maximum dimension set by LWORK not N as in NAG version
C          Using F08FAF
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, IFAIL, N
      DOUBLE PRECISION A(IA,*), R(*), E(*)
C
C Locals
C
      INTEGER    IERR, LWORK, NB
      PARAMETER (NB = 64)
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:)
      CHARACTER  JOBZ*1, UPLO*1
      PARAMETER (JOBZ = 'N', UPLO = 'L')
      EXTERNAL   F08FAF
      INTRINSIC  MAX
C
C Allocate workspace
C
      E(1) = 1.0D+00!to silence ftn95
      LWORK = MAX(3*N, N*NB) + 1
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      ALLOCATE(WORK(LWORK), STAT = IERR)
C
C Calculations
C
      CALL F08FAF (JOBZ, UPLO, N, A, IA, R, WORK, LWORK, IFAIL)
      DEALLOCATE(WORK, STAT = IERR)
      END
C
C----------------------------------------------------------------------------------
C
C ACTION: eigenvalues only of an unsymmetric matrix
C AUTHOR: W.G.Bardsley, University of Manchester, 20/02/2005
C         14/01/2006 introduced allocatable workspace and set LWORK = 1 
C         13/11/2014 corrected error in LWORK and WORK allocation  
C
      SUBROUTINE F02AFF$(A, IA, N, RR, RI, INTGER, IFAIL)
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, IFAIL, N
      INTEGER    INTGER(*)
      DOUBLE PRECISION A(IA,*), RR(*), RI(*)
C
C Locals
C
      INTEGER    IERR
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    LWORK, LDVL, LDVR
      PARAMETER (LDVL = 1, LDVR = 1)
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:)
      DOUBLE PRECISION VL(LDVL,N1), VR(LDVR,N1)
      CHARACTER  JOBVL*1
      PARAMETER (JOBVL = 'N')
      EXTERNAL   GETIFA, F02EBF$
C
C Make sure IFAIL is in range
C
      CALL GETIFA (IFAIL)
C
C Call the actual NAG library routine
C
      LWORK = 64*N
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      ALLOCATE (WORK(LWORK), STAT = IERR)
      CALL F02EBF$(JOBVL, N, A, IA, RR, RI, VL, LDVL, VR, LDVR,
     +             WORK, LWORK, IFAIL)
      INTGER(1) = 1
      DEALLOCATE(WORK, STAT = IERR)
      END
C
C----------------------------------------------------------------------------------
C
C ACTION: eigenvalues and optionally eigenvectors of a general matrix
C AUTHOR: W.G.Bardsley, University of Manchester, 01/03/2005
C         16/07/2011 now calls F08NAF and allocates workspace internally
C         13/11/2014 now only calculates eigenvectors when JOB = 'V' or 'v' 
C
      SUBROUTINE F02EBF$(JOB, N, A, LDA, WR, WI, VR, LDVR, VI, LDVI,
     +                   WORK, LWORK, IFAIL)
      IMPLICIT  NONE
      INTEGER   N, LDA, LDVR, LDVI, LWORK, IFAIL
      DOUBLE PRECISION A(LDA,*), WR(*), WI(*), VR(LDVR,*), VI(LDVI,*),
     +                 WORK(LWORK)
      CHARACTER JOB*1
      INTEGER    I, IERR, J, K, LWORK1, LDVL1, LDVR1, NTEMP
      INTEGER    NB
      PARAMETER (NB = 64)
      DOUBLE PRECISION ZERO, EPSI
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-300)
      DOUBLE PRECISION, ALLOCATABLE :: WORK1(:), VL1(:,:), VR1(:,:)
      LOGICAL    TEST 
      EXTERNAL   GETIFA, F08NAF
      INTRINSIC  ABS
      WORK(1) = ZERO!to stop FTN95 complaining
C
C Make sure IFAIL is in range
C
      CALL GETIFA (IFAIL)
C
C Allocate
C
      LWORK1 = 4*N + NB*N
      LDVL1 = N
      LDVR1 = N
      NTEMP = N
      IF (ALLOCATED(WORK1)) DEALLOCATE(WORK1, STAT = IERR)
      IF (ALLOCATED(VL1)) DEALLOCATE(VL1, STAT = IERR)
      IF (ALLOCATED(VR1)) DEALLOCATE(VR1, STAT = IERR)
      ALLOCATE (WORK1(LWORK1), STAT = IERR)
      ALLOCATE (VL1(LDVL1,NTEMP), STAT = IERR)
      ALLOCATE (VR1(LDVR1,NTEMP), STAT = IERR)
C
C Call the actual NAG library routine
C
      CALL F08NAF ('N', JOB, N, A, LDA, WR, WI, VL1, LDVL1, VR1, LDVR1,
     +             WORK1, LWORK1, IFAIL)
      IF (JOB.EQ.'V' .OR. JOB.EQ.'v') THEN
         K = 0
         TEST = .TRUE.  
         DO I = 1, N
            IF (TEST) THEN
               IF (ABS(WI(I)).LE.EPSI) THEN
C
C Real eigenvlaue
C              
                  K = K + 1
                  DO J = 1, N
                     VR(J,I) = VR1(J,K)
                     VI(J,I) = ZERO
                  ENDDO
               ELSE
C
C Record adjusted for real and imaginary parts 
C              
                  TEST = .FALSE.
                  K = K + 1
                  DO J = 1, N
                   VR(J,I) = VR1(J,K)
                   VR(J,I + 1) = VR(J,I)
                  ENDDO
                  K = K + 1
                  DO J = 1, N
                     VI(J,I) = VR1(J,K)
                     VI(J,I + 1) = -VI(J,I)
                  ENDDO    
               ENDIF
            ELSE
               TEST = .TRUE.
            ENDIF            
         ENDDO 
      ENDIF
      DEALLOCATE (WORK1, STAT = IERR)
      DEALLOCATE (VL1, STAT = IERR)
      DEALLOCATE (VR1, STAT = IERR)                               
      END
C
C----------------------------------------------------------------------------------
C
C ACTION: version of SIMFIT w_maths.dll to divert calls to the NAG library
C AUTHOR: W.G.Bardsley, University of Manchester, 23/02/2005
C         16/07/2011 replaced F02FDF by F08SAF
C
      SUBROUTINE F02FDF$(ITYPE, JOB, UPLO, N, A, LDA, B, LDB,
     +                   W, WORK, LWORK, IFAIL)
      IMPLICIT  NONE
      INTEGER   ITYPE, N, LDA, LDB, LWORK, IFAIL
      DOUBLE PRECISION A(LDA,*), B(LDB,*), W(*), WORK(LWORK)
      CHARACTER JOB*1, UPLO*1
      EXTERNAL  GETIFA, F08SAF
C
C Make sure IFAIL is in range
C
      CALL GETIFA (IFAIL)
C
C Call the actual NAG library routine
C
      CALL F08SAF (ITYPE, JOB, UPLO, N, A, LDA, B, LDB,
     +             W, WORK, LWORK, IFAIL)
      END
C
C

