C
C
      SUBROUTINE F02AAF$(A, IA, N, R, E, IFAIL)
C
C ACTION : Eigenvalues of a symmetric matrix
C AUTHOR : W.G.Bardsley, University of Manchester, 16/7/97
C          14/01/2006 introduced local allocatable workspace
C          Note: maximum domension set by LWORK not N as in NAG version
C          Using F02FAF
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, IFAIL, N
      DOUBLE PRECISION A(IA,*), R(*), E(*)
C
C Locals
C
      INTEGER    IERR, LWORK, NB
      PARAMETER (NB = 64)
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:)
      CHARACTER  JOBZ*1, UPLO*1
      PARAMETER (JOBZ = 'N', UPLO = 'L')
      EXTERNAL   F02FAF
      INTRINSIC  MAX
C
C Allocate workspace
C
      E(1) = 1.0D+00!to silence ftn95
      LWORK = MAX(3*N, N*NB) + 1
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      ALLOCATE(WORK(LWORK), STAT = IERR)
C
C Calculations
C
      CALL F02FAF (JOBZ, UPLO, N, A, IA, R, WORK, LWORK, IFAIL)
      DEALLOCATE(WORK, STAT = IERR)
      END
C
C
