c
c action: replacement f03 subroutines for mark25
c author: w.g.bardsley, university of manchester, u.k., 10/07/2016 
c
c f03aaf$
c f03abf$
c f03aef$
c f03aff$
c

C
C
      SUBROUTINE F03AAF$(A, IA, N, DET, WKSPCE, IFAIL)
C
C ACTION : Determinant
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/7/97
C          Calls F03AFF$
C
      IMPLICIT NONE
      INTEGER  IFAIL, IA, N
      INTEGER  ID
      DOUBLE PRECISION A(IA,*), DET, WKSPCE(*)
      DOUBLE PRECISION EPS, D1, X02AJF
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      EXTERNAL X02AJF, F03AFF$
      EPS = X02AJF()
      CALL F03AFF$(N, EPS, A, IA, D1, ID, WKSPCE, IFAIL)
      DET = D1*TWO**ID
      END
C
C
      SUBROUTINE F03ABF$(A, IA, N, DET, WKSPCE, IFAIL)
C
C ACTION: version of F03ABF
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 13/2/2004
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER  IA, N, IFAIL
      DOUBLE PRECISION A(IA,*), DET, WKSPCE(*)
C
C Locals
C
      INTEGER    ID
      DOUBLE PRECISION D1
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      EXTERNAL   F03AEF$
      INTRINSIC  MAX
      IFAIL = 0
      DET = ZERO
      IF (N.LT.0 .OR. IA.LT.MAX(1,N)) then
         IFAIL = 4
         RETURN
      ENDIF
      CALL F03AEF$(N, A, IA, WKSPCE, D1, ID, IFAIL)
      IF (IFAIL.EQ.0) DET = D1*TWO**ID
      END
C
C
      SUBROUTINE F03AEF$(N, A, IA, P, D1, ID, IFAIL)
C
C ACTION: version of F03AEF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 01/07/2001
C         Note: the IFAIL mechanism is not the same as the NAG one
C
      IMPLICIT   NONE
      INTEGER    IA, ID, IFAIL, N
      INTEGER    I, J
      DOUBLE PRECISION D1
      DOUBLE PRECISION A(IA,*), P(*)
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   DGEMV
      INTRINSIC  ABS, SQRT, MAX
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LT.0 .OR. IA.LT.MAX(1,N)) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Copy upper triangle and diagonal
C
      DO J = 1, N
         DO I = 1, J
            A(J,I) = A(I,J)
         ENDDO
         P(J) = A(J,J)
      ENDDO
      D1 = ONE
      ID = 0
      DO I = 1, N
         X = A(I,I)
         D1 = D1*X
         IF (X.LE.ZERO) THEN
C
C Not positive definite so abort with IFAIL = 1
C
            IFAIL = 1
            D1 = ZERO
            ID = 0
            DO J = I, N
               A(J,J) = P(J)
            ENDDO
            RETURN
         ENDIF
   20    CONTINUE
         IF (ABS(D1).LT.ONE) GOTO 40
         D1 = D1*0.0625D+00
         ID = ID + 4
         GOTO 20
   40    CONTINUE
         IF (ABS(D1).GE.0.0625D+00) GOTO 60
         D1 = D1*16.0D+00
         ID = ID - 4
         GOTO 40
   60    CONTINUE
         X = ONE/SQRT(X)
         A(I,I) = P(I)
         P(I) = X
         IF (I.LT.N) THEN
            DO J = I + 1, N
               A(J,I) = A(J,I)*X
            ENDDO
            CALL DGEMV ('N', N-I, I, -ONE, A(I+1,1), IA, A(I+1,1), IA,
     +                  ONE, A(I+1,I+1), 1)
         ENDIF
      ENDDO
      IFAIL = 0
      END
C
C
      SUBROUTINE F03AFF$(N, EPS, A, IA, D1, ID, P, IFAIL)
C
C ACTION : Determinant
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/7/97
C          Uses BLAS
C
      IMPLICIT   NONE
      INTEGER    IA, ID, IFAIL, N
      INTEGER    I, J, K, L
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION D1, EPS
      DOUBLE PRECISION A(IA,*), P(*)
      DOUBLE PRECISION X, Y, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   DGEMV, DTRSV
      INTRINSIC  ABS, SQRT, MAX
C
C Initialise
C
      D1 = ONE
      ID = N0
      IFAIL = N1
C
C Check
C
      IF (N.LT.N0 .OR. IA.LT.MAX(N1,N)) THEN
         IFAIL = N2
         RETURN
      ENDIF
C
C Empty P
C
      DO I = N1, N
         P(I) = ZERO
      ENDDO
C
C Calculate P
C
      DO J = N1, N
         DO I = N1, N
            P(I) = P(I) + A(I,J)**2
         ENDDO
      ENDDO
C
C Check/Transform P
C
      DO I = N1, N
         IF (P(I).LE.ZERO) RETURN
         Z = SQRT(P(I))
         IF (Z.LT.1.0D-300) THEN
            RETURN
         ELSE
            P(I) = ONE/Z
         ENDIF
      ENDDO
C
C The main loop
C
      D1 = ONE
      ID = N0
      DO K = N1, N
         L = K
         X = ZERO
         DO I = K, N
            Y = ABS(A(I,K)*P(I))
            IF (Y.GT.X) THEN
               X = Y
               L = I
            ENDIF
         ENDDO
         IF (L.NE.K) THEN
            D1 = - D1
            DO J = N1, N
               Y = A(K,J)
               A(K,J) = A(L,J)
               A(L,J) = Y
            ENDDO
            P(L) = P(K)
         ENDIF
         P(K) = L
         D1 = D1*A(K,K)
         IF (X.LT.8.0*EPS) RETURN

         DO WHILE (ABS(D1).GE.ONE)
            D1 = D1*0.0625
            ID = ID + 4
         ENDDO

         DO WHILE (ABS(D1).LT.0.0625)
            D1 = D1*16.0
            ID = ID - 4
         ENDDO

         IF (K.LT.N) THEN
            CALL DTRSV ('L', 'N', 'N', K, A, IA, A(1,K+1), N1)
            CALL DGEMV ('N', N-K, K, -ONE, A(K+1,1), IA, A(1,K+1), N1,
     +                  ONE, A(K+1,K+1), N1)
         ENDIF
      ENDDO
      IFAIL = N0
      END
C
C
