C
C
      SUBROUTINE F04ATF$(A, IA, B, N, C, AA, IAA, WK1, WK2, IFAIL)
C
C ACTION : Ax = b A is arbitrary
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/7/97
C          14/01/2006 introduced allocatable work space
C          Uses LAPACK/BLAS
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, IAA, IFAIL, N
      DOUBLE PRECISION A(IA,*), AA(IAA,*), B(*), C(*), WK1(*), WK2(*)
C
C Locals
C
      INTEGER    I, IERR, J, NMAX, NRHS, N1
      PARAMETER (NRHS = 1, N1 = 1)
      INTEGER, ALLOCATABLE :: IPIV(:)
      DOUBLE PRECISION, ALLOCATABLE :: TEMP(:,:)
      EXTERNAL   DGESV
      IERR = 0
      WK1(1) = 1.0D+00!to silence ftn95
      WK2(1) = 1.0D+00!to silence ftn95
      IF (N.LE.0 .OR. IA.LT.N .OR. IAA.LT.N) THEN
         IFAIL = 3
         RETURN
      ENDIF
      NMAX = N
      IF (ALLOCATED(IPIV)) DEALLOCATE(IPIV, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(TEMP)) DEALLOCATE(TEMP, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(IPIV(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(TEMP(NMAX,NRHS), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      DO I = N1, N
         TEMP(I,N1) = B(I)
      ENDDO
      CALL DGESV (N, NRHS, A, IA, IPIV, TEMP, NMAX, IFAIL)
      DO I = N1, N
         C(I) = TEMP(I,N1)
      ENDDO
      DO J = N1, N
         DO I = N1, N
            AA(I,J) = A(I,J)
         ENDDO
      ENDDO
      DEALLOCATE(IPIV, STAT = IERR)
      DEALLOCATE(TEMP, STAT = IERR)
      END
C
C
