C
C G01DDF$
C G01DDF1
C G01DDF2
C
C Requires G01DDF1 ( = SWILK)  and G01DDF2 ( = POLY )
C ===================================================
C

      SUBROUTINE G01DDF$(X, N, CALWTS, A, W, PW, IFAIL)
C
C ACTION : The Shapiro Wilks test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/11/98
C
C This is a modification of the Royston algorithm SWILK
C R94  APPL. STATIST. (1995), 44, 4
C Accuracy claimed up to N = 5000 not 2000 so IFAIL = 2 if N > 10000
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      INTEGER    I, IFAULT
      DOUBLE PRECISION A(N), X(N), PW, W
      DOUBLE PRECISION X1, X2
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      LOGICAL    CALWTS
      LOGICAL    INIT, UP
C
C Local variables
C
      INTEGER    N1, N2
      EXTERNAL   G01DDF1
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LT.3) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (N.GT.10000) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Check if the data is sorted
C
      IF (X(1).LT.X(N)) THEN
         UP = .TRUE.
      ELSEIF (X(1).GT.X(N)) THEN
         UP = .FALSE.
      ELSE
         IFAIL = 3
         RETURN
      ENDIF
      DO I = 2, N
         IF (UP) THEN
            X1 = X(I - 1)
            X2 = X(I)
         ELSE
            X1 = X(I)
            X2 = X(I - 1)
         ENDIF
         IF (X2.LT.X1) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDDO
C
C Call SWILK to Calculate W
C
      N1 = N
      N2 = N/2
      W = ONE
      INIT = .NOT.CALWTS
      CALL G01DDF1 (INIT, X, N, N1, N2, A, W, PW, IFAULT)
      END
C
C
      SUBROUTINE G01DDF1(INIT, X, N, N1, N2, A, W, PW, IFAULT)
C
C        Subroutine SWILK
C        ALGORITHM AS R94 APPL. STATIST. (1995) VOL.44, NO.4
C
C        Calculates the Shapiro-Wilk W test and its significance level
C        Modifications by w.g.bardsley, 12/11/98
C        =======================================
C        Replaced PPND and ALNORM by NAG-type equivalents, transformed
C        to DOUBLE PRECISION and cleaned up a bit
C
      IMPLICIT         NONE
      INTEGER          N, N1, N2, IFAULT
      DOUBLE PRECISION X(N), A(N), PW, W
      DOUBLE PRECISION C1(6), C2(6), C3(4), C4(4), C5(4), C6(3), C7(2)
      DOUBLE PRECISION C8(2), C9(2), G(2)
      DOUBLE PRECISION Z90, Z95, Z99, ZM, ZSS, BF1, XX90, XX95, ZERO,
     +                 ONE, TWO
      DOUBLE PRECISION THREE, SQRTH, QTR, TH, SMALL, PI6, STQR
      DOUBLE PRECISION SUMM2, SSUMM2, FAC, RSN, AN, AN25, A1, A2,
     +                 DELTA, RANGE1
      DOUBLE PRECISION SA, SX, SSX, SSA, SAX, ASA, XSX, SSASSX, W1,
     +                 Y, XX, XI
      DOUBLE PRECISION GAMMA, M, S, LD, BF, Z90F, Z95F, Z99F, ZFM,
     +                 ZSD, ZBAR
C
C        Auxiliary routines
C*****original calls replaced by G01 routines
C*****DOUBLE PRECISION PPND, ALNORM, POLY
      DOUBLE PRECISION G01FAF$, G01EAF$, G01DDF2
C
      INTEGER    NCENS, NN2, I, I1, IERR, J
      CHARACTER  TAILL*1, TAILU*1
      PARAMETER (TAILL = 'L', TAILU = 'U')
      LOGICAL    INIT
      EXTERNAL   G01FAF$, G01EAF$, G01DDF2
      INTRINSIC  ASIN, DBLE, EXP, LOG, MIN, SIGN, SQRT
C
      DATA C1 /0.0D0, 0.221157D0, -0.147981D0, -0.207119D1,
     *     0.4434685D1, -0.2706056D1/
      DATA C2 /0.0D0, 0.42981D-1, -0.293762D0, -0.1752461D1,
     *     0.5682633D1, -0.3582633D1/
      DATA C3 /0.5440D0, -0.39978D0, 0.25054D-1, -0.6714D-3/
      DATA C4 /0.13822D1, -0.77857D0, 0.62767D-1, -0.20322D-2/
      DATA C5 /-0.15861D1, -0.31082D0, -0.83751D-1, 0.38915D-2/
      DATA C6 /-0.4803D0, -0.82676D-1, 0.30302D-2/
      DATA C7 /0.164D0, 0.533D0/
      DATA C8 /0.1736D0, 0.315D0/
      DATA C9 /0.256D0, -0.635D-2/
      DATA G  /-0.2273D1, 0.459D0/
      DATA Z90, Z95, Z99 /0.12816D1, 0.16449D1, 0.23263D1/
      DATA ZM, ZSS /0.17509D1, 0.56268D0/
      DATA BF1 /0.8378D0/, XX90, XX95 /0.556D0, 0.622D0/
      DATA ZERO /0.0D0/, ONE/1.0D0/, TWO/2.0D0/, THREE/3.0D0/
      DATA SQRTH /0.70711D0/, QTR/0.25D0/, TH/0.375D0/, SMALL/1D-19/
      DATA PI6 /0.1909859D1/, STQR/0.1047198D1/
C
      PW  =  ONE
      IF (W .GE. ZERO) W = ONE
      AN = N
      IFAULT = 3
      NN2 = N/2
      IF (N2 .LT. NN2) RETURN
      IFAULT = 1
      IF (N .LT. 3) RETURN
C
C        If INIT is false, calculates coefficients for the test
C
      IF (.NOT. INIT) THEN
         IF (N .EQ. 3) THEN
            A(1) = SQRTH
         ELSE
            AN25 = AN + QTR
            SUMM2 = ZERO
            DO 30 I = 1, N2
C
C Second argument left out in original code but replaced by G01FAF$
C**************A(I) = PPND((I - TH)/AN25)
C**************A(I) = PPND((I - TH)/AN25, IERR)
C
               A(I) = G01FAF$(TAILL, (I - TH)/AN25, IERR)
               SUMM2 = SUMM2 + A(I) ** 2
30          CONTINUE
            SUMM2 = SUMM2 * TWO
            SSUMM2 = SQRT(SUMM2)
            RSN = ONE / SQRT(AN)
            A1 = G01DDF2(C1, 6, RSN) - A(1) / SSUMM2
C
C        Normalize coefficients
C
            IF (N .GT. 5) THEN
               I1 = 3
               A2 = -A(2)/SSUMM2 + G01DDF2(C2,6,RSN)
               FAC = SQRT((SUMM2 - TWO * A(1) ** 2 - TWO *
     *               A(2) ** 2)/(ONE - TWO * A1 ** 2 - TWO * A2 ** 2))
               A(1) = A1
               A(2) = A2
            ELSE
               I1 = 2
               FAC = SQRT((SUMM2 - TWO * A(1) ** 2)/
     *                   (ONE - TWO * A1 ** 2))
               A(1) = A1
            END IF
            DO 40 I = I1, NN2
               A(I) = -A(I)/FAC
   40       CONTINUE
         END IF
         INIT = .TRUE.
      END IF
      IF (N1 .LT. 3) RETURN
      NCENS = N - N1
      IFAULT = 4
      IF (NCENS .LT. 0 .OR. (NCENS .GT. 0 .AND. N .LT. 20)) RETURN
      IFAULT = 5
      DELTA = DBLE(NCENS)/AN
      IF (DELTA .GT. 0.8) RETURN
C
C        If W input as negative, calculate significance level of -W
C
      IF (W .LT. ZERO) THEN
         W1 = ONE + W
         IFAULT = 0
         GOTO 70
      END IF
C
C        Check for zero range
C
      IFAULT = 6
      RANGE1 = X(N1) - X(1)
      IF (RANGE1 .LT. SMALL) RETURN
C
C        Check for correct sort order on range - scaled X
C
      IFAULT = 7
      XX = X(1)/RANGE1
      SX = XX
      SA = -A(1)
      J = N - 1
      DO 50 I = 2, N1
         XI = X(I)/RANGE1
         IF (XX-XI .GT. SMALL) PRINT *,' ANYTHING'
         SX = SX + XI
         IF (I .NE. J) SA = SA + SIGN(1, I - J) * A(MIN(I, J))
         XX = XI
         J = J - 1
50    CONTINUE
      IFAULT = 0
      IF (N .GT. 5000) IFAULT = 2
C
C        Calculate W statistic as squared correlation
C        between data and coefficients
C
      SA = SA/N1
      SX = SX/N1
      SSA = ZERO
      SSX = ZERO
      SAX = ZERO
      J = N
      DO 60 I = 1, N1
         IF (I .NE. J) THEN
            ASA = SIGN(1, I - J) * A(MIN(I, J)) - SA
         ELSE
            ASA = -SA
         END IF
         XSX = X(I)/RANGE1 - SX
         SSA = SSA + ASA * ASA
         SSX = SSX + XSX * XSX
         SAX = SAX + ASA * XSX
         J = J - 1
   60 CONTINUE
C
C        W1 equals (1-W) claculated to avoid excessive rounding error
C        for W very near 1 (a potential problem in very large samples)
C
      SSASSX = SQRT(SSA * SSX)
      W1 = (SSASSX - SAX) * (SSASSX + SAX)/(SSA * SSX)
   70 W = ONE - W1
C
C        Calculate significance level for W (exact for N=3)
C
      IF (N .EQ. 3) THEN
          PW = PI6 * (ASIN(SQRT(W)) - STQR)
          RETURN
      END IF
      Y = LOG(W1)
      XX = LOG(AN)
      M = ZERO
      S = ONE
      IF (N .LE. 11) THEN
         GAMMA = G01DDF2(G, 2, AN)
         IF (Y .GE. GAMMA) THEN
            PW = SMALL
            RETURN
         END IF
         Y = -LOG(GAMMA - Y)
         M = G01DDF2(C3, 4, AN)
         S = EXP(G01DDF2(C4, 4, AN))
      ELSE
         M = G01DDF2(C5, 4, XX)
         S = EXP(G01DDF2(C6, 3, XX))
      END IF
      IF (NCENS .GT. 0) THEN
C
C        Censoring by proportion NCENS/N.  Calculate mean and sd
C        of normal equivalent deviate of W.
C
         LD = -LOG(DELTA)
         BF = ONE + XX * BF1
         Z90F = Z90 + BF * G01DDF2(C7, 2, XX90 ** XX) ** LD
         Z95F = Z95 + BF * G01DDF2(C8, 2, XX95 ** XX) ** LD
         Z99F = Z99 + BF * G01DDF2(C9, 2, XX) ** LD
C
C        Regress Z90F,...,Z99F on normal deviates Z90,...,Z99 to get
C        pseudo-mean and pseudo-sd of z as the slope and intercept
C
         ZFM = (Z90F + Z95F + Z99F)/THREE
         ZSD = (Z90*(Z90F-ZFM)+Z95*(Z95F-ZFM)+Z99*(Z99F-ZFM))/ZSS
         ZBAR = ZFM - ZSD * ZM
         M = M + ZBAR * S
         S = S * ZSD
      END IF
C
C Replaced original call to ALNORM by call to G01EAF$
C*****PW = ALNORM((Y - M)/S, UPPER)
C
      PW = G01EAF$(TAILU, (Y - M)/S, IERR)
C
      RETURN
      END
C
C
      DOUBLE PRECISION FUNCTION G01DDF2(C, NORD, X)
C
C ACTION : AS 181.2 Appl. Statist. (1982) vol.31, no. 2
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/11/98
C          Version of POLY for G01DDF$
C
      IMPLICIT  NONE
      INTEGER   NORD
      INTEGER   I, J, N2
      DOUBLE PRECISION C(NORD), X
      DOUBLE PRECISION P
      G01DDF2 = C(1)
      IF (NORD.EQ.1) RETURN
      P = X*C(NORD)
      IF (NORD.GT.2) THEN
         N2 = NORD - 2
         J = N2 + 1
         DO I = 1, N2
            P = (P + C(J))*X
            J = J - 1
         ENDDO
      ENDIF
      G01DDF2 = G01DDF2 + P
      END
C
C
