C
C Note: this routine has been deleted from the NAG library
C
      SUBROUTINE G04ADF$(DATA1, VAR, AMR, AMC, AMT, LCODE, IA, N, NN)
C
C ACTION : Latin square ANOVA
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/4/97
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, N, NN
      INTEGER    LCODE(IA,*)
      DOUBLE PRECISION DATA1(NN), VAR(5), AMR(N), AMC(N), AMT(N)
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      INTEGER    I, IADD1, J, K
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION GMEAN, RN, RNN, VALUE
      DOUBLE PRECISION AMRSUM, AMCSUM, AMTSUM
      INTRINSIC  DBLE
C
C Is it safe ?
C
      DO I = N1, N
         AMR(I) = ZERO
         AMC(I) = ZERO
         AMT(I) = ZERO
      ENDDO
      DO I = N1, N5
         VAR(I) = ZERO
      ENDDO
      IF (N.LT.N3 .OR. IA.LT.N .OR. NN.NE.N*N) RETURN
C
C Marginals and global mean
C
      GMEAN = ZERO
      IADD1 = N0
      DO I = N1, N
         DO J = N1, N
            IADD1 = IADD1 + N1
            VALUE = DATA1(IADD1)
            AMR(I) = AMR(I) + VALUE
            AMC(J) = AMC(J) + VALUE
            K = LCODE(I,J)
            AMT(K) = AMT(K) + VALUE
            GMEAN = GMEAN + VALUE
         ENDDO
      ENDDO
      RN = DBLE(N)
      RNN = DBLE(NN)
      GMEAN = GMEAN/RNN
C
C Sums of squares
C
      AMRSUM = ZERO
      AMCSUM = ZERO
      AMTSUM = ZERO
      DO I = N1, N
         AMRSUM = AMRSUM + AMR(I)
         AMCSUM = AMCSUM + AMC(I)
         AMTSUM = AMTSUM + AMT(I)
      ENDDO
      AMRSUM = AMRSUM/RN
      AMCSUM = AMCSUM/RN
      AMTSUM = AMTSUM/RN
      DO I = N1, N
         VAR(N1) = VAR(N1) + (AMRSUM - AMR(I))**2
         VAR(N2) = VAR(N2) + (AMCSUM - AMC(I))**2
         VAR(N3) = VAR(N3) + (AMTSUM - AMT(I))**2
      ENDDO
      VAR(N1) = VAR(N1)/RN
      VAR(N2) = VAR(N2)/RN
      VAR(N3) = VAR(N3)/RN
      DO I = N1, NN
         VAR(N5) = VAR(N5) + (DATA1(I) - GMEAN)**2
      ENDDO
      VAR(N4) = VAR(N5) - VAR(N1) - VAR(N2) - VAR(N3)
      END
C
C
