C
C Note: this routine has been deleted from the NAG library
C
      SUBROUTINE G04AEF$(Y, N, K, NOBS, GBAR, GM, SS, IDF, F, FP, IFAIL)
C
C ACTION : 1 way ANOVA
C AUTHOR : W.G.Bardsley, University of Manchester, 28/4/97
C
      IMPLICIT   NONE
C
C Subroutine arguments
C
      INTEGER    N, K, NOBS(K), IDF(3), IFAIL
      DOUBLE PRECISION Y(N), GBAR(K), GM, SS(3), F, FP
C
C Local variables
C
      INTEGER    I, IADD1, J, NSUM
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION G01EDF$, X02AMF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'U')
      EXTERNAL   G01EDF$, X02AMF$
      INTRINSIC  DBLE
C
C Is it safe ?
C
      IFAIL = N0
      IF (K.LE.N1) THEN
         IFAIL = N1
         RETURN
      ENDIF
      NSUM = N0
      DO I = N1, K
         IF (NOBS(I).LE.N0) THEN
            IFAIL = N2
            RETURN
         ELSE
            NSUM = NSUM + NOBS(I)
         ENDIF
      ENDDO
      IF (NSUM.NE.N) THEN
         IFAIL = N3
         RETURN
      ENDIF
C
C The group means and grand mean
C
      IADD1 = N0
      GM = ZERO
      DO I = N1, K
         GBAR(I) = ZERO
         DO J = N1, NOBS(I)
            IADD1 = IADD1 + N1
            GM = GM + Y(IADD1)
            GBAR(I) = GBAR(I) + Y(IADD1)
         ENDDO
         GBAR(I) = GBAR(I)/DBLE(NOBS(I))
      ENDDO
      GM = GM/DBLE(N)
C
C Sums of squares
C
      SS(N1) = ZERO
      SS(N2) = ZERO
      SS(N3) = ZERO
      IADD1 = N0
      DO I = N1, K
         SS(N1) = SS(N1) + DBLE(NOBS(I))*(GBAR(I) - GM)**2
         DO J = N1, NOBS(I)
            IADD1 = IADD1 + N1
            SS(N2) = SS(N2) + (Y(IADD1) - GBAR(I))**2
            SS(N3) = SS(N3) + (Y(IADD1) - GM)**2
         ENDDO
      ENDDO
      RTOL = X02AMF$()
      IF (SS(N3).LE.RTOL) THEN
         IFAIL = N3
         RETURN
      ENDIF
      IF (SS(N2).LE.RTOL) THEN
         IFAIL = N4
         RETURN
      ENDIF
C
C Degrees of freedom
C
      IDF(1) = K - N1
      IDF(2) = N - K
      IDF(3) = N - N1
C
C F ratio
C
      F = (SS(N1)/DBLE(IDF(N1)))/(SS(N2)/DBLE(IDF(N2)))
      IF (F.GE.9999.0) THEN
         F = 9999.0
         FP = ZERO
      ELSE
         I = N1
         FP = G01EDF$(TAIL, F, DBLE(IDF(1)), DBLE(IDF(2)), I)
      ENDIF
      END
C
C
