c
c random number generator for nag 23
c
c      program    main
c      implicit   none
c      integer    i, ifail, isend, iseed, j, m, n, ncol, nrow
c      integer    ncmax, nrmax, nr 
c      parameter (ncmax = 100, nrmax = 1000, nr = 1000)
c      integer    indx(1000)
c      integer    g05dyf$, g05eyf$
c      double precision a, b, dummy, p, t, x(nrmax,ncmax), y(nrmax)
c      double precision r(nr)
c      double precision g05caf$, g05daf$, g05dbf$, g05dcf$, g05ddf$,
c     +                 g05def$, g05dff$, g05dhf$, g05djf$, g05dpf$
c      external g05ccf$, g05caf$, g05cbf$, g05daf$, g05dbf$, g05dcf$,
c     +         g05ddf$, g05def$, g05dff$, g05dhf$, g05djf$, g05dpf$,
c     +         g05dyf$, g05eyf$, g05ecf$, g05edf$, g05ehf$, g05fff$       
c      
c
c      call g05ccf$
c
c      isend = 15
c
c     ifail = -1
c      if (isend.eq.2) then
c         a = 0.0d+00
c         b = 1.0d+00
c      elseif (isend.eq.3) then
c         a = 2.0d+00 
c      elseif (isend.eq.4) then
c         a = 1.0d+00
c         b = 1.5d+00  
c      elseif (isend.eq.5) then
c         a = 0.0d+00
c         b = 1.0d+00
c      elseif (isend.eq.6) then
c         a = 1.0d+00
c         b = 1.5d+00 
c      elseif (isend.eq.7) then
c         a = 1.0d+00
c         b = 1.5d+00 
c      elseif (isend.eq.8) then
c         n = 5
c      elseif (isend.eq.9) then
c         ifail = -1
c         n = 5  
c      elseif (isend.eq.10) then
c         a = 1.0d+00
c         b = 2.0d+00
c      elseif (isend.eq.11) then
c         m = -5
c         n = 5  
c      elseif (isend.eq.12) then
c         t = 2.7d+00
c         call g05ecf$(t, r, nr, ifail)
c      elseif (isend.eq.13) then
c         p = 0.5d+00
c         n = 100
c         call g05edf$(n, p, r, nr, ifail)
c      elseif (isend.eq.14) then
c         n = 20
c         do i = 1, n
c            indx(i) = i
c         enddo
c         call g05ehf$(indx, n , ifail)
c         do i = 1, n
c            write (*,'(i6)') indx(i)
c         enddo
c         goto 20  
c      elseif (isend.eq.15) then
c         n = 20
c         a = 5.0d+00
c         b = 1.0d+00
c         call g05fff$(a, b, n, y, ifail)  
c         do i = 1, n
c            write (*,'(1p,e13.5)') y(i)
c         enddo
c         goto 20          
c      endif
      
c      iseed = 0
c      ncol = 5
c      nrow = 30
c      do j = 1, ncol
c         call g05cbf$(iseed)
c         do i = 1, nrow
c           
c            if (isend.eq.1) then
c              x(i,j) = g05caf$(dummy)
c            elseif (isend.eq.2) then
c              x(i,j) = g05daf$(a,b)
c            elseif (isend.eq.3) then
c              x(i,j) = g05dbf$(a)
c            elseif (isend.eq.4) then
c              x(i,j) = g05dcf$(a, b) 
c            elseif (isend.eq.5) then
c              x(i,j) = g05ddf$(a, b) 
c            elseif (isend.eq.6) then
c              x(i,j) = g05def$(a, b) 
c            elseif (isend.eq.7) then
c              x(i,j) = g05dff$(a, b) 
c            elseif (isend.eq.8) then
c              x(i,j) = g05dhf$(n, ifail) 
c            elseif (isend.eq.9) then
c              x(i,j) = g05djf$(n, ifail)   
c            elseif (isend.eq.10) then
c              x(i,j) = g05dpf$(a, b, ifail)
c            elseif (isend.eq.11) then
c              x(i,j) = dble(g05dyf$(m, n, ifail))
c            elseif (isend.eq.12) then
c              x(i,j) = dble(g05eyf$(r, nr)) 
c            elseif (isend.eq.13) then
c              x(i,j) = dble(g05eyf$(r, nr))                        
c            endif
c            
c         enddo
c      enddo   
c      do i = 1, nrow
c         write (*,'(100f14.8)') ( x(i,j), j = 1, ncol )
c      enddo  
c   20 continue       
c      end


C
C*********************************************************************************
C Start of G05 interface code for Mark 23
C*********************************************************************************
C
C Code to divert calls from Simfit into MARK23 NAG G05 routines
C This interface is used with the similar interfaces in w_maths.dll
c to allow Simfit to work with all NAG DLLs from Mark 20 onwards
C    
C G05CCF$ ... unrepeatable sequence
C G05CBF$ ... repeated sequence depending on the seed
C
C G05CAF$ ... uniform on (0,1)
C G05DAF$ ... uniform on (A,B)
C G05DBF$ ... negative exponential with parameter A
C G05DCF$ ... logistic with parameters A, B
C G05DDF$ ... normal with parameters A, B
C G05DEF$ ... lognormal with parameters A, B
C G05DFF$ ... Cauchy with parameters A, B
C G05DHF$ ... Chi-square with parameter N
C G05DJF$ ... Students t with parameter N
C G05DPF$ ... Weibull with parameters A and B
C G05ECF$ ... Poisson vector
C G05EYF$ ... Binomial/Poisson 
C G05EDF$ ... Binomial vector
C G05EHF$ ... Permute an integer vector	
C G05FFF$ ... Gamma with parameters A, B
C
C
C-----------------------------------------------------------
C Start of G05 module
C-----------------------------------------------------------
      MODULE   MODULE_G05_MARK23
C
C GENID    ... generator type
C SUBID    ... sub-generator
C STATE    ... generator state vector
C LSTATE   ... length of STATE
C SEED     ... seed
C LSEED    ... length of SEED
C BINOMIAL ... .true. if binomial required o/w .false.
C POISSON  ... .true. if Poisson required o/w .false.,
C LAMBDA   ... Poisson parameter
C P        ... Binomial probability
C M        ... Binomial M
C      
      IMPLICIT NONE
      INTEGER  GENID, SUBID, STATE(17), LSTATE, SEED(1), LSEED
      INTEGER  M
      DOUBLE PRECISION LAMBDA, P
      LOGICAL  BINOMIAL, POISSON
      DATA     GENID, SUBID, LSEED, LSTATE / 1, 1, 1, 17 / 
      DATA     BINOMIAL, POISSON / .FALSE., .FALSE. /
      DATA     LAMBDA, P / 0.0D+00, 0.5D+00 /
      DATA     M / 100 /
      SAVE
      END MODULE MODULE_G05_MARK23      
C-----------------------------------------------------------
C End of G05 module
C-----------------------------------------------------------
C
C
      SUBROUTINE G05CCF$
      USE        MODULE_G05_MARK23, ONLY : GENID, SUBID, STATE, LSTATE 
      INTEGER    IFAIL
      EXTERNAL   G05KGF
      IFAIL = -1
      CALL G05KGF (GENID, SUBID, STATE, LSTATE, IFAIL)
      END
C
C
      SUBROUTINE G05CBF$(ISEED)
      USE        MODULE_G05_MARK23, ONLY : GENID, SUBID, STATE, LSTATE, 
     +                                     SEED, LSEED 
      INTEGER    ISEED
      INTEGER    IFAIL
      EXTERNAL   G05KFF
      IF (ISEED.LT.0) THEN
         SEED(1) = -ISEED
      ELSEIF (ISEED.EQ.0) THEN
         SEED(1) = 1
      ELSE
         SEED(1) = ISEED
      ENDIF         
      IFAIL = -1
      CALL G05KFF (GENID, SUBID, SEED, LSEED, STATE, LSTATE, IFAIL)
      END
C
C
CFTN95$OPTIONS(SILENT)
      DOUBLE PRECISION FUNCTION G05CAF$(X)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION X
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SAF
      IFAIL = -1
      CALL G05SAF (N, STATE, Y, IFAIL)
      G05CAF$ = Y(1)
      END
C
C
      DOUBLE PRECISION FUNCTION G05DAF$(A, B)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION A, B
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL  G05SQF
      IFAIL = -1
      CALL G05SQF (N, A, B, STATE, Y, IFAIL)
      G05DAF$ = Y(1)
      END
C
C    
      DOUBLE PRECISION FUNCTION G05DBF$(A)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION A
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SFF
      IFAIL = -1
      CALL G05SFF (N, A, STATE, Y, IFAIL)
      G05DBF$ = Y(1)
      END  
C
C    
      DOUBLE PRECISION FUNCTION G05DCF$(A, B)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION A, B
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SLF
      IFAIL = -1
      CALL G05SLF (N, A, B, STATE, Y, IFAIL)
      G05DCF$ = Y(1)
      END
C
C    
      DOUBLE PRECISION FUNCTION G05DDF$(A, B)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION A, B
      DOUBLE PRECISION C
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SKF
      IFAIL = -1
      IF (B.GE.ZERO) THEN
         C = B
      ELSE  
         C = -B
      ENDIF   
      CALL G05SKF (N, A, C, STATE, Y, IFAIL)
      G05DDF$ = Y(1)
      END
C
C    
      DOUBLE PRECISION FUNCTION G05DEF$(A, B)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION A, B
      DOUBLE PRECISION C
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SMF
      IFAIL = -1
      IF (B.GE.ZERO) THEN
         C = B
      ELSE  
         C = -B
      ENDIF   
      CALL G05SMF (N, A, C, STATE, Y, IFAIL)
      G05DEF$ = Y(1)
      END  
C
C    
      DOUBLE PRECISION FUNCTION G05DFF$(A, B)
      USE        MODULE_G05_MARK23, ONLY : STATE
      DOUBLE PRECISION A, B
      DOUBLE PRECISION C
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    IFAIL
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SCF
      IFAIL = -1
      IF (B.GE.ZERO) THEN
         C = B
      ELSE  
         C = -B
      ENDIF   
      CALL G05SCF (N, A, C, STATE, Y, IFAIL)
      G05DFF$ = Y(1)
      END
C
C    
      DOUBLE PRECISION FUNCTION G05DHF$(NDOF, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE
      INTEGER    IFAIL, NDOF
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SDF
      IF (NDOF.LT.1) THEN
         G05DHF$ = ZERO
         IFAIL = 1
         RETURN
      ENDIF 
      IFAIL = -1  
      CALL G05SDF (N, NDOF, STATE, Y, IFAIL)
      G05DHF$ = Y(1)
      END
C
C    
      DOUBLE PRECISION FUNCTION G05DJF$(NDOF, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE
      INTEGER    IFAIL, NDOF
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SNF
      IF (NDOF.LT.1) THEN
         G05DJF$ = ZERO
         IFAIL = 1
         RETURN
      ENDIF 
      IFAIL = -1  
      CALL G05SNF (N, NDOF, STATE, Y, IFAIL)
      G05DJF$ = Y(1)
      END                                        
C
C    
      DOUBLE PRECISION FUNCTION G05DPF$(A, B, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE
      INTEGER    IFAIL
      DOUBLE PRECISION A, B
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    N
      PARAMETER (N = 1)
      DOUBLE PRECISION Y(N)
      EXTERNAL   G05SSF
      G05DPF$ = ZERO
      IF (A.LE.ZERO) THEN
         IFAIL = 1
         RETURN
      ELSEIF (B.LE.ZERO) THEN  
         IFAIL = 2
         RETURN
      ENDIF   
      IFAIL = -1
      CALL G05SSF (N, A, B, STATE, Y, IFAIL)
      G05DPF$ = Y(1)
      END  
C
C    
      INTEGER FUNCTION G05DYF$(M1, M2)
      USE        MODULE_G05_MARK23, ONLY : STATE
      INTEGER    IFAIL, M1, M2
      INTEGER    N
      PARAMETER (N = 1)
      INTEGER    Y(N)
      EXTERNAL   G05TLF
      IFAIL = -1
      IF (M1.LE.M2) THEN
         CALL G05TLF (N, M1, M2, STATE, Y, IFAIL)
      ELSE  
         CALL G05TLF (N, M2, M1, STATE, Y, IFAIL)
      ENDIF   
      G05DYF$ = Y(1)
      END                             
C
C
      SUBROUTINE G05ECF$(T, R, NR, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE, BINOMIAL, POISSON,
     +                                     LAMBDA 
      INTEGER    NR, IFAIL
      DOUBLE PRECISION R(NR), T
      INTEGER    MODE, N
      PARAMETER (MODE = 0, N = 1)
      INTEGER    X(N)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   G05TJF
      IF (T.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ENDIF  
      LAMBDA = T 
      BINOMIAL = .FALSE.
      POISSON = .TRUE. 
      IFAIL = -1
      CALL G05TJF (MODE, N, LAMBDA, R, NR, STATE, X, IFAIL) 
      END  
C
C
      SUBROUTINE G05EDF$(MVAL, PVAL, R, NR, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE, BINOMIAL, POISSON, P,
     +                                     M 
      INTEGER    MVAL, NR, IFAIL
      DOUBLE PRECISION PVAL, R(NR)
      INTEGER    MODE, N
      PARAMETER (MODE = 0, N = 1)
      INTEGER    X(N)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   G05TAF
      IF (MVAL.LT.0) THEN
         IFAIL = 1
         RETURN
      ELSEIF (PVAL.LT.ZERO .OR. PVAL.GT.ONE) THEN
         IFAIL = 2
         RETURN   
      ENDIF 
      M = MVAL 
      P = PVAL 
      BINOMIAL = .TRUE.
      POISSON = .FALSE. 
      IFAIL = -1
      CALL G05TAF (MODE, N, M, P, R, NR, STATE, X, IFAIL) 
      END          
C
C
      INTEGER FUNCTION G05EYF$(R, NR)
      USE        MODULE_G05_MARK23, ONLY : STATE, BINOMIAL, POISSON, 
     +                                     LAMBDA, P, M
      INTEGER    NR, IFAIL
      DOUBLE PRECISION R(NR)
      INTEGER    MODE, N
      PARAMETER (MODE = 1, N = 1)
      INTEGER    X(N)
      EXTERNAL   G05TJF, G05TAF
      IFAIL = -1
      IF (BINOMIAL) THEN
         CALL G05TAF (MODE, N, M, P, R, NR, STATE, X, IFAIL) 
      ELSEIF (POISSON) THEN
         CALL G05TJF (MODE, N, LAMBDA, R, NR, STATE, X, IFAIL) 
      ENDIF   
      G05EYF$ = X(1)
      END 
C
C
      SUBROUTINE G05EHF$(INDX, N, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE 
      INTEGER    IFAIL, N, INDX(N)
      EXTERNAL   G05NCF
      IF (N.LT.1) THEN
         IFAIL = 1
         RETURN
      ENDIF 
      IFAIL = -1
      CALL G05NCF (INDX, N, STATE, IFAIL) 
      END  
C
C
      SUBROUTINE G05FFF$(A, B, N, X, IFAIL)
      USE        MODULE_G05_MARK23, ONLY : STATE 
      INTEGER    IFAIL, N
      DOUBLE PRECISION A, B, X(N)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   G05SJF
      IF (N.LT.1 .OR. A.LE.ZERO .OR. B.LE.ZERO) THEN
         IFAIL = 1
         RETURN
      ENDIF 
      IFAIL = -1
      CALL G05SJF (N, A, B, STATE, X, IFAIL) 
      END                                       
C
C      
C*********************************************************************************
C End of G05 interface code for Mark 23
C*********************************************************************************
      