C
C ACTION: version of SIMFIT w_maths.dll to divert calls to the NAG library
C AUTHOR: bill.bardsley@manchester.ac.uk 22/02/2005
C
C
C G08CBF$ ... calls G08CBF except for extra distributions
C
C The following items are included for the extra distributions
C CDFVAL$
C NXSORT$
C NXXBAR$
C PROBKS
C PKS2
C
C
       SUBROUTINE G08CBF$(N, X, DIST, PAR, ESTIMA, NTYPE, D, Z, P, SX,
     +                    IFAIL)
C
C ACTION : 1 sample Kolmogorov-Smirnov test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 2/5/97
C          IFAIL is not tested on entry so it is like IFAIL = 1
C          Note that the NAG routine mistakenly reverses alpha and
C          beta when they are estimated from the sample moments for
C          the gamma distribution. (This was corrected at Mark 18)
C          28/08/1998 added lognormal
C          02/04/2000 corrected integers and D- for binomial and Poisson and
C                     added t, chi-square and F distributions
C          20/08/2001 added test for data < rtol for lognormal
C          22/12/2003 changed NXXBAR$, NXSORT$ to NXXBAR, NXSORT
C          27/04/2004 changed PROBKS$ to PROBKS
C                     Note: the p-values do not agree very closely with NAG for
C                     very small samples but I have checked that my routine PROBKS
C                     seems to be working well with ACM 487. Note the factor of 2 in
C                     the Kolmogorov series exponential argument which seems OK but
C                     is missing in Kolmogorov (1948) and Fellar (1948)
C          10/11/2005 changed NXXBAR, NXSORT to NXXBAR$, NXSORT$
C
      IMPLICIT   NONE
C
C Subroutine arguments
C
      INTEGER    IFAIL, NTYPE, N
      DOUBLE PRECISION D, P, PAR(*), SX(N), X(N), Z
      CHARACTER  DIST*(*), ESTIMA*(*)
C
C Local arguments
C
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K11, K12
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K11 = 11, K12 = 12)
      INTEGER    I, ISEND, ITEMP
      DOUBLE PRECISION RTOL, X02AMF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION CDF, CDFVAL$, CDF0, CDF1, DELTA, DN, DMINUS,
     +                 DPLUS, D1, D5, XBAR, XVAR, Y1, Y2
      CHARACTER  C1*1, C2*2
      LOGICAL    OK
      EXTERNAL   X02AMF$
      EXTERNAL   CDFVAL$, PROBKS
      EXTERNAL   NXSORT$, NXXBAR$
      EXTERNAL   GETIFA, G08CBF
      INTRINSIC  ABS, DBLE, NINT, SQRT, MAX, LOG, EXP
C
C Preliminary check for NAG library
C
      C1 = DIST(K1:K1)
      C2 = DIST(K1:K2)
      IF (C1.EQ.'U'  .OR. C1.EQ.'u'  .OR.
     +    C1.EQ.'N'  .OR. C1.EQ.'n'  .OR.
     +    C1.EQ.'G'  .OR. C1.EQ.'g'  .OR.
     +    C1.EQ.'E'  .OR. C1.EQ.'e'  .OR.
     +    C1.EQ.'P'  .OR. C1.EQ.'p'  .OR.
     +    C2.EQ.'BE' .OR. C2.EQ.'Be' .OR.
     +    C2.EQ.'bE' .OR. C2.EQ.'be' .OR.
     +    C2.EQ.'BI' .OR. C2.EQ.'Bi' .OR.
     +    C2.EQ.'bI' .OR. C2.EQ.'bi') THEN
         CALL GETIFA (IFAIL)
         CALL G08CBF (N, X, DIST, PAR, ESTIMA, NTYPE, D, Z, P, SX,
     +                IFAIL)
         RETURN
      ENDIF

C
C ======================================================================
C Part 1: Check the data supplied
C ======================================================================
C
C
C Is it safe ?
C
      IFAIL = K0
      D = ZERO
      P = ZERO
      Z = ZERO
C
C Check the sample size
C
      IF (N.LT.K3) THEN
         IFAIL = K1
         RETURN
      ENDIF
C
C Check that a valid distribution has been chosen
C
      C1 = DIST(K1:K1)
      C2 = DIST(K1:K2)
      IF (C1.EQ.'U' .OR. C1.EQ.'u') THEN
C
C Uniform distribution
C
         ISEND = K1
      ELSEIF (C1.EQ.'N' .OR. C1.EQ.'n') THEN
C
C Normal distribution
C
         ISEND = K2
      ELSEIF (C1.EQ.'G' .OR. C1.EQ.'g') THEN
C
C Gamma distribution
C
         ISEND = K3
      ELSEIF (C2.EQ.'BE' .OR. C2.EQ.'Be' .OR. C2 .EQ.'bE' .OR.
     +        C2.EQ.'be') THEN
C
C Beta distribution
C
         ISEND = K4
      ELSEIF (C2.EQ.'BI' .OR. C2.EQ.'Bi' .OR. C2.EQ.'bI' .OR.
     +        C2.EQ.'bi') THEN
         ISEND = K5
      ELSEIF (C1.EQ.'E' .OR. C1.EQ.'e') THEN
C
C Exponential distribution
C
         ISEND = K6
      ELSEIF (C1.EQ.'P' .OR. C1.EQ.'p') THEN
C
C Poisson distribution
C
         ISEND = K7
      ELSEIF (C1.EQ.'L' .OR. C1.EQ.'l') THEN
C
C lognormal  distribution
C
         ISEND = K8
      ELSEIF (C1.EQ.'W' .OR. C1.EQ.'w') THEN
C
C Weibull distribution
C
         ISEND = K9
      ELSEIF (C1.EQ.'T' .OR. C1.EQ.'t') THEN
C
C t distribution
C
         ISEND = K10
      ELSEIF (C1.EQ.'C' .OR. C1.EQ.'c') THEN
C
C chi-square distribution
C
         ISEND = K11
      ELSEIF (C1.EQ.'F' .OR. C1.EQ.'f') THEN
C
C F distribution
C
         ISEND  = K12
      ELSE
         IFAIL = K2
         RETURN
      ENDIF
C
C Check that a consistent test has been selected
C
      IF (NTYPE.LT.K1 .OR. NTYPE.GT.K3) THEN
         IFAIL = K3
         RETURN
      ENDIF
C
C Check ESTIMA
C
      IF (ISEND.LE.K9) THEN
         C1 = ESTIMA(K1:K1)
         IF (C1.EQ.'S' .OR. C1.EQ.'s') then
            C1 = 'S'
         ELSEIF (C1.EQ.'E' .OR. C1.EQ.'e') THEN
            C1 = 'E'
         ELSE
            IFAIL = K4
            RETURN
         ENDIF
      ELSE
         C1 = 'S'
      ENDIF
C
C Sort then check that valid parameters have been supplied
C
      DO I = K1, N
         SX(I) = X(I)
      ENDDO
      CALL NXSORT$(N, SX)
C
C Truncate to integers if binomial or Poisson
C
      IF (ISEND.EQ.K5 .OR. ISEND.EQ.K7) THEN
         DO I = K1, N
            ITEMP = NINT(SX(I))
            SX(I) = DBLE(ITEMP)
         ENDDO
      ENDIF
      RTOL = 1.0D+09*X02AMF$()
      IF ((SX(N) - SX(1)).LE.RTOL) THEN
         IF (ISEND.EQ.K1 .OR.
     +       ISEND.EQ.K2 .OR.
     +       ISEND.EQ.K3 .OR.
     +       ISEND.EQ.K4 .OR.
     +       ISEND.EQ.K8 .OR.
     +       ISEND.EQ.K9 .OR.
     +       ISEND.EQ.K10 .OR.
     +       ISEND.EQ.K11 .OR.
     +       ISEND.EQ.K12) THEN
             IFAIL = K6
             RETURN
         ENDIF
      ENDIF
      OK = .TRUE.
      IF (C1.EQ.'S') THEN
         IF (ISEND.EQ.K1) THEN
            IF (PAR(1).GE.PAR(2)) OK = .FALSE.
         ELSEIF (ISEND.EQ.K2) THEN
            IF (PAR(2).LE.RTOL) OK = .FALSE.
         ELSEIF (ISEND.EQ.K3) THEN
            IF (PAR(1).LT.ZERO .OR. PAR(2).LT.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K4) THEN
            IF (PAR(1).LE.ZERO .OR. PAR(2).LE.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K5) THEN
            IF (PAR(1).LT.ONE .OR. PAR(2).LT.ZERO .OR.
     +          PAR(2).GT.ONE) OK = .FALSE.
         ELSEIF (ISEND.EQ.K6) THEN
            IF (PAR(1).LE.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K7) THEN
            IF (PAR(1).LE.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K8) THEN
            IF (PAR(2).LE.RTOL) OK = .FALSE.
         ELSEIF (ISEND.EQ.K9) THEN
            IF (PAR(1).LE.RTOL .OR.
     +          PAR(2).LE.RTOL) OK = .FALSE.
         ELSEIF (ISEND.EQ.K10) THEN
            IF (PAR(1).LT.ONE) OK = .FALSE.
         ELSEIF (ISEND.EQ.K11) THEN
            IF (PAR(1).LT.ONE) OK = .FALSE.
         ELSEIF (ISEND.EQ.K12) THEN
            IF (PAR(1).LT.ONE .OR.
     +          PAR(2).LT.ONE) OK = .FALSE.
         ENDIF
      ELSE
         IF (ISEND.EQ.K5 .AND. PAR(1).LT.ONE) OK = .FALSE.
      ENDIF
      IF (.NOT.OK) THEN
         IFAIL = K5
         RETURN
      ENDIF
C
C ======================================================================
C Part 2 : Check the data values
C ======================================================================
C
C Check that the data are consistent with the chosen distribution
C
      OK = .TRUE.
      IF (ISEND.EQ.K1) THEN
C
C Uniform distribution
C
         IF (C1.EQ.'S') THEN
            IF (SX(1).LT.PAR(1) .OR. SX(N).GT.PAR(2)) OK = .FALSE.
         ENDIF
      ELSEIF (ISEND.EQ.K3) THEN
C
C Gamma distribution
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K4) THEN
C
C Beta distribution
C
         IF (SX(1).LT.ZERO .OR. SX(N).GT.ONE) OK = .FALSE.
      ELSEIF (ISEND.EQ.K5) THEN
C
C Binomial distribution
C
         IF (SX(1).LT.ZERO .OR. SX(N).GT.PAR(1)) OK = .FALSE.
      ELSEIF (ISEND.EQ.K6) THEN
C
C Exponential distribution
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K7) THEN
C
C Poisson distribution
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K8) THEN
C
C Lognormal
C
         IF (SX(1).LE.RTOL) OK = .FALSE.
      ELSEIF (ISEND.EQ.K9) THEN
C
C Weibull
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K11) THEN
C
C chi-square
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K12) THEN
C
C F
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ENDIF
      IF (.NOT.OK) THEN
         IFAIL = K6
         RETURN
      ENDIF
C
C ======================================================================
C Part 3: Estimate parameters from the sample
C ======================================================================
C
C Estimate parameters from the sample
C
      DN = DBLE(N)
      IF (C1.EQ.'E') THEN
         IF (ABS(SX(K1) - SX(N)).LE.RTOL .AND. ISEND.LE.K4) THEN
            IFAIL = K7
            RETURN
         ENDIF
         IF (ISEND.EQ.K1) THEN
C
C Uniform distribution
C
            PAR(1) = SX(1)
            PAR(2) = SX(N)
         ELSEIF (ISEND.EQ.K2) THEN
C
C Normal distribution
C
            CALL NXXBAR$(N, SX, XBAR, XVAR)
            PAR(1) = XBAR
            PAR(2) = XVAR
         ELSEIF (ISEND.EQ.K3) THEN
C
C Gamma distribution
C
            CALL NXXBAR$(N, SX, XBAR, XVAR)
            PAR(2) = XVAR/XBAR
            PAR(1) = XBAR/PAR(2)
         ELSEIF (ISEND.EQ.K4) THEN
C
C Beta distribution
C
            CALL NXXBAR$(N, SX, XBAR, XVAR)
            Y1 = XBAR**2/XVAR
            Y2 = ONE/XBAR - ONE
            PAR(1) = XBAR*(Y1*Y2 - ONE)
            PAR(2) = PAR(1)*Y2
            IF (PAR(1).LT.RTOL) PAR(1) = RTOL
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
         ELSEIF (ISEND.EQ.K5) THEN
C
C Binomial distribution
C
            CALL NXXBAR$(N, SX, XBAR, XVAR)
            PAR(2) = XBAR/PAR(1)
         ELSEIF (ISEND.EQ.K6) THEN
C
C Exponential distribution
C
             CALL NXXBAR$(N, SX, XBAR, XVAR)
             PAR(1) = ONE/XBAR
         ELSEIF (ISEND.EQ.K7) THEN
C
C Poisson distribution
C
            CALL NXXBAR$(N, SX, XBAR, XVAR)
            PAR(1) = XBAR
         ELSEIF (ISEND.EQ.K8) THEN
C
C lognormal
C
            DO I = 1, N
               SX(I) = LOG(SX(I))
            ENDDO
            CALL NXXBAR$(N, SX, XBAR, XVAR)
            PAR(1) = XBAR
            PAR(2) = XVAR
            DO I = 1, N
               SX(I) = EXP(SX(I))
            ENDDO
         ENDIF
      ENDIF
C
C Check np(1 - p) if Binomial distribution
C
      IF (ISEND.EQ.K5) THEN
         XVAR = PAR(1)*PAR(2)*(ONE - PAR(2))
         IF (XVAR.GT.1000000.0) THEN
            IFAIL = K8
            RETURN
         ENDIF
      ENDIF
C
C ======================================================================
C Part 4: Calculate the D values
C ======================================================================
C
C
C Initialise all the counters
C
      CDF0 = ZERO
      CDF1 = ZERO
      DELTA = ZERO
      DPLUS = ZERO
      DMINUS = ZERO
      IF (ISEND.EQ.K5 .OR. ISEND.EQ.K7) THEN
C
C Special action for discrete distributions since CDF0 not tested
C
         DO I = K1, N
            IF (I.LT.N) THEN
               IF (SX(I + K1).GT.SX(I)) THEN
C
C The next X increases
C
                  OK = .TRUE.
              ELSE
C
C The next X is a replicate
C
                  OK = .FALSE.
               ENDIF
            ELSE
C
C The next X is the last
C
               OK = .TRUE.
            ENDIF
            IF (OK) THEN
C
C The end of one or a group of replicates so do the sums
C
               CDF = CDFVAL$(ISEND, PAR, SX(I))
               CDF1 = DBLE(I)/DN
               DELTA = CDF1 - CDF
               IF (DELTA.GT.DPLUS) DPLUS = DELTA
               IF (DELTA.LT.DMINUS) DMINUS = DELTA
            ENDIF
         ENDDO
      ELSE
         DO I = K1, N
            IF (I.LT.N) THEN
               IF (SX(I + K1).GT.SX(I)) THEN
C
C The next X increases
C
                  OK = .TRUE.
              ELSE
C
C The next X is a replicate
C
                  OK = .FALSE.
               ENDIF
            ELSE
C
C The next X is the last
C
               OK = .TRUE.
            ENDIF
            IF (OK) THEN
C
C The end of one or a group of replicates so do the sums
C
               CDF = CDFVAL$(ISEND, PAR, SX(I))
               CDF1 = DBLE(I)/DN
               DELTA = CDF1 - CDF
               IF (DELTA.GT.DPLUS) DPLUS = DELTA
               DELTA = CDF0 - CDF
               IF (DELTA.LT.DMINUS) DMINUS = DELTA
               CDF0 = CDF1
            ENDIF
         ENDDO
      ENDIF
C
C ======================================================================
C Part 5: Adjust the D and P values
C ======================================================================
C
      IF (NTYPE.EQ.K1) THEN
         D = MAX (- DMINUS, DPLUS)
      ELSEIF (NTYPE.EQ.K2) THEN
         D = DPLUS
      ELSE
         D = - DMINUS
      ENDIF
      CALL PROBKS (N, D, D1, D5, P)
      IF (NTYPE.GT.K1) P = P/TWO
      Z = D*SQRT(DN)
      END
C
C
      DOUBLE PRECISION FUNCTION CDFVAL$(ISEND, PAR, X)
C
C ACTION : CDF for probability distributions
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 2/5/97
C          28/8/98 Added lognormal and Weibull
C          04/04/2000 Added t, chi-square and F
C
      IMPLICIT   NONE
      INTEGER    ISEND
      INTEGER    K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K11, K12
      PARAMETER (K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K11 = 11, K12 = 12)
      INTEGER    IFAIL, N, K
      DOUBLE PRECISION PAR(*), X
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION A, B, G, P, PDF, PEQK, PGTK, PLEK, Q, RTOL,
     +                 TOL, XNEW, Z
      DOUBLE PRECISION S15ABF$, X02AJF$, X02AMF$, G01EBF$, G01ECF$,
     +                 G01EDF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   S14BAF$, S15ABF$, X02AJF$, X02AMF$, G01EBF$, G01ECF$,
     +           G01EDF$
      EXTERNAL   G01EEF$, G01BJF$
      INTRINSIC  NINT, EXP, SQRT, LOG
      IF (ISEND.EQ.K1) THEN
C
C Uniform distribution
C
         A = X - PAR(K1)
         B = PAR(K2) - PAR(K1)
         CDFVAL$ = A/B
      ELSEIF (ISEND.EQ.K2) THEN
C
C Normal distribution
C
         RTOL = 1.0D+09*X02AMF$()
         IF (PAR(2).GT.RTOL) THEN
            XNEW = (X - PAR(K1))/SQRT(PAR(K2))
            IFAIL = K1
            CDFVAL$ = S15ABF$(XNEW, IFAIL)
         ELSE
            CDFVAL$ = ZERO
         ENDIF
      ELSEIF (ISEND.EQ.K3) THEN
C
C Gamma distribution
C
         G = X
         Z = G/PAR(K2)
         A = PAR(K1)
         TOL = 1.0D+02*X02AJF$()
         IFAIL = K1
         CALL S14BAF$(A, Z, TOL, P, Q, IFAIL)
         CDFVAL$ = P
      ELSEIF (ISEND.EQ.K4) THEN
C
C Beta distribution
C
         A = PAR(K1)
         B = PAR(K2)
         TOL = 1.0D+02*X02AJF$()
         IFAIL = K1
         CALL G01EEF$(X, A, B, TOL, P, Q, PDF, IFAIL)
         CDFVAL$ = P
      ELSEIF (ISEND.EQ.K5) THEN
C
C Binomial distribution
C
         N = NINT(PAR(K1))
         K = NINT(X)
         P = PAR(K2)
         IFAIL = K1
         CALL G01BJF$(N, P, K, PLEK, PGTK, PEQK, IFAIL)
         CDFVAL$ = PLEK
      ELSEIF (ISEND.EQ.K6) THEN
C
C Exponential distribution
C
         XNEW = - PAR(1)*X
         IF (XNEW.LT.-100.0D+00) THEN
            CDFVAL$ = ZERO
         ELSEIF (XNEW.GT.100.0D+00) THEN
            CDFVAL$ = ONE
         ELSE
            CDFVAL$ = ONE - EXP(XNEW)
         ENDIF
      ELSEIF (ISEND.EQ.K7) THEN
C
C Poisson distribution
C
         IFAIL = K1
         TOL = 1.0D+02*X02AJF$()
         A = PAR(K1)
         XNEW = X + ONE
         CALL S14BAF$(XNEW, A, TOL, P, Q, IFAIL)
         CDFVAL$ = Q
      ELSEIF (ISEND.EQ.K8) THEN
C
C lognormal distribution
C
         RTOL = 1.0D+09*X02AMF$()
         IF (PAR(2).GT.RTOL) THEN
            XNEW = (LOG(X) - PAR(K1))/SQRT(PAR(K2))
            IFAIL = K1
            CDFVAL$ = S15ABF$(XNEW, IFAIL)
         ELSE
            CDFVAL$ = ZERO
         ENDIF
      ELSEIF (ISEND.EQ.K9) THEN
C
C Weibull distribution
C
         XNEW = - (PAR(1)*X)**PAR(2)
         IF (XNEW.LT.-100.0D+00) THEN
            CDFVAL$ = ZERO
         ELSEIF (XNEW.GT.100.0D+00) THEN
            CDFVAL$ = ONE
         ELSE
            CDFVAL$ = ONE - EXP(XNEW)
         ENDIF
      ELSEIF (ISEND.EQ.K10) THEN
C
C t distribution
C
         IFAIL = K1
         CDFVAL$ = G01EBF$(TAIL, X, PAR(K1), IFAIL)
      ELSEIF (ISEND.EQ.K11) THEN
C
C Chi-square distribution
C
         IFAIL = K1
         CDFVAL$ = G01ECF$(TAIL, X, PAR(K1), IFAIL)
      ELSEIF (ISEND.EQ.K12) THEN
C
C F distribution
C
         IFAIL = K1
         CDFVAL$ =  G01EDF$(TAIL, X, PAR(K1), PAR(K2), IFAIL)
      ENDIF
      END
C
C
      SUBROUTINE NXSORT$(N, X)
C
C ACTION : Sort array X into increasing order using HEAPSORT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Date of this version 5/4/97
C
      IMPLICIT NONE
      INTEGER  N
      INTEGER  I, J, K, L
      DOUBLE PRECISION X(N)
      DOUBLE PRECISION XTEMP
      IF (N.LT.2) RETURN
      L = N/2 + 1
      K = N
   20 CONTINUE
         IF (L.GT.1) THEN
            L = L - 1
            XTEMP = X(L)
         ELSE
            XTEMP = X(K)
            X(K) = X(1)
            K = K - 1
            IF (K.EQ.1) THEN
               X(1) = XTEMP
               GOTO 60
            ENDIF
         ENDIF
         I = L
         J = L + L
   40    IF (J.LE.K) THEN
            IF (J.LT.K) THEN
               IF (X(J).LT.X(J + 1)) J = J + 1
            ENDIF
            IF (XTEMP.LT.X(J)) THEN
               X(I) = X(J)
               I = J
               J = J + J
            ELSE
               J = K + 1
            ENDIF
            GOTO 40
         ENDIF
         X(I) = XTEMP
         GOTO 20
   60 CONTINUE
      END
C
C
      SUBROUTINE NXXBAR$(N, X, XBAR, XVAR)
C
C ACTION : Input X(N) then return XBAR and sample variance unless N < 2
C AUTHOR : W. G. Bardsley, 26/07/90
C          05/07/99 Revised
C          Date of this version 05/07/99
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    I
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      DOUBLE PRECISION X(N)
      DOUBLE PRECISION XBAR, XVAR
      DOUBLE PRECISION DN, SUMS, SUMX
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      INTRINSIC  DBLE
C
C Check N
C
      IF (N.LT.N2) THEN
         XBAR = ZERO
         XVAR = ZERO
         IF (N.EQ.N1) XBAR = X(N1)
         RETURN
      ELSE
         DN = DBLE(N)
      ENDIF
C
C Calculate XBAR
C
      SUMX = ZERO
      DO I = N1, N
         SUMX = SUMX + X(I)
      ENDDO
      XBAR = SUMX/DN
C
C Calculate XVAR
C
      SUMS = ZERO
      DO I = N1, N
         SUMS = SUMS + (X(I) - XBAR)**2
      ENDDO
      XVAR = SUMS/(DN - ONE)
      END
C
C
C uses PKS2 = ACM 487 to calculate probabilities
C
      SUBROUTINE PROBKS (N, D, D1, D5, P)
C
C ACTION : Input N and D and return D1, D5 and P(Kolmogorov-Smirnov >= D)
C ADVICE : Table used for D1 and D2 when N =< 50. See NAG G08CAF
C          PKS2 used for small samples o/w series
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 10/3/93
C          05/04/2000 Added call to PKS2 for small samples
C          27/04/2004 included X01AAF$ and x02AMF$ in line so the routine
C                     is then independent of the NAG-substitute routines
C                     Also enlarged table to N = 50
C          Date of this version 27/04/2004
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    NTABLE
      PARAMETER (NTABLE = 50)
      INTEGER    I
      DOUBLE PRECISION D, D1, D5, P
      DOUBLE PRECISION ARG, ENEG, FCN, PI, TEMP, X01AAF$, X02AMF$, Z
      DOUBLE PRECISION TABLE1(NTABLE), TABLE5(NTABLE)
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PKS2
      EXTERNAL   PKS2
      INTRINSIC  DBLE, EXP, LOG, MAX, SQRT
      DATA TABLE1 /
     +.9950D+00, .9292D+00, .8290D+00, .7342D+00, .6685D+00,
     +.6166D+00, .5758D+00, .5418D+00, .5133D+00, .4889D+00,
     +.4677D+00, .4490D+00, .4325D+00, .4176D+00, .4042D+00,
     +.3920D+00, .3809D+00, .3706D+00, .3612D+00, .3524D+00,
     +.3443D+00, .3367D+00, .3295D+00, .3229D+00, .3165D+00,
     +.3106D+00, .3050D+00, .2997D+00, .2947D+00, .2899D+00,
     +.2852D+00, .2809D+00, .2768D+00, .2728D+00, .2690D+00,
     +.2653D+00, .2618D+00, .2584D+00, .2552D+00, .2521D+00,
     +.2490D+00, .2461D+00, .2433D+00, .2406D+00, .2380D+00,
     +.2354D+00, .2330D+00, .2306D+00, .2283D+00, .2260D+00 /
      DATA TABLE5 /
     +.9750D+00, .8419D+00, .7076D+00, .6239D+00, .5633D+00,
     +.5192D+00, .4834D+00, .4543D+00, .4300D+00, .4093D+00,
     +.3912D+00, .3754D+00, .3614D+00, .3489D+00, .3376D+00,
     +.3273D+00, .3180D+00, .3094D+00, .3014D+00, .2940D+00,
     +.2872D+00, .2809D+00, .2749D+00, .2693D+00, .2640D+00,
     +.2591D+00, .2544D+00, .2499D+00, .2457D+00, .2417D+00,
     +.2379D+00, .2342D+00, .2307D+00, .2274D+00, .2243D+00,
     +.2212D+00, .2183D+00, .2154D+00, .2127D+00, .2101D+00,
     +.2076D+00, .2052D+00, .2028D+00, .2006D+00, .1984D+00,
     +.1963D+00, .1942D+00, .1922D+00, .1903D+00, .1884D+00 /
C
C Initialise
C
      X01AAF$ = 3.14159265358979323846264338328D+00
      X02AMF$ = 2.574667400493D-308
      ENEG = LOG(1.0D+09*X02AMF$)
      PI = X01AAF$
      TEMP = DBLE(N)
      Z = SQRT(TEMP)*D
C
C Calculate P
C
      IF (N.LE.140 .AND. D.LE.0.1D+00 .OR.
     +    N.LE.70  .AND. D.LE.0.2D+00 .OR.
     +    N.LE.60  .AND. D.LE.0.3D+00 .OR.
     +    N.LE.50  .AND. D.LE.0.5D+00 .OR.
     +    N.LE.40  .AND. D.LE.0.6D+00 .OR.
     +    N.LE.30  .AND. D.LE.0.7D+00 .OR.
     +    N.LE.20  .AND. D.LE.0.8D+00 .OR.
     +    N.LE.10) THEN
         FCN = PKS2 (N, D)
      ELSEIF (Z.LE.0.27D+00) THEN
         FCN = ZERO
      ELSEIF (Z.LE.ONE) THEN
         TEMP = (PI**2)/(8.0D+00*Z**2)
         FCN = ZERO
         DO I = 1, 3
            ARG = MAX(ENEG, - TEMP*(TWO*I - ONE)**2)
            FCN = FCN + EXP(ARG)
         ENDDO
         FCN = FCN*(SQRT(TWO*PI))/Z
      ELSEIF (Z.LE.3.1D+00) THEN
         FCN = ZERO
         TEMP = ONE
         DO I = 1, 4
            ARG = MAX(ENEG, - TWO*I**2*Z**2)
            FCN = FCN + TEMP*EXP(ARG)
            TEMP = - TEMP
         ENDDO
         FCN = ONE - TWO*FCN
      ELSE
         FCN = ONE
      ENDIF
      P = ONE - FCN
C
C Check P
C
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
C
C Critical values D1 and D5
C
      IF (N.LE.NTABLE) THEN
         D1 = TABLE1(N)
         D5 = TABLE5(N)
      ELSE
         ARG = DBLE(N)
         TEMP = SQRT(ARG)
         D1 = 1.62762D+00/TEMP
         D5 = 1.35810D+00/TEMP
      ENDIF
      END
C
C
C
C ACM 487
C
C Function PKS2 adapted by W.G.Bardsley, 04/04/2000
C =================================================
C Replaced intrinsics by generics, introduced implicit none, declared
C intrinsics, reflected PKS2 back into (0,1) and doubled array dimensions
C for future developments.
C
C     ALGORITHM 487 COLLECTED ALGORITHMS FROM ACM.
C     ALGORITHM APPEARED IN COMM. ACM, VOL. 17, NO. 12,
C     P. 703.
      DOUBLE PRECISION FUNCTION PKS2 (N, D)
      IMPLICIT NONE
C
C Arguments supplied are N and D
C
      INTEGER N
      DOUBLE PRECISION D
C
C N IS THE SAMPLE SIZE USED.
C D IS THE MAXIMUM MAGNITUDE (OF THE DISCREPANCY
C BETWEEN THE EMPIRICAL AND PROPOSED DISTRIBUTIONS)
C IN EITHER THE POSITIVE OR NEGATIVE DIRECTION.
C PKS2 IS THE EXACT PROBABILITY OF OBTAINING A
C DEVIATION NO LARGER THAN D.
C THESE FORMULAS APPEAR AS (23) AND (24) IN
C J. DURBIN.  THE PROBABILITY THAT THE SAMPLE
C DISTRIBUTION FUNCTION LIES BETWEEN TWO PARALLEL
C STRAIGHT LINES. ANNALS OF MATHEMATICAL STATISTICS
C 39, 2(APRIL 1968),398-411.
C
      INTEGER    I, J, JMAX, K, ND, NDD, NDDP, NDP, NDT
      DOUBLE PRECISION Q(282), FACT(282), SUM1, CI,
     + FT, FU, FV
      DOUBLE PRECISION FN, FND, SIGN1
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      INTRINSIC  MIN, INT, DBLE
      IF (N.EQ.1) GO TO 90
      FN = DBLE(N)
      FND = FN*D
      NDT = INT(TWO*FND)
      IF (NDT.LT.1) GO TO 100
      ND = INT(FND)
      NDD = MIN(2*ND,N)
      NDP = ND + 1
      NDDP = NDD + 1
      FACT(1) = ONE
      CI = ONE
      DO 10 I = 1, N
        FACT(I + 1) = FACT(I)*CI
        CI = CI + ONE
   10 CONTINUE
      Q(1) = ONE
      IF (NDD.EQ.0) GO TO 50
      CI = ONE
      DO 20 I = 1, NDD
        Q(I + 1) = CI**I/FACT(I + 1)
        CI = CI + ONE
   20 CONTINUE
      IF (NDP.GT.N) GO TO 80
      FV = DBLE(NDP) - FND
      JMAX = INT(FV) + 1
      DO 40 I = NDP, NDD
        SUM1 = ZERO
        FT = FND
        K = I
        FU = FV
        DO 30 J = 1, JMAX
          SUM1 = SUM1 + FT**(J - 2)/FACT(J)*FU**K/
     +     FACT(K + 1)
          FT = FT + ONE
          FU = FU - ONE
          K = K - 1
   30   CONTINUE
        Q(I + 1) = Q(I + 1) - TWO*FND*SUM1
        JMAX = JMAX + 1
        FV = FV + ONE
   40 CONTINUE
      IF (NDD.EQ.N) GO TO 80
   50 DO 70 I = NDDP, N
        SUM1 = ZERO
        SIGN1 = ONE
        FT = TWO*FND
        DO 60 J = 1, NDT
          FT = FT - ONE
          K = I - J + 1
          SUM1 = SUM1 + SIGN1*FT**J/FACT(J + 1)*Q(K)
          SIGN1 = - SIGN1
   60   CONTINUE
        Q(I + 1) = SUM1
   70 CONTINUE
   80 PKS2 = Q(N + 1)*FACT(N + 1)/FN**N
      IF (PKS2.LT.ZERO) PKS2 = ZERO
      IF (PKS2.GT.ONE) PKS2 = ONE
      RETURN
   90 PKS2 = TWO*D - ONE
      IF (PKS2.LT.ZERO) PKS2 = ZERO
      IF (PKS2.GT.ONE) PKS2 = ONE
      RETURN
  100 PKS2 = ZERO
      RETURN
      END
C
C
