c
c
c 29/01/2020 This G10BAF$ is to replace the call to G10BAF by a call to G10BBF
c            The academic version of G10BAF$ also here is based on APS176 and is a non-threaded version. 
c            It is a stand-alone version that does not call any NAG routines.
c
C
C ACTION: version of SIMFIT w_maths.dll to divert calls to the NAG library
C AUTHOR: bill.bardsley@manchester.ac.uk 23/02/2005
C         23/01/2020 now calls g10bbf at mark 27
C
      SUBROUTINE G10BAF$(N, X, WINDOW, SLO, SHI, NS, SMOOTH, T,
     +                   USEFFT, FFT, IFAIL)
C
C ACTION: Front end to NAG routine
C AUTHOR: w.g.bardsley, university of manchester, u.k., 30/01/2020
C
      IMPLICIT NONE
      INTEGER  N, NS, IFAIL
      DOUBLE PRECISION X(N), WINDOW, SLO, SHI, SMOOTH(NS), T(NS),
     +                 FFT(NS)
      LOGICAL USEFFT
C
C start new declarations required to call g10bbf
C       
      INTEGER NS_SAV
      DOUBLE PRECISION, ALLOCATABLE :: RCOMM(:)
C
C end new declarations required to call g10bbf
C      
      EXTERNAL GETIFA, G10BBF
      SAVE     RCOMM
      DATA     NS_SAV / 0 /
C
C Make sure IFAIL is in range
C
      CALL GETIFA (IFAIL)
C
C Call the actual NAG library routine G10BBF but first allocate RCOMM if required
C
      IF (NS + 20 .GT. NS_SAV) THEN
         NS_SAV  = NS + 20 
         ALLOCATE (RCOMM(NS_SAV))
      ENDIF   
      CALL G10BBF (N, X, 2, WINDOW, SLO, SHI, NS, SMOOTH, T,
     +             USEFFT, FFT, RCOMM, IFAIL)
      END
C
C
C
C Action: Simfit substitute for G10BAF based on AS176
C Author: w.g.bardsley, university of manchester, u.k., 20/10/2012
C
C 30/10/2012 now returns IFAIL = (10 + IFAULT) if failure occurs in APS176
C            and also requires NS = 2**K for call to APS176     
C
      SUBROUTINE G10BAF$_OLD(N, X, WINDOW, SLO, SHI, NS, SMOOTH, T,
     +                   USEFFT, FFT, IFAIL)
      IMPLICIT   NONE     
C
C Arguments
C
      INTEGER    N, NS, IFAIL
      DOUBLE PRECISION X(N), WINDOW, SLO, SHI, SMOOTH(NS), T(NS),
     +                 FFT(NS)
      LOGICAL    USEFFT
C
C Locals
C      
      INTEGER    I, ICAL, IFAULT
      DOUBLE PRECISION DELTA, XBOT, XTOP
      DOUBLE PRECISION ZERO, HALF, THREE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, THREE = 3.0D+00)
      LOGICAL    READY
      EXTERNAL   APS176
      INTRINSIC  DBLE
      SAVE       READY
      DATA       READY / .FALSE. /
      IFAIL = 1
      IF (N.LE.0 .OR.
     +    NS.LT.2 .OR.
     +    SHI.LE.SLO .OR.
     +    WINDOW.LE.ZERO) RETURN 
      IFAIL = 2
      IF (USEFFT) THEN
        IF (.NOT.READY) RETURN
        ICAL = 1  
      ELSE
         ICAL = 0
      ENDIF  
      IFAIL = 4
      XBOT = X(1)
      XTOP = X(1)
      DO I = 2, N
         IF (X(I).LT.XBOT) THEN
            XBOT = X(I)
         ELSEIF (X(I).GT.XTOP) THEN
            XTOP = X(I)
         ENDIF
      ENDDO 
      IF (XBOT - THREE*WINDOW.LT.SLO .OR.
     +    XTOP + THREE*WINDOW.GT.SHI) RETURN 
              
      CALL APS176(X, N, SLO, SHI, WINDOW, FFT, SMOOTH, NS, ICAL, IFAULT)
      
      IF (IFAULT.NE.0) THEN
         IFAIL = 10 + IFAULT
         READY = .FALSE.
      ELSE
         IFAIL = 0
         READY = .TRUE.
         DELTA = (SHI - SLO)/DBLE(NS)
         DO I = 1, NS
            T(I) = SLO + (DBLE(I) - HALF)*DELTA
         ENDDO  
      ENDIF
      END 


c 
c 17/10/2012 edited (in lower case) by w.g.bardsley, university of manchester, u.k.
c AS R50 Jones and Lotwick 1983 improvement included
c Also changed kftlo and kfthi from (5, 1) to (3, 21)
c      
C renaming as follows:
C DENEST = APS176
C  FORRT = APS97
C  REVRT = APS97_1
C FASTFG = APS97_2
C  SCRAG = APS97_3     
c
c      SUBROUTINE DENEST(DT, NDT, DLO, DHI, WINDOW, FT, SMOOTH,
c     *                  NFT, ICAL, IFAULT)
      SUBROUTINE APS176(DT, NDT, DLO, DHI, WINDOW, FT, SMOOTH,
     *                  NFT, ICAL, IFAULT)
     
       implicit none
         
c      REAL DT(NDT), FT(NFT), SMOOTH(NFT)
C
C     ALGORITHM AS 176  APPL. STATIST. (1982) VOL.31, NO.1
C     Modified using AS R50 (Appl. Statist. (1984))
C
C     Find density estimate by kernel method using Gaussian kernel.
C     The interval on which the estimate is evaluated has end points
C     DLO and DHI.   If ICAL is not zero then it is assumed that the
C     routine has been called before with the same data and end points
C     and that the array FT has not been altered.
C
C     Auxiliary routines called: FORRT & REVRT from AS 97
C

c
c arguments
c
      integer,          intent (in)    :: ical, ndt, nft
      integer,          intent (out)   :: ifault
      double precision, intent (in)    :: dt(ndt)
      double precision, intent (inout) :: ft(nft), smooth(nft)
      double precision, intent (in)    :: dlo, dhi, window
c
c locals
c      
      integer i, ii, j, jj, jhi, jmax, j1, j2, j2lo, k, kk, nft2 
      integer kftlo, kfthi
      double precision ainc, bc, dlo1, fac, fac1, hw, rj, rjfac, step,
     +                 winc, wt
      double precision zero, half, one, six, thir2
      double precision big
      external  aps97, aps97_1
      intrinsic dble, exp, atan, min, sqrt
      DATA ZERO/0.0d+00/, HALF/0.5d+00/, ONE/1.0d+00/, SIX/6.0d+00/
     +                  , THIR2/32.0d+00/
      DATA BIG/30.0d+00/, KFTLO/3/, KFTHI/21/
C
C     The constant BIG is set so that exp(-BIG) can be calculated
C     without causing underflow problems and can be considered = 0.
C
C     Initialize and check for valid parameter values.
C
      IF (WINDOW .LE. ZERO) GO TO 92
      IF (DLO .GE. DHI) GO TO 93
      II = 2**KFTLO
      DO 1 K = KFTLO, KFTHI
      IF (II .EQ. NFT) GO TO 2
      II = II + II
    1 CONTINUE
      IFAULT = 1
      RETURN
    2 STEP = (DHI - DLO) / dble(NFT)
      AINC = ONE / (NDT * STEP)
      NFT2 = NFT / 2
      HW = WINDOW / STEP
      FAC1 = THIR2 * (ATAN(ONE) * HW / NFT) ** 2
      IF (ICAL .NE. 0) GO TO 10
C
C     Discretize the data
C
      DLO1 = DLO - STEP * HALF
      DO 3 J = 1, NFT
      FT(J) = ZERO
    3 continue
      DO 4 I = 1, NDT
      WT = (DT(I) - DLO1) / STEP
      JJ = INT(WT)
      IF (JJ .LT. 1 .OR. JJ .GT. NFT) GO TO 4
      WT = WT - dble(JJ)
      WINC = WT * AINC
      KK = JJ + 1
      IF (JJ .EQ. NFT) KK = 1
      FT(JJ) = FT(JJ) + AINC - WINC
      FT(KK) = FT(KK) + WINC
    4 CONTINUE
C
C     Transform to find FT.
C
      CALL APS97(FT, NFT)
C
C     Find transform of density estimate.
C
   10 JHI = SQRT(BIG / FAC1)
      JMAX = MIN(NFT2 - 1, JHI)
      SMOOTH(1) = FT(1)
      RJ = ZERO
      DO 11 J = 1, JMAX
      RJ = RJ + ONE
      RJFAC = RJ * RJ * FAC1
      BC = ONE - RJFAC / (HW * HW * SIX)
      FAC = EXP(-RJFAC) / BC
      J1 = J + 1
      J2 = J1 + NFT2
      SMOOTH(J1) = FAC * FT(J1)
      SMOOTH(J2) = FAC * FT(J2)
   11 CONTINUE
C
C     Cope with underflow by setting tail of transform to zero.
C
      IF (JHI + 1 - NFT2) 21, 23, 20
   20 SMOOTH(NFT2 + 1) = EXP(-FAC1 * dble(NFT2)**2) * FT(NFT2 + 1)
      GO TO 24
   21 J2LO = JHI + 2
      DO 22 J1 = J2LO, NFT2
      J2 = J1 + NFT2
      SMOOTH(J1) = ZERO
      SMOOTH(J2) = ZERO
   22 CONTINUE
   23 SMOOTH(NFT2 + 1) = ZERO
C
C     Invert Fourier transform of SMOOTH to get estimate and eliminate
C     negative density values.
C
   24 CALL APS97_1(SMOOTH, NFT)
      DO 25 J = 1, NFT
      IF (SMOOTH(J) .LT. ZERO) SMOOTH(J) = ZERO
   25 continue
      IFAULT = 0
      RETURN
C
   92 IFAULT = 2
      RETURN
   93 IFAULT = 3
      RETURN
      END


c 
c
c 17/10/2012 edited (in lower case) by w.g.bardsley, university of manchester, u.k.
c  FORRT = APS97
C  REVRT = APS97_1
C FASTFG = APS97_2
C  SCRAG = APS97_3
c 
C      SUBROUTINE FORRT(X, M)
      subroutine aps97 (x, m)

      implicit none
      
C
C     ALGORITHM AS 97  APPL. STATIST. (1976) VOL.25, NO. 2
C
C     Forward discrete Fourier transform in one dimension of real
C     data using complex transform subroutine FASTG.
C
C     X = array of real input data, type real, dimension M.
C     M = length of the transform, must be a power of 2.
C     The minimum length is 8, maximum 2**21.
C
C     The result is placed in X as described in the text of the paper.
C
C     Auxiliary routines required: SCRAG (or SCRAM) & FASTG from AS 83,
C     but with SCRAG modified as described on page 168 of the paper for
C     this algorithm.
C
c      REAL X(M)
c
c arguments
c
      integer,          intent (in)    :: m
      double precision, intent (inout) :: x(m) 
c
c locals
c      
      integer ii, ipow, jpow, k, ki, l, li, n, nn, nn1, nn2
      double precision an, bcos, bn, bsin, cn, dn, pie, save1, un, vn,
     +                 yn, xn, z
      double precision zero, quart, half, one, one5, two, four
c      external scrag, fastg
      external aps97_3, aps97_2
      
      DATA ZERO/0.0d+00/, QUART/0.25d+00/, HALF/0.5d+00/, ONE/1.0d+00/,
     +     ONE5/1.5d+00/, TWO/2.0d+00/, FOUR/4.0d+00/
C
C     Check for valid transform size.
C
      II = 8
      DO 2 K = 3, 21
      IPOW = K
      IF (II .EQ. M) GO TO 3
      II = II * 2
    2 CONTINUE
C
C     If this point is reached, an illegal size was specified.
C
      RETURN
    3 PIE = FOUR * ATAN(ONE)
C
C     Separate odd and even parts into two halves.
C     First bit reverse the whole array of length M.
C
C      CALL SCRAG(X, M, IPOW)
      CALL APS97_3 (X, M, IPOW)
C
C     Next bit reverse the half arrays separately.
C
      N = M / 2
      JPOW = IPOW - 1
C      CALL SCRAG(X, N, JPOW)
      CALL APS97_3 (X, N, JPOW)
C      CALL SCRAG(X(N+1), N, JPOW)
      CALL APS97_3 (X(N+1), N, JPOW)
C
C     Faster alternative to the two lines above to SCRAM.
C     	CALL SCRAM(X, X(N+1), N, JPOW)
C
C     Now do the transform.
C
C      CALL FASTG(X, X(N+1), N, 1)
      CALL APS97_2 (X, X(N+1), N, 1)

C     Unscramble the transform results.
C
C      CALL SCRAG(X, N, JPOW)
      CALL APS97_3 (X, N, JPOW)
C      CALL SCRAG(X(N+1), N, JPOW)
      CALL APS97_3 (X(N+1), N, JPOW)
C
C     Faster alternative to the two lines above to SCRAM.
C     	CALL SCRAM(X, X(N+1), N, JPOW)
C
      NN = N / 2
C
C     Now unravel the result; first the special cases.
C
      Z = HALF * (X(1) + X(N+1))
      X(N+1) = HALF * (X(1) - X(N+1))
      X(1) = Z
      NN1 = NN + 1
      NN2 = NN1 + N
      X(NN1) = HALF * X(NN1)
      X(NN2) = -HALF * X(NN2)
      Z = PIE / N
      BCOS = -TWO * (SIN(Z / TWO) **2)
      BSIN = SIN(Z)
      UN = ONE
      VN = ZERO
      DO 4 K = 2, NN
      Z = UN * BCOS + VN * BSIN + UN
      VN = VN * BCOS - UN * BSIN + VN
      SAVE1 = ONE5 - HALF * (Z * Z + VN * VN)
      UN = Z * SAVE1
      VN = VN * SAVE1
      KI = N + K
      L = N + 2 - K
      LI = N + L
      AN = QUART * (X(K) + X(L))
      BN = QUART * (X(KI) - X(LI))
      CN = QUART * (X(KI) + X(LI))
      DN = QUART * (X(L) - X(K))
      XN = UN * CN - VN * DN
      YN = UN * DN + VN * CN
      X(K) = AN + XN
      X(KI) = BN + YN
      X(L) = AN - XN
      X(LI) = YN - BN
    4 CONTINUE
      RETURN
      END
C

C      SUBROUTINE REVRT(X, M)
      SUBROUTINE APS97_1 (X, M)

      implicit none
      
C
C     ALGORITHM AS 97.1  APPL. STATIST. (1976) VOL.25, NO. 2
C
C     Inverse discrete Fourier transform in one dimension of real
C     data using complex transform subroutine FASTG.
C
C     X = array of Fourier components as output from subroutine FORRT,
C         type real, dimension M.	
C     M = length of the inverse transform, must be a power of 2.
C     The minimum length is 8, maximum 2**21.
C
C     Auxiliary routines required: SCRAG & FASTG from AS 83, but
C     with SCRAG modified as described on page 168 of the paper for
C     this algorithm.
C
c      REAL X(M)
c
c arguments
c
      integer,          intent (in)    :: m
      double precision, intent (inout) :: x(m)
c
c locals
c      
      integer ii, ipow, k, ki, l, li, n, nn, nn1, nn2
      double precision an, bn, bcos, bsin, cn, dn, pie, pn, qn, save1,
     +                 un, vn, z
      double precision zero, half, one, one5, two, four
c      external scrag, fastg
      external aps97_3, aps97_2
      intrinsic sin
      DATA ZERO/0.0d+00/, HALF/0.5d+00/, ONE/1.0d+00/, ONE5/1.5d+00/,
     *TWO/2.0d+00/, FOUR/4.0d+00/
C
C     Check for valid transform size.
C
      II = 8
      DO 2 K = 3, 21
      IPOW = K
      IF (II .EQ. M) GO TO 3
      II = II * 2
    2 CONTINUE
C
C     If this point is reached, an illegal size was specified.
C
      RETURN
    3 PIE = FOUR * ATAN(ONE)
      N = M / 2
      NN = N / 2
C
C     Undo the spectrum into that of two interleaved series.
C     First, the special cases.
C
      Z = X(1) + X(N+1)
      X(N+1) = X(1) - X(N+1)
      X(1) = Z
      NN1 = NN + 1
      NN2 = NN1 + N
      X(NN1) = TWO * X(NN1)
      X(NN2) = -TWO * X(NN2)
      Z = PIE / N
      BCOS = -TWO * (SIN(Z / TWO) **2)
      BSIN = SIN(Z)
      UN = ONE
      VN = ZERO
      DO 4 K = 2, NN
      Z = UN * BCOS + VN * BSIN + UN
      VN = VN * BCOS - UN * BSIN + VN
      SAVE1 = ONE5 - HALF * (Z * Z + VN * VN)
      UN = Z * SAVE1
      VN = VN * SAVE1
      KI = N + K
      L = N + 2 - K
      LI = N + L
      AN = X(K) + X(L)
      BN = X(KI) - X(LI)
      PN = X(K) - X(L)
      QN = X(KI) + X(LI)
      CN = UN * PN + VN * QN
      DN = UN * QN - VN * PN
      X(K) = AN - DN
      X(KI) = BN + CN
      X(L) = AN + DN
      X(LI) = CN - BN
    4 CONTINUE
C
C     Now do the inverse transform
C
C      CALL FASTG(X, X(N+1), N, -1)
      CALL APS97_2 (X, X(N+1), N, -1)
C
C     Now undo the order - the half arrays are already bit reversed;
C     bit reverse the whole array.
C
C      CALL SCRAG(X, M, IPOW)
       CALL APS97_3 (X, M, IPOW)
      
      RETURN
      END
C
c      subroutine fastg(xreal, ximag, n, itype)
      subroutine aps97_2 (xreal, ximag, n, itype)

      implicit none
      
c
c       Algorithm AS 83.2 Appl. Statist. (1975) vol.24, no.1
c
c       Radix 4 complex discrete fast Fourier transform without
c       unscrambling, suitable for convolutions or other applications
c       which do not require unscrambling.   Called by subroutine
c       FASTF which also does the unscrambling.
c
c      real    xreal(n), ximag(n)
c
c arguments
c
      integer,          intent (in)    :: itype, n
      double precision, intent (inout) :: xreal(n), ximag(n)
c
c locals
c        
      integer ifaca, ifcab, i0, i1, i2, i3, k, litla
      double precision bcos, bsin, cw1, cw2, cw3, pi, sw1, sw2, sw3,
     +                 tempr, 
     +                 xs0, xs1, xs2, xs3, x1, x2, x3,
     +                 ys0, ys1, ys2, ys3, y1, y2, y3, z
      double precision zero, half, one, one5, two, four 
      data    zero, half, one, one5, two, four
     +          /0.0d+00, 0.5d+00, 1.0d+00, 1.5d+00, 2.0d+00, 4.0d+00/
      intrinsic atan, sin
      pi = four * atan(one)
      ifaca = n / 4
      if (itype .eq. 0) return
      if (itype .gt. 0) go to 5
c
c       ITYPE < 0 indicates inverse transform required.
c       Calculate conjugate.
c
      do 4 k = 1, n
        ximag(k) = -ximag(k)
    4 continue
c
c       Following code is executed for IFACA = N/4, N/16, N/64, ...
c       until IFACA <= 1.
c
    5   ifcab = ifaca * 4
      z = pi / ifcab
      bcos = -two * sin(z)**2
      bsin = sin(two * z)
      cw1 = one
      sw1 = zero
      do 10 litla = 1, ifaca
      do 8 i0 = litla, n, ifcab
        i1 = i0 + ifaca
        i2 = i1 + ifaca
        i3 = i2 + ifaca
        xs0 = xreal(i0) + xreal(i2)
        xs1 = xreal(i0) - xreal(i2)
        ys0 = ximag(i0) + ximag(i2)
        ys1 = ximag(i0) - ximag(i2)
        xs2 = xreal(i1) + xreal(i3)
        xs3 = xreal(i1) - xreal(i3)
        ys2 = ximag(i1) + ximag(i3)
        ys3 = ximag(i1) - ximag(i3)
        xreal(i0) = xs0 + xs2
        ximag(i0) = ys0 + ys2
        x1 = xs1 + ys3
        y1 = ys1 - xs3
        x2 = xs0 - xs2
        y2 = ys0 - ys2
        x3 = xs1 - ys3
        y3 = ys1 + xs3
        if (litla .eq. 1) then
          xreal(i2) = x1
          ximag(i2) = y1
          xreal(i1) = x2
          ximag(i1) = y2
          xreal(i3) = x3
          ximag(i3) = y3
        else
          xreal(i2) = x1 * cw1 + y1 * sw1
          ximag(i2) = y1 * cw1 - x1 * sw1
          xreal(i1) = x2 * cw2 + y2 * sw2
          ximag(i1) = y2 * cw2 - x2 * sw2
          xreal(i3) = x3 * cw3 + y3 * sw3
          ximag(i3) = y3 * cw3 - x3 * sw3
        end if
    8     continue
c
c       Calculate a new set of twiddle factors.
c
      if (litla .lt. ifaca) then
        z = cw1 * bcos - sw1 * bsin + cw1
        sw1 = bcos * sw1 + bsin * cw1 + sw1
        tempr = one5 - half * (z * z + sw1 * sw1)
        cw1 = z * tempr
        sw1 = sw1 * tempr
        cw2 = cw1 * cw1 - sw1 * sw1
        sw2 = two * cw1 * sw1
        cw3 = cw1 * cw2 - sw1 * sw2
        sw3 = cw1 * sw2 + cw2 * sw1
      end if
   10   continue
      if (ifaca .le. 1) go to 14
c
c       Set up the transform split for the next stage.
c
      ifaca = ifaca / 4
      if (ifaca .gt. 0) go to 5
c
c       Radix 2 calculation, if needed.
c
      if (ifaca .lt. 0) return
      do 13 k = 1, n, 2
      tempr = xreal(k) + xreal(k+1)
      xreal(k+1) = xreal(k) - xreal(k+1)
      xreal(k) = tempr
      tempr = ximag(k) + ximag(k+1)
      ximag(k+1) = ximag(k) - ximag(k+1)
      ximag(k) = tempr
   13   continue
   14   if (itype .lt. 0) then
c
c       Inverse transform; conjugate the result.
c
      do 16 k = 1, n
        ximag(k) = -ximag(k)
   16 continue
      return
      end if
c
c       Forward transform
c
      z = one / n
      do 18 k = 1, n
      xreal(k) = xreal(k) * z
      ximag(k) = ximag(k) * z
   18   continue
c
      return
      end
c
c
c
c      subroutine scrag(xreal, n, ipow)
      subroutine aps97_3 (xreal, n, ipow)

      implicit none
      
c
c       Algorithm AS 83.3 Appl. Statist. (1975) vol.24, no.1
c ***   MODIFIED FOR USE WITH AS 97 ***
c
c       Subroutine for unscrambling FFT data.
c
c      real    xreal(n)
c
c arguments
c
      integer,          intent (in)    :: ipow, n 
      double precision, intent (inout) :: xreal(n)
c
c locals
c      
      integer i, ii, itop, k
      integer j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12, j13,
     +        j14, j15, j16, j17, j18, j19, j20
      integer l0, l1, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 
     +        l13, l14, l15, l16, l17, l18, l19
     +
      integer l(19)
      double precision tempr
      equivalence (l1,l(1)), (l2,l(2)), (l3,l(3)), (l4,l(4)),
     +          (l5,l(5)), (l6,l(6)), (l7,l(7)), (l8,l(8)), (l9,l(9)),
     +          (l10,l(10)), (l11,l(11)), (l12,l(12)), (l13,l(13)),
     +          (l14,l(14)), (l15,l(15)), (l16,l(16)), (l17,l(17)),
     +          (l18,l(18)), (l19,l(19))
c
      ii = 1
      itop = 2 ** (ipow - 1)
      i = 20 - ipow
      do 5 k = 1, i
        l(k) = ii
    5 continue
      l0 = ii
      i = i + 1
      do 6 k = i, 19
      ii = ii * 2
      l(k) = ii
    6   continue
c
      ii = 0
      do 9 j1 = 1, l1, l0
      do 9 j2 = j1, l2, l1
        do 9 j3 = j2, l3, l2
          do 9 j4 = j3, l4, l3
        do 9 j5 = j4, l5, l4
          do 9 j6 = j5, l6, l5
            do 9 j7 = j6, l7, l6
              do 9 j8 = j7, l8, l7
            do 9 j9 = j8, l9, l8
              do 9 j10 = j9, l10, l9
                do 9 j11 = j10, l11, l10
                  do 9 j12 = j11, l12, l11
                do 9 j13 = j12, l13, l12
                  do 9 j14 = j13, l14, l13
                    do 9 j15 = j14, l15, l14
                      do 9 j16 = j15, l16, l15
                    do 9 j17 = j16, l17, l16
                      do 9 j18 = j17, l18, l17
                        do 9 j19 = j18, l19, l18
                          j20 = j19
                          do 9 i = 1, 2
                        ii = ii + 1
                        if (ii .lt. j20) then
c
c       J20 is the bit-reverse of II pairwise interchange.
c
                          tempr = xreal(ii)
                          xreal(ii) = xreal(j20)
                          xreal(j20) = tempr
                        end if
                        j20 = j20 + itop
    9   continue
c
      return
      end
