!c
!c
!
! This contain the version of getifa for use with the 64-bit NAG DLL as follows
! getifa                ... returns ifail = -1 and opens the file nagifail.txt for messages
! x64_nagdll_lcase1     ... transforms strings to lower case
! x64_nagdll_mkdir      ... makes a new folder
! x64_nagdll_stripc0    ... deals with null string terminators
! z64_nagdll_v7path     ... returns the paths to simfit folders
!
!
      subroutine getifa (ifail)
!c
!c action: adjust ifail, etc.
!c author: w.g.bardsley, university of manchester, u.k.
!          28/11/2014 developed from getifa_ftn95.f95
!c
!c         This routine is called on entry to every simfit NAG type
!c         routine before any action is taken to call true NAG code.
!c         So, by editing this subroutine, virtually any type of error
!c         message output can be generated from NAG, as follows:
!c
!c         idfolt = default ifail entry value
!c         iounit = error/message output unit
!c          fname = error/message file
!c
!c         note: simfit uses units 3, 4 all the time and 10 to 100
!c               some of the time. The optimisation and DE solving
!c               simfit routines use units 5 and 6 for monitoring.
!c               Hence iounit = 101 as the default.
!c               Further, iounit cannot be used for write after the
!c               call to x04acf as nagfor does not recognise it as
!c               connected.
!c
!c
      implicit   none
!c
!c argument: ifail (input/output)
!c
      integer, intent (inout) :: ifail
!c
!c locals
!c
      integer    k
      integer    ierr, iflag, nadv, nerr
      integer    idfolt, iounit, mode
      parameter (idfolt = -1, iounit = 101, mode = 1)
      character (len = 1024) csidl_path, full_path
      character (len = 12  ) fname
      parameter (fname = 'nagifail.txt')
      character (len = 1   ) blank, bslash 
      parameter (blank = ' ', bslash = '\')
      logical    first
      external   x04aaf, x04abf, x04acf, x04baf
      external   x64_nagdll_v7path
      
!c
!c make absolutely sure that first is saved
!c
      save       first
      data       first / .true. /
!c
!c initialise ifail every time
!c
      ifail = idfolt
!c
!c rest of code only executed first time
!c
      if (first) then
        
         first = .false.
         
         call x64_nagdll_v7path (k,&
                                'res', csidl_path)
         if (k.gt.0) then
            if (csidl_path(k:k).eq.bslash) then
               csidl_path(k:k) = blank
               k = k - 1
            endif   
         endif   
         if (k.le.0) then
            full_path = fname
         else   
            full_path = csidl_path(1:k)//bslash//fname
         endif
!c
!c try to open message file
!c
         ierr = 0
         call x04acf (iounit, full_path, mode, ierr)
!c
!c divert all output to message file by setting nerr = nadv = iounit
!c
         iflag = 1
         nerr = iounit
         call x04aaf (iflag, nerr)
         iflag = 1
         nadv = iounit
         call x04abf (iflag, nadv)
!c
!c write to the error message file
!c         
         call x04baf (iounit, '64-bit NAG DLL error/message file')
      endif
      end
!
!
      SUBROUTINE X64_NAGDLL_LCASE1 (STRNG)
!
! ACTION : Transform a string to lower case
! AUTHOR : W.G.Bardsley, University of manchester, U.K.
!          28/01/2007 derived from LCASE1
!          29/11/2014 version for 64-bit NAG DLL 
!
      IMPLICIT   NONE
!
! Argument
!
      CHARACTER (LEN = *), INTENT (INOUT) :: STRNG
!
! Locals
!
      INTEGER    I, J
      INTEGER    N1, N32, N65, N90
      PARAMETER (N1 = 1, N32 = 32, N65 = 65, N90 = 90)
      INTRINSIC  CHAR, ICHAR, LEN
      DO I = N1, LEN(STRNG)
         J = ICHAR(STRNG(I:I))
         IF (J.GE.N65 .AND. J.LE.N90) STRNG(I:I) = CHAR(J + N32)
      ENDDO
      END
!
!
      
!
!---------------------------------------------------------------------------      
!
      subroutine x64_nagdll_mkdir (folder)
!
! action: implementation of CreateDirectoryA
! author: w.g.bardsley, university of manchester, u.k., 28/11/2011
!         08/03/2013 defined lp_security as a pointer
!         29/11/2014 version for 64-bit NAG DLL 
!
! specifications: BOOL CreateDirectory (path, security)
!
      use iso_c_binding
      implicit none
!
! arguments
!
      character (len = *), intent (in) :: folder
!
! locals
!
      type(c_ptr), pointer :: lp_security=>NULL()
      integer    k
      character (len = 248) folder_copy
      character (len = 1  ) c0
      parameter (c0 = char(0))
      logical    i_create
      intrinsic  char, len_trim
!
! interface to Windows API
!
      interface
         function create_folder (c, s) bind(C,NAME='CreateDirectoryA')
            import c_bool, c_char, c_ptr
            logical(c_bool):: create_folder
            character(c_char) :: c
            type(c_ptr) :: s
         end function create_folder
      end interface

      k = len_trim(folder)
      if (k.gt.0 .and. k.lt.248) then
         folder_copy = folder(1:k)//c0
         i_create = create_folder (folder_copy, lp_security)
         if (i_create) return!to silence NAGfor
      endif
      end
!
!-------------------------------------------------------------
!
      subroutine x64_nagdll_stripc0 (strng)
!
! Replace char(0)s by blanks in a string
! 29/11/2014 version for 64-bit NAG DLL 

!
      implicit   none
!
! argument
!
      character (len = *), intent (inout) :: strng
!
!
!
      integer    n
      character (len = 1) blank, c0
      parameter (blank = ' ', c0 = char(0))
      intrinsic  index
      n = index(strng,c0)
      do while (n.gt.0)
         strng(n:n) = blank
         n = index(strng,c0)
      enddo
      end
!
!------------------------------------------------------------------------------------
!
      subroutine x64_nagdll_v7path (k, &
                                    arg, path)
!
! action: return Version 7 paths to results, user, configuration and temporary files
! author: w.g.bardsley, university of manchester, u.k., 13/01/2011
!         25/01/2011 replaced C_EXTERNAL by STDCALL
!         11/11/2011 version for 64_bit simfit
!         29/11/2014 version for 64-bit NAG DLL 

!
! Notes: this subroutine was developed with valuable help from David Bailey.
!        If the paths do not exist, the folders are created on the fly.
!        The code is verbose to allow for possible future developments using
!        additional or alternative folders.
!        The folder name is Documents but may display as My Documents in
!        the Disk Explorer control.
!
!    k: effective length of path
!  arg: path required as follows ...
!       cfg: Simfit configuration folder
!       res: Simfit results folder
!       p32: %PROGRAMFILES% Program Files or Program Files (x86)
!       p64: %PROGRAMFILESW6432%?? Program Files
!       tmp: %TEMP%
!       usr: Simfit user folder
!       win: Windows folder
!       s32: System32 folder
! path: path returned
!
      use iso_c_binding
      implicit   none
!
! arguments
!
      integer,             intent (out) :: k
      character (len = *), intent (in)  :: arg
      character (len = *), intent (out) :: path

!
! interface for c_inter_operability
!
      interface

         function cspath (int1, char1, int2, int3) bind(C,NAME='SHGetSpecialFolderPathA')
            import c_int, c_char, c_bool
            logical(c_bool) :: cspath
            integer(c_int), value ::  int1, int2, int3
            character(c_char) char1(*)
         end function cspath

         function temppath (int4, char2) bind(C,NAME='GetTempPathA')
            import c_int, c_char
            integer(c_int) :: temppath
            integer(c_int), value :: int4
            character(c_char) char2(*)
         end function temppath

      end interface
!
! locals
!
      integer    k_cfg, k_res, k_tmp, k_usr, n
      integer    k32, k64
      integer    k_win, k_s32
      integer    csidl
      integer    integer_temppath
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\')
      character (len = 3) arg_copy
      character (len = 3) cfg, res, tmp, usr
      parameter (cfg = 'cfg', res = 'res', tmp = 'tmp', usr = 'usr')
      character (len = 3) p32, p64
      parameter (p32 = 'p32', p64 = 'p64')
      character (len = 3) win, s32
      parameter (win = 'win', s32 = 's32')
      character (len = 1024) cfg_path, res_path, tmp_path, usr_path
      character (len = 1024) csidl_path, simfit
      character (len = 1024) pfiles32, pfiles64
      character (len = 1024) win_path, sys32_path
      logical    first, logical_cspath
      external   x64_nagdll_mkdir
      external   x64_nagdll_lcase1
      external   x64_nagdll_stripc0
      intrinsic  len_trim
      save       first
      save       k_cfg, k_res, k_tmp, k_usr
      save       k32, k64
      save       cfg_path, res_path, tmp_path, usr_path
      save       pfiles32, pfiles64
      save       win_path, sys32_path
      data       first  / .true. /
      data       cfg_path, res_path, tmp_path, usr_path / blank, blank, &
                                                          blank, blank /
      data       k_cfg, k_res, k_tmp, k_usr / 0, 0, 0, 0 /
      data       pfiles32, pfiles64 / blank, blank /
      data       k32, k64 / 0, 0 /
      data       win_path, sys32_path / blank, blank /
      data       k_win, k_s32 / 0, 0 /
!
! initialise
!
      k = 0
      path = blank
!
! if first time create the folders if they are not there already
!
      if (first) then
         first = .false.
!
! get the path to My Documents
!
         csidl = 5
         csidl_path = blank
         logical_cspath = cspath (0, csidl_path, csidl, 0)
         if (logical_cspath) call x64_nagdll_stripc0 (csidl_path)
         n = len_trim(csidl_path)
         if (n.gt.0) then
            if (csidl_path(n:n).eq.bslash) then
               csidl_path(n:n) = blank
               n = n - 1
            endif
         endif
         if (n.eq.0) then
            n = 2
            csidl_path = 'C:'
         endif

         simfit = csidl_path(1:n)//'\Simfit'
         n = n + 7
         call x64_nagdll_mkdir (simfit)

         cfg_path = simfit(1:n)//'\cfg'
         k_cfg = n + 4
         call x64_nagdll_mkdir (cfg_path)

         res_path = simfit(1:n)//'\res'
         k_res = n + 4
         call x64_nagdll_mkdir (res_path)

         usr_path = simfit(1:n)//'\usr'
         k_usr = n + 4
         call x64_nagdll_mkdir (usr_path)
!
! get the path to TEMP
!
         n = 1024
         tmp_path = blank
         integer_temppath = temppath (n, tmp_path)
         if (integer_temppath.gt.0) call x64_nagdll_stripc0 (tmp_path)

         k_tmp = len_trim(tmp_path)
         if (k_tmp.gt.0) then
            if (tmp_path(k_tmp:k_tmp).eq.bslash) then
               tmp_path(k_tmp:k_tmp) = blank
               k_tmp = k_tmp - 1
            endif
         endif
         if (k_tmp.eq.0) then
            k_tmp = 7
            tmp_path = 'C:\Temp'
         endif
!
! get the paths to program files
!
         csidl = 38
         csidl_path = blank
         logical_cspath = cspath (0, csidl_path, csidl, 0)
         if (logical_cspath) call x64_nagdll_stripc0 (csidl_path)
         n = len_trim(csidl_path)
         if (n.gt.0) then
            if (csidl_path(n:n).eq.bslash) then
               csidl_path(n:n) = blank
               n = n - 1
            endif
            if (csidl_path(n - 2:n).eq.'86)') then
               k32 = n
               pfiles32 = csidl_path
               k64 = n - 5
               csidl_path(n - 4:n) = '    '
               pfiles64 = csidl_path
            else
               k64 = n
               pfiles64 = csidl_path
               k32 = n + 6
               pfiles32 = pfiles64(1:n)//' (x86)'
            endif
         else
            k32 = 0
            k64 = 0
            pfiles32 = blank
            pfiles64 = blank
         endif
!
! get the windows and system32 folders
!
          csidl = 36
          csidl_path = blank
          logical_cspath = cspath (0, csidl_path, csidl, 0)
          if (logical_cspath) call x64_nagdll_stripc0 (csidl_path)
          n = len_trim(csidl_path)
          if (n.gt.0) then
             win_path = csidl_path
             k_win = n
          endif

          csidl = 37
          csidl_path = blank
          logical_cspath = cspath (0, csidl_path, csidl, 0)
          if (logical_cspath) call x64_nagdll_stripc0 (csidl_path)
          n = len_trim(csidl_path)
          if (n.gt.0) then
             sys32_path = csidl_path
             k_s32 = n
          endif

      endif
!
! decide which folder is required
!
      arg_copy = arg
      call x64_nagdll_lcase1 (arg_copy)
!
! return the stored values
!
      if (arg_copy.eq.cfg) then
         k = k_cfg
         path = cfg_path
      elseif (arg_copy.eq.res) then
         k = k_res
         path = res_path
      elseif (arg_copy.eq.tmp) then
         k = k_tmp
         path = tmp_path
      elseif (arg_copy.eq.usr) then
         k = k_usr
         path = usr_path
      elseif (arg_copy.eq.p32) then
         k = k32
         path = pfiles32
      elseif (arg_copy.eq.p64) then
         k = k64
         path = pfiles64
      elseif (arg_copy.eq.win) then
         k = k_win
         path = win_path
      elseif (arg_copy.eq.s32) then
         k = k_s32
         path = sys32_path
      endif
      end
!
!