@echo off

echo.
echo.
echo ****************************************************************
echo *  A batch file to make the two DLL files                      *
echo *  FLW6I24DC_nag_maths.dll                                     *
echo *  FLW6I24DC_mkl_maths.dll                                     *
echo *  which allow simfit to use the NAG library at Mark24         *
echo *  Full details are in the document nag_simfit.pdf.            *
echo *  Edit this batch file for any other release of the NAG DLLs. * 
echo *  Requirement: Nagfor.EXE must be on the path and all paths   *        
echo *               in the link scripts must be correct.           *
echo ****************************************************************


echo.
echo -------
echo Step 1: Compile all the *.f source code (optional if all *.obj files exist)
echo -------
echo.

pause

echo old...nagfor -ieee=full -w=all -f2003 -mismatch getifa_nagfor.f95 -c
echo old...nagfor -ieee=full -w=all -f2003 -mismatch *.f -c
ftn95 /64 getifa_ftn95.f95
ftn95 /64 *.f

echo.
echo -------
echo Step 2: Create the new nag dll linked to the 64-bit nag mark24 NAG DLL
echo -------
echo.

pause

echo old..nagfor @x64_nag_mark24.link
slink64 x64_ftn95_nag_mark24.link


echo.
echo -------
echo Step 3: Create the new mkl dll linked to the 64-bit mkl mark24 NAG DLL
echo -------
echo.

pause

echo old...nagfor @x64_mkl_mark24.link
slink64 x64_ftn95_mkl_mark24.link

echo.
echo ------- 
echo Step 4: Don't forget to edit x64_change_simfit_version.config
echo ------- then overwrite the version in the simfit\bin folder.
echo         Also add these new DLLs to the simfit\bin folder.
echo         Then, as administrator, run x64_change_simfit_version.exe
echo         in the simfit\bin folder.  
echo.
echo.
