@echo off

echo.
echo.
echo ****************************************************************
echo *  A batch file to make the two DLL files                      *
echo *  NLW6I27DE_nag_maths.dll                                     *
echo *  NLW6I27DE_mkl_maths.dll                                     *
echo *  which allow simfit to use the NAG library at Mark27         *
echo *  Full details are in the document nag_simfit.pdf.            *
echo *  Edit this batch file for any other release of the NAG DLLs. * 
echo *  Requirement: FTN95.EXE must be on the path and all paths    *        
echo *               in the link scripts must be correct.           *
echo ****************************************************************


echo.
echo -------
echo Step 1: Compile all the *.f source code (optional if all *.obj files exist)
echo -------
echo.

pause

echo for nagfor use ... NAGfor -ieee=full -w=all -f2003 -mismatch getifa_nagfor.f95 -c
echo for nagfor use ... NAGfor -ieee=full -w=all -f2003 -mismatch *.f -c
ftn95 /64 getifa_ftn95.f95
ftn95 /64 *.f

echo.
echo -------
echo Step 2: Create the new nag dll linked to the 64-bit nag mark26 NAG DLL
echo -------
echo.

pause

echo for nagfor use ... NAGfor @x64_nagfor_nag_mark26.link
slink64 x64_nag_mark27.link


echo.
echo -------
echo Step 3: Create the new mkl dll linked to the 64-bit mkl mark27 NAG DLL
echo -------
echo.

pause

echo for nagfor use ... NAGfor @x64_nagfor_mkl_mark27.link
slink64 x64_mkl_mark27.link

echo.
echo ------- 
echo Step 4: Don't forget to edit x64_change_simfit_version.config
echo ------- then overwrite the version in the simfit\bin folder.
echo         Also add these new DLLs to the simfit\bin folder.
echo         Then, as administrator, run x64_change_simfit_version.exe
echo         in the simfit\bin folder.  
echo.
echo.
