c
c ABRAMZ
c ABRAM0
c ABRAM1
c ABRAM2
c
c ACMTOMS 757: Abramovitz integrals but with error messages disabled
c              isend = 0, 1, 2
c              x >= 0
c
      double precision function abramz (isend, x)
      implicit none
      integer  isend
      double precision x
      double precision zero
      parameter (zero = 0.0d+00)
      double precision abram0, abram1, abram2
      external abram0, abram1, abram2
      if (isend.lt.0 .or. isend.gt.2 .or. x.lt.zero) then
         abramz = zero
      else
         if (isend.eq.0) then
            abramz = abram0 (x)
         elseif (isend.eq.1) then
            abramz = abram1 (x)
         elseif (isend.eq.2) then
            abramz = abram2 (x)
         endif
      endif
      end
c
c
      DOUBLE PRECISION FUNCTION ABRAM0(XVALUE)
C
C   DESCRIPTION:
C      This function calculates the Abramowitz function of order 0,
C      defined as
C
C       ABRAM0(x) = integral{ 0 to infinity } exp( -t*t - x/t ) dt
C
C       The code uses Chebyshev expansions with the coefficients
C       given to an accuracy of 20 decimal places.
C
C
C   ERROR RETURNS:
C      If XVALUE < 0.0, the function prints a message and returns the
C      value 0.0.
C
C
C   MACHINE-DEPENDENT CONSTANTS:
C
C      NTERMF - INTEGER - No. of terms needed for the array AB0F.
C               Recommended value such that
C                     ABS( AB0F(NTERMF) ) < EPS/100
C
C      NTERMG - INTEGER - No. of terms needed for array AB0G.
C               Recommended value such that
C                     ABS( AB0G(NTERMG) ) < EPS/100
C
C      NTERMH - INTEGER - No. of terms needed for array AB0H.
C               Recommended value such that
C                     ABS( AB0H(NTERMH) ) < EPS/100
C
C      NTERMA - INTEGER - No. of terms needed for array AB0AS.
C               Recommended value such that
C                     ABS( AB0AS(NTERMA) ) < EPS/100
C
C     XLOW1 - DOUBLE PRECISION - The value below which
C              ABRAM0 = root(pi)/2 + X ( ln X - GVAL0 )
C             Recommended value is SQRT(2*EPSNEG)
C
C     LNXMIN - DOUBLE PRECISION - The value of ln XMIN. Used to prevent
C              exponential underflow for large X.
C
C     For values of EPS, EPSNEG, XMIN refer to the file MACHCON.TXT.
C
C     The machine-dependent constants are computed internally by
C     using the D1MACH subroutine.
C
C
C   INTRINSIC FUNCTIONS USED:
C
C     LOG, EXP, SQRT
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
C          CHEVAL , ERRPRN, D1MACH
C
C
C   AUTHOR:
C
C      DR. ALLAN J. MACLEOD,
C      DEPT. OF MATHEMATICS AND STATISTICS,
C      UNIVERSITY OF PAISLEY ,
C      HIGH ST.,
C      PAISLEY,
C      SCOTLAND.
C      PA1 2BE
C
C      ( e-mail: macl_ms0@paisley.ac.uk )
C
C
C   LATEST REVISION:   23 January
C
C
      INTEGER NTERMA,NTERMF,NTERMG,NTERMH
      DOUBLE PRECISION AB0F(0:8),AB0G(0:8),AB0H(0:8),AB0AS(0:27),
     &     ASLN,ASVAL,CHEVAL,FVAL,GVAL,GVAL0,HALF,HVAL,
     &     LNXMIN,ONEHUN,ONERPI,RTPIB2,RT3BPI,SIX,T,
     &     THREE,TWO,V,X,XLOW1,XVALUE,ZERO,D1MACH
C   INTRINSIC FUNCTIONS USED:
C
      INTRINSIC ABS, LOG, EXP, SQRT
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
      EXTERNAL CHEVAL, D1MACH
C
c*****CHARACTER FNNAME*6,ERRMSG*33
c*****DATA FNNAME/'ABRAM0'/
c*****DATA ERRMSG/'FUNCTION CALLED WITH ARGUMENT < 0'/
      DATA AB0F/-0.68121 92709 35494 69816  D    0,
     1          -0.78867 91981 61492 52495  D    0,
     2           0.51215 81776 81881 9543   D   -1,
     3          -0.71092 35289 45412 96     D   -3,
     4           0.36868 18085 04287        D   -5,
     5          -0.91783 23372 37           D   -8,
     6           0.12702 02563              D  -10,
     7          -0.10768 88                 D  -13,
     8           0.599                      D  -17/
      DATA AB0G/-0.60506 03943 08682 73190  D    0,
     1          -0.41950 39816 32017 79803  D    0,
     2           0.17032 65125 19037 0333   D   -1,
     3          -0.16938 91784 24913 97     D   -3,
     4           0.67638 08951 9710         D   -6,
     5          -0.13572 36362 55           D   -8,
     6           0.15629 7065               D  -11,
     7          -0.11288 7                  D  -14,
     8           0.55                       D  -18/
      DATA AB0H/1.38202 65523 05749 89705  D    0,
     1         -0.30097 92907 39749 04355  D    0,
     2          0.79428 88093 64887 241    D   -2,
     3         -0.64319 10276 84756 3      D   -4,
     4          0.22549 83068 4374         D   -6,
     5         -0.41220 96619 5            D   -9,
     6          0.44185 282                D  -12,
     7         -0.30123                    D  -15,
     8          0.14                       D  -18/
      DATA AB0AS(0)/  1.97755 49972 36930 67407  D    0/
      DATA AB0AS(1)/ -0.10460 24792 00481 9485   D   -1/
      DATA AB0AS(2)/  0.69680 79025 36253 66     D   -3/
      DATA AB0AS(3)/ -0.58982 98299 99659 9      D   -4/
      DATA AB0AS(4)/  0.57716 44553 05320        D   -5/
      DATA AB0AS(5)/ -0.61523 01336 5756         D   -6/
      DATA AB0AS(6)/  0.67853 96884 767          D   -7/
      DATA AB0AS(7)/ -0.72306 25379 07           D   -8/
      DATA AB0AS(8)/  0.63306 62736 5            D   -9/
      DATA AB0AS(9)/ -0.98945 3793               D  -11/
      DATA AB0AS(10)/-0.16819 80530              D  -10/
      DATA AB0AS(11)/ 0.67379 9551               D  -11/
      DATA AB0AS(12)/-0.20099 7939               D  -11/
      DATA AB0AS(13)/ 0.54055 903                D  -12/
      DATA AB0AS(14)/-0.13816 679                D  -12/
      DATA AB0AS(15)/ 0.34222 05                 D  -13/
      DATA AB0AS(16)/-0.82668 6                  D  -14/
      DATA AB0AS(17)/ 0.19456 6                  D  -14/
      DATA AB0AS(18)/-0.44268                    D  -15/
      DATA AB0AS(19)/ 0.9562                     D  -16/
      DATA AB0AS(20)/-0.1883                     D  -16/
      DATA AB0AS(21)/ 0.301                      D  -17/
      DATA AB0AS(22)/-0.19                       D  -18/
      DATA AB0AS(23)/-0.14                       D  -18/
      DATA AB0AS(24)/ 0.11                       D  -18/
      DATA AB0AS(25)/-0.4                        D  -19/
      DATA AB0AS(26)/ 0.2                        D  -19/
      DATA AB0AS(27)/-0.1                        D  -19/
      DATA ZERO,HALF,TWO/ 0.0 D 0 , 0.5 D 0, 2.0 D 0/
      DATA THREE,SIX,ONEHUN/ 3.0 D 0, 6.0 D 0 , 100.0 D 0/
      DATA RT3BPI/0.97720 50238 05839 84317 D 0/
      DATA RTPIB2/0.88622 69254 52758 01365 D 0/
      DATA GVAL0/0.13417 65026 47700 70909 D 0/
      DATA ONERPI/0.56418 95835 47756 28695 D 0/
C
C   Start computation
C
      X = XVALUE
C
C   Error test
C
      IF ( X .LT. ZERO ) THEN
c********CALL ERRPRN(FNNAME,ERRMSG)
         ABRAM0 = ZERO
         RETURN
      ENDIF
C
C   Compute the machine-dependent constants.
C
      T = D1MACH(4) / ONEHUN
      IF ( X .LE. TWO ) THEN
         DO 10 NTERMF = 8 , 0 , -1
            IF ( ABS(AB0F(NTERMF)) .GT. T ) GOTO 19
 10      CONTINUE
 19      DO 20 NTERMG = 8 , 0 , -1
            IF ( ABS(AB0G(NTERMG)) .GT. T ) GOTO 29
 20      CONTINUE
 29      DO 30 NTERMH = 8 , 0 , -1
            IF ( ABS(AB0H(NTERMH)) .GT. T ) GOTO 39
 30      CONTINUE
 39      XLOW1 = SQRT ( TWO * D1MACH(3) )
      ELSE
         DO 40 NTERMA = 27 , 0 , -1
            IF ( ABS(AB0AS(NTERMA)) .GT. T ) GOTO 49
 40      CONTINUE
 49      LNXMIN = LOG(D1MACH(1))
      ENDIF
C
C   Code for 0 <= XVALUE <= 2
C
      IF ( X .LE. TWO ) THEN
         IF ( X .EQ. ZERO ) THEN
            ABRAM0 = RTPIB2
            RETURN
         ENDIF
         IF ( X .LT. XLOW1 ) THEN
            ABRAM0 = RTPIB2 + X * ( LOG( X ) - GVAL0 )
            RETURN
         ELSE
            T =  ( X * X / TWO - HALF ) - HALF
            FVAL = CHEVAL( NTERMF,AB0F,T )
            GVAL = CHEVAL( NTERMG,AB0G,T )
            HVAL = CHEVAL( NTERMH,AB0H,T )
            ABRAM0 = FVAL/ONERPI + X * ( LOG( X ) * HVAL- GVAL )
            RETURN
         ENDIF
      ELSE
C
C   Code for XVALUE > 2
C
         V = THREE *  ( (X / TWO) ** ( TWO / THREE ) )
         T =  ( SIX/V - HALF ) - HALF
         ASVAL = CHEVAL( NTERMA,AB0AS,T )
         ASLN = LOG( ASVAL / RT3BPI ) - V
         IF ( ASLN .LT. LNXMIN ) THEN
            ABRAM0 = ZERO
         ELSE
            ABRAM0 = EXP( ASLN )
         ENDIF
         RETURN
      ENDIF
      END

      DOUBLE PRECISION FUNCTION ABRAM1(XVALUE)
C
C   DESCRIPTION:
C      This function calculates the Abramowitz function of order 1,
C      defined as
C
C       ABRAM1(x) = integral{ 0 to infinity } t * exp( -t*t - x/t ) dt
C
C       The code uses Chebyshev expansions with the coefficients
C       given to an accuracy of 20 decimal places.
C
C
C   ERROR RETURNS:
C      If XVALUE < 0.0, the function prints a message and returns the
C      value 0.0.
C
C
C   MACHINE-DEPENDENT CONSTANTS:
C
C      NTERMF - INTEGER - No. of terms needed for the array AB1F.
C               Recommended value such that
C                     ABS( AB1F(NTERMF) ) < EPS/100
C
C      NTERMG - INTEGER - No. of terms needed for array AB1G.
C               Recommended value such that
C                     ABS( AB1G(NTERMG) ) < EPS/100
C
C      NTERMH - INTEGER - No. of terms needed for array AB1H.
C               Recommended value such that
C                     ABS( AB1H(NTERMH) ) < EPS/100
C
C      NTERMA - INTEGER - No. of terms needed for array AB1AS.
C               Recommended value such that
C                     ABS( AB1AS(NTERMA) ) < EPS/100
C
C      XLOW - DOUBLE PRECISION - The value below which
C                ABRAM1(x) = 0.5 to machine precision.
C             The recommended value is EPSNEG/2
C
C      XLOW1 - DOUBLE PRECISION - The value below which
C                ABRAM1(x) = (1 - x ( sqrt(pi) + xln(x) ) / 2
C              Recommended value is SQRT(2*EPSNEG)
C
C      LNXMIN - DOUBLE PRECISION - The value of ln XMIN. Used to prevent
C              exponential underflow for large X.
C
C      For values of EPS, EPSNEG, XMIN refer to the file MACHCON.TXT
C
C      The machine-dependent constants are computed internally by using
C      the D1MACH subroutine.
C
C
C   INTRINSIC FUNCTIONS USED:
C
C     LOG, EXP, SQRT
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
C          CHEVAL , ERRPRN, D1MACH
C
C
C   AUTHOR:
C
C      DR. ALLAN J. MACLEOD,
C      DEPT. OF MATHEMATICS AND STATISTICS,
C      UNIVERSITY OF PAISLEY,
C      HIGH ST.,
C      PAISLEY,
C      SCOTLAND.
C      PA1 2BE
C
C      ( e-mail: macl_ms0@paisley.ac.uk )
C
C
C   LATEST REVISION:   23 January, 1996
C
C
      INTEGER NTERMA,NTERMF,NTERMG,NTERMH
      DOUBLE PRECISION AB1F(0:9),AB1G(0:8),AB1H(0:8),AB1AS(0:27),
     &     ASLN,ASVAL,CHEVAL,FVAL,GVAL,HALF,HVAL,
     &     LNXMIN,ONE,ONEHUN,ONERPI,RT3BPI,SIX,T,THREE,TWO,
     &     V,X,XLOW,XLOW1,XVALUE,ZERO,D1MACH
C
C   INTRINSIC FUNCTIONS USED:
C
       INTRINSIC ABS, LOG, EXP, SQRT
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
       EXTERNAL CHEVAL, D1MACH
C
c*****CHARACTER FNNAME*6,ERRMSG*33
c*****DATA FNNAME/'ABRAM1'/
c*****DATA ERRMSG/'FUNCTION CALLED WITH ARGUMENT < 0'/
      DATA AB1F/1.47285 19257 79788 07369  D    0,
     1          0.10903 49757 01689 56257  D    0,
     2         -0.12430 67536 00565 69753  D    0,
     3          0.30619 79468 53493 315    D   -2,
     4         -0.22184 10323 07651 1      D   -4,
     5          0.69899 78834 451          D   -7,
     6         -0.11597 07644 4            D   -9,
     7          0.11389 776                D  -12,
     8         -0.7173                     D  -16,
     9          0.3                        D  -19/
      DATA AB1G/0.39791 27794 90545 03528  D    0,
     1         -0.29045 28522 64547 20849  D    0,
     2          0.10487 84695 46536 3504   D   -1,
     3         -0.10249 86952 26913 36     D   -3,
     4          0.41150 27939 9110         D   -6,
     5         -0.83652 63894 0            D   -9,
     6          0.97862 595                D  -12,
     7         -0.71868                    D  -15,
     8          0.35                       D  -18/
      DATA AB1H/0.84150 29215 22749 47030  D    0,
     1         -0.77900 50698 77414 3395   D   -1,
     2          0.13399 24558 78390 993    D   -2,
     3         -0.80850 39071 52788        D   -5,
     4          0.22618 58281 728          D   -7,
     5         -0.34413 95838              D  -10,
     6          0.31598 58                 D  -13,
     7         -0.1884                     D  -16,
     8          0.1                        D  -19/
      DATA AB1AS(0)/  2.13013 64342 90655 49448  D    0/
      DATA AB1AS(1)/  0.63715 26795 21853 9933   D   -1/
      DATA AB1AS(2)/ -0.12933 49174 77510 647    D   -2/
      DATA AB1AS(3)/  0.56783 28753 22826 5      D   -4/
      DATA AB1AS(4)/ -0.27943 49391 77646        D   -5/
      DATA AB1AS(5)/  0.56002 14736 787          D   -7/
      DATA AB1AS(6)/  0.23920 09242 798          D   -7/
      DATA AB1AS(7)/ -0.75098 48650 09           D   -8/
      DATA AB1AS(8)/  0.17301 53307 76           D   -8/
      DATA AB1AS(9)/ -0.36648 87795 5            D   -9/
      DATA AB1AS(10)/ 0.75207 58307              D  -10/
      DATA AB1AS(11)/-0.15179 90208              D  -10/
      DATA AB1AS(12)/ 0.30171 3710               D  -11/
      DATA AB1AS(13)/-0.58596 718                D  -12/
      DATA AB1AS(14)/ 0.10914 455                D  -12/
      DATA AB1AS(15)/-0.18705 36                 D  -13/
      DATA AB1AS(16)/ 0.26254 2                  D  -14/
      DATA AB1AS(17)/-0.14627                    D  -15/
      DATA AB1AS(18)/-0.9500                     D  -16/
      DATA AB1AS(19)/ 0.5873                     D  -16/
      DATA AB1AS(20)/-0.2420                     D  -16/
      DATA AB1AS(21)/ 0.868                      D  -17/
      DATA AB1AS(22)/-0.290                      D  -17/
      DATA AB1AS(23)/ 0.93                       D  -18/
      DATA AB1AS(24)/-0.29                       D  -18/
      DATA AB1AS(25)/ 0.9                        D  -19/
      DATA AB1AS(26)/-0.3                        D  -19/
      DATA AB1AS(27)/ 0.1                        D  -19/
      DATA ZERO,HALF,ONE/ 0.0 D 0, 0.5 D 0, 1.0 D 0/
      DATA TWO,THREE,SIX/ 2.0 D 0, 3.0 D 0, 6.0 D 0/
      DATA ONEHUN/100.0 D 0/
      DATA RT3BPI/ 0.97720 50238 05839 84317 D 0/
      DATA ONERPI/ 0.56418 95835 47756 28695 D 0/
C
C   Start calculation
C
      X = XVALUE
C
C   Error test
C
      IF ( X .LT. ZERO ) THEN
c********CALL ERRPRN(FNNAME,ERRMSG)
         ABRAM1 = ZERO
         RETURN
      ENDIF
C
C   Compute the machine-dependent constants.
C
      T = D1MACH(4) / ONEHUN
      IF ( X .LE. TWO ) THEN
         DO 10 NTERMF = 9 , 0 , -1
            IF ( ABS(AB1F(NTERMF)) .GT. T ) GOTO 19
 10      CONTINUE
 19      DO 20 NTERMG = 8 , 0 , -1
            IF ( ABS(AB1G(NTERMG)) .GT. T ) GOTO 29
 20      CONTINUE
 29      DO 30 NTERMH = 8 , 0 , -1
            IF ( ABS(AB1H(NTERMH)) .GT. T ) GOTO 39
 30      CONTINUE
 39      T = D1MACH(3)
         XLOW1 = SQRT ( TWO * T )
         XLOW = T / TWO
      ELSE
         DO 40 NTERMA = 27 , 0 , -1
            IF ( ABS(AB1AS(NTERMA)) .GT. T ) GOTO 49
 40      CONTINUE
 49      LNXMIN = LOG(D1MACH(1))
      ENDIF
C
C   Code for 0 <= XVALUE <= 2
C
      IF ( X .LE. TWO ) THEN
         IF ( X .EQ. ZERO ) THEN
            ABRAM1 = HALF
            RETURN
         ENDIF
         IF ( X .LT. XLOW1 ) THEN
            IF ( X .LT. XLOW ) THEN
               ABRAM1 = HALF
            ELSE
               ABRAM1 = ( ONE - X / ONERPI - X * X * LOG( X ) ) * HALF
            ENDIF
            RETURN
         ELSE
            T =  ( X * X / TWO - HALF ) - HALF
            FVAL = CHEVAL( NTERMF,AB1F,T )
            GVAL = CHEVAL( NTERMG,AB1G,T )
            HVAL = CHEVAL( NTERMH,AB1H,T )
            ABRAM1 = FVAL - X * ( GVAL / ONERPI + X * LOG( X ) * HVAL )
            RETURN
         ENDIF
      ELSE
C
C   Code for XVALUE > 2
C
         V = THREE *  ( (X / TWO) ** ( TWO / THREE ) )
         T =  ( SIX / V - HALF ) - HALF
         ASVAL = CHEVAL( NTERMA,AB1AS,T )
         ASLN = LOG( ASVAL * SQRT ( V / THREE ) / RT3BPI ) - V
         IF ( ASLN .LT. LNXMIN ) THEN
            ABRAM1 = ZERO
         ELSE
            ABRAM1 = EXP( ASLN )
         ENDIF
         RETURN
      ENDIF
      END

      DOUBLE PRECISION FUNCTION ABRAM2(XVALUE)
C
C   DESCRIPTION:
C      This function calculates the Abramowitz function of order 2,
C      defined as
C
C       ABRAM2(x) = integral{ 0 to infinity } (t**2) * exp( -t*t - x/t ) dt
C
C      The code uses Chebyshev expansions with the coefficients
C      given to an accuracy of 20 decimal places.
C
C
C   ERROR RETURNS:
C      If XVALUE < 0.0, the function prints a message and returns the
C      value 0.0.
C
C
C   MACHINE-DEPENDENT CONSTANTS:
C
C      NTERMF - INTEGER - No. of terms needed for the array AB2F.
C               Recommended value such that
C                     ABS( AB2F(NTERMF) ) < EPS/100
C
C      NTERMG - INTEGER - No. of terms needed for array AB2G.
C               Recommended value such that
C                     ABS( AB2G(NTERMG) ) < EPS/100
C
C      NTERMH - INTEGER - No. of terms needed for array AB2H.
C               Recommended value such that
C                     ABS( AB2H(NTERMH) ) < EPS/100
C
C      NTERMA - INTEGER - No. of terms needed for array AB2AS.
C               Recommended value such that
C                     ABS( AB2AS(NTERMA) ) < EPS/100
C
C      XLOW - DOUBLE PRECISION - The value below which
C               ABRAM2 = root(pi)/4 to machine precision.
C             The recommended value is EPSNEG
C
C      XLOW1 - DOUBLE PRECISION - The value below which
C                ABRAM2 = root(pi)/4 - x/2 + x**3ln(x)/6
C              Recommended value is SQRT(2*EPSNEG)
C
C      LNXMIN - DOUBLE PRECISION - The value of ln XMIN. Used to prevent
C               exponential underflow for large X.
C
C     For values of EPS, EPSNEG, XMIN refer to the file MACHCON.TXT
C
C     The machine-dependent constants are computed internally by
C     using the D1MACH subroutine.
C
C
C   INTRINSIC FUNCTIONS USED:
C
C     LOG, EXP
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
C          CHEVAL , ERRPRN, D1MACH
C
C
C   AUTHOR:
C
C      DR. ALLAN J. MACLEOD,
C      DEPT. OF MATHEMATICS AND STATISTICS,
C      UNIVERSITY OF PAISLEY,
C      HIGH ST.,
C      PAISLEY,
C      SCOTLAND.
C      PA1 2BE
C
C      ( e-mail: macl_ms0@paisley.ac.uk )
C
C
C   LATEST REVISION:   23 January, 1996
C
C
      INTEGER NTERMA,NTERMF,NTERMG,NTERMH
      DOUBLE PRECISION AB2F(0:9),AB2G(0:8),AB2H(0:7),AB2AS(0:26),
     &     ASLN,ASVAL,CHEVAL,FVAL,GVAL,HALF,HVAL,LNXMIN,
     &     ONEHUN,ONERPI,RTPIB4,RT3BPI,SIX,T,THREE,TWO,
     &     V,X,XLOW,XLOW1,XVALUE,ZERO,D1MACH
C
C   INTRINSIC FUNCTIONS USED:
C
       INTRINSIC ABS, LOG, EXP, SQRT
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
       EXTERNAL CHEVAL, D1MACH
C
c*****CHARACTER FNNAME*6,ERRMSG*33
c*****DATA FNNAME/'ABRAM2'/
c*****DATA ERRMSG/'FUNCTION CALLED WITH ARGUMENT < 0'/
      DATA AB2F/1.03612 16280 42437 13846  D    0,
     1          0.19371 24662 67945 70012  D    0,
     2         -0.72587 58839 23300 7378   D   -1,
     3          0.17479 05908 64327 399    D   -2,
     4         -0.12812 23233 75654 9      D   -4,
     5          0.41150 18153 651          D   -7,
     6         -0.69710 47256              D  -10,
     7          0.69901 83                 D  -13,
     8         -0.4492                     D  -16,
     9          0.2                        D  -19/
      DATA AB2G/1.46290 15719 86307 41150  D    0,
     1          0.20189 46688 31540 14317  D    0,
     2         -0.29082 92087 99712 9022   D   -1,
     3          0.47061 04903 52700 50     D   -3,
     4         -0.25792 20803 59333        D   -5,
     5          0.65613 37129 46           D   -8,
     6         -0.91411 0203               D  -11,
     7          0.77427 6                  D  -14,
     8         -0.429                      D  -17/
      DATA AB2H/0.30117 22501 09104 88881  D    0,
     1         -0.15886 67818 31762 3783   D   -1,
     2          0.19295 93693 55845 26     D   -3,
     3         -0.90199 58784 9300         D   -6,
     4          0.20610 50418 37           D   -8,
     5         -0.26511 1806               D  -11,
     6          0.21086 4                  D  -14,
     7         -0.111                      D  -17/
      DATA AB2AS(0)/  2.46492 32530 43348 56893  D    0/
      DATA AB2AS(1)/  0.23142 79742 22489 05432  D    0/
      DATA AB2AS(2)/ -0.94068 17301 00857 73     D   -3/
      DATA AB2AS(3)/  0.82902 70038 08973 3      D   -4/
      DATA AB2AS(4)/ -0.88389 47042 45866        D   -5/
      DATA AB2AS(5)/  0.10663 85435 67985        D   -5/
      DATA AB2AS(6)/ -0.13991 12853 8529         D   -6/
      DATA AB2AS(7)/  0.19397 93208 445          D   -7/
      DATA AB2AS(8)/ -0.27704 99383 75           D   -8/
      DATA AB2AS(9)/  0.39590 68718 6            D   -9/
      DATA AB2AS(10)/-0.54083 54342              D  -10/
      DATA AB2AS(11)/ 0.63554 6076               D  -11/
      DATA AB2AS(12)/-0.38461 613                D  -12/
      DATA AB2AS(13)/-0.11696 067                D  -12/
      DATA AB2AS(14)/ 0.68966 71                 D  -13/
      DATA AB2AS(15)/-0.25031 13                 D  -13/
      DATA AB2AS(16)/ 0.78558 6                  D  -14/
      DATA AB2AS(17)/-0.23033 4                  D  -14/
      DATA AB2AS(18)/ 0.64914                    D  -15/
      DATA AB2AS(19)/-0.17797                    D  -15/
      DATA AB2AS(20)/ 0.4766                     D  -16/
      DATA AB2AS(21)/-0.1246                     D  -16/
      DATA AB2AS(22)/ 0.316                      D  -17/
      DATA AB2AS(23)/-0.77                       D  -18/
      DATA AB2AS(24)/ 0.18                       D  -18/
      DATA AB2AS(25)/-0.4                        D  -19/
      DATA AB2AS(26)/ 0.1                        D  -19/
      DATA ZERO,HALF,TWO/ 0.0 D 0 , 0.5 D 0, 2.0 D 0/
      DATA THREE,SIX,ONEHUN/ 3.0 D 0, 6.0 D 0 , 100.0 D 0/
      DATA RT3BPI/ 0.97720 50238 05839 84317 D 0/
      DATA RTPIB4/ 0.44311 34627 26379 00682 D 0/
      DATA ONERPI/ 0.56418 95835 47756 28695 D 0/
C
C   Start calculation
C
      X = XVALUE
C
C   Error test
C
      IF ( X .LT. ZERO ) THEN
c********CALL ERRPRN(FNNAME,ERRMSG)
         ABRAM2 = ZERO
         RETURN
      ENDIF
C
C   Compute the machine-dependent constants.
C
      T = D1MACH(4) / ONEHUN
      IF ( X .LE. TWO ) THEN
         DO 10 NTERMF = 9 , 0 , -1
            IF ( ABS(AB2F(NTERMF)) .GT. T ) GOTO 19
 10      CONTINUE
 19      DO 20 NTERMG = 8 , 0 , -1
            IF ( ABS(AB2G(NTERMG)) .GT. T ) GOTO 29
 20      CONTINUE
 29      DO 30 NTERMH = 7 , 0 , -1
            IF ( ABS(AB2H(NTERMH)) .GT. T ) GOTO 39
 30      CONTINUE
 39      XLOW = D1MACH(3)
         XLOW1 = SQRT ( TWO * XLOW )
      ELSE
         DO 40 NTERMA = 26 , 0 , -1
            IF ( ABS(AB2AS(NTERMA)) .GT. T ) GOTO 49
 40      CONTINUE
 49      LNXMIN = LOG(D1MACH(1))
      ENDIF
C
C   Code for 0 <= XVALUE <= 2
C
      IF ( X .LE. TWO ) THEN
         IF ( X .EQ. ZERO ) THEN
            ABRAM2 = RTPIB4
            RETURN
         ENDIF
         IF ( X .LT. XLOW1 ) THEN
            IF ( X .LT. XLOW ) THEN
               ABRAM2 = RTPIB4
            ELSE
               ABRAM2 = RTPIB4 - HALF * X + X * X * X * LOG( X ) / SIX
            ENDIF
            RETURN
         ELSE
            T =  ( X * X / TWO - HALF ) - HALF
            FVAL = CHEVAL( NTERMF,AB2F,T )
            GVAL = CHEVAL( NTERMG,AB2G,T )
            HVAL = CHEVAL( NTERMH,AB2H,T )
            ABRAM2 = FVAL/ONERPI + X * ( X * X * LOG(X) * HVAL- GVAL )
            RETURN
         ENDIF
      ELSE
C
C   Code for XVALUE > 2
C
         V = THREE *  ( (X / TWO) ** ( TWO / THREE ) )
         T =  ( SIX / V - HALF ) - HALF
         ASVAL = CHEVAL( NTERMA,AB2AS,T )
         ASLN = LOG( ASVAL / RT3BPI ) + LOG( V / THREE ) - V
         IF ( ASLN .LT. LNXMIN ) THEN
            ABRAM2 = ZERO
         ELSE
            ABRAM2 = EXP( ASLN )
         ENDIF
         RETURN
      ENDIF
      END
C
C
