C
C From ACTOMS 745 ... Eta functions for Fermi-Dirac integrals
C Added LOGGAM = .FALSE. after CALL GAMMAC 20/12/2001
C
C ETARIE
C ETALEV
C ETAN
C
C
* **********************************************************************
*
        SUBROUTINE ETARIE(S, EPS, XMAX, RELERR, ETA)
*
* **********************************************************************
* ETARIE returns in ETA the value of the eta function, for real argument
*        S, approximated with a relative error RELERR.  EPS and XMAX
*        represent the smallest positive floating-point number such that
*        1.0+EPS .NE. 1.0, and the largest finite floating-point number,
*        respectively.  For S .GT. -1 Levin's u transform [2] is used to
*        sum the alternating series (23.2.19) of [1], except when S is a
*        positive integer.  Otherwise the reflection formula (23.2.6) of
*        [1] is employed, involving gamma function evaluation, except in
*        the trivial zeros S = -2N.
*
* References:
*
*   [1] E. V. Haynsworth and K. Goldberg, "Bernoulli and Euler
*       Polynomials - Riemann Zeta Function", in "Handbook of
*       Mathematical Functions with Formulas, Graphs and Mathematical
*       Tables" (M. Abramowitz and I. A. Stegun, eds.), no. 55 in
*       National Bureau of Standards Applied Mathematics Series, ch. 23,
*       pp. 803-819, Washington, D.C.:  U.S. Government Printing Office,
*       1964.
*
*   [2] T. Fessler, W. F. Ford, D. A. Smith, "ALGORITHM 602. HURRY: An
*       acceleration algorithm for scalar sequences and series", ACM
*       Transactions on Mathematical Software, vol. 9, no. 3,
*       pp. 355-357, September  1983.
*
* If a single precision version is desired, change all occurrences of
* *SP in columns 1 to 3 to blanks and comment the corresponding double
* precision statements.
*
* Michele Goano, Politecnico di Torino  (goano@polito.it).
* Latest revision:  March 22, 1994.
* **********************************************************************
*   Parameters
*SP     REAL             ONE, PI, PILOG, TWO, ZERO
        DOUBLE PRECISION ONE, PI, PILOG, TWO, ZERO
*SP     PARAMETER (ONE = 1.0E+0, PI = 3.141592653589793238462643E+0,
*SP  &             PILOG = 1.144729885849400174143427E+0, TWO = 2.0E+0,
*SP  &             ZERO = 0.0E+0)
        PARAMETER (ONE = 1.0D+0, PI = 3.141592653589793238462643D+0,
     &             PILOG = 1.144729885849400174143427D+0, TWO = 2.0D+0,
     &             ZERO = 0.0D+0)
*   Scalar arguments
*SP     REAL             S, EPS, XMAX, RELERR, ETA
        DOUBLE PRECISION S, EPS, XMAX, RELERR, ETA
*   Local scalars
        LOGICAL LOGGAM
        INTEGER IERR
*SP     REAL             ETALOG, GAMMA, TWOTOS, XBIG
        DOUBLE PRECISION ETALOG, GAMMA, TWOTOS
*   External subroutines
        EXTERNAL ETALEV, ETAN, GAMMAC
*   Intrinsic functions
        INTRINSIC ANINT, EXP, LOG, MOD, SIN
        intrinsic abs, nint
* ----------------------------------------------------------------------
C*******XBIG = LOG(XMAX)
        ETA = ZERO
*
        IF (S.EQ.ZERO) THEN
          ETA = ONE/TWO
        ELSE IF (S.LT.ZERO .AND. MOD(S, TWO).EQ.ZERO) THEN
          ETA = ZERO
        ELSE IF (S.GT.-ONE) THEN
          IF (ABS(S-ANINT(S)).LE.ABS(S)*EPS) THEN
            CALL ETAN(NINT(S), ETA)
          ELSE
            CALL ETALEV(S, RELERR, ETA)
          END IF
        ELSE
          TWOTOS = TWO**S
          CALL GAMMAC(ONE - S, EPS, XMAX, GAMMA, IERR)
          LOGGAM = .FALSE.!added by w.g.bardsley, 20/12/2001
          IF (IERR.EQ.-1) LOGGAM = .TRUE.
          CALL ETALEV(ONE - S, RELERR, ETA)
          IF (LOGGAM) THEN
            ETALOG = (S - ONE)*PILOG+GAMMA+LOG(ETA)
            ETA = (TWOTOS - TWO)/(ONE - TWOTOS)*SIN(S*PI/TWO)*
     &                                                       EXP(ETALOG)
          ELSE
            ETA = (TWOTOS - TWO)/(ONE - TWOTOS)*SIN(S*PI/TWO)*
     &                                           PI**(S - ONE)*GAMMA*ETA
          END IF
        END IF
        RETURN
        END

* **********************************************************************
*
        SUBROUTINE ETALEV(S, RELERR, ETA)
*
* **********************************************************************
* ETALEV returns in ETA the value of the eta function, for real argument
*        S, approximated with a relative error RELERR.  Levin's u
*        transform [2] is used to sum the alternating series (23.2.19)
*        of [1].
*
* References:
*
*   [1] E. V. Haynsworth and K. Goldberg, "Bernoulli and Euler
*       Polynomials - Riemann Zeta Function", in "Handbook of
*       Mathematical Functions with Formulas, Graphs and Mathematical
*       Tables" (M. Abramowitz and I. A. Stegun, eds.), no. 55 in
*       National Bureau of Standards Applied Mathematics Series, ch. 23,
*       pp. 803-819, Washington, D.C.:  U.S. Government Printing Office,
*       1964.
*
*   [2] T. Fessler, W. F. Ford, D. A. Smith, "ALGORITHM 602. HURRY: An
*       acceleration algorithm for scalar sequences and series", ACM
*       Transactions on Mathematical Software, vol. 9, no. 3,
*       pp. 355-357, September  1983.
*
* If a single precision version is desired, change all occurrences of
* *SP in columns 1 to 3 to blanks and comment the corresponding double
* precision statements.
*
* Michele Goano, Politecnico di Torino  (goano@polito.it).
* Latest revision:  March 22, 1994.
* **********************************************************************
*   Parameters
        INTEGER ITMAX
        PARAMETER (ITMAX = 100)
*SP     REAL             ONE, ZERO
        DOUBLE PRECISION ONE, ZERO
*SP     PARAMETER (ONE = 1.0E+0, ZERO = 0.0E+0)
        PARAMETER (ONE = 1.0D+0, ZERO = 0.0D+0)
*   Scalar arguments
*SP     REAL             S, RELERR, ETA
        DOUBLE PRECISION S, RELERR, ETA
*   Local scalars
        INTEGER JTERM
*SP     REAL             ETAOLD, SEGN, SUM, TERM
        DOUBLE PRECISION ETAOLD, SEGN, SUM, TERM
*   Local arrays
*SP     REAL             QNUM(ITMAX), QDEN(ITMAX)
        DOUBLE PRECISION QNUM(ITMAX), QDEN(ITMAX)
*   External subroutines
        EXTERNAL WHIZ
*   Intrinsic functions
*SP     INTRINSIC ABS, REAL
        INTRINSIC ABS, DBLE
* ----------------------------------------------------------------------
        ETA = ZERO
*
        SEGN = ONE
        DO 10 JTERM = 1, ITMAX
          ETAOLD = ETA
*SP       TERM = SEGN/REAL(JTERM)**S
          TERM = SEGN/DBLE(JTERM)**S
          CALL WHIZ(TERM, JTERM, QNUM, QDEN, ETA, SUM)
*   Check truncation error and convergence
          IF (ABS(ETA-ETAOLD).LE.ABS(ETA)*RELERR) RETURN
          SEGN = -SEGN
   10   CONTINUE
        END

* **********************************************************************
*
        SUBROUTINE ETAN(N, ETA)
*
* **********************************************************************
* ETAN returns in ETA the value of the eta function for integer
*      nonnegative argument N, approximated to 25 significant decimal
*      digits.
*
* Reference:
*
*   E. V. Haynsworth and K. Goldberg, "Bernoulli and Euler Polynomials -
*   Riemann Zeta Function", in "Handbook of Mathematical Functions with
*   Formulas, Graphs and Mathematical Tables" (M. Abramowitz and
*   I. A. Stegun, eds.), no. 55 in National Bureau of Standards Applied
*   Mathematics Series, ch. 23, pp. 803-819, Washington, D.C.:  U.S.
*   Government Printing Office, 1964.
*
* If a single precision version is desired, change all occurrences of
* *SP in columns 1 to 3 to blanks and comment the corresponding double
* precision statements.
*
* Michele Goano, Politecnico di Torino  (goano@polito.it).
* Latest revision:  March 22, 1994.
* **********************************************************************
*   Parameters
*SP     REAL             HALF, ONE, ZERO
        DOUBLE PRECISION HALF, ONE, ZERO
*SP     PARAMETER (HALF = 0.5E+0, ONE = 1.0E+0, ZERO = 0.0E+0)
        PARAMETER (HALF = 0.5D+0, ONE = 1.0D+0, ZERO = 0.0D+0)
*   Scalar arguments
        INTEGER N
*SP     REAL             ETA
        DOUBLE PRECISION ETA
*   Local arrays
*SP     REAL             ETABLE(84)
        DOUBLE PRECISION ETABLE(84)
* ----------------------------------------------------------------------
        SAVE ETABLE
*SP     DATA ETABLE(1),  ETABLE(2),  ETABLE(3),  ETABLE(4),
*SP  &       ETABLE(5),  ETABLE(6),  ETABLE(7),  ETABLE(8),
*SP  &       ETABLE(9),  ETABLE(10), ETABLE(11), ETABLE(12),
*SP  &       ETABLE(13), ETABLE(14), ETABLE(15), ETABLE(16) /
*SP  &  0.6931471805599453094172321E+0, 0.8224670334241132182362076E+0,
*SP  &  0.9015426773696957140498036E+0, 0.9470328294972459175765032E+0,
*SP  &  0.9721197704469093059356551E+0, 0.9855510912974351040984392E+0,
*SP  &  0.9925938199228302826704257E+0, 0.9962330018526478992272893E+0,
*SP  &  0.9980942975416053307677830E+0, 0.9990395075982715656392218E+0,
*SP  &  0.9995171434980607541440942E+0, 0.9997576851438581908531797E+0,
*SP  &  0.9998785427632651154921750E+0, 0.9999391703459797181709542E+0,
*SP  &  0.9999695512130992380826329E+0, 0.9999847642149061064416828E+0 /
*SP     DATA ETABLE(17), ETABLE(18), ETABLE(19), ETABLE(20),
*SP  &       ETABLE(21), ETABLE(22), ETABLE(23), ETABLE(24),
*SP  &       ETABLE(25), ETABLE(26), ETABLE(27), ETABLE(28),
*SP  &       ETABLE(29), ETABLE(30), ETABLE(31), ETABLE(32) /
*SP  &  0.9999923782920410119769379E+0, 0.9999961878696101134796892E+0,
*SP  &  0.9999980935081716751068565E+0, 0.9999990466115815221150508E+0,
*SP  &  0.9999995232582155428163167E+0, 0.9999997616132308225478972E+0,
*SP  &  0.9999998808013184395032238E+0, 0.9999999403988923946283614E+0,
*SP  &  0.9999999701988569628344151E+0, 0.9999999850992319965687877E+0,
*SP  &  0.9999999925495504849635159E+0, 0.9999999962747534001087275E+0,
*SP  &  0.9999999981373694181121867E+0, 0.9999999990686822814539786E+0,
*SP  &  0.9999999995343403314542175E+0, 0.9999999997671698959514908E+0 /
*SP     DATA ETABLE(33), ETABLE(34), ETABLE(35), ETABLE(36),
*SP  &       ETABLE(37), ETABLE(38), ETABLE(39), ETABLE(40),
*SP  &       ETABLE(41), ETABLE(42), ETABLE(43), ETABLE(44),
*SP  &       ETABLE(45), ETABLE(46), ETABLE(47), ETABLE(48) /
*SP  &  0.9999999998835848580460305E+0, 0.9999999999417923990453159E+0,
*SP  &  0.9999999999708961895298095E+0, 0.9999999999854480914338848E+0,
*SP  &  0.9999999999927240446065848E+0, 0.9999999999963620219331688E+0,
*SP  &  0.9999999999981810108432087E+0, 0.9999999999990905053804789E+0,
*SP  &  0.9999999999995452526765309E+0, 0.9999999999997726263336959E+0,
*SP  &  0.9999999999998863131653248E+0, 0.9999999999999431565821547E+0,
*SP  &  0.9999999999999715782909081E+0, 0.9999999999999857891453976E+0,
*SP  &  0.9999999999999928945726800E+0, 0.9999999999999964472863337E+0 /
*SP     DATA ETABLE(49), ETABLE(50), ETABLE(51), ETABLE(52),
*SP  &       ETABLE(53), ETABLE(54), ETABLE(55), ETABLE(56),
*SP  &       ETABLE(57), ETABLE(58), ETABLE(59), ETABLE(60),
*SP  &       ETABLE(61), ETABLE(62), ETABLE(63), ETABLE(64) /
*SP  &  0.9999999999999982236431648E+0, 0.9999999999999991118215817E+0,
*SP  &  0.9999999999999995559107906E+0, 0.9999999999999997779553952E+0,
*SP  &  0.9999999999999998889776976E+0, 0.9999999999999999444888488E+0,
*SP  &  0.9999999999999999722444244E+0, 0.9999999999999999861222122E+0,
*SP  &  0.9999999999999999930611061E+0, 0.9999999999999999965305530E+0,
*SP  &  0.9999999999999999982652765E+0, 0.9999999999999999991326383E+0,
*SP  &  0.9999999999999999995663191E+0, 0.9999999999999999997831596E+0,
*SP  &  0.9999999999999999998915798E+0, 0.9999999999999999999457899E+0 /
*SP     DATA ETABLE(65), ETABLE(66), ETABLE(67), ETABLE(68),
*SP  &       ETABLE(69), ETABLE(70), ETABLE(71), ETABLE(72),
*SP  &       ETABLE(73), ETABLE(74), ETABLE(75), ETABLE(76),
*SP  &       ETABLE(77), ETABLE(78), ETABLE(79), ETABLE(80) /
*SP  &  0.9999999999999999999728949E+0, 0.9999999999999999999864475E+0,
*SP  &  0.9999999999999999999932237E+0, 0.9999999999999999999966119E+0,
*SP  &  0.9999999999999999999983059E+0, 0.9999999999999999999991530E+0,
*SP  &  0.9999999999999999999995765E+0, 0.9999999999999999999997882E+0,
*SP  &  0.9999999999999999999998941E+0, 0.9999999999999999999999471E+0,
*SP  &  0.9999999999999999999999735E+0, 0.9999999999999999999999868E+0,
*SP  &  0.9999999999999999999999934E+0, 0.9999999999999999999999967E+0,
*SP  &  0.9999999999999999999999983E+0, 0.9999999999999999999999992E+0 /
*SP     DATA ETABLE(81), ETABLE(82), ETABLE(83), ETABLE(84) /
*SP  &  0.9999999999999999999999996E+0, 0.9999999999999999999999998E+0,
*SP  &  0.9999999999999999999999999E+0, 0.9999999999999999999999999E+0 /
        DATA ETABLE(1),  ETABLE(2),  ETABLE(3),  ETABLE(4),
     &       ETABLE(5),  ETABLE(6),  ETABLE(7),  ETABLE(8),
     &       ETABLE(9),  ETABLE(10), ETABLE(11), ETABLE(12),
     &       ETABLE(13), ETABLE(14), ETABLE(15), ETABLE(16) /
     &  0.6931471805599453094172321D+0, 0.8224670334241132182362076D+0,
     &  0.9015426773696957140498036D+0, 0.9470328294972459175765032D+0,
     &  0.9721197704469093059356551D+0, 0.9855510912974351040984392D+0,
     &  0.9925938199228302826704257D+0, 0.9962330018526478992272893D+0,
     &  0.9980942975416053307677830D+0, 0.9990395075982715656392218D+0,
     &  0.9995171434980607541440942D+0, 0.9997576851438581908531797D+0,
     &  0.9998785427632651154921750D+0, 0.9999391703459797181709542D+0,
     &  0.9999695512130992380826329D+0, 0.9999847642149061064416828D+0 /
        DATA ETABLE(17), ETABLE(18), ETABLE(19), ETABLE(20),
     &       ETABLE(21), ETABLE(22), ETABLE(23), ETABLE(24),
     &       ETABLE(25), ETABLE(26), ETABLE(27), ETABLE(28),
     &       ETABLE(29), ETABLE(30), ETABLE(31), ETABLE(32) /
     &  0.9999923782920410119769379D+0, 0.9999961878696101134796892D+0,
     &  0.9999980935081716751068565D+0, 0.9999990466115815221150508D+0,
     &  0.9999995232582155428163167D+0, 0.9999997616132308225478972D+0,
     &  0.9999998808013184395032238D+0, 0.9999999403988923946283614D+0,
     &  0.9999999701988569628344151D+0, 0.9999999850992319965687877D+0,
     &  0.9999999925495504849635159D+0, 0.9999999962747534001087275D+0,
     &  0.9999999981373694181121867D+0, 0.9999999990686822814539786D+0,
     &  0.9999999995343403314542175D+0, 0.9999999997671698959514908D+0 /
        DATA ETABLE(33), ETABLE(34), ETABLE(35), ETABLE(36),
     &       ETABLE(37), ETABLE(38), ETABLE(39), ETABLE(40),
     &       ETABLE(41), ETABLE(42), ETABLE(43), ETABLE(44),
     &       ETABLE(45), ETABLE(46), ETABLE(47), ETABLE(48) /
     &  0.9999999998835848580460305D+0, 0.9999999999417923990453159D+0,
     &  0.9999999999708961895298095D+0, 0.9999999999854480914338848D+0,
     &  0.9999999999927240446065848D+0, 0.9999999999963620219331688D+0,
     &  0.9999999999981810108432087D+0, 0.9999999999990905053804789D+0,
     &  0.9999999999995452526765309D+0, 0.9999999999997726263336959D+0,
     &  0.9999999999998863131653248D+0, 0.9999999999999431565821547D+0,
     &  0.9999999999999715782909081D+0, 0.9999999999999857891453976D+0,
     &  0.9999999999999928945726800D+0, 0.9999999999999964472863337D+0 /
        DATA ETABLE(49), ETABLE(50), ETABLE(51), ETABLE(52),
     &       ETABLE(53), ETABLE(54), ETABLE(55), ETABLE(56),
     &       ETABLE(57), ETABLE(58), ETABLE(59), ETABLE(60),
     &       ETABLE(61), ETABLE(62), ETABLE(63), ETABLE(64) /
     &  0.9999999999999982236431648D+0, 0.9999999999999991118215817D+0,
     &  0.9999999999999995559107906D+0, 0.9999999999999997779553952D+0,
     &  0.9999999999999998889776976D+0, 0.9999999999999999444888488D+0,
     &  0.9999999999999999722444244D+0, 0.9999999999999999861222122D+0,
     &  0.9999999999999999930611061D+0, 0.9999999999999999965305530D+0,
     &  0.9999999999999999982652765D+0, 0.9999999999999999991326383D+0,
     &  0.9999999999999999995663191D+0, 0.9999999999999999997831596D+0,
     &  0.9999999999999999998915798D+0, 0.9999999999999999999457899D+0 /
        DATA ETABLE(65), ETABLE(66), ETABLE(67), ETABLE(68),
     &       ETABLE(69), ETABLE(70), ETABLE(71), ETABLE(72),
     &       ETABLE(73), ETABLE(74), ETABLE(75), ETABLE(76),
     &       ETABLE(77), ETABLE(78), ETABLE(79), ETABLE(80) /
     &  0.9999999999999999999728949D+0, 0.9999999999999999999864475D+0,
     &  0.9999999999999999999932237D+0, 0.9999999999999999999966119D+0,
     &  0.9999999999999999999983059D+0, 0.9999999999999999999991530D+0,
     &  0.9999999999999999999995765D+0, 0.9999999999999999999997882D+0,
     &  0.9999999999999999999998941D+0, 0.9999999999999999999999471D+0,
     &  0.9999999999999999999999735D+0, 0.9999999999999999999999868D+0,
     &  0.9999999999999999999999934D+0, 0.9999999999999999999999967D+0,
     &  0.9999999999999999999999983D+0, 0.9999999999999999999999992D+0 /
        DATA ETABLE(81), ETABLE(82), ETABLE(83), ETABLE(84) /
     &  0.9999999999999999999999996D+0, 0.9999999999999999999999998D+0,
     &  0.9999999999999999999999999D+0, 0.9999999999999999999999999D+0 /
* ----------------------------------------------------------------------
        ETA = ZERO
        IF (N.EQ.0) THEN
          ETA = HALF
        ELSE IF (N.LE.84) THEN
          ETA = ETABLE(N)
        ELSE IF (N.GT.84) THEN
          ETA = ONE
        END IF
        RETURN
        END

