C
C ACM 487
C
C Function PKS2 adapted by W.G.Bardsley, 04/04/2000
C =================================================
C Replaced intrinsics by generics, introduced implicit none, declared
C intrinsics, reflected PKS2 back into (0,1) and doubled array dimensions
C for future developments.
C
C     ALGORITHM 487 COLLECTED ALGORITHMS FROM ACM.
C     ALGORITHM APPEARED IN COMM. ACM, VOL. 17, NO. 12,
C     P. 703.
      DOUBLE PRECISION FUNCTION PKS2 (N, D)
      IMPLICIT NONE
C
C Arguments supplied are N and D
C
      INTEGER N
      DOUBLE PRECISION D
C
C N IS THE SAMPLE SIZE USED.
C D IS THE MAXIMUM MAGNITUDE (OF THE DISCREPANCY
C BETWEEN THE EMPIRICAL AND PROPOSED DISTRIBUTIONS)
C IN EITHER THE POSITIVE OR NEGATIVE DIRECTION.
C PKS2 IS THE EXACT PROBABILITY OF OBTAINING A
C DEVIATION NO LARGER THAN D.
C THESE FORMULAS APPEAR AS (23) AND (24) IN
C J. DURBIN.  THE PROBABILITY THAT THE SAMPLE
C DISTRIBUTION FUNCTION LIES BETWEEN TWO PARALLEL
C STRAIGHT LINES. ANNALS OF MATHEMATICAL STATISTICS
C 39, 2(APRIL 1968),398-411.
C
      INTEGER    I, J, JMAX, K, ND, NDD, NDDP, NDP, NDT
      DOUBLE PRECISION Q(282), FACT(282), SUM1, CI,
     + FT, FU, FV
      DOUBLE PRECISION FN, FND, SIGN1
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      INTRINSIC  MIN, INT, DBLE
      IF (N.EQ.1) GO TO 90
      FN = DBLE(N)
      FND = FN*D
      NDT = INT(TWO*FND)
      IF (NDT.LT.1) GO TO 100
      ND = INT(FND)
      NDD = MIN(2*ND,N)
      NDP = ND + 1
      NDDP = NDD + 1
      FACT(1) = ONE
      CI = ONE
      DO 10 I = 1, N
        FACT(I + 1) = FACT(I)*CI
        CI = CI + ONE
   10 CONTINUE
      Q(1) = ONE
      IF (NDD.EQ.0) GO TO 50
      CI = ONE
      DO 20 I = 1, NDD
        Q(I + 1) = CI**I/FACT(I + 1)
        CI = CI + ONE
   20 CONTINUE
      IF (NDP.GT.N) GO TO 80
      FV = DBLE(NDP) - FND
      JMAX = INT(FV) + 1
      DO 40 I = NDP, NDD
        SUM1 = ZERO
        FT = FND
        K = I
        FU = FV
        DO 30 J = 1, JMAX
          SUM1 = SUM1 + FT**(J - 2)/FACT(J)*FU**K/
     +     FACT(K + 1)
          FT = FT + ONE
          FU = FU - ONE
          K = K - 1
   30   CONTINUE
        Q(I + 1) = Q(I + 1) - TWO*FND*SUM1
        JMAX = JMAX + 1
        FV = FV + ONE
   40 CONTINUE
      IF (NDD.EQ.N) GO TO 80
   50 DO 70 I = NDDP, N
        SUM1 = ZERO
        SIGN1 = ONE
        FT = TWO*FND
        DO 60 J = 1, NDT
          FT = FT - ONE
          K = I - J + 1
          SUM1 = SUM1 + SIGN1*FT**J/FACT(J + 1)*Q(K)
          SIGN1 = - SIGN1
   60   CONTINUE
        Q(I + 1) = SUM1
   70 CONTINUE
   80 PKS2 = Q(N + 1)*FACT(N + 1)/FN**N
      IF (PKS2.LT.ZERO) PKS2 = ZERO
      IF (PKS2.GT.ONE) PKS2 = ONE
      RETURN
   90 PKS2 = TWO*D - ONE
      IF (PKS2.LT.ZERO) PKS2 = ZERO
      IF (PKS2.GT.ONE) PKS2 = ONE
      RETURN
  100 PKS2 = ZERO
      RETURN
      END
C
C
