C
C Calculation of Legendre polynomials by recurrence
C
      DOUBLE PRECISION FUNCTION POLLEG (L, M, X)
      IMPLICIT NONE
      INTEGER  L, M
      INTEGER  I
      DOUBLE PRECISION X
      DOUBLE PRECISION A, B, C, D, E
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      INTRINSIC ABS, SQRT, DBLE
C
C Check for consistent arguments
C
      IF (M.LT.0 .OR .M.GT.L .OR .ABS(X).GT.ONE) THEN
         POLLEG = ZERO
         RETURN
      ENDIF
      B = ONE
C
C The case M > 0
C
      IF (M.GT.0) THEN
         E = SQRT((ONE - X)*(ONE + X))
         D = ONE
         DO I = 1, M
            B = - B*D*E
            D = D + TWO
         ENDDO
      ENDIF
      IF (L.EQ.M) THEN
C
C The case L = M
C
         POLLEG = B
      ELSE
         C = X*(TWO*DBLE(M) + ONE)*B
         IF (L.EQ.M + 1) THEN
C
C The case L = M + 1
C
            POLLEG = C
         ELSE
           DO I = M + 2, L
              A = (X*(TWO*DBLE(I) - ONE)*C - DBLE(I + M - 1)*B)/
     +             DBLE(I - M)
              B = C
              C = A
           ENDDO
           POLLEG = A
         ENDIF
      ENDIF
      END
C
C
