c 
c 17/10/2012 edited (in lower case) by w.g.bardsley, university of manchester, u.k.
c AS R50 Jones and Lotwick 1983 improvement included
c Also changed kftlo and kfthi from (5, 1) to (3, 21)
c      
C renaming as follows:
C DENEST = APS176
C  FORRT = APS97
C  REVRT = APS97_1
C FASTFG = APS97_2
C  SCRAG = APS97_3     
c
c      SUBROUTINE DENEST(DT, NDT, DLO, DHI, WINDOW, FT, SMOOTH,
c     *                  NFT, ICAL, IFAULT)
      SUBROUTINE APS176(DT, NDT, DLO, DHI, WINDOW, FT, SMOOTH,
     *                  NFT, ICAL, IFAULT)
     
       implicit none
         
c      REAL DT(NDT), FT(NFT), SMOOTH(NFT)
C
C     ALGORITHM AS 176  APPL. STATIST. (1982) VOL.31, NO.1
C     Modified using AS R50 (Appl. Statist. (1984))
C
C     Find density estimate by kernel method using Gaussian kernel.
C     The interval on which the estimate is evaluated has end points
C     DLO and DHI.   If ICAL is not zero then it is assumed that the
C     routine has been called before with the same data and end points
C     and that the array FT has not been altered.
C
C     Auxiliary routines called: FORRT & REVRT from AS 97
C

c
c arguments
c
      integer,          intent (in)    :: ical, ndt, nft
      integer,          intent (out)   :: ifault
      double precision, intent (in)    :: dt(ndt)
      double precision, intent (inout) :: ft(nft), smooth(nft)
      double precision, intent (in)    :: dlo, dhi, window
c
c locals
c      
      integer i, ii, j, jj, jhi, jmax, j1, j2, j2lo, k, kk, nft2 
      integer kftlo, kfthi
      double precision ainc, bc, dlo1, fac, fac1, hw, rj, rjfac, step,
     +                 winc, wt
      double precision zero, half, one, six, thir2
      double precision big
      external  aps97, aps97_1
      intrinsic dble, exp, atan, min, sqrt
      DATA ZERO/0.0d+00/, HALF/0.5d+00/, ONE/1.0d+00/, SIX/6.0d+00/
     +                  , THIR2/32.0d+00/
      DATA BIG/30.0d+00/, KFTLO/3/, KFTHI/21/
C
C     The constant BIG is set so that exp(-BIG) can be calculated
C     without causing underflow problems and can be considered = 0.
C
C     Initialize and check for valid parameter values.
C
      IF (WINDOW .LE. ZERO) GO TO 92
      IF (DLO .GE. DHI) GO TO 93
      II = 2**KFTLO
      DO 1 K = KFTLO, KFTHI
      IF (II .EQ. NFT) GO TO 2
      II = II + II
    1 CONTINUE
      IFAULT = 1
      RETURN
    2 STEP = (DHI - DLO) / dble(NFT)
      AINC = ONE / (NDT * STEP)
      NFT2 = NFT / 2
      HW = WINDOW / STEP
      FAC1 = THIR2 * (ATAN(ONE) * HW / NFT) ** 2
      IF (ICAL .NE. 0) GO TO 10
C
C     Discretize the data
C
      DLO1 = DLO - STEP * HALF
      DO 3 J = 1, NFT
      FT(J) = ZERO
    3 continue
      DO 4 I = 1, NDT
      WT = (DT(I) - DLO1) / STEP
      JJ = INT(WT)
      IF (JJ .LT. 1 .OR. JJ .GT. NFT) GO TO 4
      WT = WT - dble(JJ)
      WINC = WT * AINC
      KK = JJ + 1
      IF (JJ .EQ. NFT) KK = 1
      FT(JJ) = FT(JJ) + AINC - WINC
      FT(KK) = FT(KK) + WINC
    4 CONTINUE
C
C     Transform to find FT.
C
      CALL APS97(FT, NFT)
C
C     Find transform of density estimate.
C
   10 JHI = SQRT(BIG / FAC1)
      JMAX = MIN(NFT2 - 1, JHI)
      SMOOTH(1) = FT(1)
      RJ = ZERO
      DO 11 J = 1, JMAX
      RJ = RJ + ONE
      RJFAC = RJ * RJ * FAC1
      BC = ONE - RJFAC / (HW * HW * SIX)
      FAC = EXP(-RJFAC) / BC
      J1 = J + 1
      J2 = J1 + NFT2
      SMOOTH(J1) = FAC * FT(J1)
      SMOOTH(J2) = FAC * FT(J2)
   11 CONTINUE
C
C     Cope with underflow by setting tail of transform to zero.
C
      IF (JHI + 1 - NFT2) 21, 23, 20
   20 SMOOTH(NFT2 + 1) = EXP(-FAC1 * dble(NFT2)**2) * FT(NFT2 + 1)
      GO TO 24
   21 J2LO = JHI + 2
      DO 22 J1 = J2LO, NFT2
      J2 = J1 + NFT2
      SMOOTH(J1) = ZERO
      SMOOTH(J2) = ZERO
   22 CONTINUE
   23 SMOOTH(NFT2 + 1) = ZERO
C
C     Invert Fourier transform of SMOOTH to get estimate and eliminate
C     negative density values.
C
   24 CALL APS97_1(SMOOTH, NFT)
      DO 25 J = 1, NFT
      IF (SMOOTH(J) .LT. ZERO) SMOOTH(J) = ZERO
   25 continue
      IFAULT = 0
      RETURN
C
   92 IFAULT = 2
      RETURN
   93 IFAULT = 3
      RETURN
      END
