C
C subroutine APS196
C
C****************************************************************************
C Subroutine LOGCCH renamed as AS196 and including subroutines HOWARD, ALGFAC,
C CHOL renamed as APS006 and SYMINV renamed as APS007 to avoid inconsistent
C argument lists.
C
C Corrected and edited by w.g.bardsley@man.ac.uk 18/08/2002 as follows:-
C
C Items 9, 11 and 16 below are serious corrections since the code gives
C incorrect answers as it stands, but the rest are essentially cosmetic
C improvements.
C
C  (1) Added IMPLICIT NONE
C  (2) Declared all variable types
C  (3) Added MAXIT and EPS to argument list
C  (4) Changed all REAL to DOUBLE PRECISION
C  (5) Changed name from LOGCCH to APS196
C  (6) Changed ALOG to LOG and FLOAT to DBLE
C  (7) Declared ABS, LOG, DBLE, EXP as INTRINSICS
C  (8) Added CHOL (AS6) and SYMINV (AS7 with restored argument list,
C      i.e. using NN) but renamed them as APS006 and APS007
C  (9) Altered WD2B(L,I1) = to WD2B(L,J1) = in subroutine HOWARD which was
C      clearly wrong even in the paper
C (10) Initialised CHI2 = 0
C (11) Corrected definition of COVI at label 12 which was truncated in the
C      email code probably due to a scanning error
C (12) Replaced SYMINV by APS007
C (13) Returned DEV in COVI(1)
C (14) Indented code loops and cleaned up to make it more readable
C (15) Added IPRINT
C (16) Changed IVAR(IS) to IVAR(IR) in HOWARD which was probably a scanning error
C
C********************************************************************************
C      31/12/2014 revision to make G11CAF$ behave better with respect to scores by changing the
C                 termination criteria and to prevent derivatives being saved when inappropriate
c                 at the sections dated as ... edited by w.g.bardsley 31/12/2014  
C
C                 New variables 
C                 DOUBLE PRECISION, ALLOCATABLE :: DLSAV       
C                 DOUBLE PRECISION DLMIN, DLSUM, DNV
C                 PARAMETER (DLMIN = 1.0D-07) 
C
      SUBROUTINE APS196 (NS, NCA, NCT, NIMAX, NMAX, NMAX1, NVMAX,
     +                   NVMAX1, NV, Z, IVAR, COVI, CNTR, W, WB, WDB,
     +                   WD2B, U, INS, DB, D2B, DL, B, COV, CHI2, ST,
     +                   IFAULT,
     +                   IPRINT, MAXIT, EPS)
C
C ALGORITHM AS 196 APPL. STATIST. (1984) VOL.33, NO.1
C
C LOGISTIC ANALYSIS OF CASE-CONTROL STUDIES
C
c *** WARNING  This file has been input using a scanner and may
c              contain errors.
c
      IMPLICIT   NONE
      INTEGER    IPRINT, MAXIT
      INTEGER    IFAULT, NV, NVMAX1, NVMAX, NMAX1, NMAX, NIMAX, NS
      INTEGER    I2, NULLTY, KK, IR, IS, L, NID, JJ, J, J1, K1, K, M,
     +           I1, ITS, N, I, NN
      INTEGER    NCA(NS), NCT(NS), IVAR(NVMAX), INS(NS)
      INTEGER    IADD1
      DOUBLE PRECISION Z(NVMAX, NIMAX), COVI(NVMAX1), CNTR(NVMAX, NS),
     +                 W(NVMAX), WB(NMAX1), WDB(NVMAX, NMAX1),
     +                 WD2B(NVMAX1, NMAX1), U(NMAX), DB(NVMAX),
     +                 D2B(NVMAX1), DL(NVMAX), B(NVMAX), COV(NVMAX1)
      DOUBLE PRECISION CHI2, EPS, ZERO, ONE, TWO, BMN, CONST, C1, FM,
     +                 RLIK, RLIKP, RLIKS, ST, T, TTT
      DOUBLE PRECISION ALGFAC
      DOUBLE PRECISION, ALLOCATABLE :: DLSAV(:)
      DOUBLE PRECISION DLMIN, DLSUM, DNV
      PARAMETER (DLMIN = 1.0D-07)
      EXTERNAL   ALGFAC, HOWARD, APS007
      INTRINSIC  DBLE, ABS, LOG, EXP, MIN
      DATA ZERO / 0.0D+00 /, ONE / 1.0D+00 /, TWO / 2.0D+00 /
C
C ... edited by w.g.bardsley 31/12/2014 ... Initialise DNV, DLSAV, and DLSUM 
C      
      IF (ALLOCATED(DLSAV)) DEALLOCATE(DLSAV, STAT = J)
      I = NV
      ALLOCATE (DLSAV(I), STAT = J)
      DNV = DBLE(NV)
      DO I = 1, NV
         DLSAV(I) = DLMIN
      ENDDO 
      DLSUM = ZERO     
C
C INITIAL SETTINGS
C
      IF (IPRINT.GT.0) THEN
         IADD1 = 0
         WRITE (*,'(A)') 'It.   Obj.Fcn.      B(1)        B(2)  ...'
      ENDIF
      RLIKP = ONE
      IFAULT = 0
      ITS = 0
      IF (NV .GT. NVMAX) GOTO 21
      IF (NVMAX * (NVMAX + 1) / 2 .GT. NVMAX1) GOTO 21
      IF (NMAX + 1 .GT. NMAX1) GOTO 21
      INS(1) = 0
      IF (NCA(1) + NCT(1) .GT. NMAX .OR. NCA(1) + NCT(1) .GT. NIMAX)
     *  GOTO 21
      IF (NS .EQ. 1) GOTO 2
      DO 1 I = 2, NS
         IF (NCA(I) + NCT(I) .GT. NMAX) GOTO 21
         I1 = I - 1
         INS(I) = NCA(I1) + NCT(I1) + INS(I1)
    1 CONTINUE
      IF (INS(NS) + NCA(NS) + NCT(NS) .GT. NIMAX) GOTO 21
C
C CENTRE THE INDEPENDENT VARIABLES ABOUT THE MEAN OF THE
C COVARIATES FOR THE CASES (C.F. S.HOWARDS COMMENT TO COX (1972))
C
    2 CONTINUE
      DO 6 I = 1, NS
         IF (NCA(I) * NCT(I) .EQ. 0) GOTO 6
         M = NCA(I)
         N = M + NCT(I)
         FM = ONE / DBLE(M)
         I1 = INS(I)
         DO 5 K = 1, NV
            CNTR(K, I) = ZERO
            K1 = IVAR(K)
            J1 = I1
            DO 3 J = 1, M
               J1 = J1 + 1
               CNTR(K, I) = CNTR(K, I) + Z(K1, J1)
    3       CONTINUE
            CNTR(K, I) = CNTR(K, I) * FM
            J1 = I1
            DO 4 J = 1, N
               J1 = J1 + 1
               Z(K1, J1) = Z(K1, J1) - CNTR(K, I)
    4       CONTINUE
    5    CONTINUE
    6 CONTINUE
C
C The iteration loop starts here for ITS = 1, 2, ..., MAXIT
C
    7 CONTINUE
      ITS = ITS + 1
      IF (ITS .GT. MAXIT) GOTO 23
      RLIK = ZERO
      K = 0
      DO 8 J = 1, NV
         DL(J) = ZERO
      DO 8 JJ = 1, J
         K = K + 1
         COVI(K) = ZERO
    8 CONTINUE
C
C LOOP THROUGH STRATA
C
      DO 14 I = 1, NS
         IF (NCA(I) * NCT(I) .EQ. 0) GOTO 14
         M = NCA(I)
         N = M + NCT(I)
         NID = INS(I)
C
C FIND U(J)=EXP(Z(J)*BETA) FOR EACH INDIVIDUAL J IN THE STRATA.
C ALSO, FIHD TTT, THE TOTAL OF THE (Z(J)*BETA)S.
C
         TTT = ZERO
         DO 10 J = 1, N
            J1 = J + NID
            T = ZERO
            DO 9 K = 1, NV
               L = IVAR(K)
               T = T + B(K) * Z(L, J1)
    9       CONTINUE
            TTT = TTT + T
            U(J) = EXP(T)
   10    CONTINUE
C
C CALCULATE THE CONSTANT CONST=
C ((N(C)M) * EXP(M*BETA*XBAR))**(1/M)
C WHERE XBAR IS THE MEAN OF THE COVARIATES OVER THE CASES AND
C CONTROLS, AHD DIVIDE EACH U(J) BY THIS CONSTANT.
C THIS KEEPS THE SUMS CALCULATED BY SUBROUTINE HOWARD FROM
C BECOMING TOO LARGE IN ABSOLUTE VALUE.
C NOTE - ALGFAC(X)=LN((X)FACTORIAL)
C
         C1 = ALGFAC(N) - (ALGFAC(M) + ALGFAC(N - M)) + TTT * DBLE(M) /
     *      DBLE(N)
         CONST = EXP(-C1 / DBLE(M))
         DO 11 J = 1, N
            U(J) = U(J) * CONST
   11    CONTINUE
C
C CALL TO HOWARD TO CALCULATE SUM(EXP(S(L)*BETA)) OVER ALL
C COMBINATIONS OF N LABELS TAKEN M AT A TIME, AND ITS FIRST AND
C SECOND DERIVATIVES WITH RESPECT TO BETA.
C NOTE - THE VALUE FOR THE SUM AND ITS DERIVATIVES RETURNED BY
C HOWARD ARE THE TRUE VALUES DIVIDED BY THE CONSTANT CONST**M.
C THEREFORE RLIK IS CORRECTED FOR THIS CONSTANT SO THAT THE
C LIKELIHOOD RATIO TEST STATISTIC WILL BE CORRECT.
C NOTE - SC=BETA*(SUM(Z(J)) OVER THE CASES) = 0 BY DEFINITION.
C
         CALL HOWARD(M, N, U, Z, NID, IVAR, NVMAX, NIMAX, NMAX, NVMAX1,
     *               NV, NMAX1, WB, WDB, WD2B, DB, D2B, BMN)
         RLIK = RLIK - LOG(BMN) - C1
         L = 0
         IR = 1
         IS = 0
C
C CALCULATE THE CUMULATIVE SCORE UP TO THIS STRATUM.
C
         DO 13 K = 1, NV
            DL(K) = DL(K) - DB(K) / BMN
         DO 13 KK = 1, K
            L = L + 1
            IS = IS + 1
            IF (IS .LE. IR) GOTO 12
            IR = IR + 1
            IS = 1
C
C CALCULATE THE CUMULATIVE INFORMATION UP TO THIS STRATUM.
C
C Note by w.g.bardsley (18/08/2002)
C ... the next line was truncated in the aps email
C
   12       CONTINUE
            COVI(L) = COVI(L) + D2B(L) / BMN -
     *                DB(IR) * DB(IS) / (BMN * BMN)
   13    CONTINUE
   14 CONTINUE
      IF (ITS .EQ. 1) RLIKS = RLIK
C
C CALCULATE THE INVERSE OF THE INFORMATION MATRIX
C
C Note by w.g.bardsley (18/08/2002)
C ... defined NN and altered argument list in call to SYMINV and replaced by APS007
C
      NN = NV*(NV + 1)/2
      CALL APS007 (COVI, NV, NN, COV, W, NULLTY, IFAULT)
      IF (IFAULT .NE. 0) GOTO 22
C
C CALCULATE NEW PARAMETER ESTIMATES
C
      DO 17 I = 1, NV
         W(I) = ZERO
         I2 = I * (I - 1) / 2
         DO 15 J = 1, I
            K = I2 + J
            W(I) = W(I) + DL(J) * COV(K)
   15    CONTINUE
         I1 = I + 1
         IF (I1 .GT. NV) GOTO 17
         DO 16 K = I1, NV
            J = K * (K - 1) / 2 + I
            W(I) = W(I) + DL(K) * COV(J)
   16    CONTINUE
   17 CONTINUE
      DO 18 I = 1, NV
         B(I) = B(I) + W(I)
   18 CONTINUE
      IF (ITS .NE. 1) GOTO 20
C
C CALCULATE THE TEST SCORE
C
      ST = ZERO
      DO 19 I = 1, NV
         ST = ST + W(I) * DL(I)
   19 CONTINUE
C
C TEST FOR CONVERGENCE
C
   20 CONTINUE
      RLIK = RLIK - RLIKS
C
C Intermediate output if IPRINT.GT.0
C
      IF (IPRINT.GT.0) THEN
         IADD1 = IADD1 + 1
         IF (IADD1.EQ.IPRINT) THEN
            IADD1 = 0
            WRITE (*,'(I3,1P,E13.6,10E12.4)') ITS, RLIK,
     +            (B(I),I = 1, MIN(10,NV))
         ENDIF
      ENDIF
C
C ... edited by w.g.bardsley 31/12/2014 ... Save derivatives if not too small and new covergence test
C      
      DLSUM = ZERO
      DO I = 1, NV
         DLSUM = DLSUM + ABS(DL(I))
      ENDDO
      DLSUM = DLSUM/DNV
      IF (DLSUM.GT.DLMIN) THEN
          DO I = 1, NV
             DLSAV(I) = DL(I) 
          ENDDO
      ENDIF         
      IF (ABS(RLIKP - RLIK) .LT. EPS*(ONE + RLIKP)) GOTO 24
        
      RLIKP = RLIK
      GOTO 7
   21 IFAULT = 1
      GOTO 25
   22 IFAULT = 2
      GOTO 25
   23 IFAULT = 3
      GOTO 25
   24 CHI2 = TWO * RLIK
C
C w.g.bardsley (18/08/2002) returned the deviance in COVI(1)
C
      COVI(1) = - TWO*(RLIK + RLIKS)
C
C RETURN MATRIX Z TO THE FORM IT WAS IN WHEN LOGCCH WAS CALLED
C
   25 CONTINUE
      DO 27 I = 1, NS
         IF (NCA(I) * NCT(I) .EQ. 0) GOTO 27
         N = NCA(I) + NCT(I)
         I1 = INS(I)
         DO 26 K = 1, NV
            K1 = IVAR(K)
            J1 = I1
         DO 26 J = 1, N
            J1 = J1 + 1
            Z(K1, J1) = Z(K1, J1) + CNTR(K, I)
   26    CONTINUE
   27 CONTINUE
C   
C ... edited by w.g.bardsley 31/12/2014 ... output the saved derivatives 
C   
      DO I = 1, NV
         DL(I) = DLSAV(I)
      ENDDO   
      DEALLOCATE (DLSAV, STAT = J)
      RETURN
      END
C
C**********************************************************************
C
      SUBROUTINE HOWARD(M, N, U, Z, NID, IVAR, NVMAX, NIMAX, NMAX,
     +                  NVMAX1, NV, NMAX1, WB, WDB, WD2B, DB, D2B, BMN)
C
C ALGORITHM AS 122.1 APPL. STATIST. (1984) VOL.33, NO.1
C
      IMPLICIT NONE
      INTEGER  NMAX1, NV, NVMAX1, NMAX, NIMAX, NVMAX, NID, N, M
      INTEGER  IR1, IS1, IS, IR, I1, J1, IM, NMMP1, J, M1, LL, I,NV1,
     +         L1, L
      INTEGER  IVAR(NVMAX)
      DOUBLE PRECISION U(NMAX), Z(NVMAX, NIMAX), WB(NMAX1),
     +                 WDB(NVMAX, NMAX1), WD2B(NVMAX1, NMAX1),
     +                 DB(NVMAX), D2B(NVMAX1)
C
      DOUBLE PRECISION BMN, ZERO, ONE
C
      DATA ZERO / 0.0D+00 /, ONE / 1.0D+00 /
C
      NV1 = NV * (NV + 1) / 2
C
C INITIALISE THE REQUIRED MATRICES AND VECTORS FOR THE RECURSION
C
      WB(1) = ONE
      I = 0
      DO 1 L = 1, NV
         WDB(L, 1) = ZERO
      DO 1 LL = 1, L
         I = I + 1
         WD2B(I, 1) = ZERO
    1 CONTINUE
      M1 = M + 1
      IF (M .EQ. 0) GOTO 9
      DO 3 J = 2, M1
         WB(J) = ZERO
         I = 0
         DO 2 L = 1, NV
            WDB(L, J) = ZERO
         DO 2 LL = 1, L
            I = I + 1
            WD2B(I, J) = ZERO
    2    CONTINUE
    3 CONTINUE
      NMMP1 = N - M + 1
      DO 8 IM = 1, NMMP1
         DO 7 J = 1, M
            J1 = J + 1
            I = J + IM - 1
            I1 = I + NID
            IR = 1
            IS = 0
            DO 5 L = 1, NV1
               IS = IS + 1
               IS1 = IVAR(IS)
C
C Note by w.g.bardsley (18/08/2002)
C ... altered IVAR(IS) to IVAR(IR)
C
               IR1 = IVAR(IR)
               IF (IS .LE. IR) GOTO 4
               IR = IR + 1
               IS = 1
               IS1 = IVAR(IS)
               IR1 = IVAR(IR)
C
C CALCULATE SUM(EXP(S(L)*BETA)) OVER ALL COMBINATIONS OF N
C LABELS TAKEN M AT A TIME?  AND ITS FIRST AND SECOND DERIVATIVES
C WITH RESPECT TO BETA.
C NOTE - THE VALUES RETURNED BT THIS ROUTINE ARE THE TRUE VALUES
C OF THE SUMS DIVIDED BY TME CONSTANT CONST**M, WHERE CONST
C IS AS CALCULATED IN 2UBROUTINE LOGCCH.
C
C Note by w.g.bardsley (18/08/2002)
C ... altered WD2B(L, I1) = ... to WD2B(L,J1) =
C
    4          CONTINUE
               WD2B(L, J1) = WD2B(L, J1) + U(I) * WD2B(L, J) +
     *                       Z(IR1, I1) * Z(IS1, I1) * U(I) * WB(J) +
     *                       Z(IR1, I1) * U(I) * WDB(IS, J) +
     *                       Z(IS1, I1) * U(I) * WDB(IR, J)
    5       CONTINUE
            DO 6 L = 1, NV
               L1 = IVAR(L)
               WDB(L, J1) = WDB(L, J1) + U(I) * WDB(L, J) +
     *                      Z(L1, I1) * U(I) * WB(J)
    6       CONTINUE
            WB(J1) = WB(J1) + U(I) * WB(J)
    7    CONTINUE
    8 CONTINUE
    9 CONTINUE
      BMN = WB(M1)
      I = 0
      DO 10 L = 1, NV
         DB(L) = WDB(L, M1)
      DO 10 LL = 1, L
         I = I + 1
         D2B(I) = WD2B(I, M1)
   10 CONTINUE
      RETURN
      END
C
C**********************************************************************
C
      DOUBLE PRECISION FUNCTION ALGFAC(I)
C
C ALGORITHM AS 196.2 APPL. STATIST. (1984) VOL.33, NO.1
C
C EVALUATES THE NATURAL LOGARITHM OF GAMMA(I+1)=LN(I-FACTORIAL)
C (FORTRAN VERSION OF ACM291 - M.C.PIKE AND I.D.HILL,CACM,9,1966)
C
      IMPLICIT  NONE
      INTEGER   I
      INTEGER   K
      DOUBLE PRECISION HALF, CONST, ONE, TWELVE, TREE60, AA, AK, B
C
      INTRINSIC LOG, DBLE
C
      DATA      HALF, CONST, ONE, TWELVE, TREE60 / 0.5D+00,
     +     0.9189385333D+00, 1.0D+00, 12.0D+00, 360.0D+00 /

      IF (I .GT. 7) GOTO 3
      B = ONE
      IF (I .LE. 1) GOTO 2
      DO 1 K = 2, I
         B = B * DBLE(K)
    1 CONTINUE
    2 CONTINUE
      ALGFAC = LOG(B)
      RETURN
    3 CONTINUE
      AA = DBLE(I)
      AK = ONE / AA
      ALGFAC = (AA + HALF) * LOG(AA) + AK * (ONE / TWELVE - (AK * AK)
     *   / TREE60) - AA + CONST
      RETURN
      END
C
C
