C
C************************************
C More accurate replacement for AS245
C APS245 = ALNGAM = S14ABF$ = DLNGAM
C************************************
C Defines APS245 and ALNGAM as DLNGAM from SLATEC
C

      DOUBLE PRECISION FUNCTION APS245 (XX, IFAIL)
C*****DOUBLE PRECISION FUNCTION ALNGAM (XX, IFAIL)
C*****DOUBLE PRECISION FUNCTION S14ABF$(XX, IFAIL)
C
C ACTION : log gamma function using SLATEC
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/12/2001
C          Equivalent to IFAIL = 1 soft fail, no error trapping
C          Returns IFAIL = 2 for large values but just keeps on.
C          Set to 0 to trap the poles occurring at 1 and 2
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, RTOL, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, RTOL = 1.0D-300, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION XBIG, XSMALL
      PARAMETER (XBIG = 1.0D+300, XSMALL = 1.0D-14)
      DOUBLE PRECISION EPSI, Z1LO, Z1HI, Z2LO, Z2HI
      PARAMETER (EPSI = 1.0D-14,
     +           Z1LO = ONE - EPSI, Z1HI = ONE + EPSI,
     +           Z2LO = TWO - EPSI, Z2HI = TWO + EPSI)
      DOUBLE PRECISION DLNGAM
      EXTERNAL   DLNGAM
      INTRINSIC  MAX, LOG
C
C Copy X into XX so X is returned unchanged
C
      X = XX
      IF (X.LE.ZERO) THEN
C
C Failure if X < 0
C

         APS245 = ZERO
         IFAIL = 1
      ELSEIF (X.LE.XSMALL) THEN
         X = MAX(X,RTOL)
         IFAIL = 0
         APS245 = LOG(ONE/X)
      ELSEIF ((X.GT.Z1LO .AND. X.LT.Z1HI) .OR.
     +        (X.GT.Z2LO .AND. X.LT.Z2HI)) THEN
C
C Trap the poles at X = 1 and X = 2
C
C
         APS245 = ZERO
         IFAIL = 0
      ELSE
C
C DLNGAM
C
         IFAIL = 0
         IF (X.GT.XBIG) THEN
            IFAIL = 2
            X = XBIG
         ENDIF
         APS245 = DLNGAM(X)
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION ALNGAM (XX, IFAIL)
C*****DOUBLE PRECISION FUNCTION S14ABF$(XX, IFAIL)
C
C ACTION : log gamma function using SLATEC
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/12/2001
C          Equivalent to IFAIL = 1 soft fail, no error trapping
C          Returns IFAIL = 2 for large values but just keeps on.
C          Set to 0 to trap the poles occurring at 1 and 2
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, RTOL, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, RTOL = 1.0D-300, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION XBIG, XSMALL
      PARAMETER (XBIG = 1.0D+300, XSMALL = 1.0D-14)
      DOUBLE PRECISION EPSI, Z1LO, Z1HI, Z2LO, Z2HI
      PARAMETER (EPSI = 1.0D-14,
     +           Z1LO = ONE - EPSI, Z1HI = ONE + EPSI,
     +           Z2LO = TWO - EPSI, Z2HI = TWO + EPSI)
      DOUBLE PRECISION DLNGAM
      EXTERNAL   DLNGAM
      INTRINSIC  MAX, LOG
C
C Copy X into XX so X is returned unchanged
C
      X = XX
      IF (X.LE.ZERO) THEN
C
C Failure if X < 0
C

         ALNGAM = ZERO
         IFAIL = 1
      ELSEIF (X.LE.XSMALL) THEN
         X = MAX(X,RTOL)
         IFAIL = 0
         ALNGAM = LOG(ONE/X)
      ELSEIF ((X.GT.Z1LO .AND. X.LT.Z1HI) .OR.
     +        (X.GT.Z2LO .AND. X.LT.Z2HI)) THEN
C
C Trap the poles at X = 1 and X = 2
C
C
         ALNGAM = ZERO
         IFAIL = 0
      ELSE
C
C DLNGAM
C
         IFAIL = 0
         IF (X.GT.XBIG) THEN
            IFAIL = 2
            X = XBIG
         ENDIF
         ALNGAM = DLNGAM(X)
      ENDIF
      END
C
C
