c
c action: Simfit driver for CG+
c author: w.g.bardsely, university of manchester.u.k.
c         23/03/2013 derived from the authors main program
c
c Note: output is written to f$cgplus.tmp on unit = 8 and maxit = maximum iterations
C       i.e. termination if icall > maxit
c
c       --------------------------------------------------------------------
c       Main program for running the conjugate gradient methods described in 
c       the paper:
c
c       Gilbert, J.C. and Nocedal, J. (1992). "Global Convergence Properties 
c       of Conjugate Gradient Methods", SIAM Journal on Optimization, Vol. 2,
c       pp. 21-42.
c
c       A web-based Server which solves unconstrained nonlinear optimization
c       problems using this Conjugate Gradient code can be found at:
c
c       http://www-neos.mcs.anl.gov/neos/solvers/UCO:CGPLUS/
c
c       Written by G. Liu, J. Nocedal and R. Waltz
c       October 1998
c       --------------------------------------------------------------------
C
C     N      =  NUMBER OF VARIABLES
C     X      =  ITERATE
C     F      =  FUNCTION VALUE
C     G      =  GRADIENT VALUE
C     GOLD   =  PREVIOUS GRADIENT VALUE
C     IPRINT =  FREQUENCY AND TYPE OF PRINTING
C               IPRINT(1) < 0 : NO OUTPUT IS GENERATED
C               IPRINT(1) = 0 : OUTPUT ONLY AT FIRST AND LAST ITERATION
C               IPRINT(1) > 0 : OUTPUT EVERY IPRINT(1) ITERATIONS
C               IPRINT(2)     : SPECIFIES THE TYPE OF OUTPUT GENERATED;
C                               THE LARGER THE VALUE (BETWEEN 0 AND 3),
C                               THE MORE INFORMATION
C               IPRINT(2) = 0 : NO ADDITIONAL INFORMATION PRINTED
C 		IPRINT(2) = 1 : INITIAL X AND GRADIENT VECTORS PRINTED
C		IPRINT(2) = 2 : X VECTOR PRINTED EVERY ITERATION
C		IPRINT(2) = 3 : X VECTOR AND GRADIENT VECTOR PRINTED 
C				EVERY ITERATION 
C     EPS    =  CONVERGENCE CONSTANT
C     W      =  WORKING ARRAY
C     IFLAG  =  CONTROLS TERMINATION OF CODE, AND RETURN TO MAIN
C               PROGRAM TO EVALUATE FUNCTION AND GRADIENT
C               IFLAG = -3 : IMPROPER INPUT PARAMETERS
C               IFLAG = -2 : DESCENT WAS NOT OBTAINED
C               IFLAG = -1 : LINE SEARCH FAILURE
C               IFLAG =  0 : INITIAL ENTRY OR 
C                            SUCCESSFUL TERMINATION WITHOUT ERROR   
C               IFLAG =  1 : INDICATES A RE-ENTRY WITH NEW FUNCTION VALUES
C               IFLAG =  2 : INDICATES A RE-ENTRY WITH A NEW ITERATE
C     IREST  =  0 (NO RESTARTS); 1 (RESTART EVERY N STEPS)
C     METHOD =  1 : FLETCHER-REEVES 
C               2 : POLAK-RIBIERE
C               3 : POSITIVE POLAK-RIBIERE ( BETA=MAX{BETA,0} )
C

c 
      subroutine cgdriver (fcn,
     +                     icall, iflag, iprint, irest, maxit, method, 
     +                     n,
     +                     d, eps, g, gold, w, x)
      implicit none
c
c arguments
c   
      integer,          intent (out)   :: icall, iflag
      integer,          intent (in)    :: iprint(2), irest, maxit,
     +                                    method, n
      double precision, intent (in)    :: eps
      double precision, intent (inout) :: d(n), g(n), gold(n), w(n),
     +                                    x(n)   
c
c locals
c
      double precision f,tlev, one
      logical          finish
      integer          maxcal
      integer          mp,lp,i
      integer          iter,nfun
      external         fcn, cgfam
      intrinsic        max
      common /cgdd/    mp,lp
      common /runinf/  iter,nfun
      data one/1.0D+0/
      maxcal = max(100,maxit)
c
c check
c      
      if (method.lt.1 .or. method.gt.3 .or.
     +    n.lt.1 .or.
     +    irest.lt.0 .or. irest.gt.1) then
         iflag = -3
         return
      endif   
      
c
c define mp and lp and open output file
c      
      mp = 8
      lp = 8
      open (unit = mp, file = 'f$cgplus.tmp')
     
       FINISH = .FALSE.

c
c Print parameters
c
      if (iprint(1) .ge. 0) then
         write (mp,100) n, method, irest, maxit
      end if
c
c initialise icall	
c
      ICALL=0
c
c IFLAG=0 indicates an initial entry to program
c
      IFLAG=0
c
c main loop
c
  20  CONTINUE
c
c Calculate the function and gradient values here
c
      call fcn(n,x,f,g)

 30   CONTINUE
c
c Call the main optimization code
c
      CALL CGFAM(N,X,F,G,D,GOLD,IPRINT,EPS,W,
     *            IFLAG,IREST,METHOD,FINISH)
c
c       IFLAG=
c              0 : successful termination
c              1 : return to evaluate F and G
c              2 : return with a new iterate, try termination test
c             -i : error
c
      IF(IFLAG.LE.0.OR.ICALL.GT.MAXCAL) GO TO 50
         IF(IFLAG.EQ.1) THEN
            ICALL=ICALL + 1       
            GO TO 20
         ENDIF     
         IF(IFLAG.EQ.2) THEN
c
c Termination Test.  The user may replace it by some other test. However, 
c the parameter 'FINISH' must be set to 'TRUE' when the test is satisfied.
c
       TLEV= EPS*(ONE + DABS(F))
       I=0
  40   I=I+1
       IF(I.GT.N) THEN
              FINISH = .TRUE.
          GO TO 30
       ENDIF
       IF(DABS(G(I)).GT.TLEV) THEN
          GO TO 30
       ELSE
          GO TO 40
       ENDIF

        ENDIF

  50  continue
c
c Code has terminated; print final results
c
      if (iprint(1).ge.0.and.iflag.ge.0) then
         write (mp,200) f, icall
      end if
      close (unit = mp)
c
c Formatting
c
 100  format (' Conjugate Gradient Minimization Routine',/,
     +        ' n      =', i6, /,
     *        ' method =', i6,/,
     *        ' irest  =', i6,/,
     +        ' maxit  =', i6)
  200 format (' f(x*) =',1p,d16.8,', ICALL =',i6)
      end
























