C
C Double precision version of CL1 ... W.G.B. 18/9/97
C ==================================================
C
C 13/11/98 Changed all A(1) dimensions to A(*)
C ============================================
C
C Subroutine substitutions SETUP   ... CL1A
C                          NEWPEN  ... CL1B
C                          UPDATE  ... CL1C
C                          MONIT   ... CL1D
C                          FINDP   ... CL1E
C                          STEP    ... CL1F
C                          REFINE  ... CL1G
C                          DELCOL  ... CL1H
C                          RESID   ... CL1I
C                          ADDCOL  ... CL1J
C                          OBJECT  ... CL1K
C                          GETV    ... CL1L
C
C

      SUBROUTINE CL1(NEQNS,NEQC,NIQC,NVARS,NACT,IFL,MXS,PSW,
     *               E,NER,X,F,EL1N,RES,INDX,W)
C
      IMPLICIT NONE
      INTEGER  IFL,INDX(*),MXS,NACT,NEQC,NEQNS,NER,NIQC,NVARS
      LOGICAL  PSW
      DOUBLE PRECISION E(NER,*),EL1N,F(*),RES(*),W(*),X(*)
C
C
C     **********************************************************
C     A PROGRAM FOR THE SOLUTION IN THE   L1  SENSE
C     OF A LINEAR-EQUATION SYSTEM
C     (WITH OR WITHOUT LINEAR CONSTRAINTS).
C     RICHARD H. BARTELS AND ANDREW R. CONN.
C     LATEST UPDATE .... 13 APRIL, 1980.
C
C     DEVELOPMENT OF THIS PROGRAM WAS SUPPORTED
C     IN PART BY U. S. NSF GRANT DCR75-07817
C     AND BY FUNDS FROM THE NATIONAL BUREAU OF STANDARDS,
C     AND IN PART BY CANADIAN NRC GRANT A8639.
C
C     +++++ PARAMETERS +++++
C     ----------------------------------------------------------
C                           INPUT
C     NAME  TYPE  SUBSCRPT  OUTPUT        DESCRIPTION
C                           SCRATCH
C     ..........................................................
C     NEQNS INT.    NONE      IN      NUMBER OF EQUATIONS
C                                     (MAY BE ZERO)
C
C     NEQC  INT.    NONE      IN      NUMBER OF EQUALITY
C                                     CONSTRAINTS
C                                     (MAY BE ZERO)
C
C     NIQC  INT.    NONE      IN      NUMBER OF INEQUALITY
C                                     CONSTRAINTS
C                                     (MAY BE ZERO)
C
C     NVARS INT.    NONE      IN      NUMBER OF VARIABLES
C
C     NACT  INT.    NONE      OUT     NUMBER OF ACTIVE
C                                     EQUATIONS/CONSTRAINTS
C                                     AT TERMINATION
C                                     (IF ANY, THEIR ASSOCIATED
C                                      COLUMN POSITIONS IN  E  WILL
C                                      BE LISTED IN  INDX(1)
C                                      THROUGH  INDX(NACT) )
C
C     IFL   INT.    NONE      OUT     TERMINATION CODE
C                                     (SEE BELOW)
C
C     MXS   INT.    NONE      IN      MAXIMUM NUMBER OF STEPS
C                                     ALLOWED
C
C     PSW   LOGIC.  NONE      IN      PRINT SWITCH
C                                     (SEE BELOW)
C
C     E     REAL     2        IN      EQUATION/CONSTRAINT MATRIX
C                                     THE FIRST  NEQNS  COLUMNS
C                                     (SEE NOTE BELOW) SPECIFY
C                                     EQUATIONS, THE REMAINING
C                                     COLUMNS (IF ANY) SPECIFY
C                                     CONSTRAINTS.
C
C     NER   INT.    NONE      IN      ROW DIMENSION OF E
C
C     X     REAL     1        IN      STARTING VALUES FOR THE
C                                     UNKNOWNS (USE ZEROS IF NO
C                                     GUESS IS AVAILABLE)
C                             OUT     TERMINATION VALUES FOR
C                                     THE UNKNOWNS
C
C     F     REAL     1        IN      EQUATION/CONSTRAINT
C                                     RIGHT-HAND SIDES
C
C     EL1N  REAL    NONE      OUT     L1 NORM OF EQUATION
C                                     RESIDUALS AT TERMINATION
C
C     RES   REAL     1        OUT     EQUATION/CONSTRAINT
C                                     RESIDUALS AT TERMINATION
C
C     INDX  INT.     1        OUT     INDEX VECTOR USED TO RECORD
C                                     THE ORDER IN WHICH THE COLUMNS
C                                     OF  E  ARE BEING PROCESSED
C
C     W     REAL     1        SCR.    WORKING STORAGE
C     ----------------------------------------------------------
C
C     +++++ PURPOSE +++++
C     ----------------------------------------------------------
C     THIS SUBROUTINE SOLVES THE   NEQNS BY NVARS
C     SYSTEM OF EQUATIONS
C
C                       (A-TRANSPOSE) * X   ==   B
C
C     SUBJECT TO THE  NEQC   CONSTRAINTS
C
C                       (G-TRANSPOSE) * X  .EQ.  H
C
C     AND THE  NIQC  INEQUALITY CONSTRAINTS
C
C                       (C-TRANSPOSE) * X  .GE.  D
C
C     FOR THE UNKNOWNS  X(1),...,X(NVARS).
C
C     THE PROBLEM MUST BE WELL-POSED, NONTRIVIAL
C     AND OVERDETERMINED IN THE SENSE THAT
C
C                          NVARS .GE. 1
C                          NEQNS .GE. 0
C                          NEQC  .GE. 0
C                          NIQC  .GE. 0
C               NEQNS+NEQC+NIQC  .GE. NVARS.
C
C     FURTHER, NO COLUMN OF  A, G  OR  C  SHOULD BE ZERO.
C     IF THESE CONDITIONS ARE NOT MET, THE PROGRAM
C     WILL TERMINATE WITHOUT PERFORMING ANY SUBSTANTIVE
C     COMPUTATIONS.
C
C     A POINT  X  IS A SOLUTION IF IT MINIMIZES THE EQUATION
C     RESIDUALS FROM AMONG ALL POINTS WHICH SATISFY THE
C     CONSTRAINTS.  AT ANY (NONDEGENERATE) SOLUTION
C     THERE WILL BE  NACT  EQUATIONS AND CONSTRAINTS
C     WHOSE RESIDUALS
C
C          (A(I)-TRANSPOSE) * X - B(I)
C
C          (G(I)-TRANSPOSE) * X - H(I)
C
C     AND
C
C          (C(I)-TRANSPOSE) * X - D(I)
C
C     ARE ZERO.
C
C     THE COLUMNS OF  (A,G,C)  CORRESPONDING TO THE ZERO RESIDUALS
C     ARE REFERRED TO AS  ACTIVE COLUMNS  THROUGHOUT THIS LISTING.
C     THE NUMBERS OF THE ACTIVE COLUMNS ARE MAINTAINED AS THE
C     ENTRIES  1,...,NACT  OF THE ARRAY  INDX.
C
C     A SOLUTION  X  IS FOUND BY MINIMIZING A PIECEWISE
C     LINEAR PENALTY FUNCTION FORMED FROM THE  L1
C     NORM OF THE EQUATION RESIDUALS AND THE SUM OF THE
C     INFEASIBILITIES IN THE CONSTRAINTS.
C     THE MINIMIZATION PROCEEDS IN A STEP-BY-STEP
C     FASHION, TERMINATING AFTER A FINITE NUMBER OF STEPS.
C
C     NOTE THAT  A, G  AND  C  APPEAR TRANSPOSED IN THE
C     PROBLEM FORMULATION.  HENCE IT IS THE COLUMNS OF  (A,G,C)
C     WHICH DEFINE THE EQUATIONS AND CONSTRAINTS RESPECTIVELY.
C
C     THE ARRAY  E  IS A COMPOSITE OF   A, G AND C
C     AND  F  IS A COMPOSITE OF  B, H  AND  D.
C     E  SHOULD CONTAIN  A  AS ITS FIRST  NEQNS  COLUMNS.
C     IT SHOULD CONTAIN  G  AS ITS NEXT  NEQC  COLUMNS AND
C     CONTAIN  C  AS ITS REMAINING  NIQC  COLUMNS.
C     SIMILARLY  F  SHOULD CONTAIN  B  AS ITS FIRST
C     NEQNS  COMPONENTS,  H  AS ITS NEXT  NEQC  COMPONENTS
C     AND  D  AS ITS LAST  NIQC  COMPONENTS.
C     ----------------------------------------------------------
C
C     +++++ ARRAYS +++++
C     ----------------------------------------------------------
C     E  IS TO BE DIMENSIONED AT LEAST    N  BY  M,
C     X                       AT LEAST    N,
C     F                       AT LEAST    M,
C     RES                     AT LEAST    M,
C     INDX                    AT LEAST    M,
C     W                       AT LEAST    ((3*N*N+11*N+2)/2) + (2*M).
C
C                                         WHERE  N = NVARS  AND
C                                         M = NEQNS+NEQC+NIQC
C     ----------------------------------------------------------
C
C     +++++ INITIALIZATION +++++
C     ----------------------------------------------------------
C     THE USER MUST INITIALIZE
C
C          NEQNS,NEQC,NIQC,NVARS,MXS,PSW,E,NER,X,F .
C
C     THE FOLLOWING ARE SET BY  CL1
C     AND DO NOT REQUIRE INITIALIZATION
C
C          NACT,INDX,RES .
C
C     THE ARRAY  W  IS USED AS SCRATCH SPACE.
C     ----------------------------------------------------------
C
C     +++++ TERMINATION CODES AND INTERMEDIATE PRINTING +++++
C     ----------------------------------------------------------
C     MXS  SETS A LIMIT ON THE NUMBER OF MINIMIZATION STEPS TO BE
C     TAKEN.
C
C     UPON TERMINATION  IFL  WILL BE SET ACCORDING TO
C     THE FOLLOWING CODE ...
C
C             IFL = 1 .... SUCCESSFUL TERMINATION.
C
C             IFL = 2 .... UNSUCCESSFUL TERMINATION.
C                          CONSTRAINTS CANNOT BE SATISFIED.
C                          PROBLEM IS INFEASIBLE.
C
C             IFL = 3 .... LIMIT IMPOSED BY  MXS  REACHED
C                          WITHOUT FINDING A SOLUTION.
C
C             IFL = 4 .... PROGRAM ABORTED.
C                          NUMERICAL DIFFICULTIES
C                          DUE TO ILL-CONDITIONING.
C
C             IFL = 5 .... NEQNS, NVARS, NEQC AND/OR
C                          NIQC  HAVE IMPROPER VALUES
C                          OR  E  CONTAINS A ZERO COLUMN.
C
C     IN ALL CASES THE OUTPUT PARAMETERS  X,EL1N AND RES
C     WILL CONTAIN THE VALUES WHICH THEY REACHED AT TERMINATION.
C
C     INTERMEDIATE PRINTING WILL BE TURNED OFF IF  PSW = .FALSE. .
C     ON THE OTHER HAND,  DETAILS OF EACH MINIMIZATION CYCLE
C     WILL BE PRINTED IF  PSW  IS SET TO  .TRUE.
C     ----------------------------------------------------------
C
C     +++++ REMARKS AND USER CAUTIONS +++++
C     ----------------------------------------------------------
C       1.  BEYOND SOME PRECAUTIONARY STEPS TAKEN IN
C           CERTAIN DIVISIONS, NO SPECIAL
C           OVERFLOW/UNDERFLOW PROTECTION IS PROVIDED.
C       2.  ALL TOLERANCES FOR CHECKING ZEROS AND LINEAR
C           DEPENDENCIES ARE DETERMINED FROM THE QUANTITY
C           EPS  WHICH APPEARS IN DATA DECLARATIONS IN  CL1
C           AND SEVERAL OF ITS SUBROUTINES.   EPS  CAN BE SET TO THE
C           LEAST POSITIVE NUMBER SATISFYING  (1.0 + EPS) .GT. 1.0
C           IN THE PRECISION OF ARITHMETIC BEING USED.  WITH THIS
C           SETTING,  CL1  USES AN EXTREMELY STRICT ZERO TOLERANCE.
C           FOR A MORE FORGIVING VERSION OF  CL1,  EPS MAY BE REMOVED
C           FROM THE DATA DEFINITIONS AND INCLUDED AS A USER-SPECIFIED
C           ZERO-TESTING PARAMETER IN THE ARGUMENT LIST.  IN SUCH AN
C           EVENT, IF THE PROBLEM DATA IS GIVEN TO  NDIG  SIGNIFICANT
C           DIGITS, THEN  10.0**(-NDIG)  IS A REASONABLE CHOICE
C           FOR THE VALUE OF  EPS.
C           OVERFLOW CHECKING PRIOR TO DIVISION IS
C           DONE USING THE QUANTITY  BIG,  ALSO SPECIFIED AS DATA.
C           BIG  SHOULD BE THE LARGEST REPRESENTABLE FLOATING
C           POINT NUMBER.
C       3.  THIS IS A SINGLE PRECISION VERSION OF  CL1.
C           TO CHANGE THIS CODE INTO DOUBLE PRECISION ...
C           A.  CHANGE ALL OCCURRENCES OF  - REAL -
C               DECLARATIONS TO  - DOUBLE PRECISION -
C           B.  CHANGE ALL OCCURRENCES OF  - SYSTEM ROUTINES -
C               (AS LISTED IN THE HEADING OF EACH SUBROUTINE)
C               TO THEIR CORRESPONDING DOUBLE PRECISION VERSIONS
C           C.  CHANGE ALL OCCURRENCES OF THE STRINGS  E+  AND  E-
C               TO  D+  AND  D-  RESPECTIVELY
C           D.  CHANGE ALL BASIC LINEAR ALGEBRA ROUTINES  (BLAS)
C               TO THEIR DOUBLE-PRECISION EQUIVALENTS
C           E.  BOTH  EPS  AND  BIG  WILL HAVE TO BE CHANGED
C               TO THEIR DOUBLE PRECISION EQUIVALENTS
C           F.  THE REFERENCES TO  - IFIX -  IN SUBROUTINES
C               - RESID -  AND  - GETV -  MUST BE CHANGED
C               FROM THE FORM
C                    IFIX(FLOAT(K)*UNIF(...))
C               TO THE FORM
C                    IFIX(FLOAT(K)*SNGL(UNIF(...)))
C           G.  THE REFERENCE TO  - FLOAT -  IN SUBROUTINE
C               - RESID -  MUST BE CHANGED FROM THE FORM
C                    FLOAT(...)
C               TO THE FORM
C                    DBLE(FLOAT(...))
C           H.  REMOVE THESE COMMENT CARDS  (3., 3.A.-3.H.).
C     ----------------------------------------------------------
C
C     +++++ PORTABILITY NOTE +++++
C     ----------------------------------------------------------
C     THE INTRINSIC FORTRAN FUNCTIONS WHICH HAVE BEEN USED
C     ARE NOT DECLARED IN TYPE STATEMENTS IN  CL1  OR ANY
C     OF ITS SUBROUTINES.  A VERY FEW FORTRAN COMPILERS DO
C     REQUIRE SUCH TYPING, AND THEY WILL FAIL QUITE EXPLICITLY
C     BECAUSE OF OUR OMISSION.  ON THE OTHER HAND, SOME FEW
C     OTHER FORTRAN COMPILERS DO NOT EXPECT SUCH TYPING, AND
C     THEIR MODE OF FAILURE IS MORE SUBTILE.  THESE COMPILERS
C     MAY ATTACH THE NAMES OF THE INTRINSIC FUNCTIONS TO THE
C     LIST OF SUBROUTINES TO BE OBTAINED FROM EXTERNAL SOURCES,
C     CAUSING A FAULT IN LIBRARY SEARCHING DURING PRE-EXECUTION
C     LOADING.   SINCE THERE IS NO WAY TO WIN THE GAME, WE
C     HAVE OPTED TO LOSE IT, IN THOSE FEW CASES WHERE WE MUST,
C     IN THE MOST IMMEDIATE AND OBVIOUS FASHION.
C     NOTE -- INTRINSIC FUNCTIONS ARE LISTED AMONG THE
C                  - SYSTEM ROUTINES -
C              AT THE START OF EACH SUBPROGRAM.
C
C     THE QUANTITIES  EPS  AND  BIG  WHICH ARE TO BE FOUND
C     IN DATA STATEMENTS ARE MACHINE DEPENDENT.  SEE  2.  UNDER
C     + REMARKS AND USER CAUTIONS +.
C
C     MANY OF THE COMPUTATIONS IN THIS PROGRAM ARE
C     DEFINED IN TERMS OF THE  BASIC LINEAR ALGEBRA
C     SUBROUTINES  (BLAS).  REFER TO THE APPENDIX
C     OF THIS CODE FOR FURTHER INFORMATION.
C     **********************************************************
C
      INTEGER DDX,GRDX,ICYC,IADDC,IDELC
      INTEGER PX,PTEX,RRX,TOPX,ZZX
      DOUBLE PRECISION ALPHA,AMAG,CGMAG,PEN,PENPAR
C*****EXTERNAL SETUP, NEWPEN, UPDATE, MONIT, FINDP, STEP
      EXTERNAL CL1A, CL1B, CL1C, CL1D, CL1E, CL1F
C
C     ////////////////  BEGIN PROGRAM  /////////////////////////
C
C*****CALL SETUP
      CALL CL1A
     *                    (NEQNS,NEQC,NIQC,NVARS,DDX,GRDX,PX,PTEX,RRX,
     *                     TOPX,ZZX,ICYC,IFL,E,NER,AMAG,CGMAG,PENPAR)
C
C
   10   CONTINUE
C
C*********CALL NEWPEN
          CALL CL1B
     *                    (IADDC,IDELC,NACT,NEQNS,NEQC,
     *                     NIQC,NVARS,IFL,E,NER,X,F,RES,
     *                     W(PTEX),ALPHA,PENPAR,INDX)
C
   20     CONTINUE
C
C***********CALL UPDATE
            CALL CL1C
     *                    (IADDC,IDELC,NACT,NEQNS,NEQC,NIQC,NVARS,
     *                     ICYC,IFL,MXS,E,NER,X,F,RES,
     *                     W(GRDX),EL1N,PEN,PENPAR,
     *                     INDX,W(ZZX),NVARS,W(DDX),W(RRX),
     *                     W(TOPX))
C***********CALL MONIT
            CALL CL1D
     *                    (NACT,NEQC,NIQC,NVARS,ICYC,PSW,X,
     *                     ALPHA,EL1N,PEN,PENPAR,INDX)
C***********CALL FINDP
            CALL CL1E
     *                    (IDELC,NACT,NEQNS,NEQC,NIQC,NVARS,IFL,E,NER,
     *                     X,F,RES,W(GRDX),W(PX),EL1N,AMAG,CGMAG,
     *                     PENPAR,INDX,W(ZZX),NVARS,W(DDX),
     *                     W(RRX),W(TOPX))
C***********CALL STEP
            CALL CL1F
     *                    (IADDC,NACT,NEQNS,NEQC,NIQC,NVARS,IFL,E,NER,
     *                     X,RES,W(GRDX),W(PX),W(PTEX),ALPHA,PENPAR,
     *                     INDX,W(TOPX))
C
            IF (IFL .EQ. 0)  GO TO 20
C
          IF (IFL .EQ. 2
     *           .AND. (CGMAG + PENPAR*AMAG) .NE. CGMAG)  GO TO 10
C
      RETURN
      END
C
C
