C
C Double precision version by W.G.B 18/9/97
C =========================================
C
C 13/11/98 Changed all dimensions A(1) to A(*)
C ============================================
C
C     ---------------
C     SECOND LEVEL SUBROUTINES --
C          SETUP,NEWPEN,UPDATE,MONIT,FINDP,STEP,REFINE
C     ---------------
C
C*****SUBROUTINE SETUP
      SUBROUTINE CL1A
     *                    (NEQNS,NEQC,NIQC,NVARS,DDX,GRDX,PX,PTEX,RRX,
     *                     TOPX,ZZX,ICYC,IFL,E,NER,AMAG,CGMAG,PENPAR)
C
      IMPLICIT NONE
      INTEGER  DDX,GRDX,ICYC,IFL,NEQC,NEQNS,NER
      INTEGER  NIQC,NVARS,PX,PTEX,RRX,TOPX,ZZX
      DOUBLE PRECISION AMAG,CGMAG,E(NER,*),PENPAR
C
C     ***************
C     CL1  VERSION.
C
C     SET UP THE PROGRAM
C     PARAMETERS AND INDICES.
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS
C     +++++++++++++++
C
      INTEGER I,J,NCOLS,NQNP1
      DOUBLE PRECISION OCT,TMP,ZERO
      INTRINSIC ABS
C
      DATA OCT /8.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C     ***************
C     CHECK VALIDITY OF PROBLEM DIMENSIONS
C     ***************
C
      NCOLS = NEQNS + NEQC + NIQC
      IF (NVARS .GE. 1
     *       .AND. NEQC .GE. 0
     *        .AND. NIQC .GE. 0
     *         .AND. NEQNS .GE. 0
     *          .AND. NCOLS .GE. NVARS
     *           .AND. NER .GE. NVARS)  GO TO 10
        IFL = 5
        GO TO 100
   10 CONTINUE
C
C     ***************
C     SET UP INDICES FOR THE TEMPORARY STORAGE VECTOR  W.
C     ***************
C
      NQNP1 = NEQNS + 1
      GRDX = 1
      PX = GRDX + NVARS
      PTEX = PX + NVARS
      DDX = PTEX + NCOLS
      RRX = DDX + NVARS
      ZZX = RRX + (((NVARS + 1)*(NVARS + 2))/2)
      TOPX = ZZX + NVARS*NVARS
C
C     ***************
C     AMAG  IS A ROUGH ESTIMATE OF THE NORM OF  A.
C     CGMAG  IS A ROUGH ESTIMATE OF THE NORM OF  (G,C).
C     TOGETHER THEY ARE USED TO DETERMINE WHEN THE
C     PENALTY PARAMETER IS TOO SMALL AND WHEN THE
C     RESTRICTED GRADIENT IS ZERO.
C     ***************
C
      AMAG = ZERO
      CGMAG = ZERO
      IF (1 .GT. NEQNS)  GO TO 50
        DO 40 J=1,NEQNS
          TMP = ZERO
          DO 20 I=1,NVARS
            TMP = TMP + ABS(E(I,J))
  20     CONTINUE
          IF (TMP .GT. ZERO)  GO TO 30
            IFL = 5
            GO TO 100
   30     CONTINUE
          IF (TMP .GT. AMAG)  AMAG = TMP
   40   CONTINUE
   50 CONTINUE
      IF (NQNP1 .GT. NCOLS)  GO TO 90
        DO 80 J=NQNP1,NCOLS
          TMP = ZERO
          DO 60 I=1,NVARS
            TMP = TMP + ABS(E(I,J))
  60     CONTINUE
          IF (TMP .GT. ZERO)  GO TO 70
            IFL = 5
            GO TO 100
   70     CONTINUE
          IF (TMP .GT. CGMAG)  CGMAG = TMP
   80   CONTINUE
   90 CONTINUE
C
C     ***************
C     INITIALIZE  IFL,ICYC,PENPAR
C     ***************
C
      IFL = 2
      ICYC = -1
      PENPAR = OCT
  100 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE NEWPEN
      SUBROUTINE CL1B
     *                    (IADDC,IDELC,NACT,NEQNS,NEQC,NIQC,
     *                     NVARS,IFL,E,NER,X,F,RES,PTE,
     *                     ALPHA,PENPAR,INDX)
C
      IMPLICIT NONE
      INTEGER  IADDC,IDELC,IFL,INDX(*),NACT
      INTEGER  NEQC,NEQNS,NER,NIQC,NVARS
      DOUBLE PRECISION ALPHA,E(NER,*),F(*),PENPAR,PTE(*),RES(*),X(*)
C
C     ***************
C     CL1  VERSION.
C
C     BEGIN A ROUND OF MINIMIZATION STEPS
C     WITH A NEW PENALTY PARAMETER VALUE.
C     ***************
C
C     +++++++++++++++
C     BLAS  SDOT
C     +++++++++++++++
C
      INTEGER I,NCOLS
      DOUBLE PRECISION OCT,ZERO
C
      DOUBLE PRECISION DDOT
      EXTERNAL DDOT
C
      DATA ZERO /0.0D+00/
      DATA OCT /8.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C     ***************
C     SET PENALTY PARAMETER VALUE.
C     ERASE RECORD OF ACTIVE EQUATION/CONSTRAINTS.
C     ***************
C
      IF (IFL .NE. 2)  GO TO 20
        NCOLS = NEQNS + NEQC + NIQC
        IFL = 0
        NACT = 0
        IADDC = 0
        IDELC = 0
        ALPHA = ZERO
        PENPAR = PENPAR/OCT
C
C     ***************
C     INITIALIZE  INDX,RES,PTE,INDX
C     ***************
C
        DO 10 I=1,NCOLS
          RES(I) = DDOT(NVARS,E(1,I),1,X,1) - F(I)
          PTE(I) = ZERO
          INDX(I) = I
   10   CONTINUE
   20 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE UPDATE
      SUBROUTINE CL1C
     *                     (IADDC,IDELC,NACT,NEQNS,NEQC,NIQC,NVARS,
     *                     ICYC,IFL,MXS,E,NER,X,F,RES,GRD,
     *                     EL1N,PEN,PENPAR,INDX,ZZ,
     *                     NZZR,DD,RR,W)
C
      IMPLICIT NONE
      INTEGER  IADDC,IDELC,ICYC,IFL,INDX(*),MXS
      INTEGER  NACT,NEQC,NEQNS,NER,NIQC,NVARS,NZZR
      DOUBLE PRECISION DD(*),E(NER,*),EL1N,F(*),GRD(*),PEN,PENPAR
      DOUBLE PRECISION RES(*),RR(*),W(*),X(*),ZZ(NZZR,*)
C
C     ***************
C     CL1  VERSION.
C
C     PREPARATION FOR NEXT MINIMIZATION STEP.
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS
C     +++++++++++++++
C
      INTEGER NALLQ,NCOLS
C*****EXTERNAL DELCOL, RESID, ADDCOL, OBJECT
      EXTERNAL CL1H  , CL1I , CL1J  , CL1K
      INTRINSIC ABS
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C     ***************
C     DETERMINE THE ACTIVE EQUATIONS AND ACTIVE
C     CONSTRAINTS.  COMPUTE RESIDUALS AND FUNCTION VALUE.
C     UPDATE THE  Z*D*R  DECOMPOSITION.
C     ***************
C
      NALLQ = NEQNS + NEQC
      NCOLS = NALLQ + NIQC
      IF (IFL .NE. 0)  GO TO 20
        ICYC = ICYC + 1
        IF (ICYC .LE. MXS)  GO TO 10
          IFL = 3
          GO TO 20
   10   CONTINUE
          CALL CL1H  (IADDC,IDELC,NACT,NVARS,ZZ,NZZR,DD,RR,INDX)
          CALL CL1I (IADDC,NACT,NCOLS,NVARS,E,NER,X,F,RES,INDX)
          CALL CL1J  (IADDC,IDELC,NACT,NVARS,ZZ,NZZR,DD,RR,
     *                E,NER,INDX,W)
          CALL CL1K  (IADDC,NACT,NEQNS,NALLQ,NCOLS,NVARS,E,NER,
     *                RES,GRD,EL1N,PEN,PENPAR,INDX)
   20 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE MONIT
      SUBROUTINE CL1D
     *                    (NACT,NEQC,NIQC,NVARS,ICYC,PSW,X,
     *                     ALPHA,EL1N,PEN,PENPAR,INDX)
C
      IMPLICIT NONE
      INTEGER  ICYC,INDX(*),NACT,NEQC,NIQC,NVARS
      LOGICAL  PSW
      DOUBLE PRECISION ALPHA,EL1N,PEN,PENPAR,X(*)
C
C     ***************
C     CL1  VERSION.
C
C     PRINT OUT INFORMATION AT
C     EACH STEP IF  PSW = .TRUE.
C
C     TO CHANGE THE OUTPUT MEDIUM,
C     CHANGE THE  DATA  DECLARATION
C     APPEARING BELOW.
C     ***************
C
      INTEGER I,NXOUTP
C
      DATA NXOUTP /6/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      IF (.NOT. PSW)  GO TO 20
        WRITE (NXOUTP,6000) ICYC,ALPHA
        WRITE (NXOUTP,6010) (X(I),I=1,NVARS)
        WRITE (NXOUTP,6020)  NACT
        IF (NACT .LE. 0)  GO TO 10
          WRITE (NXOUTP,6030)
          WRITE (NXOUTP,6040) (INDX(I),I=1,NACT)
   10   CONTINUE
        WRITE (NXOUTP,6050) EL1N
        IF (NEQC + NIQC .GT. 0)  WRITE (NXOUTP,6060) PENPAR,PEN
   20 CONTINUE
      RETURN
C
 6000 FORMAT(20H0***** CYCLE NUMBER ,I5/
     *       6X,13HSTEP TAKEN = ,1PE15.7/
     *       6X,11HX-VECTOR...)
 6010 FORMAT(5X,3(1PE15.7))
 6020 FORMAT(6X,38HNUMBER OF ACTIVE EQUATIONS/CONSTRAINTS,I5)
 6030 FORMAT(6X,31HACTIVE EQUATIONS/CONSTRAINTS...)
 6040 FORMAT(5X,7I5)
 6050 FORMAT(6X,19HRESIDUAL L1 NORM = ,1PE15.7)
 6060 FORMAT(6X,20HPENALTY PARAMETER = ,1PE10.2/
     *       6X,25HPENALTY FUNCTION VALUE = ,1PE15.7)
      END
C
C
C*****SUBROUTINE FINDP
      SUBROUTINE CL1E
     *                    (IDELC,NACT,NEQNS,NEQC,NIQC,NVARS,IFL,
     *                     E,NER,X,F,RES,GRD,P,EL1N,AMAG,CGMAG,
     *                     PENPAR,INDX,ZZ,NZZR,DD,RR,W)
C
      IMPLICIT NONE
      INTEGER  IDELC,IFL,INDX(*),NACT,NEQC,NEQNS,NER,NIQC,NVARS,NZZR
      DOUBLE PRECISION AMAG,CGMAG,DD(*),E(NER,*),EL1N,F(*),GRD(*),P(*),
     +                 PENPAR
      DOUBLE PRECISION RES(*),RR(*),W(*),X(*),ZZ(NZZR,*)
C
C     ***************
C     CL1  VERSION.
C
C     DETERMINE DESCENT DIRECTION  P
C     (OR DISCOVER OPTIMALITY)
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS
C
C     BLAS  SASUM,SCOPY,SSCAL
C
C     EPS  IS THE SMALLEST POSITIVE NUMBER WHICH
C     SATISFIES   (1.0 + EPS) .GT. 1.0   IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     (ALTERNATIVELY, FOR LESS STRICT ZERO CHECKING,
C      EPS  CAN BE SET TO A USER-SPECIFIED TOLERANCE.)
C     +++++++++++++++
C
C*****INTEGER COEFX,I,IX,NALLQ,NALQP1,NCOLS,NQNP1,TOPX
      INTEGER COEFX,I,IX,NALLQ,       NCOLS,NQNP1,TOPX
      LOGICAL FAIL
C*****DOUBLE PRECISION EPS,GRDNRM,ONE,PNRM,PROD,TEST,ZERO
      DOUBLE PRECISION EPS,       ONE,PNRM,PROD,TEST,ZERO
C
      DOUBLE PRECISION DASUM
C
C     +++++++++++++++
C     THE FOLLOWING DECLARATIONS ARE NECESSARY
C     FOR PORTABILITY WHEN  SCOPY  IS USED, AS
C     IT IS BELOW, TO FILL ARRAYS WITH A SINGLE VALUE
C     (ONE=UNITY  AND  ZERO=ZIP  IN THIS CASE).
C     +++++++++++++++
C
C*****DOUBLE PRECISION UNITY(1),ZIP(1)
      EXTERNAL DASUM, DSCAL
C*****EXTERNAL ZDRGNV, GETV, ZDRGIT, REFINE, ZDRPOC
      EXTERNAL ZDRGNV, CL1L, ZDRGIT, CL1G  , ZDRPOC
      INTRINSIC ABS
c
c Cannot have equivalence before data
c
C     EQUIVALENCE (ONE,UNITY(1)),(ZERO,ZIP(1))
C
      DATA EPS /1.0D-10/
      DATA ONE /1.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C
C I do not think UNITY/ZIP/DCOPY are used in this version... check later
C
C*****UNITY(1) = ONE
C*****ZIP(1) = ZERO
      IDELC = 0
      IF (IFL .NE. 0)  GO TO 90
        NALLQ = NEQNS + NEQC
C*******NALQP1 = NALLQ + 1
        NCOLS = NALLQ + NIQC
        NQNP1 = NEQNS + 1
        COEFX = 1
        TOPX = COEFX + NVARS
C
C     ***************
C     PROJECT THE NEGATIVE OF THE RESTRICTED GRADIENT
C     ONTO THE ORTHOGONAL COMPLEMENT OF THE SPACE
C     SPANNED BY THE ACTIVE COLUMNS.
C     ***************
C
        CALL ZDRPOC(NVARS,NACT,ZZ,NZZR,DD,GRD,P,FAIL)
        IF (.NOT.FAIL)  GO TO 5
          IFL = 4
          GO TO 90
    5   CONTINUE
        CALL DSCAL(NVARS,-ONE,P,1)
        PNRM = DASUM(NVARS,P,1)
C*******GRDNRM = DASUM(NVARS,GRD,1)
C
C     ***************
C     IF THE PROJECTION IS NOT ZERO,
C     IT WILL SERVE AS A DESCENT DIRECTION.
C
C     OTHERWISE FIND THE REPRESENTATION OF
C     THE RESTRICTED GRADIENT AS A LINEAR
C     COMBINATION OF THE ACTIVE COLUMNS.
C     THE COEFFICIENTS OF THE LINEAR COMBINATION
C     ARE TO BE STORED IN THE ARRAY  COEF
C     (THAT IS, IN  W(COEFX),...,W(COEFX+NACT-1)).
C     ***************
C
        IF (PNRM .GT. EPS*(AMAG*PENPAR + CGMAG))  GO TO 90
        IF (NACT .EQ. 0)  GO TO 50
          CALL ZDRGNV(NVARS,NACT,ZZ,NZZR,RR,GRD,W(COEFX),FAIL)
          IF (.NOT. FAIL)  GO TO 10
            IFL = 4
            GO TO 90
   10     CONTINUE
C
C     ***************
C     CONVERT THE COEFFICIENTS OF THE LINEAR
C     COMBINATION INTO A DESCENT DIRECTION  P ,
C     OR DETERMINE OPTIMALITY.
C
C     IF THE OPTIMALITY TEST IS NOT SATISFIED,
C     GETV  WILL INDICATE AN EQUATION/CONSTRAINT
C     TO BE DELETED FROM ACTIVITY BY THE VALUE
C     OF  IDELC.  FOR OPTIMALITY,  IDELC=0.
C     ***************
C
          CALL CL1L(IDELC,NACT,NVARS,NEQNS,NALLQ,E,NER,GRD,
     *              W(COEFX),PENPAR,INDX)
          PNRM = ZERO
          IF (IDELC .EQ. 0)  GO TO 20
            CALL ZDRGIT(NVARS,NACT,ZZ,NZZR,RR,W(COEFX),P,FAIL,W(TOPX))
            IF (.NOT. FAIL)  PNRM = DASUM(NVARS,P,1)
            IF (.NOT. FAIL)  GO TO 20
              IFL = 4
              GO TO 90
   20   CONTINUE
C
C     ***************
C     IF A DESCENT DIRECTION  P  COULD HAVE BEEN FOUND,
C     IT HAS BEEN OBTAINED BY THIS POINT IN THE PROGRAM.
C
C     CHECK FOR OPTIMALITY.
C
C     PNRM  HAS BEEN SET EXACTLY ZERO
C     AFTER THE CALL TO SUBROUTINE  GETV
C     IF THE OPTIMALITY CONDITIONS ARE SATISFIED.
C     THE CHECK BELOW HAS BEEN MADE SOMEWHAT
C     COMPLICATED TO ALLOW FOR THE RARE EVENT THAT
C     THE RESTRICTED GRADIENT IS ZERO AND NO
C     COLUMNS ARE ACTIVE,  OR THAT THE  L1  NORM OF
C               (A-TRANSPOSE) * X - F
C     IS COMPUTATIONALLY ZERO.
C     (THE CALL TO THE SUBROUTINE  REFINE
C      MAY BE OMITTED, IF DESIRED.)
C     ***************
C
        IF (PNRM .LE. EPS*(AMAG*PENPAR + CGMAG))  GO TO 50
        DO 40 I=1,NEQNS
          TEST = ABS(F(I))
          DO 30 IX=1,NVARS
            PROD = ABS(E(IX,I)*X(IX))
            IF (PROD .GT. TEST)  TEST = PROD
   30     CONTINUE
          IF (ABS(RES(I)) .GT. EPS*TEST)  GO TO 90
   40   CONTINUE
   50   CONTINUE
          IFL = 1
          CALL CL1G  (NACT,NEQNS,NCOLS,NVARS,IFL,E,NER,
     *                X,F,EL1N,RES,INDX,ZZ,NZZR,RR,W)
          IF (IFL .NE. 1)  GO TO 90
C
C     ***************
C     IF THE PROBLEM HAS CONSTRAINTS,
C     CHECK FEASIBILITY.
C     ***************
C
          IF (NQNP1 .GT. NCOLS)  GO TO 90
            DO 80 I=NQNP1,NCOLS
              TEST = ABS(F(I))
              DO 60 IX=1,NVARS
                PROD = ABS(E(IX,I)*X(IX))
                IF (PROD .GT. TEST)  TEST = PROD
   60         CONTINUE
              TEST = EPS*TEST
              IF (I .GT. NALLQ)  GO TO 70
                IF (ABS(RES(I)) .LE. TEST)  GO TO 80
                  IFL = 2
                  GO TO 90
   70         CONTINUE
                IF (RES(I) .GE. (-TEST))  GO TO 80
                  IFL = 2
                  GO TO 90
   80       CONTINUE
   90 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE STEP
      SUBROUTINE CL1F
     *                   (IADDC,NACT,NEQNS,NEQC,NIQC,NVARS,IFL,
     *                    E,NER,X,RES,GRD,P,PTE,ALPHA,PENPAR,INDX,ALF)
C
      IMPLICIT NONE
      INTEGER  IADDC,IFL,INDX(*),NACT,NEQC,NEQNS,NER,NIQC,NVARS
      DOUBLE PRECISION ALPHA,ALF(*),E(NER,*),GRD(*),P(*)
      DOUBLE PRECISION PENPAR,PTE(*),RES(*),X(*)
C
C     ***************
C     CL1  VERSION.
C
C     PIECEWISE LINEAR LINE SEARCH.
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES ABS,SIGN
C
C     BLAS  SASUM,SAXPY,SDOT
C
C     EPS  IS THE SMALLEST POSITIVE NUMBER WHICH
C     SATISFIES   (1.0 + EPS) .GT. 1.0   IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     (ALTERNATIVELY, FOR LESS STRICT ZERO CHECKING,
C      EPS  CAN BE SET TO A USER-SPECIFIED TOLERANCE.)
C
C     BIG  IS THE LARGEST POSITIVE NUMBER
C     WHICH CAN BE REPRESENTED IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     +++++++++++++++
C
      INTEGER I,IIN,IX,JX,NACTP1,NALLQ,NCOLS,NUM,NUMNAC
      DOUBLE PRECISION BIG,DEN,EPS,GRDNRM,ONE,PNRM,PTG
      DOUBLE PRECISION RATIO,RESID,TMP,TWO,ZERO
C
      DOUBLE PRECISION DASUM,DDOT
      EXTERNAL DASUM, DAXPY, DDOT
      EXTERNAL DKHEAP
      INTRINSIC ABS, SIGN
C
      DATA BIG /1.0D300/
      DATA EPS /1.0D-10/
      DATA ONE /1.0D+00/
      DATA TWO /2.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C     ***************
C     THIS ROUTINE DETERMINES ALL OF THE RATIOS  ALF
C     OF THE FORM
C        -RES(I)/((E(.,I)-TRANSP)*P),
C              FOR  I = K+1,...,MPL
C     WHICH ARE NONNEGATIVE AND HENCE INDICATE DISTANCES
C     FROM THE POINT  X  TO BREAKPOINTS WHICH WILL
C     BE ENCOUNTERED IN TRAVEL ALONG DIRECTION  P.
C     THE INDEX VECTOR  INDX  IS REARRANGED SO THAT
C     ITS  K+1  THROUGH  NUM  COMPONENTS CORRESPOND TO
C     THESE NONNEGATIVE RATIOS.
C     THE RESULTS ARE HEAPED SO THAT THE  ALF  VALUES CAN
C     BE INSPECTED IN ORDER FROM SMALLEST TO LARGEST.
C     THE BREAKPOINT  ALPHA  GIVING THE MINIMUM OBJECTIVE
C     FUNCTION VALUE IS FOUND, AND  X  IS
C     ADJUSTED TO  X + ALPHA*P .
C
C     THE INNER PRODUCTS  (E(.,I)-TRANSPOSE)*P  ARE SAVED
C     FOR LATER USE IN UPDATING THE RESIDUAL VALUES.
C     ***************
C
      ALPHA = ZERO
      IF (IFL .NE. 0)  GO TO 90
        NALLQ = NEQNS + NEQC
        NCOLS = NALLQ + NIQC
        NACTP1 = NACT + 1
        NUM = 0
        IF (1 .GT. NACT)  GO TO 20
          DO 10 I=1,NACT
            IX = INDX(I)
            PTE(IX) = DDOT(NVARS,E(1,IX),1,P,1)
   10     CONTINUE
   20   CONTINUE
        IF (NACTP1 .LE. NCOLS)  GO TO 30
          IFL = 1
          GO TO 90
   30   CONTINUE
          DO 50 I=NACTP1,NCOLS
            IX = INDX(I)
            RESID = RES(IX)
            DEN = DDOT(NVARS,E(1,IX),1,P,1)
            PTE(IX) = DEN
            IF (SIGN(ONE,RESID) .EQ. SIGN(ONE,DEN)
     *                    .AND. RESID .NE. ZERO)  GO TO 50
              RESID = ABS(RESID)
              DEN = ABS(DEN)
              IF (DEN .GE. ONE)  GO TO 40
                IF (RESID .GE. DEN*BIG)  GO TO 50
   40         CONTINUE
                RATIO = RESID/DEN
                NUM = NUM + 1
                NUMNAC = NUM + NACT
                JX = INDX(NUMNAC)
                INDX(NUMNAC) = IX
                INDX(I) = JX
                ALF(NUM) = RATIO
   50     CONTINUE
          IF (NUM .GT. 0)  GO TO 60
            IFL = 2
            GO TO 90
   60     CONTINUE
C
C     ***************
C     HEAP THE POSITIVE RATIOS
C     ***************
C
            CALL DKHEAP(.TRUE.,NUM,INDX(NACTP1),ALF)
C
C     ***************
C     TRAVEL ALONG  P  UNTIL NO FURTHER DECREASE IN THE
C     PENALTY FUNCTION IS POSSIBLE
C     ***************
C
            IIN = NUM
            PTG = DDOT(NVARS,GRD,1,P,1)
            PNRM = DASUM(NVARS,P,1)
            GRDNRM = DASUM(NVARS,GRD,1)
            DO 70 I=1,NUM
              IX = INDX(NACTP1)
              TMP = -SIGN(ONE,RES(IX))
              IF (IX .LE. NALLQ)  TMP = TMP*TWO
              IF (IX .LE. NEQNS)  TMP = TMP*PENPAR
              PTG = PTG + TMP*PTE(IX)
              IF (PTG .GE. (-EPS*GRDNRM*PNRM))  GO TO 80
                CALL DKHEAP(.FALSE.,IIN,INDX(NACTP1),ALF)
   70       CONTINUE
            IFL = 2
            GO TO 90
   80       CONTINUE
            IADDC = NACTP1
C
C     ***************
C     ADJUST  X  TO  X + ALPHA*P
C     ***************
C
            ALPHA = ALF(1)
            CALL DAXPY(NVARS,ALPHA,P,1,X,1)
   90 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE REFINE(NACT,NEQNS,NCOLS,NVARS,IFL,E,NER,
      SUBROUTINE CL1G  (NACT,NEQNS,NCOLS,NVARS,IFL,E,NER,
     *                  X,F,EL1N,RES,INDX,ZZ,NZZR,RR,W)
C
      IMPLICIT NONE
      INTEGER  IFL,INDX(*),NACT,NCOLS,NEQNS,NER,NVARS,NZZR
      DOUBLE PRECISION E(NER,*),EL1N,F(*),RES(*),RR(*),W(*),X(*),
     +                 ZZ(NZZR,*)
C
C     ***************
C     A ROUTINE FOR REFINING THE SOLUTION
C     PRODUCED BY  CL1.
C
C     (THIS ROUTINE MAY BE OMITTED IF DESIRED.)
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS
C
C     BLAS  SDOT
C     +++++++++++++++
C
      INTEGER I,IX
      LOGICAL FAIL
      DOUBLE PRECISION TMP,ZERO
C
      DOUBLE PRECISION DDOT
      EXTERNAL DDOT
      EXTERNAL ZDRGIT
      INTRINSIC ABS
C
      DATA ZERO /0.0D+00/
C
C     /////////////// BEGIN PROGRAM ///////////////
C
      IF (NACT .EQ. 0)  GO TO 40
        DO 10 I=1,NACT
          IX = INDX(I)
          RES(I) = F(IX)
   10   CONTINUE
        CALL ZDRGIT(NVARS,NACT,ZZ,NZZR,RR,RES,X,FAIL,W)
        IF (.NOT. FAIL)  GO TO 20
          IFL = 4
          GO TO 40
   20   CONTINUE
        EL1N = ZERO
        DO 30 I=1,NCOLS
          TMP = DDOT(NVARS,E(1,I),1,X,1) - F(I)
          RES(I) = TMP
          IF (I .LE. NEQNS)  EL1N = EL1N + ABS(TMP)
   30   CONTINUE
   40 CONTINUE
      RETURN
      END
C
C
