C
C 13/11/98 Changed all dimensions A(1) to A(*)
C ============================================
C
C     ---------------
C     THIRD LEVEL SUBROUTINES --
C          DELCOL,RESID,ADDCOL,OBJECT,GETV
C     ---------------
C
C*****SUBROUTINE DELCOL(IADDC,IDELC,NACT,NROW,ZZ,NZZR,DD,RR,INDX)
      SUBROUTINE CL1H  (IADDC,IDELC,NACT,NROW,ZZ,NZZR,DD,RR,INDX)
C
      IMPLICIT NONE
      INTEGER  INDX(*),NZZR,NACT,IDELC,IADDC,NROW
      DOUBLE PRECISION DD(*),RR(*),ZZ(NZZR,*)
C
C     ***************
C     CL1  VERSION OF  DELCOL.
C
C     THIS ROUTINE ADMINISTERS THE DELETION OF THE COLUMN
C     INDICATED BY THE VALUE OF IDELC
C     FROM AN  NROW BY NACT   Z*D*R   DECOMPOSITION.
C     NOTE THAT THE VALUE OF IDELC
C     IS THE NUMBER OF A COLUMN IN THE DECOMPOSITION
C     RATHER THAN A NUMBER WHICH REFERS TO
C     A COLUMN IN THE MATRIX  E.
C     (THE  E-COLUMN  NUMBERS CORRESPONDING TO
C     THE COLUMNS OF THE FACTORIZATION ARE TO BE
C     FOUND IN   INDX(1),...,INDX(NACT) .
C     THE CONTENTS OF   INDX(NACT+1),...,INDX(IADDC)
C     INDICATE COLUMNS OF  E  WHICH ARE SLATED FOR
C     ADDITION TO THE DECOMPOSITION.)
C     THE VECTOR  INDX   IS REARRANGED BY
C     PERMUTING THE ELEMENT WHICH CORRESPONDS TO
C     THE DELETION OUT TO THE   IADDC-TH  POSITION.
C     NACT  AND  IADDC  ARE DECREASED ACCORDINGLY.
C     ***************
C
      INTEGER I,IDLP1,IXDLC
      LOGICAL FAIL
      EXTERNAL ZDRCOU
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      IF (IDELC .EQ. 0)  GO TO 20
        IDLP1 = IDELC + 1
        IXDLC = INDX(IDELC)
        DO 10 I=IDLP1,IADDC
          INDX(I - 1) = INDX(I)
   10   CONTINUE
        INDX(IADDC) = IXDLC
        IADDC = IADDC - 1
        CALL ZDRCOU(NROW,NACT,ZZ,NZZR,DD,RR,IDELC,FAIL)
        IDELC = IXDLC
   20 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE RESID(IADDC,NACT,NCOLS,NVARS,E,NER,X,F,RES,INDX)
      SUBROUTINE CL1I (IADDC,NACT,NCOLS,NVARS,E,NER,X,F,RES,INDX)
C
      IMPLICIT NONE
      INTEGER  IADDC,INDX(*),NACT,NCOLS,NER,NVARS
      DOUBLE PRECISION E(NER,*),F(*),RES(*),X(*)
C
C
C     ***************
C     COMPUTE THE RESIDUALS
C          (E(.,IX)-TRANSP)*X - F(IX)  .
C     THE RESIDUALS ARE STORED IN THE ARRAY  RES.
C     INDX  IS REARRANGED SO THAT THE ZERO RESIDUALS
C     CORRESPOND TO  INDX(1),...,INDX(IADDC)  .
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS,IFIX,FLOAT,SQRT
C
C     BLAS  SDOT
C
C     EPS  IS THE SMALLEST POSITIVE NUMBER WHICH
C     SATISFIES   (1.0 + EPS) .GT. 1.0   IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     (ALTERNATIVELY, FOR LESS STRICT ZERO CHECKING,
C      EPS  CAN BE SET TO A USER-SPECIFIED TOLERANCE.)
C     +++++++++++++++
C
      INTEGER I,IADP1,IDUMMY,IRAND,IX,J,NACTP1
      DOUBLE PRECISION EPS,PROD,TEMP,TEST,TOL,ZERO
C
      DOUBLE PRECISION DDOT,UNIF01
      EXTERNAL UNIF01
      EXTERNAL DDOT
      INTRINSIC ABS, INT, DBLE, SQRT
C
      DATA EPS /1.0D-10/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      TOL = EPS*SQRT(DBLE(NVARS))
      NACTP1 = NACT + 1
      IF (1 .GT. IADDC)  GO TO 20
C
C     ***************
C     ZERO OUT ALL RESIDUALS KNOWN TO BE ZERO.
C     ***************
C
        DO 10 I=1,IADDC
          IX = INDX(I)
          RES(IX) = ZERO
   10   CONTINUE
   20 CONTINUE
C
C     ***************
C     COMPUTE THE REMAINING RESIDUALS.
C     DETECT ANY MORE RESIDUALS WHICH
C     ARE COMPUTATIONALLY ZERO, AND
C     SET THEM EXACTLY ZERO.  THEIR
C     ASSOCIATED INDICES ARE PERMUTED
C     SO THAT THEY ARE STORED IN
C     INDX(NACT+1),...,NACT(IADDC).
C
C     (A FAIRLY TIGHT ZERO CHECK IS USED.
C     IT IS FAR LESS EXPENSIVE IN RUNNING
C     TIME TO NEGLECT AN EXTRA ZERO
C     RESIDUAL THAN TO ACCEPT IT AND RISK
C     INVOKING THE ANTI-CYCLING
C     MECHANISMS IN THE PROGRAM.
C     THE ACCURACY OF THE SOLUTION AS
C     FINALLY DETERMINED IS NOT AFFECTED.)
C     ***************
C
      IADP1 = IADDC + 1
      IF (IADP1 .GT. NCOLS)  GO TO 50
        DO 40 I=IADP1,NCOLS
          IX = INDX(I)
          TEMP = DDOT(NVARS,E(1,IX),1,X,1) - F(IX)
          TEST = ABS(F(IX))
          DO 25 J=1,NVARS
            PROD = ABS(E(J,IX)*X(J))
            IF (PROD .GT. TEST)  TEST = PROD
   25     CONTINUE
          TEST = TOL*TEST
          IF (ABS(TEMP) .LE. TEST)  GO TO 30
            RES(IX) = TEMP
            GO TO 40
   30     CONTINUE
            IADDC = IADDC + 1
            INDX(I) = INDX(IADDC)
            INDX(IADDC) = IX
            RES(IX) = ZERO
   40   CONTINUE
   50 CONTINUE
C
C     ***************
C     IF ANY NEW ZERO RESIDUALS HAVE
C     BEEN FOUND, RANDOMIZE THEIR
C     ORDERING AS AN ANTI-CYCLING
C     DEVICE FOR  ADDCOL.
C     ***************
C
      IF (IADDC .LE. NACTP1)  GO TO 70
        DO 60 I=NACTP1,IADDC
          IRAND = I + INT(DBLE(IADDC - I + 1)*UNIF01(0,IDUMMY))
          IX = INDX(IRAND)
          INDX(IRAND) = INDX(I)
          INDX(I) = IX
   60   CONTINUE
   70 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE ADDCOL(IADDC,IDELC,NACT,NVARS,ZZ,NZZR,DD,RR,
      SUBROUTINE CL1J  (IADDC,IDELC,NACT,NVARS,ZZ,NZZR,DD,RR,
     *                  E,NER,INDX,W)
C
      IMPLICIT NONE
      INTEGER  IADDC,IDELC,INDX(*),NACT,NER,NVARS,NZZR
      DOUBLE PRECISION DD(*),E(NER,*),RR(*)
      DOUBLE PRECISION W(*),ZZ(NZZR,*)
C
C     ***************
C     CL1 VERSION OF ADDCOL.
C
C     THIS ROUTINE ADMINISTERS THE ADJUSTMENT OF THE
C     Z*D*R   DECOMPOSITION FOR ANY NEW ZERO RESIDUALS.
C     THE DATA CORRESPONDING TO THE ZERO RESIDUALS IS INDEXED
C     IN  INDX(NACT+1),...,INDX(IADDC).
C     ***************
C
C     +++++++++++++++
C     BLAS  SASUM
C
C     EPS  IS THE SMALLEST POSITIVE NUMBER WHICH
C     SATISFIES   (1.0 + EPS) .GT. 1.0   IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     (ALTERNATIVELY, FOR LESS STRICT ZERO CHECKING,
C      EPS  CAN BE SET TO A USER-SPECIFIED TOLERANCE.)
C     +++++++++++++++
C
C*****INTEGER I,ISTRT,IX,NACTP1,TOPX
      INTEGER I,ISTRT,IX,NACTP1
      LOGICAL FAIL
      DOUBLE PRECISION COLNRM,EPS,PRJNRM
C
      DOUBLE PRECISION DASUM
      EXTERNAL DASUM
      EXTERNAL ZDRPOC, ZDRCIN
C
      DATA EPS /1.0D-10/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C*****TOPX = NVARS + 1
      ISTRT = NACT + 1
      IF (ISTRT .GT. IADDC)  GO TO 20
C
C     ***************
C     CANDIDATES FOR ADDITION TO THE  Z*D*R
C     FACTORIZATION ARE INSPECTED IN RANDOM
C     ORDER TO HINDER CYCLING.
C     THE RANDOMIZATION WAS CARRIED OUT BY  RESID.
C
C     IF A CANDIDATE HAS JUST BEEN RELEASED
C     FROM THE FACTORIZATION OR IS DEPENDENT UPON THE
C     COLUMNS IN THE FACTORIZATION,
C     THEN IT IS OMITTED FROM ADDITION.
C
C     UPON EXIT, INDICES OF SUCH OMITTED
C     COLUMNS ARE TO BE FOUND IN
C          INDX(NACT+1),...,INDX(IADDC) .
C     ***************
C
        DO 10 I=ISTRT,IADDC
          NACTP1 = NACT + 1
          IX = INDX(I)
          CALL ZDRPOC(NVARS,NACT,ZZ,NZZR,DD,E(1,IX),W,FAIL)
          COLNRM = DASUM(NVARS,E(1,IX),1)
          PRJNRM = DASUM(NVARS,W,1)
          IF (PRJNRM .LE. EPS*COLNRM .OR. IX .EQ. IDELC)  GO TO 10
            INDX(I) = INDX(NACTP1)
            INDX(NACTP1) = IX
            CALL ZDRCIN(NVARS,NACT,ZZ,NZZR,DD,RR,E(1,IX),FAIL,W)
   10   CONTINUE
   20 CONTINUE
      RETURN
      END
C
C
C*****SUBROUTINE OBJECT(IADDC,NACT,NEQNS,NALLQ,NCOLS,NVARS,
      SUBROUTINE CL1K  (IADDC,NACT,NEQNS,NALLQ,NCOLS,NVARS,
     *                  E,NER,RES,GRD,EL1N,PEN,PENPAR,INDX)
C
      IMPLICIT NONE
      INTEGER  IADDC,INDX(*),NACT,NALLQ,NEQNS,NCOLS,NER,NVARS
      DOUBLE PRECISION E(NER,*),EL1N,GRD(*),PEN,PENPAR,RES(*)
C
C     ***************
C     CL1 VERSION OF OBJECT.
C
C     THIS ROUTINE ADMINISTERS THE EVALUATION OF THE
C     PENALTY (OBJECTIVE) FUNCTION GIVEN THE EQUATION
C     AND CONSTRAINT RESIDUALS.  IT ALSO COMPUTES THE
C     RESTRICTED GRADIENT OF THE FUNCTION.
C
C     COLUMNS WHICH ARE NOT IN THE  Z*D*R FACTORIZATION
C     BUT WHICH ARE ASSOCIATED WITH ZERO RESIDUALS MUST
C     BE INCLUDED IN THE RESTRICTED GRADIENT WITH RANDOM
C     SIGNS AS AN ANTI-CYCLING DEVICE.
C     THE INDICES OF THESE COLUMNS ARE TO BE
C     FOUND IN  INDX(NACT+1),...,INDX(IADDC)
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS,SIGN
C
C     BLAS  SAXPY,SCOPY
C     +++++++++++++++
C
      INTEGER I,IDUMMY,IX,NACTP1
      DOUBLE PRECISION HALF,ONE,SGN,TMP,ZERO
C
      DOUBLE PRECISION UNIF01
C
C     +++++++++++++++
C     THE FOLLOWING DECLARATIONS ARE NECESSARY
C     FOR PORTABILITY WHEN  SCOPY  IS USED, AS
C     IT IS BELOW, TO FILL ARRAYS WITH A SINGLE
C     VALUE  (ZERO=ZIP  IN THIS CASE).
C     +++++++++++++++
C
      DOUBLE PRECISION ZIP(1)
      EXTERNAL DAXPY, DCOPY
      EXTERNAL UNIF01
      INTRINSIC ABS, SIGN
C     EQUIVALENCE (ZERO,ZIP(1))
C
      DATA HALF /0.5D+00/
      DATA ONE /1.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      ZIP(1) = ZERO
      NACTP1 = NACT + 1
      EL1N = ZERO
      PEN = ZERO
      CALL DCOPY(NVARS,ZIP,0,GRD,1)
      IF (NACTP1 .GT. NCOLS)  GO TO 30
        DO 20 I=NACTP1,NCOLS
          IX = INDX(I)
          TMP = RES(IX)
          SGN = SIGN(ONE,TMP)
          IF (I .LE. IADDC)  SGN = SIGN(ONE,HALF - UNIF01(0,IDUMMY))
          IF (IX .GT. NALLQ .AND. SGN .GT. ZERO)  GO TO 20
            TMP = ABS(TMP)
            IF (IX .GT. NEQNS)  GO TO 10
              EL1N = EL1N + TMP
              TMP = TMP*PENPAR
              SGN = SGN*PENPAR
   10       CONTINUE
            PEN = PEN + TMP
            CALL DAXPY(NVARS,SGN,E(1,IX),1,GRD,1)
   20   CONTINUE
   30 CONTINUE
      RETURN
      END
C
C
C
C*****SUBROUTINE GETV(IDELC,NACT,NVARS,NEQNS,NALLQ,E,NER,
      SUBROUTINE CL1L(IDELC,NACT,NVARS,NEQNS,NALLQ,E,NER,
     *                GRD,COEF,PENPAR,INDX)
C
      IMPLICIT NONE
      INTEGER  IDELC,INDX(*),NACT,NALLQ,NEQNS,NER,NVARS
      DOUBLE PRECISION COEF(*),E(NER,*),GRD(*),PENPAR
C
C     ***************
C     CL1  VERSION.
C
C     SET UP THE RIGHT-HAND-SIDE VECTOR
C     (AND STORE IN THE ARRAY  COEF)
C     FOR THE LINEAR PROBLEM WHICH DETERMINES
C     A DESCENT DIRECTION  P  IN THE CASE WHERE
C     THE PROJECTION OF THE RESTRICTED GRADIENT IS ZERO.
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS,FLOAT,IFIX,SIGN
C
C     BLAS  SAXPY
C
C     EPS  IS THE SMALLEST POSITIVE NUMBER WHICH
C     SATISFIES   (1.0 + EPS) .GT. 1.0   IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     (ALTERNATIVELY, FOR LESS STRICT ZERO CHECKING,
C      EPS  CAN BE SET TO A USER-SPECIFIED TOLERANCE.)
C     +++++++++++++++
C
      INTEGER I,IDUMMY,IRAND,IX
      DOUBLE PRECISION CF,EPS,ONE,OPE,S,TMP,TMPSAV,ZERO
C
      DOUBLE PRECISION UNIF01
      EXTERNAL DAXPY
      EXTERNAL UNIF01
      INTRINSIC ABS, DBLE, INT, SIGN
C
      DATA EPS /1.0D-10/
      DATA ONE /1.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
C     ***************
C     FIND THE MOST OUT-OF-KILTER
C     COEFFICIENT.  BEGIN INSPECTING
C     THE COEFFICIENTS AT A RANDOM INDEX
C     TO HINDER CYCLING.  SET  COEF
C     TO ZERO ON THE FLY.
C     ***************
C
      OPE = ONE + EPS
      IDELC = 0
      TMPSAV = ZERO
      IF (1 .GT. NACT)  GO TO 40
        IRAND = INT(DBLE(NACT)*UNIF01(0,IDUMMY))
        DO 30 I=1,NACT
          IRAND = IRAND + 1
          IF (IRAND .GT. NACT)  IRAND = 1
          IX = INDX(IRAND)
          CF = COEF(IRAND)
          COEF(IRAND) = ZERO
          IF (IX .GT. NALLQ)  GO TO 10
            IF (IX .LE. NEQNS)  CF = CF/PENPAR
            TMP = OPE - ABS(CF)
            GO TO 20
   10     CONTINUE
            TMP = CF + EPS
   20    CONTINUE
         IF (TMP .GE. TMPSAV)  GO TO 30
           IDELC = IRAND
           S = SIGN(ONE,CF)
           TMPSAV = TMP
   30   CONTINUE
C
C     ***************
C     IF NO COEFFICIENTS ARE OUT OF KILTER,
C     THEN RETURN.  OTHERWISE SET A
C     VALUE IN AN APPROPRIATE COMPONENT
C     (INDICATED BY  IDELC)  OF  COEF
C     AND ADJUST THE RESTRICTED GRADIENT
C     IF NECESSARY.
C     ***************
C
        IF (IDELC .EQ. 0)  GO TO 40
          COEF(IDELC) = ONE
          IX = INDX(IDELC)
          IF (IX .GT. NALLQ)  GO TO 40
            COEF(IDELC) = -S
            TMP = -S
            IF (IX .LE. NEQNS)  TMP = TMP*PENPAR
            CALL DAXPY(NVARS,TMP,E(1,IX),1,GRD,1)
   40 CONTINUE
      RETURN
      END
C
C
