C
C 13/11/98 changed all dimensions A(1) to A(*)
C ============================================
C
C     ---------------
C     FOURTH LEVEL SUBROUTINES --
C               DKHEAP,UNIF01,ZDRCIN,ZDRCOU,
C               ZDRGIT,ZDRGNV,ZDRPOC
C     ---------------
C
      SUBROUTINE DKHEAP(MAKE,IR,INDX,ARAY)
C
      IMPLICIT NONE
      INTEGER INDX(*),IR
      LOGICAL MAKE
      DOUBLE PRECISION ARAY(*)
C
C     ***************
C     AN ADAPTATION OF D. E. KNUTH,S HEAPING
C     ROUTINES (SEE VOLUME 3 OF
C          THE ART OF COMPUTER PROGRAMMING  ).
C     IF  MAKE  IS  .TRUE.,  THE FULL HEAP BUILDING
C     PROCESS IS CARRIED OUT ON
C          ARAY(1),...,ARAY(IR) ,
C     AND THE VALUE OF  IR  IS UNCHANGED.
C     IF  MAKE  IS  .FALSE.,  ONE STEP OF THE SORTING
C     PROCESS IS CARRIED OUT TO PROVIDE THE NEXT
C     ELEMENT OF  ARAY  IN ORDER,  AND THE VARIABLE
C     IR  IS DECREASED BY ONE.  THE INTERRUPTION OF THE
C     SORTING PHASE IS BUILT IN VIA THE FLAG  ONCE.
C     INDX  IS AN INDEX VECTOR ASSOCIATED WITH
C     ARAY  WHICH MUST BE REARRANGED IN PARALLEL
C     WITH IT.
C     ***************
C
      INTEGER I,IL,IT,J
      LOGICAL ONCE
      DOUBLE PRECISION T
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      IF (IR .GT. 1)  GO TO 5
        IF (.NOT.MAKE)  IR = 0
        RETURN
    5 CONTINUE
C
C     ***************
C     TEST WHETHER OR NOT THE INITIAL
C     HEAP IS TO BE BUILT
C     ***************
C
      IL = 1
      IF (MAKE)  IL = (IR/2) + 1
      ONCE = .FALSE.
C
C     ***************
C     THE LOOP BEGINS HERE
C     ***************
C
   10 CONTINUE
      IF (IL .GT. 1)  GO TO 20
C
C     ***************
C     THE SORTING PHASE USES THIS BRANCH
C     ***************
C
        IF (MAKE .OR. ONCE)  RETURN
        ONCE = .TRUE.
        IT = INDX(IR)
        T = ARAY(IR)
        INDX(IR) = INDX(1)
        ARAY(IR) = ARAY(1)
        IR = IR - 1
        IF (IR .GT. 1)  GO TO 30
          INDX(1) = IT
          ARAY(1) = T
          RETURN
   20 CONTINUE
C
C     ***************
C     THE HEAP-BUILDING PHASE USES THIS BRANCH
C     ***************
C
        IL = IL - 1
        IT = INDX(IL)
        T = ARAY(IL)
   30 CONTINUE
C
C     ***************
C     THE REMAINING STATEMENTS ARE COMMON
C     TO BOTH PHASES AND EMBODY THE
C     HEAP-RECTIFYING (SIFTING) SECTION
C     ***************
C
      J = IL
   40 CONTINUE
      I = J
      J = 2*J
C*****IF (J - IR)  50, 60, 70
      IF (J.LT.IR) THEN
         GOTO 50
      ELSEIF (J.EQ.IR) THEN
         GOTO 60
      ELSE
         GOTO 70
      ENDIF
   50 CONTINUE
      IF (ARAY(J) .LE. ARAY(J + 1))  GO TO 60
        J = J + 1
   60 CONTINUE
      IF (T .LE. ARAY(J))  GO TO 70
        INDX(I) = INDX(J)
        ARAY(I) = ARAY(J)
        GO TO 40
   70 CONTINUE
      INDX(I) = IT
      ARAY(I) = T
      GO TO 10
      END
C
C
      DOUBLE PRECISION FUNCTION UNIF01(ISEED,IX)
C
      INTEGER ISEED,IX,IX0
      INTRINSIC DBLE, MOD
C
      DATA IX0/2/
C
C     +++++++++++++++
C     SYSTEM ROUTINES  FLOAT,MOD
C     +++++++++++++++
C
C     --------------------------------------------------------------
C     --------------------------------------------------------------
C
C     *****PURPOSE-
C     THIS FUNCTION RETURNS A PSEUDO-RANDOM NUMBER DISTRIBUTED
C     UNIFORMLY IN THE INTERVAL (0,1).
C
C     *****PARAMETER DESCRIPTION-
C     ON INPUT-
C
C     ISEED,  IF IT IS NONZERO MODULO 9973, BECOMES THE
C          NEW SEED, I.E. IT REPLACES THE INTERNALLY STORED
C          VALUE OF IX0.  ON MACHINES WHERE FORTRAN VARIABLES
C          RETAIN THEIR VALUES BETWEEN CALLS, THE INTERNALLY
C          STORED VALUE IF IX0 IS THE VALUE ASSIGNED TO  IX  IN
C          THE PREVIOUS INVOCATION OF  UNIF01.  OTHERWISE -- AND
C          IN THE FIRST CALL TO  UNIF01 --  IX0=2.
C
C     ON OUTPUT-
C
C     IX IS THE NEXT INTEGER IN A PSEUDO-RANDOM SEQUENCE OF
C          INTEGERS BETWEEN  1  AND  9972  AND IS GENERATED FROM ITS
C          PREDECESSOR  IX0  (I.E.  FROM  ISEED,  IF  ISEED  IS NONZERO
C          MODULO 9973).  IX  IS THE VALUE WHICH  ISEED  SHOULD HAVE
C          IN THE NEXT INVOCATION OF  UNIF01  TO GET THE NEXT
C          PSEUDO-RANDOM NUMBER.  THE CALLER WILL OFTEN PASS THE
C          SAME VARIABLE FOR  ISEED  AS FOR  IX,
C          E.G.  X = UNIF01(IX,IX).
C
C     *****APPLICATION AND USAGE RESTRICTIONS-
C     UNIF01  SHOULD ONLY BE USED WHEN PORTABILITY IS IMPORTANT AND A
C     COURSE RANDOM NUMBER GENERATOR SUFFICES.  APPLICATIONS REQUIRING
C     A FINE, HIGH PRECISON GENERATOR SHOULD USE ONE WITH A MUCH
C     LARGER MODULUS.
C
C     *****ALGORITHM NOTES-
C     UNIF01 WILL RUN ON ANY MACHINE HAVING AT LEAST 20 BITS OF AC-
C     CURACY FOR FIXED-POINT ARITHMITIC.  IT IS BASED ON A GENERATOR
C     RECOMMENDED IN (3), WHICH PASSES THE SPECTRAL TEST WITH FLYING
C     COLORS -- SEE (1) AND (2).
C
C     REFERENCES-
C     (1) HOAGLIN, D.C. (1976), THEORETICAL PROPERTIES OF CONGRUENTIAL
C     RANDOM-NUMBER GENERATORS-  AN EMPIRICAL VIEW,
C     MEMORANDUM NS-340, DEPT. OF STATISTICS, HARVARD UNIV.
C
C     (2) KNUTH, D.E. (1969), THE ART OF COMPUTER PROGRAMMING, VOL. 2
C     (SEMINUMERICAL ALGORITHMS), ADDISON-WESLEY, READING, MASS.
C
C     (3) SMITH, C.S. (1971), MULTIPLICATIVE PSEUDO-RANDOM NUMBER
C     GENERATORS WITH PRIME MODULUS, J. ASSOC. COMPUT. MACH. 18,
C     PP. 586-593.
C
C     *****GENERAL-
C
C     THIS SUBROUTINE WAS WRITTEN IN CONNECTION WITH RESEARCH
C     SUPPORTED BY THE NATIONAL SCIENCE FOUNDATION UNDER GRANTS
C     MCS-7600324, DCR75-10143, 76-14311DSS, AND MCS76-11989.
C
C     PERMISSION FOR THE USE OF  UNIF01  IN  CL1  WAS
C     GENEROUSLY GIVEN BY  V. KLEMA  AND  D. HOAGLIN.
C
C     --------------------------------------------------------------
C     --------------------------------------------------------------
C
      IF (ISEED .EQ. 0) GO TO 10
      IX = MOD(ISEED, 9973)
      IF (IX .NE. 0) IX0 = IX
C  ***
C  IN ORDER THAT ALL FIXED-POINT CALCULATIONS REQUIRE ONLY 20 BIT
C  ARITHMETIC, WE USE TWO CALLS TO  MOD  TO COMPUTE
C  IX0 = MOD(3432*IX0, 9973).
C  ***
 10   IX0 = MOD(52*MOD(66*IX0, 9973), 9973)
      IX = IX0
      UNIF01 = DBLE(IX0)/9973.0D+00
      RETURN
      END
C
C
      SUBROUTINE ZDRCIN(N,K,ZZ,NZZR,DD,RR,COL,FAIL,W)
C
      IMPLICIT NONE
      INTEGER  K,N,NZZR
      LOGICAL  FAIL
      DOUBLE PRECISION COL(*),DD(*),RR(*),W(*),ZZ(NZZR,*)
C
C     ***************
C     PREPARED BY RICHARD BARTELS
C     THE UNIVERSITY OF WATERLOO
C     COMPUTER SCIENCE DEPARTMENT
C     LATEST UPDATE .... 30 NOVEMBER, 1979.
C
C     GIVEN THE FACTORIZATION
C
C          ZZ*DD*RR
C
C     OF SOME  N BY K  MATRIX
C
C       (0 .LE. K .LT. N)
C         (N .GE. 1),
C
C     WHERE
C
C          (ZZ-TRANSP)*(ZZ) = (DD-INV),
C          DD  IS DIAGONAL AND NONSINGULAR,
C     AND
C          RR  HAS ZEROS BELOW THE DIAGONAL,
C
C     AND GIVEN A  (K+1)TH  COLUMN
C     TO BE ADDEDTO THE ORIGINAL MATRIX,
C     THIS PROGRAM UPDATES  ZZ,DD AND RR.
C
C     THE VALUE OF  K  IS INCREASED BY ONE.
C
C     W  IS A SCRATCH ARRAY.
C
C     USE IS MADE OF ROUTINES FROM THE LIBRARY
C     OF BASIC LINEAR ALGEBRA SUBROUTINES (BLAS).
C
C     PARAMETERS...
C
C                     INPUT/
C       NAME   TYPE   OUTPUT/   SUB-    DESCRIPTION
C                     SCRATCH  SCRIPTS
C       -------------------------------------------
C       N      INT.      I              NUMBER OF ROWS
C
C       K      INT.     I/O             NUMBER OF COLUMNS
C
C       ZZ     REAL     I/O       2     SCALED ORTHOGONAL
C                                       MATRIX
C
C       NZZR   INT.      I              ROW DIMENSION OF ZZ
C
C       DD     REAL     I/O       1     DIAGONAL SCALING
C                                       MATRIX (DIAGONAL
C                                       ELEMENTS ONLY)
C
C       RR     REAL     I/O       1     RIGHT-TRIANGULAR
C                                       MATRIX IN COMPACT FORM.
C
C       COL    REAL      I        1     COLUMN TO BE
C                                       ADDED TO  RR
C
C       FAIL   LOG.      O             .TRUE.  IF  K,N
C                                       ARE IMPROPER
C
C       W      REAL     SCR       1     WORKSPACE
C       -------------------------------------------
C
C     THE  I-TH  SEGMENT OF THE ARRAY  RR  IS  N-I+2 SPACES
C     LONG AND CONTAINS  1  WORK SPACE FOLLOWED BY THE
C     K-I+1  ELEMENTS OF ROW  I  FOLLOWED BY  N-K
C     SCRATCH SPACES.
C     ***************
C
C     +++++++++++++++
C     BLAS  SCOPY,SDOT,SROTM,SROTMG
C     +++++++++++++++
C
      INTEGER I,J,JDEL,KP1,KP2
      DOUBLE PRECISION DI,ONE,PARAM(5),WI,ZERO
C
      DOUBLE PRECISION DDOT
C
C     +++++++++++++++
C     THE FOLLOWING DECLARATIONS ARE NECESSARY
C     FOR PORTABILITY WHEN  SCOPY  IS USED, AS
C     IT IS BELOW, TO FILL ARRAYS WITH A SINGLE VALUE
C     (ONE=UNITY  AND  ZERO=ZIP  IN THIS CASE).
C     +++++++++++++++
C
      DOUBLE PRECISION UNITY(1),ZIP(1)
      EXTERNAL DCOPY, DDOT, DROTM, DROTMG
C     EQUIVALENCE (ONE,UNITY(1)),(ZERO,ZIP(1))
C
      DATA ONE /1.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      UNITY(1) = ONE
      ZIP(1) = ZERO
      IF (K .GE. 0 .AND. K .LT. N .AND. N .LE. NZZR)  GO TO 5
        FAIL = .TRUE.
        RETURN
    5 CONTINUE
      IF (K .GT. 0)  GO TO 20
C
C     ***************
C     FOR THE SPECIAL CASE THAT THE
C     FACTORIZATION WAS VACUOUS,
C     RESET THE ARRAYS  ZZ AND DD
C     TO REPRESENT THE  IDENTITY.
C     ***************
C
        K = 0
        CALL DCOPY(N,UNITY,0,DD,1)
        CALL DCOPY(N*N,ZIP,0,ZZ,1)
        DO 10 I=1,N
          ZZ(I,I) = ONE
   10   CONTINUE
   20 CONTINUE
      KP1 = K + 1
      KP2 = K + 2
C
C     ***************
C     TRANSFORM THE INCOMING COLUMN,
C     AND STORE THE RESULT IN  W.
C     ***************
C
      DO 30 I=1,N
        W(I) = DDOT(N,ZZ(1,I),1,COL,1)
   30 CONTINUE
C
C     ***************
C     ZERO OUT THE SPIKE WHICH WOULD RESULT FROM
C     STORING  W  IN  RR.   UPDATE  ZZ  AND  DD.
C     ***************
C
      IF (KP2 .GT. N)  GO TO 50
        DO 40 I=KP2,N
          DI = DD(I)
          WI = W(I)
          CALL DROTMG(DD(KP1),DI,W(KP1),WI,PARAM)
          W(I) = WI
          DD(I) = DI
          CALL DROTM(N,ZZ(1,KP1),1,ZZ(1,I),1,PARAM)
   40   CONTINUE
   50 CONTINUE
C
C     ***************
C     STORE THE NEW COLUMN, WHICH IS STILL
C     IN THE ARRAY  W,  INTO  RR.
C     ***************
C
      J = KP2
      JDEL = N
      DO 60 I=1,KP1
        RR(J) = W(I)
        J = J + JDEL
        JDEL = JDEL - 1
   60 CONTINUE
      K = KP1
      FAIL = .FALSE.
      RETURN
      END
C
C
      SUBROUTINE ZDRCOU(N,K,ZZ,NZZR,DD,RR,IC,FAIL)
C
      IMPLICIT NONE
      INTEGER  IC,K,N,NZZR
      LOGICAL  FAIL
      DOUBLE PRECISION DD(*),RR(*),ZZ(NZZR,*)
C
C     ***************
C     PREPARED BY RICHARD BARTELS
C     THE UNIVERSITY OF WATERLOO
C     COMPUTER SCIENCE DEPARTMENT
C     LATEST UPDATE .... 30 NOVEMBER, 1979.
C
C     GIVEN THE FACTORIZATION
C
C          ZZ*DD*RR
C
C     OF SOME  N BY K  MATRIX
C
C       (1 .LE. K .LE. N)
C          (N .GE. 1),
C
C     WHERE
C
C          (ZZ-TRANSP)*(ZZ) = (DD-INV),
C          DD  IS DIAGONAL AND NONSINGULAR,
C     AND
C          RR  HAS ZEROS BELOW THE DIAGONAL,
C
C     AND GIVEN THE INDEX  IC  OF A COLUMN
C     TO BE REMOVED  (1 .LE. IC .LE. K),
C     THIS PROGRAM UPDATES  ZZ,DD AND RR .
C
C     THE VALUE OF  K  IS DECREASED BY ONE, AND
C     THE COLUMN ORDERING IN  RR  IS CHANGED.
C
C     USE IS MADE OF ROUTINES FROM THE LIBRARY
C     OF BASIC LINEAR ALGEBRA SUBROUTINES (BLAS).
C
C     PARAMETERS...
C
C       NAME   TYPE    INPUT/   SUB-    DESCRIPTION
C                      OUTPUT  SCRIPTS
C       -------------------------------------------
C       N      INT.      I              NUMBER OF ROWS
C
C       K      INT.     I/O             NUMBER OF COLUMNS
C
C       ZZ     REAL     I/O       2     SCALED ORTHOGONAL
C                                       MATRIX
C
C       NZZR   INT.      I              ROW DIMENSION OF ZZ
C
C       DD     REAL     I/O       1     DIAGONAL SCALING
C                                       MATRIX (DIAGONAL
C                                       ELEMENTS ONLY)
C
C       RR     REAL     I/O       1     RIGHT-TRIANGULAR
C                                       MATRIX IN COMPACT FORM.
C
C       IC     INT.      I              INDEX OF COLUMN
C                                       TO BE REMOVED
C
C       FAIL   LOG.      O              .TRUE.  IF  K,N,IC
C                                       ARE IMPROPER
C       -------------------------------------------
C
C     THE  I-TH  SEGMENT OF THE ARRAY  RR  IS  N-I+2 SPACES
C     LONG AND CONTAINS  1  WORK SPACE FOLLOWED BY THE
C     K-I+1  ELEMENTS OF ROW  I  FOLLOWED BY  N-K
C     SCRATCH SPACES.
C     ***************
C
C     +++++++++++++++
C     BLAS  SROTM,SROTMG
C     +++++++++++++++
C
      INTEGER I,IM1,J,JEND,JINC,JSTRT,KM1,LSTRT
      DOUBLE PRECISION DI,PARAM(5),RJ
      EXTERNAL DROTM, DROTMG
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      IF (K .GE. 1 .AND. K .LE. N .AND. N .LE. NZZR)  GO TO 5
        FAIL = .TRUE.
        RETURN
    5 CONTINUE
      KM1 = K - 1
C
C     ***************
C     SPECIAL CASES ARE HANDLED FIRST.
C     1.  K=1 AND THE FACTORIZATION BECOMES NULL.
C     2.  IC=K AND THE UPDATING IS TRIVIAL.
C     ***************
C
      IF (K .GT. 1)  GO TO 10
        K = 0
        FAIL = .FALSE.
        RETURN
   10 CONTINUE
      IF (IC .LT. K)  GO TO 20
        K = KM1
        FAIL = .FALSE.
        RETURN
   20 CONTINUE
C
C     ***************
C     GENERAL UPDATING STEP.
C     THE COLUMN TO BE DELETED MUST BE PERMUTED
C     TO THE RIGHT, AND SUBDIAGONAL ELEMENTS
C     WHICH RESULT IN  RR  HAVE TO BE
C     TRANSFORMED TO ZERO.
C     ***************
C
      JSTRT = IC + 1
      JEND = K
      JINC = N
      DO 50 I=1,K
C
C     ***************
C     PERMUTATION OF THE  I-TH  ROW OF RR.
C     ***************
C
        DO 30 J=JSTRT,JEND
          RR(J) = RR(J + 1)
   30   CONTINUE
        IF (I .LE. IC)  GO TO 40
C
C     ***************
C     TRANSFORMATION OF THE CURRENT AND LAST
C     ROWS  (I AND I-1)  OF RR  AS WELL AS
C     CORRESPONDING CHANGES TO  ZZ AND DD.
C
C     THE EXTRA VARIABLES  DI  AND  RJ
C     ARE USED TO AVOID AN ERROR MESSAGE
C     FROM THE  PFORT VERIFIER, AND THEY
C     MAY BE REMOVED, IF DESIRED, SO THAT
C     THE CALL TO  SROTMG  WOULD BE
C
C     CALL SROTMG(DD(IM1),DD(I),RR(LSTRT),RR(JSTRT),PARAM)
C
C     ***************
C
          IM1 = I - 1
          DI = DD(I)
          RJ = RR(JSTRT)
          CALL DROTMG(DD(IM1),DI,RR(LSTRT),RJ,PARAM)
          RR(JSTRT) = RJ
          DD(I) = DI
          CALL DROTM(JEND - JSTRT + 1,RR(LSTRT + 1),1,
     *               RR(JSTRT + 1),1,PARAM)
          CALL DROTM(N,ZZ(1,IM1),1,ZZ(1,I),1,PARAM)
          JSTRT = JSTRT + 1
   40   CONTINUE
C
C     ***************
C     INDEX UPDATING
C     ***************
C
        LSTRT = JSTRT
        JSTRT = JSTRT + JINC
        JEND = JEND + JINC
        JINC = JINC - 1
   50 CONTINUE
      K = KM1
      FAIL = .FALSE.
      RETURN
      END
C
C
      SUBROUTINE ZDRGIT(N,K,ZZ,NZZR,RR,GV,SOL,FAIL,W)
C
      IMPLICIT NONE
      INTEGER  K,N,NZZR
      LOGICAL  FAIL
      DOUBLE PRECISION GV(*),RR(*),W(*),SOL(*),ZZ(NZZR,*)
C
C     ***************
C     PREPARED BY RICHARD BARTELS
C     THE UNIVERSITY OF WATERLOO
C     COMPUTER SCIENCE DEPARTMENT
C     LATEST UPDATE .... 30 NOVEMBER, 1979.
C
C     GIVEN THE FACTORIZATION
C
C          ZZ*DD*RR
C
C     OF SOME  N BY K  MATRIX
C
C       (1 .LE. K .LE. N)
C         (N .GE. 1),
C
C     WHERE
C
C          (ZZ-TRANSP)*(ZZ) = (DD-INV),
C          DD  IS DIAGONAL AND NONSINGULAR,
C     AND
C          RR  HAS ZEROS BELOW THE DIAGONAL,
C
C     AND GIVEN AN ARBITRARY VECTOR  GV  OF
C     APPROPRIATE DIMENSION, THIS ROUTINE FINDS THE
C     VECTOR  SOL  SATISFYING THE UNDERDETERMINED SYSTEM
C
C          (ZZ*DD*RR-TRANSP.)*(SOL) = (GV).
C
C     THAT IS,
C
C          (SOL) = ((ZZ*DD*RR)-GEN.INV.-TRANSP.)*(GV).
C
C     THE ARRAY  DD  IS NOT NEEDED BY  ZDRGIT.
C
C     USE IS MADE OF ROUTINES FROM THE LIBRARY
C     OF BASIC LINEAR ALGEBRA SUBROUTINES (BLAS).
C
C     W  IS A SCRATCH ARRAY.
C
C     PARAMETERS...
C
C                     INPUT/
C       NAME   TYPE   OUTPUT/   SUB-    DESCRIPTION
C                     SCRATCH  SCRIPTS
C       -------------------------------------------
C       N      INT.      I              NUMBER OF ROWS
C
C       K      INT.     I/O             NUMBER OF COLUMNS
C
C       ZZ     REAL     I/O       2     SCALED ORTHOGONAL
C                                       MATRIX
C
C       NZZR   INT.      I              ROW DIMENSION OF ZZ
C
C       RR     REAL     I/O       1     RIGHT-TRIANGULAR
C                                       MATRIX IN COMPACT FORM.
C
C       GV     REAL      I        1     GIVEN VECTOR
C
C       SOL    REAL      O        1     SOLUTION
C
C       FAIL   LOG.      O              .TRUE. IF  N,K
C                                       ARE IMPROPER, OR IF
C                                       RR  IS SINGULAR
C
C       W      REAL     SCR       1     WORKSPACE
C       -------------------------------------------
C
C     THE  I-TH  SEGMENT OF THE ARRAY  RR  IS  N-I+2 SPACES
C     LONG AND CONTAINS  1  WORK SPACE FOLLOWED BY THE
C     K-I+1  ELEMENTS OF ROW  I  FOLLOWED BY  N-K
C     SCRATCH SPACES.
C
C     IF  GV  AND  SOL  ARE DIMENSIONED TO THE
C     MAXIMUM OF  N  AND  K , THEN THE SAME
C     STORAGE ARRAY MAY BE USED FOR BOTH OF
C     THESE VECTORS.
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS
C
C     BLAS  SAXPY,SCOPY
C
C     BIG  IS THE LARGEST POSITIVE NUMBER
C     WHICH CAN BE REPRESENTED IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     +++++++++++++++
C
      INTEGER I,J,JDEL
      DOUBLE PRECISION BIG,WI,ONE,RRJ,ZERO
C
C     +++++++++++++++
C     THE FOLLOWING DECLARATIONS ARE NECESSARY
C     FOR PORTABILITY WHEN  SCOPY  IS USED, AS
C     IT IS BELOW, TO FILL ARRAYS WITH A SINGLE VALUE
C     (ZERO=ZIP  IN THIS CASE).
C     +++++++++++++++
C
      DOUBLE PRECISION ZIP(1)
      EXTERNAL DAXPY, DCOPY
      INTRINSIC ABS
C     EQUIVALENCE (ZERO,ZIP(1))
C
      DATA BIG /1.0D+300/
      DATA ONE /1.0D+00/
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      ZIP(1) = ZERO
      IF (K .GE. 1 .AND. K .LE. N .AND. N .LE. NZZR)  GO TO 10
        FAIL = .TRUE.
        RETURN
   10 CONTINUE
C
C     ***************
C     FIRST SOLVE  (RR-TRANSP.)*(W) = (GV)
C     ***************
C
      CALL DCOPY(K,GV,1,W,1)
      J = 2
      JDEL = N + 1
      DO 30 I=1,K
        RRJ = RR(J)
        WI = W(I)
        IF (ABS(RRJ) .GE. ONE)  GO TO 20
        IF (ABS(WI) .LT. ABS(RRJ)*BIG)  GO TO 20
          FAIL = .TRUE.
          RETURN
   20   CONTINUE
        W(I) = WI/RRJ
        IF (I.LT.K) CALL DAXPY(K-I,(-W(I)),RR(J+1),1,W(I+1),1)
        J = J + JDEL
        JDEL = JDEL - 1
   30 CONTINUE
C
C     ***************
C     NOW  (SOL) = (ZZ)*(W)
C     ***************
C
      CALL DCOPY(N,ZIP,0,SOL,1)
      DO 40 I=1,K
        CALL DAXPY(N,W(I),ZZ(1,I),1,SOL,1)
   40 CONTINUE
      FAIL = .FALSE.
      RETURN
      END
C
C
      SUBROUTINE ZDRGNV(N,K,ZZ,NZZR,RR,GV,SOL,FAIL)
C
      IMPLICIT NONE
      INTEGER  K,N,NZZR
      LOGICAL  FAIL
      DOUBLE PRECISION GV(*),RR(*),SOL(*),ZZ(NZZR,*)
C
C     ***************
C     PREPARED BY RICHARD BARTELS
C     THE UNIVERSITY OF WATERLOO
C     COMPUTER SCIENCE DEPARTMENT
C     LATEST UPDATE .... 30 NOVEMBER, 1979.
C
C     GIVEN THE FACTORIZATION
C
C          ZZ*DD*RR
C
C     OF SOME  N BY K  MATRIX
C
C       (1 .LE. K .LE. N)
C         (N .GE. 1),
C
C     WHERE
C
C          (ZZ-TRANSP)*(ZZ) = (DD-INV),
C          DD  IS DIAGONAL AND NONSINGULAR,
C     AND
C          RR  HAS ZEROS BELOW THE DIAGONAL,
C
C     AND GIVEN AN ARBITRARY VECTOR  GV  OF
C     APPROPRIATE DIMENSION, THIS ROUTINE FINDS THE
C     VECTOR  SOL  GIVEN BY
C
C          (SOL) = ((ZZ*DD*RR)-GEN.INV.)*(GV),
C
C     WHICH REPRESENTS THE LEAST SQUARES PROBLEM
C
C        (ZZ*DD*RR)*(SOL) = (GV).
C
C     THE ARRAY  DD  IS NOT NEEDED BY  ZDRGNV.
C
C     USE IS MADE OF ROUTINES FROM THE LIBRARY
C     OF BASIC LINEAR ALGEBRA SUBROUTINES (BLAS).
C
C     PARAMETERS...
C
C       NAME   TYPE   INPUT/    SUB-    DESCRIPTION
C                     OUTPUT/  SCRIPTS
C       -------------------------------------------
C       N      INT.      I              NUMBER OF ROWS
C
C       K      INT.     I/O             NUMBER OF COLUMNS
C
C       ZZ     REAL     I/O       2     SCALED ORTHOGONAL
C                                       MATRIX
C
C       NZZR   INT.      I              ROW DIMENSION OF ZZ
C
C       RR     REAL     I/O       1     RIGHT-TRIANGULAR
C                                       MATRIX IN COMPACT FORM.
C
C       GV     REAL      I        1     GIVEN VECTOR
C
C       SOL    REAL      O        1     SOLUTION
C
C       FAIL   LOG.      O              .TRUE. IF  N,K
C                                       ARE IMPROPER, OR IF
C                                       RR  IS SINGULAR
C       -------------------------------------------
C
C     THE  I-TH  SEGMENT OF THE ARRAY  RR  IS  N-I+2 SPACES
C     LONG AND CONTAINS  1  WORK SPACE FOLLOWED BY THE
C     K-I+1  ELEMENTS OF ROW  I  FOLLOWED BY  N-K
C     SCRATCH SPACES.
C     ***************
C
C     +++++++++++++++
C     SYSTEM ROUTINES  ABS
C
C     BLAS  SDOT
C
C     BIG  IS THE LARGEST POSITIVE NUMBER
C     WHICH CAN BE REPRESENTED IN THE
C     PRECISION OF THE ARITHMETIC BEING USED.
C     +++++++++++++++
C
      INTEGER I,IX,J,JDEL
      DOUBLE PRECISION BIG,ONE,TDEN,TNUM
C
      DOUBLE PRECISION DDOT
      EXTERNAL DDOT
      INTRINSIC ABS
C
      DATA BIG /1.0D+300/
      DATA ONE /1.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      IF (K .GE. 1 .AND. K .LE. N .AND. N .LE. NZZR)  GO TO 10
        FAIL = .TRUE.
        RETURN
   10 CONTINUE
C
C     ***************
C     FORM   (V) = (ZZ(1)-TRANSP)*(GV),   WHERE  ZZ(1)
C     IS THE MATRIX OF THE FIRST  K  COLUMNS OF  ZZ
C
C     V  CAN BE STORED IN THE ARRAY  SOL.
C     ***************
C
      DO 20 I=1,K
        SOL(I) = DDOT(N,ZZ(1,I),1,GV,1)
   20 CONTINUE
C
C     ***************
C     BACKSOLVE THE SYSTEM
C          (RR)*(SOL) = (V)
C     FOR THE VECTOR  SOL
C
C     NOTE THAT  SOL  AND  V
C     ARE STORED IN THE SAME ARRAY.
C     ***************
C
      J = (((N + 1)*(N + 2) - (N - K + 3)*(N - K + 2))/2) + 2
      JDEL = N - K + 3
      DO 40 IX=1,K
        I = K - IX + 1
        TDEN = RR(J)
        TNUM = SOL(I)
        IF (IX.GT.1) TNUM = TNUM-DDOT(IX-1,RR(J+1),1,SOL(I+1),1)
        IF (ABS(TDEN) .GE. ONE)  GO TO 30
        IF (ABS(TNUM) .LT. ABS(TDEN)*BIG)  GO TO 30
          FAIL = .TRUE.
          RETURN
   30   CONTINUE
        SOL(I) = TNUM/TDEN
        J = J - JDEL
        JDEL = JDEL + 1
   40 CONTINUE
      FAIL = .FALSE.
      RETURN
      END
C
C
      SUBROUTINE ZDRPOC(N,K,ZZ,NZZR,DD,GV,POC,FAIL)
C
      IMPLICIT NONE
      INTEGER  K,N,NZZR
      LOGICAL  FAIL
      DOUBLE PRECISION DD(*),POC(*),GV(*),ZZ(NZZR,*)
C
C     ***************
C     PREPARED BY RICHARD BARTELS
C     THE UNIVERSITY OF WATERLOO
C     COMPUTER SCIENCE DEPARTMENT
C     LATEST UPDATE .... 30 NOVEMBER, 1979.
C
C     ZZ IS AN  N BY N  (N .GE. 1)  SCALED
C     ORTHOGONAL MATRIX.  DD  CONTAINS THE
C     DIAGONAL ELEMENTS OF A DIAGONAL SCALING
C     MATRIX.  GV  IS A GIVEN VECTOR OF LENGTH  N.
C
C     WE HAVE
C
C          (ZZ-TRANSP.)*(ZZ) = (DD-INV.)
C
C     AND
C
C               ZZ*DD*RR = MAT
C
C     FOR SOME  N BY K  (0 .LE. K .LE. N)
C     MATRIX  RR  WITH ZEROS BELOW THE DIAGONAL
C     AND SOME GIVEN MATRIX  MAT.  (NIETHER  RR
C     NOR  MAT  ARE NEEDED BY  ZDRPOC.)
C
C     THEN
C
C    (PROJ(OC)) = (ZZ(2))*(DD(2))*(ZZ(2)-TRANSP.)
C
C     IS THE (ORTHOGONAL) PROJECTOR ON THE
C     COMPLEMENT OF THE RANGE SPACE OF  MAT,
C     WHERE  ZZ(2)  REPRESENTS THE LAST  N-K
C     COLUMNS OF  ZZ  AND  DD(2)  REPRESENTS THE
C     LOWER-RIGHT-HAND  N-K  ORDER SUBMATRIX OF  DD.
C
C     ZDRPOC  PRODUCES THE VECTOR
C
C               POC = (PROJ(OC))*GV .
C
C     USE IS MADE OF ROUTINES FROM THE LIBRARY
C     OF BASIC LINEAR ALGEBRA SUBROUTINES (BLAS).
C
C     PARAMETERS...
C
C                     INPUT/
C       NAME   TYPE   OUTPUT/   SUB-    DESCRIPTION
C                     SCRATCH  SCRIPTS
C       -------------------------------------------
C       N      INT.      I              ORDER OF  ZZ,DD
C
C       K      INT.     I/O             NUMBER OF COLUMNS
C                                       OF  ZZ  DEFINING
C                                       RANGE OF  MAT
C
C       ZZ     REAL     I/O       2     SCALED ORTHOGONAL
C                                       MATRIX
C
C       NZZR   INT.      I              ROW DIMENSION OF ZZ
C
C       DD     REAL     I/O       1     DIAGONAL SCALING
C                                       MATRIX (DIAGONAL
C                                       ELEMENTS ONLY)
C
C       GV     REAL      I        1     VECTOR TO BE PROJECTED
C
C       POC    REAL      O        1     PROJECTION
C
C       FAIL   LOG.      O              .TRUE.  IF  N,K
C                                       ARE IMPROPER
C
C       -------------------------------------------
C
C     ***************
C
C     +++++++++++++++
C     BLAS  SAXPY,SCOPY,SDOT
C     +++++++++++++++
C
      INTEGER I,KP1
      DOUBLE PRECISION WI,ZERO
C
      DOUBLE PRECISION DDOT
C
C     +++++++++++++++
C     THE FOLLOWING DECLARATIONS ARE NECESSARY
C     FOR PORTABILITY WHEN  SCOPY  IS USED, AS
C     IT IS BELOW, TO FILL ARRAYS WITH A SINGLE VALUE
C     (ZERO=ZIP  IN THIS CASE).
C     +++++++++++++++
C
      DOUBLE PRECISION ZIP(1)
      EXTERNAL DAXPY, DCOPY, DDOT
C     EQUIVALENCE (ZERO,ZIP(1))
C
      DATA ZERO /0.0D+00/
C
C     /////////////////  BEGIN PROGRAM  //////////////////
C
      ZIP(1) = ZERO
      KP1 = K + 1
      IF (K .GE. 0 .AND. K .LE. N
     *       .AND. N .GE. 1 .AND. N .LE. NZZR)  GO TO 5
        FAIL = .TRUE.
        RETURN
    5 CONTINUE
      IF (K .GT. 0)  GO TO 10
C
C     ***************
C     CASE 1 ... ZZ(2)=ZZ  (K=0)
C     ***************
C
        CALL DCOPY(N,GV,1,POC,1)
        FAIL = .FALSE.
        RETURN
   10 CONTINUE
      IF (K .LT. N)  GO TO 20
C
C     ***************
C     CASE 2 ... ZZ(2) IS VACUOUS  (K=N)
C     ***************
C
        CALL DCOPY(N,ZIP,0,POC,1)
        FAIL = .FALSE.
        RETURN
   20 CONTINUE
C
C     ***************
C     CASE 3 ... ZZ(2)  IS INTERMEDIATE
C     BETWEEN THE OTHER TWO CASES
C     (0 .LT. K .LT. N)
C     ***************
C
      CALL DCOPY(N,ZIP,0,POC,1)
      DO 30 I=KP1,N
        WI = DDOT(N,ZZ(1,I),1,GV,1)*DD(I)
        CALL DAXPY(N,WI,ZZ(1,I),1,POC,1)
   30 CONTINUE
      FAIL = .FALSE.
      RETURN
      END
C
C
