c
c revision 1: 4/11/98
c ===================
c


      subroutine timer(ttime)
      double precision, intent (out) :: ttime
c     *********
c
c     Subroutine timer
c
c     This subroutine is used to determine user time. In a typical
c     application, the user time for a code segment requires calls
c     to subroutine timer to determine the initial and final time.
c
c     The subroutine statement is
c
c       subroutine timer(ttime)
c
c     where
c
c       ttime is an output variable which specifies the user time.
c
c     Argonne National Laboratory and University of Minnesota.
c     MINPACK-2 Project.
c
c     Modified October 1990 by Brett M. Averick.
c
c     **********
c     real temp
c     real tarray(2)
c     real etime
c
c     The first element of the array tarray specifies user time
c
c     temp = etime(tarray)
c
c     ttime = dble(tarray(1))
c
c     return
c
c Modified by w.g.bardsley, 4/11/98 to use dclock@
c
c      external dclock@
c      call dclock@(ttime)
c Modified by w.g.bardlsey 17/01/2012 to use date_and_time
c
      integer   ivalues(8)
      intrinsic dble
      call date_and_time (values=ivalues)
      ttime = dble(360*ivalues(5) + 60*ivalues(6) + ivalues(7))
      end

c====================== The end of timer ===============================
