c
c
      subroutine bisect (n, nfind,
     +                   x, xfind)
c
c action: bisection of a monotonically increasing or decreasing sequence
c author: w.g.bardsley, university of manchester, u.k., 01/10/2012 
c
c Note: this version of bisect does not check x on entry.
c       So it is vital that x is either a monotonically increasing or
c       a monotonically decreasing sequence and, if xfind is in range,
c       it returns nfind such that x(nfind) < xfind < x(nfind + 1).
c       If xfind is out of range it returns either 0 or n as appropriate. 
c       For instance, to search a binomial(M,p) cdf then use as follows
c       x(1) = cdf(0)
c       x(2) = cdf(1)
c       ...
c       x(M + 1) = cdf(M) (= 1)
c       then call with n = M + 1 to return 0 =< nfind =< M   
c     
      implicit none
c
c arguments
c          
      integer,          intent (in)  :: n
      integer,          intent (out) :: nfind  
      double precision, intent (in)  :: x(n), xfind 
c
c locals
c      
      integer nbot, nmid, ntop
      logical up
c
c initialise nbot, and ntop
c      
      up = x(n).gt.x(1)
      nbot = 0
      ntop = n + 1
c
c bisect until the position is located
c      
      do while (ntop - nbot.gt.1)
         nmid = (nbot + ntop)/2
         if (up.eqv.(xfind.gt.x(nmid))) then
            nbot = nmid
         else
            ntop = nmid
         endif      
      enddo
      nfind = nbot
      end
c
c              


