C
C
      SUBROUTINE C05AZ1 (X, Y, FX, TOLX, IR, CVAL, IND, IFAIL)
C
C ACTION : Root finding
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/3/97
C
C          Note that this method differs considerably from the NAG routine
C          since it uses quadratic interpolation rather than linear as in
C          Bus and Decker. Most of the time the quadratic reduces to a
C          linear step anyway. This version also includes the Brent stopping
C          criterion as well as the NAG ones and it has a maximum number
C          of iterations as set by parameter ICMAX. It will not usually have
C          f(x)*f(y) < 0 on exit and may not trap poles with IFAIL = 4.
C          Pole trapping is controlled by BIGVAL and FSAV.
C          A further difference is that Y = X at the normal solution to
C          avoid situations when a quick, or one step solution leaves Y
C          still at or near the starting estimate.
C
C
      IMPLICIT   NONE
      INTEGER    IFAIL, IND, IR
      DOUBLE PRECISION CVAL(17), FX, TOLX, X, Y
C
C Local variables
C
      INTEGER    ICMAX
      PARAMETER (ICMAX = 1000)
      INTEGER    ICOUNT
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, THREE, TEN
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, THREE = 3.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION BIGVAL
      PARAMETER (BIGVAL = 1.0D+09)
      DOUBLE PRECISION EPSI, TOLSAV, TOLTMP
      DOUBLE PRECISION A, B, C, D, E, FA, FB, FC, FSAV
      DOUBLE PRECISION ABSDEL, DELTA, P, Q, R, S, T, Z
      DOUBLE PRECISION X02AJF$
      PARAMETER (X02AJF$ = 1.111307226798D-016)
      LOGICAL    DONE
      INTRINSIC  ABS, SIGN, MAX, MIN
      SAVE ICOUNT
      SAVE A, B, C, D, E, EPSI, FA, FB, FC, FSAV, TOLSAV
      DATA ICOUNT / 0 /
      DATA    A,   B,   C,   D,   E, EPSI,  FA,  FB,  FC, FSAV, TOLSAV
     +    / ONE, ONE, ONE, ONE, ONE,  ONE, ONE, ONE, ONE,  ONE, ONE /
C
C Is it safe ?
C
      IFAIL = 0
      IF (IND.LT. -1) THEN
C
C Error
C
         IND = 0
         IFAIL = 2
         RETURN
      ELSEIF (IND.EQ. -1) THEN
C
C Special case IND = -1 ... Entry with A, B, FA, FB already defined
C
         ICOUNT = 2
         A = Y
         FA = CVAL(1)
         B = X
         FB = FX
         FC = FB
         IND = 3
         IF (FA*FB.GT.ZERO) THEN
            IND = 0
            IFAIL = 1
            RETURN
         ENDIF
         IF (TOLX.LE.ZERO .OR. IR.LT.0 .OR. IR.GT.2) THEN
            IND = 0
            IFAIL = 3
            RETURN
         ENDIF
         FSAV = ABS(FA) + ABS(FB)
         EPSI = TEN*X02AJF$
         TOLSAV = MAX(TOLX, EPSI)
      ELSEIF (IND.EQ.0) THEN
C
C Error
C
         IFAIL = 2
         RETURN
      ELSEIF (IND.EQ.1) THEN
C
C First call with IND = 1 ... Set ICOUNT = 0, IND = 2 and return for A, FA
C
         ICOUNT = 0
         IND = 2
         IF (TOLX.LE.ZERO .OR. IR.LT.0 .OR. IR.GT.2) THEN
            IND = 0
            IFAIL = 3
            RETURN
         ENDIF
         EPSI = TEN*X02AJF$
         TOLSAV = MAX(TOLX, EPSI)
         RETURN
      ELSEIF (IND.EQ.2) THEN
C
C Second call after first entering with IND = 1 ... Set IND = 3
C
         ICOUNT = 1
         A = X
         FA = FX
         C = X
         X = Y
         Y = C
         IND = 3
         RETURN
      ELSEIF (IND.EQ.3) THEN
C
C Third call after first entering with IND = 1 ... Set IND = 3
C
         ICOUNT = 2
         B = X
         FB = FX
         FC = FB
         IF (FA*FB.GT.ZERO) THEN
            IND = 0
            IFAIL = 1
            RETURN
         ENDIF
         FSAV = ABS(FA) + ABS(FB)
      ELSEIF (IND.EQ.4) THEN
C
C Usual entry when routine is under way ... Set FB = FX
C
         FB = FX
      ELSEIF (IND.GT.4) THEN
C
C Error
C
         IND = 0
         IFAIL = 2
         RETURN
      ENDIF
C
C Check that maximum iteration count has not been exceeded
C
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.ICMAX) THEN
         IND = 0
         IFAIL = 5
         RETURN
      ELSE
C
C First see if estimates need swapping around
C
         IF (FB*FC.GT.ZERO) THEN
            C = A
            FC = FA
            D = B - A
            E = D
         ENDIF
C
C Make sure B is the best estimate
C
         IF (ABS(FC).LT.ABS(FB)) THEN
            A = B
            B = C
            C = A
            FA = FB
            FB = FC
            FC = FA
         ENDIF
C
C Calculate the stopping parameter and step
C
         TOLTMP = TWO*EPSI*ABS(B) + HALF*TOLSAV
         DELTA = HALF*(C - B)
         ABSDEL = ABS(DELTA)
C
C Done if function value is very small
C
         Z = ABS(FB)
         IF (Z.GT.ZERO) THEN
            DONE = .FALSE.
         ELSE
            DONE = .TRUE.
         ENDIF
C
C Done if the step is very small
C
         Z = ABS(B)
         IF (IR.EQ.0) THEN
            IF (ABSDEL.LT.TOLSAV*MAX(ONE, Z)) DONE = .TRUE.
         ELSEIF (IR.EQ.1) THEN
            IF (ABSDEL.LT.TOLSAV) DONE = .TRUE.
         ELSE
            IF (ABSDEL.LT.TOLSAV*Z) DONE = .TRUE.
         ENDIF
         IF (ABSDEL.LE.TOLTMP) DONE = .TRUE.
C
C If the root has been located set X to the estimate and stop
C
         IF (DONE) THEN
            IND = 0
            FC = ABS(FA) + ABS(FB) + ABS(FC)
C
C Is it a pole instead of a zero ?
C
            IF (FC.GT.BIGVAL*FSAV) THEN
               IFAIL = 4
            ELSE
               IFAIL = 0
            ENDIF
C
C Finally set Y = X then finish (indicated by IND = 0)
C
            X = B
            Y = B
            RETURN
         ENDIF
C
C Try quadratic or linear interpolation
C
         IF (ABS(E).GE.TOLTMP .AND. ABS(FA).GT.ABS(FB)) THEN
            IF (A.LT.C .OR. A.GT.C) THEN
C
C Three distinct points
C
               R = FB/FC
               S = FB/FA
               T = FA/FC
               P = S*(TWO*DELTA*T*(T - R) - (B - A)*(R - ONE))
               Q = (T - ONE)*(R - ONE)*(S - ONE)
            ELSE
C
C Only two distinct points
C
               S = FB/FA
               P = TWO*DELTA*S
               Q = ONE - S
            ENDIF
C
C Make sure bounds are not exceeded
C
            IF (P.GT.ZERO) THEN
               Q =  - Q
            ELSE
               P =  - P
            ENDIF
C
C Choose between interpolant and bisection
C
            IF (TWO*P .LT.
     +          MIN(THREE*DELTA*Q - ABS(TOLTMP*Q), ABS(E*Q))) THEN
               E = D
               D = P/Q
            ELSE
               D = DELTA
               E = D
            ENDIF
         ELSE
C
C Otherwise use bisection
C
            D = DELTA
            E = D
         ENDIF
C
C Set previous estimates to A and FA
C
         A = B
         FA = FB
C
C Adjust the estimate for another try
C
         IF (ABS(D).GT.TOLTMP) THEN
            B = B + D
         ELSE
            B = B + SIGN(TOLTMP, DELTA)
         ENDIF
C
C Return for another function evaluation
C
         X = B
         Y = A
         IND = 4
      ENDIF
      END
C
C
