C
C
      SUBROUTINE INDEXR (INDEXX, N,
     +                   A)
C
C ACTION: provide an index to A if A was to be sorted in nondecreasing order
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 16/06/2001
C         16/10/2007 added INTENTS
C
C         N = Dimension (INPUT: unchanged)
C         A = Input array (INPUT: unchanged)
C         INDEXX = list of positions if sorted (OUTPUT)
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      INTEGER,          INTENT (OUT) :: INDEXX(N)
      DOUBLE PRECISION, INTENT (IN)  :: A(N)
C
C Locals
C      
      INTEGER  I, ICOUNT, IRANK, J, L
      DOUBLE PRECISION VALUE
C
C Initialise
C
      IF (N.LT.1) RETURN
      DO I = 1, N
        INDEXX(I) = I
      ENDDO
      IF (N.EQ.1) RETURN
      L = N/2 + 1
      IRANK = N
C
C Heapsort but using INDEXX
C
   20 CONTINUE
      IF (L.GT.1) THEN
         L = L - 1
         ICOUNT = INDEXX(L)
         VALUE = A(ICOUNT)
      ELSE
         ICOUNT = INDEXX(IRANK)
         VALUE = A(ICOUNT)
         INDEXX(IRANK) = INDEXX(1)
         IRANK = IRANK - 1
         IF (IRANK.EQ.1) THEN
C
C Return if finished
C
            INDEXX(1) = ICOUNT
            RETURN
         ENDIF
      ENDIF
      I = L
      J = L + L
   40 CONTINUE
      IF (J.LE.IRANK) THEN
         IF (J.LT.IRANK) THEN
            IF (A(INDEXX(J)).LT.A(INDEXX(J + 1))) J = J + 1
         ENDIF
         IF (VALUE.LT.A(INDEXX(J))) THEN
            INDEXX(I) = INDEXX(J)
            I = J
            J = J + J
         ELSE
            J = IRANK + 1
         ENDIF
         GOTO 40
      ENDIF
      INDEXX(I) = ICOUNT
C
C Another go if unfinished
C
      GOTO 20
      END
C
C