C
C
      SUBROUTINE KSPROB (N1, N2, D, D1, D5, P)
C
C ACTION: Kolmogorov-Smirnov probabilities for two samples
C AUTHOR: W.G.Bardsley, University of Manchester, U.K. 27/04/2004
C         This uses the method described in:-
C         Neumann Statistical Software Newsletter 14, no.3, 120-126 (1988)
C         Test values agree with Massey Ann Math Stat 22, 125-128 (1951)
C         but do not agree exactly with NAG
C
C         N1: (input/unchanged) sample size
C         N2: (input/unchanged) sample size
C          D: (input/unchanged) KS D value
C         D1: (output) 1% critical value from PROBKS
C         D5: (output) 5% critical value from PROBKS
C          P: (output) upper tail P value
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER    N1, N2
      DOUBLE PRECISION D, D1, D5, P
C
C Locals
C
      INTEGER    J, M, NSUM, NDUMMY, NRATIO
      INTEGER    MAX_SIZE
      PARAMETER (MAX_SIZE = 1000)
      DOUBLE PRECISION DN1, DN2, RATIO
      DOUBLE PRECISION DLAM, DLOWER, DS, DUPPER, WORK(-1:MAX_SIZE)
      DOUBLE PRECISION ALPHA, ZERO, ONE
      PARAMETER (ALPHA = 1.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   PROBKS
      INTRINSIC  ABS, DBLE, NINT
C
C Call PROBKS and return for large samples
C
      DN1 = DBLE(N1)
      DN2 = DBLE(N2)
      RATIO = DN1*DN2/(DN1 + DN2)
      NRATIO = NINT(RATIO)
      CALL PROBKS (NRATIO, D, D1, D5, P)
      IF (N1.GT.60 .OR. N2.GT.60 .OR. N1 + N2 .GT. 100) RETURN
C
C Use the algorithm
C
      IF (N1.LT.1 .OR. N2.LT.1) RETURN
      NSUM = N1 + N2
      WORK(-1) = ZERO
      WORK(0) = ONE
      DS = DN1*DN2*D
      DO M = 1, NSUM
         IF (M.LT.N1) THEN
            NDUMMY = M
         ELSE
            NDUMMY = N1
         ENDIF
         DO J = NDUMMY, 0 , -1
            DLOWER = ABS(DBLE(N2*J - N1*(M - J)))
            IF (N2*J .LT. N1*(M - J)) THEN
               DUPPER = DBLE(N1*(M - J))
            ELSE
               DUPPER = DBLE(N2*J)
            ENDIF
            IF (DS.LT.DLOWER) THEN
               WORK(J) = ZERO
            ELSEIF (DS.GE.DUPPER) THEN
               WORK(J) = ONE
            ELSE
               DLAM = DBLE(J)/(DBLE(J) + ALPHA*DBLE(M - J))
               WORK(J) = DLAM*WORK(J - 1) + (ONE - DLAM)*WORK(J)
            ENDIF
         ENDDO
      ENDDO
      P = ONE - WORK(N1)
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
      END
C
C
