C
C
      SUBROUTINE MTSORT (NCOL, NRMAX, NROW,
     +                   A,
     +                   ABORT)
C
C ACTION : Sort A(.,1) using HEAPSORT then re-order A(.,.) accordingly
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/07/2004
C          03/10/2007 made ATEMP allocatable
C
C         NCOL: (input/unchanged) column dimension
C        NRMAX: (input/unchanged) maximum row dimension
C         NROW: (input/unchanged) current row dimension
C            A: (input/output) returned with rows rearranged so that column 1
C                              is in nondecreasing order
C        ABORT: (output)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCOL, NRMAX, NROW
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCOL)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Allocatable array
C      
      DOUBLE PRECISION, ALLOCATABLE :: ATEMP(:) 
C
C Locals
C
      INTEGER    NCMAX
      INTEGER    I, IERR, J, K, L, M, N
      LOGICAL    OK
C
C Check input data
C
      IF (NROW.LT.2 .OR. NROW.GT.NRMAX .OR. NCOL.LT.1) THEN
         ABORT = .TRUE.
         RETURN
      ELSE   
         ABORT = .FALSE.
      ENDIF   
C
C Check if already sorted
C
      I = 1
      OK = .TRUE.
      DO WHILE (OK .AND. I.LT.NROW)
         I = I + 1
         IF (A(I,1).LT.A(I - 1,1)) OK = .FALSE.
      ENDDO
      IF (OK) RETURN
C
C Allocate
C        
      NCMAX = NCOL
      IERR = 0
      IF (ALLOCATED(ATEMP)) DEALLOCATE(ATEMP, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(ATEMP(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN     
C
C Heapsort
C
      N = NROW
      L = N/2 + 1
      K = N
   20 CONTINUE
         IF (L.GT.1) THEN
            L = L - 1
            DO M = 1, NCOL
               ATEMP(M) = A(L,M)
            ENDDO
         ELSE
            DO M = 1, NCOL
               ATEMP(M) = A(K,M)
            ENDDO
            DO M = 1, NCOL
               A(K,M) = A(1,M)
            ENDDO
            K = K - 1
            IF (K.EQ.1) THEN
               DO M = 1, NCOL
                  A(1,M) = ATEMP(M)
               ENDDO
               GOTO 60
            ENDIF
         ENDIF
         I = L
         J = L + L
   40    IF (J.LE.K) THEN
            IF (J.LT.K) THEN
               IF (A(J,1).LT.A(J + 1,1)) J = J + 1
            ENDIF
            IF (ATEMP(1).LT.A(J,1)) THEN
               DO M = 1, NCOL
                  A(I,M) = A(J,M)
               ENDDO
               I = J
               J = J + J
            ELSE
               J = K + 1
            ENDIF
            GOTO 40
         ENDIF
         DO M = 1, NCOL
            A(I,M) = ATEMP(M)
         ENDDO
         GOTO 20
   60 CONTINUE
      DEALLOCATE(ATEMP, STAT = IERR)
      END
C
C
