C
C uses PKS2 = ACM 487 to calculate probabilities
C
      SUBROUTINE PROBKS (N, D, D1, D5, P)
C
C ACTION : Input N and D and return D1, D5 and P(Kolmogorov-Smirnov >= D)
C ADVICE : Table used for D1 and D2 when N =< 50. See NAG G08CAF
C          PKS2 used for small samples o/w series
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 10/3/93
C          05/04/2000 Added call to PKS2 for small samples
C          27/04/2004 included X01AAF$ and x02AMF$ in line so the routine
C                     is then independent of the NAG-substitute routines
C                     Also enlarged table to N = 50
C          Date of this version 27/04/2004
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    NTABLE
      PARAMETER (NTABLE = 50)
      INTEGER    I
      DOUBLE PRECISION D, D1, D5, P
      DOUBLE PRECISION ARG, ENEG, FCN, PI, TEMP, X01AAF$, X02AMF$, Z
      DOUBLE PRECISION TABLE1(NTABLE), TABLE5(NTABLE)
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PKS2
      EXTERNAL   PKS2
      INTRINSIC  DBLE, EXP, LOG, MAX, SQRT
      DATA TABLE1 /
     +.9950D+00, .9292D+00, .8290D+00, .7342D+00, .6685D+00,
     +.6166D+00, .5758D+00, .5418D+00, .5133D+00, .4889D+00,
     +.4677D+00, .4490D+00, .4325D+00, .4176D+00, .4042D+00,
     +.3920D+00, .3809D+00, .3706D+00, .3612D+00, .3524D+00,
     +.3443D+00, .3367D+00, .3295D+00, .3229D+00, .3165D+00,
     +.3106D+00, .3050D+00, .2997D+00, .2947D+00, .2899D+00,
     +.2852D+00, .2809D+00, .2768D+00, .2728D+00, .2690D+00,
     +.2653D+00, .2618D+00, .2584D+00, .2552D+00, .2521D+00,
     +.2490D+00, .2461D+00, .2433D+00, .2406D+00, .2380D+00,
     +.2354D+00, .2330D+00, .2306D+00, .2283D+00, .2260D+00 /
      DATA TABLE5 /
     +.9750D+00, .8419D+00, .7076D+00, .6239D+00, .5633D+00,
     +.5192D+00, .4834D+00, .4543D+00, .4300D+00, .4093D+00,
     +.3912D+00, .3754D+00, .3614D+00, .3489D+00, .3376D+00,
     +.3273D+00, .3180D+00, .3094D+00, .3014D+00, .2940D+00,
     +.2872D+00, .2809D+00, .2749D+00, .2693D+00, .2640D+00,
     +.2591D+00, .2544D+00, .2499D+00, .2457D+00, .2417D+00,
     +.2379D+00, .2342D+00, .2307D+00, .2274D+00, .2243D+00,
     +.2212D+00, .2183D+00, .2154D+00, .2127D+00, .2101D+00,
     +.2076D+00, .2052D+00, .2028D+00, .2006D+00, .1984D+00,
     +.1963D+00, .1942D+00, .1922D+00, .1903D+00, .1884D+00 /
C
C Initialise
C
      X01AAF$ = 3.14159265358979323846264338328D+00
      X02AMF$ = 2.574667400493D-308
      ENEG = LOG(1.0D+09*X02AMF$)
      PI = X01AAF$
      TEMP = DBLE(N)
      Z = SQRT(TEMP)*D
C
C Calculate P
C
      IF (N.LE.140 .AND. D.LE.0.1D+00 .OR.
     +    N.LE.70  .AND. D.LE.0.2D+00 .OR.
     +    N.LE.60  .AND. D.LE.0.3D+00 .OR.
     +    N.LE.50  .AND. D.LE.0.5D+00 .OR.
     +    N.LE.40  .AND. D.LE.0.6D+00 .OR.
     +    N.LE.30  .AND. D.LE.0.7D+00 .OR.
     +    N.LE.20  .AND. D.LE.0.8D+00 .OR.
     +    N.LE.10) THEN
         FCN = PKS2 (N, D)
      ELSEIF (Z.LE.0.27D+00) THEN
         FCN = ZERO
      ELSEIF (Z.LE.ONE) THEN
         TEMP = (PI**2)/(8.0D+00*Z**2)
         FCN = ZERO
         DO I = 1, 3
            ARG = MAX(ENEG, - TEMP*(TWO*I - ONE)**2)
            FCN = FCN + EXP(ARG)
         ENDDO
         FCN = FCN*(SQRT(TWO*PI))/Z
      ELSEIF (Z.LE.3.1D+00) THEN
         FCN = ZERO
         TEMP = ONE
         DO I = 1, 4
            ARG = MAX(ENEG, - TWO*I**2*Z**2)
            FCN = FCN + TEMP*EXP(ARG)
            TEMP = - TEMP
         ENDDO
         FCN = ONE - TWO*FCN
      ELSE
         FCN = ONE
      ENDIF
      P = ONE - FCN
C
C Check P
C
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
C
C Critical values D1 and D5
C
      IF (N.LE.NTABLE) THEN
         D1 = TABLE1(N)
         D5 = TABLE5(N)
      ELSE
         ARG = DBLE(N)
         TEMP = SQRT(ARG)
         D1 = 1.62762D+00/TEMP
         D5 = 1.35810D+00/TEMP
      ENDIF
      END
C
C
