c
c
      subroutine pseudo (ncol, nrank, nrmax, nrow,
     +                   a, rcond)
c
c action: inverse (or pseudo inverse) of a nrow by ncol matrix
c author: w.g.bardsley, university of manchester, u.k., 08/07/2011
c
c  ncol: number of columns of matrix a ... unchanged
c nrank: estimated rank of a           ... output (= 0 if deficient data input)
c nrmax: leading column dimension of a ... unchanged
c  nrow: number of rows of matrix a    ... unchanged
c     a: a(nrmax,*) matrix             ... overwritten by the inverse
c  
c Note: This routine requires that nrow >= ncol and uses the parameter epsi
c       to determine the rank of a.
c       If a is of full rank then a contains the square inverse in the upper left
c       ncol by ncol square on exit.
c       If a is less than full rank then the pseudo inverse is returned as the ncol 
c       by nrow upper left rectangle, so in this case a must be wide enough to contain 
c       the full ncol by nrow pseudo inverse.
c       In other words, the second dimension must be sufficient to hold the pseudo
c       inverse and with a second dimension wide enough to avoid BLAS errors,
c       i.e. max(nrow,ncol) + 2.
c   
      implicit none  
c
c arguments
c      
      integer,          intent (in)    :: ncol, nrmax, nrow
      integer,          intent (out)   :: nrank
      double precision, intent (inout) :: a(nrmax,*)
      double precision, intent (in)    :: rcond
c
c allocatable
c      
      double precision, allocatable :: u(:,:), vt(:,:), s(:)
c
c locals
c       
      integer    i, ierr, j, m, n
      integer    isend
      double precision epsi, smax, smin
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      external   svd000, dgemm
c
c check
c      
      nrank = 0
      if (nrmax.lt.1 .or. ncol.lt.1 .or. nrow.lt.1 .or.
     +    ncol.gt.nrow)return 
c
c allocate
c     
      ierr = 0
      m = nrow
      n = ncol
      if (allocated(u)) deallocate(u, stat = ierr)
      if (ierr.ne.0) return  
      allocate (u(m,m + 2), stat = ierr) 
      if (ierr.ne.0) return
      if (allocated(vt)) deallocate(vt, stat = ierr)
      if (ierr.ne.0) return  
      allocate (vt(n,n + 2), stat = ierr) 
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return  
      allocate (s(n), stat = ierr) 
      if (ierr.ne.0) return  
c        
c calculate the svd
c           
      isend = 5  
      call svd000 (isend, nrmax, m, n, m, n,
     +             a, s, u, vt)
c
c work out the rank and define smax, smin, then sigma inverse
c     
      if (rcond.le.zero) then
         epsi = 0.005d+00
      else
         epsi = rcond
      endif      
      smax = zero 
      do i = 1, n
         if (s(i).gt.smax) smax = s(i)
      enddo
      smin = epsi*smax     
      do i = 1, n
        if (s(i).gt.smin) then
            nrank = nrank + 1
            s(i) = one/s(i)
         endif   
      enddo  
      do j = 1, nrank
         do i = 1, m
            u(i,j) = u(i,j)*s(j)
         enddo  
      enddo 
c
c work out vt-inverse*sigma-inverse*u-inverse where
c u = m by rank
c vt = rank by n
c sigma-inverse is rank by rank
c       
      call dgemm ('T', 'T', n, m, nrank, one, vt, n, u, m, zero, a,
     +            nrmax)
c
c deallocate
c
      deallocate (u, stat = ierr) 
      deallocate (vt, stat = ierr) 
      deallocate (s, stat = ierr)
      end
c
c    
         