C
C
      SUBROUTINE RANKIT (ISEND, N, 
     +                   DATA1, FACTOR, RANK)
C
C ACTION : Calculate ranks and correction factor depending on ISEND
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.,30/4/97
C          20/04/2004 revised
C          18/09/2012 new version calling indexr and ranker
C
C          ISEND: (input/unchanged) controls FACTOR value depending
C                 on type of tie-correction required
C              N: (input/unchanged)
C          DATA1: (input/unchanged)
C         FACTOR: (output) depends on ISEND as follows
C                  ISEND = 1: sum of T(T^2 - 1)/12
C                  ISEND > 1: sum of T(T - 1)/2   
C           RANK: (output) ranks for DATA
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)  :: ISEND, N
      DOUBLE PRECISION, INTENT (IN)  :: DATA1(N)
      DOUBLE PRECISION, INTENT (OUT) :: FACTOR, RANK(N)
C
C Allocatable
C      
      INTEGER, ALLOCATABLE :: IX(:), IR(:) 
C
C Locals
C
      INTEGER    I, IERR, J, NSTART, NSTOP, NTIES
      INTEGER    N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION TEMP, XTIE
      DOUBLE PRECISION ZERO, ONE, TWO, F12
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F12 = 12.0D+00)
      LOGICAL   ACTION
      EXTERNAL  INDEXR, RANKER
      INTRINSIC DBLE
C
C Error exit if N =< 1
C
      FACTOR = ZERO
      RANK(1) = 1 
      IF (N.LE.N1) RETURN
      DO I = 1, N
         RANK(I) = ZERO
      ENDDO   
C
C Allocate
C  
      IERR = 0
      IF (ALLOCATED(IX)) DEALLOCATE(IX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(IR)) DEALLOCATE(IR, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      J = N
      ALLOCATE (IX(J), STAT = IERR)  
      IF (IERR.NE.0) RETURN 
      ALLOCATE (IR(J), STAT = IERR)  
      IF (IERR.NE.0) RETURN
C
C Get the index IX
C        
      CALL INDEXR (IX, N,
     +             DATA1)
C
C Get the ranks IR
C     
      CALL RANKER (IX, IR, N)
C
C Initialise RANK
C      
      DO I = 1, N
         RANK(I) = DBLE(IR(I))
      ENDDO
C
C Search for ties by looping up through nondecreasing data values
C      
      ACTION = .FALSE.        
      NSTART = 0
      NSTOP = 0
      NTIES = 0
      DO I = 2, N
         IF (DATA1(IX(I)).GT.DATA1(IX(I - 1))) THEN
C
C The data are increasing at this point
C           
            IF (ACTION) THEN
C
C Existing ties have to be handled
C              
               ACTION = .FALSE.
               XTIE = DBLE(NTIES + 1)
               TEMP = TEMP + RANK(IX(I - 1))
               TEMP = TEMP/XTIE
               IF (ISEND.EQ.N1) THEN
                  FACTOR = FACTOR + XTIE*(XTIE**2 - ONE)/F12
               ELSEIF (ISEND.GT.N1) THEN
                  FACTOR = FACTOR + XTIE*(XTIE - ONE)/TWO
               ENDIF
               NSTOP = I - 1
               DO J = NSTART, NSTOP
                  RANK(IX(J)) = TEMP  
               ENDDO  
               NTIES = 0
            ENDIF     
         ELSE
C
C The data are not increasing at this point
C           
            ACTION = .TRUE.
            IF (NTIES.EQ.0) THEN
               NTIES = 1
               NSTART = I - 1
               TEMP = RANK(IX(I - 1))
            ELSE
               NTIES = NTIES + 1
               TEMP = TEMP + RANK(IX(I - 1))
            ENDIF 
            IF (I.EQ.N) THEN
C
C Special action is required if it is the last point
C              
               NSTOP = N 
               XTIE = DBLE(NTIES + 1)
               TEMP = TEMP + RANK(IX(I))
               TEMP = TEMP/XTIE
               IF (ISEND.EQ.N1) THEN
                  FACTOR = FACTOR + XTIE*(XTIE**2 - ONE)/F12
               ELSEIF (ISEND.GT.N1) THEN
                  FACTOR = FACTOR + XTIE*(XTIE - ONE)/TWO
               ENDIF
               NSTOP = N
               DO J = NSTART, NSTOP
                  RANK(IX(J)) = TEMP  
               ENDDO
            ENDIF   
         ENDIF
      ENDDO  
      DEALLOCATE (IX, STAT = IERR)
      DEALLOCATE (IR, STAT = IERR)
      END
C
C
