C
C
      SUBROUTINE SVD000 (ISEND, LDA, LDU, LDVT, M, N,
     +                   A, S, U, VT)
C
C ACTION: SVD by LAPACK
C AUTHOR: W.G.Bardsley, University of Manchester, UK, 16/01/2004
C         03/01/2006 introduced ALLOCATE/DEALLOCATE
C
C         ISEND: (input/output)
C                 On entry
C                 ISEND = 1: just return S
C                 ISEND = 2: return S and U(first min(M,N) columns)
C                            i.e., requires U(M,min(M,N))
C                 ISEND = 3: return S and VT(first min(M,N) rows)
C                            i.e., requires VT(min(M,N),N)
C                 ISEND = 4: return S, U(as for 2) and VT(as for 3)
C                            i.e., requires U(M,min(M,N)), VT(min(M,N),N)
C                 ISEND = 5: return S, full-U(M by M) and full-VT(N by N)
C                            i.e., requires U(M,M), VT(N,N)
C                 ISEND = 6: return S, U(as for 2) and VT(as for 5)
C                            i.e., requires U(M,min(M,N)), VT(N,N)
C                 On exit
C                 ISEND = INFO from DGESVD
C                 or ISEND = -100 if incorrect parameters supplied or
C                 failure to allocate/deallocate
C           LDA: (input/unchanged) leading dimension
C           LDU: (input/unchanged) leading dimension
C          LDVT: (input/unchanged) leading dimension
C             M: (input/unchanged) no. rows
C             N: (input/unchanged) no. columns
C             A: (input/output) data which is overwritten
C             S: (output) singular values
C             U: (output) left singular vectors by column
C            VT: (output) right singular vectors by row
C
C Note: it is wise to have wider dimensions in A, U and VT to avoid
C       problems with BLAS routines, in particular A should be at
C       least A(LDA,N + 1).
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    ISEND, LDA, LDU, LDVT, M, N
      DOUBLE PRECISION A(LDA,*), S(*), U(LDU,*), VT(LDVT,*)
C
C Locals
C
      INTEGER    NB, NWMAX
      PARAMETER (NB = 64)
      INTEGER    IERR, LWORK
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:)
      CHARACTER  JOBU*1, JOBVT*1
      EXTERNAL   DGESVD
      INTRINSIC  MAX, MIN
C
C Check that M > 0, N > 0
C
      IF (M.LT.1 .OR. N.LT.1) THEN
         ISEND = -100
         RETURN
      ENDIF
C
C Assign JOBU and JOBVT
C
      IF (ISEND.EQ.1) THEN
         JOBU = 'N'
         JOBVT = 'N'
      ELSEIF (ISEND.EQ.2) THEN
         JOBU = 'S'
         JOBVT = 'N'
      ELSEIF (ISEND.EQ.3) THEN
         JOBU = 'N'
         JOBVT = 'S'
      ELSEIF (ISEND.EQ.4) THEN
         JOBU = 'S'
         JOBVT = 'S'
      ELSEIF (ISEND.EQ.5) THEN
         JOBU = 'A'
         JOBVT = 'A'
      ELSEIF (ISEND.EQ.6) THEN
         JOBU = 'S'
         JOBVT = 'A'
      ELSE
         ISEND = -100
         RETURN
      ENDIF
C
C Create workspace
C
      LWORK = MAX(3*MIN(M,N) + MAX(M,N), 5*MIN(M,N)) + M + N
      NWMAX = NB*N
      IF (LWORK.LT.NWMAX) LWORK = NWMAX
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK)
      ALLOCATE (WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) THEN
         ISEND = -100
         RETURN
      ENDIF
C
C LAPACK
C
      CALL DGESVD (JOBU, JOBVT, M, N, A, LDA, S, U, LDU, VT, LDVT,
     +             WORK, LWORK, ISEND)
C
C Free up workspace
C
      DEALLOCATE (WORK, STAT = IERR)
      IF (IERR.NE.0) THEN
         ISEND = -100
      ENDIF
      END
C
C
