c
c
      subroutine x2ibin (ibin, nbins, nx,
     +                   a, b, x,
     +                   abort)
c
c action: assign x(i) to an integer histogram array with sum = nx
c author: w.g.bardsley, university of manchester, u.k., 19/10/2012
c     
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: nbins, nx
      integer,          intent (out) :: ibin(nbins)
      double precision, intent (in)  :: a, b, x(nx)
      logical,          intent (out) :: abort
c
c locals
c 
      integer   i, j
      double precision aa, bb, delta, step
      intrinsic int
c
c check arguments then assign aa = min(a,b), bb = max(a,b)
c      
      abort = .true.
      if (nbins.lt.2 .or. nx.lt.2) return 
      if (a.lt.b) then
         aa = a
         bb = b
      elseif (a.gt.b) then
         aa = b
         bb = a
      else
         return   
      endif 
c
c fill ibin putting vales out of range into the extreme bins
c      
      do i = 1, nbins
         ibin(i) = 0
      enddo     
      step = (bb - aa)/dble(nbins)
      delta = aa - step
      do i = 1, nx
         j = int((x(i) - delta)/step)
         if (j.lt.1) then
            ibin(1) = ibin(1) + 1
         elseif (j.gt.nbins) then
            ibin(nbins) = ibin(nbins) + 1   
         else
            ibin(j) = ibin(j) + 1
         endif   
      enddo  
      abort = .false.
      end   
c
c

 
