c
c
      subroutine x2ybin (nbins, nx,
     +                   a, b, x, ybin,
     +                   abort)
c
c action: assign x(i) to a double precision histogram array with area = 1
c author: w.g.bardsley, university of manchester, u.k., 19/10/2012
c     
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: nbins, nx
      double precision, intent (out) :: ybin(nbins)
      double precision, intent (in)  :: a, b, x(nx)
      logical,          intent (out) :: abort
c
c locals
c 
      integer    i, j
      double precision aa, bb, delta, step, yadd
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      intrinsic  int
c
c check arguments then assign aa = min(a,b), bb = max(a,b)
c      
      abort = .true.
      if (nbins.lt.2 .or. nx.lt.2) return 
      if (a.lt.b) then
         aa = a
         bb = b
      elseif (a.gt.b) then
         aa = b
         bb = a
      else
         return   
      endif 
c
c fill ybin putting vales out of range into the extreme bins
c      
      do i = 1, nbins
         ybin(i) = zero
      enddo   
      step = (bb - aa)/dble(nbins)
      delta = aa - step
      yadd = one/(dble(nx)*step)  
      do i = 1, nx
         j = int((x(i) - delta)/step)
         if (j.lt.1) then
            ybin(1) = ybin(1) + yadd
         elseif (j.gt.nbins) then
            ybin(nbins) = ybin(nbins) + yadd   
         else
            ybin(j) = ybin(j) + yadd
         endif   
      enddo  
      abort = .false.
      end   
c
c
                      