c
c
      subroutine ztranz (ifail, nrmax, nrow,
     +                   a, x, ztz)
c
c action: return (z^T)z = x^T(A^{-1})x = x^T(R^TR)^{-1}x
c author: w.g.bardsley, university of manchester, u.k., 12/09/2012
c
c ifail: returned as follows
c        ifail = 0: OK
c        ifail < 0: if = -100: allocation or dimension error
c                   o/w argument number ifail is incorrect
c        ifail > 0: not pos def at minor number ifail
c nrmax: leading dimension of A
c  nrow: row dimension of A
c     A: pos def symmetric matrix (only upper triangle used)
c     x: vector
c   ztz: (z^T)z
c
c     
      implicit none
c
c arguments
c      
      integer,          intent (out) :: ifail
      integer,          intent (in)  :: nrmax, nrow
      double precision, intent (in)  :: a(nrmax,nrow), x(nrow)
      double precision, intent (out) :: ztz
c
c allocatable
c      
      double precision, allocatable :: b(:), u(:,:), p(:)
c
c locals
c      
      integer    inc
      parameter (inc = 1)
      integer    i, info, ierr, j, k, n
      double precision dnrm2
      double precision zero
      parameter (zero = 0.0d+00)
      external   dpotrf, dtpsv, dnrm2
c
c initialise ifail and ztz
c      
      ifail = -100
      ztz = zero
      if (nrow.lt.1 .or. nrow.gt.nrmax) return
      ierr = 0
      if (allocated(u))deallocate(u, stat = ierr)
      if (ierr.ne.0) return
      n = nrow
      allocate (u(n,n), stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      allocate (b(n), stat = ierr)
      if (ierr.ne.0) return
      i = n*(n + 1)/2
      if (allocated(p)) deallocate(p, stat = ierr)
      if (ierr.ne.0) return
      allocate (p(i), stat = ierr)
      if (ierr.ne.0) return  
c
c copy upper triangle of A into U
c          
      do i = 1, n
         do j = i, n   
            u(i,j) = a(i,j)
         enddo  
      enddo 
c
c generate R as upper triangle of U
c         
      call dpotrf ('U', n, u, n, info)
      if (info.ne.0) then
         ifail = info
         return
      endif 
c
c copy x into b
c      
      do i = 1, n
         b(i) = x(i)
      enddo
c
c copy upper triangle of U into p
c      
      k = 0
      do j = 1, n
         do i = 1, j
            k = k + 1
            p(k) = u(i, j)
         enddo  
      enddo
c
c solve R^Tz = x
c      
      call dtpsv ('U', 'T', 'N', n, p, b, inc)
c
c calculate z^Tz
c      
      ztz = dnrm2(n,
     +          b,
     +          inc)
      ztz = ztz*ztz
      ifail = 0
      deallocate (b, stat = ierr)
      deallocate (u, stat = ierr)
      deallocate (p, stat = ierr)
      end
c      
c



      