c
c
      double precision function beta_cdf (a_in, b_in, x_in) 
c
c action: calculate the beta cdf using slatec dbetai
c author: w.g.bardsley, university of manchester, u.k., 01/05/2019
c      
      implicit none
c
c arguments
c
      double precision, intent (in) :: a_in, b_in, x_in
c      
c locals       
c
      double precision dbetai
      double precision a, b, x
      double precision amin, bmin, one, xmax, xmin
      parameter (amin = 1.0d-10, bmin = amin, one = 1.0d+00, 
     +           xmin = 1.0d-10, xmax = one - xmin)
      external  dbetai
      a = a_in
      b = b_in
      x = x_in
      if (a.lt.amin) a = amin
      if (b.lt.bmin) b = bmin
      if (x.lt.xmin) then
         x = xmin
      elseif (x.gt.xmax) then
         x = xmax
      endif  
      beta_cdf = dbetai (x, a, b)
      end
c
c  


