C
C
      SUBROUTINE G03IJK (I, J, K, N, NTYPE)
C
C ACTION: returns K given I, J, or I, J given K and N
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 15/07/2001
C         25/05/2008 improved calculation of I, J given K
C         23/03/2013 added data for K =< NMAX
C                
C         NTYPE = 1: calculate K given I and J
C         NTYPE = 2: calculate I and J given K and N
C
C         It is supposed that I, J refer to the strict lower triangle
C         of a matrix while K is the equivalent position in the matrix
C         strict lower triangle packed by rows.
C         Note: I > J >= 1, and K = (I - 1)*(I - 2)/2 + J 
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)    :: N, NTYPE
      INTEGER, INTENT (INOUT) :: I, J, K
C
C Locals
C      
      INTEGER    NMAX
      PARAMETER (NMAX = 45)
      INTEGER    KK
      INTEGER    ISAV(NMAX), JSAV(NMAX)
      DOUBLE PRECISION TWO, THREE, SEVEN, EIGHT
      PARAMETER (TWO = 2.0D+00, THREE = 3.0D+00,
     +           SEVEN = 7.0D+00, EIGHT = 8.0D+00)
      INTRINSIC  SQRT, NINT
      DATA       ISAV / 2,  3,  3,  4,  4,  4,  5,  5,  5,  5,
     +                  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,
     +                  7,  8,  8,  8,  8,  8,  8,  8,  9,  9,
     +                  9,  9,  9,  9,  9,  9, 10, 10, 10, 10,
     +                 10, 10, 10, 10, 10 /
      DATA       JSAV / 1,  1,  2,  1,  2,  3,  1,  2,  3,  4,
     +                  1,  2,  3,  4,  5,  1,  2,  3,  4,  5,
     +                  6,  1,  2,  3,  4,  5,  6,  7,  1,  2,
     +                  3,  4,  5,  6,  7,  8,  1,  2,  3,  4,
     +                  5,  6,  7,  8,  9 /
      IF (NTYPE.EQ.1) THEN 
C
C Return K given I, J: K = 0 on error
C
         K = 0
         IF (I.GT.1 .AND. J.GT.0 .AND. I.GT.J) THEN
            IF (I.EQ.2) THEN
               K = 1
            ELSEIF (I.EQ.3) THEN
               K = J + 1
            ELSE
               K = (I - 2)*(I - 1)/2 + J
            ENDIF
         ENDIF
      ELSEIF (NTYPE.EQ.2) THEN
C
C Return I and J given K and N: I and J = 0 on error
C
         I = 0
         J = 0
         IF (K.GE.1 .AND. K.LE.(N*(N - 1))/2) THEN
            IF (K.LE.NMAX) THEN
               I = ISAV(K)
               J = JSAV(K)
            ELSE   
               I = NINT((THREE + SQRT(EIGHT*K - SEVEN))/TWO)
               KK = (I - 1)*(I - 2)/2 + 1
               IF (KK.LT.K) THEN
C
C Initial guess is too low
C                 
                  DO WHILE (KK.LT.K)
                     I = I + 1          
                     KK = (I - 1)*(I - 2)/2 + 1
                  ENDDO
                  I = I - 1
               ELSEIF (KK.GT.K) THEN
C
C Initial guess is too high
C               
                  DO WHILE (KK.GT.K)
                     I = I - 1          
                     KK = (I - 1)*(I - 2)/2 + 1
                  ENDDO
               ENDIF     
               KK = (I - 1)*(I - 2)/2
               J = K - KK   
            ENDIF  
         ENDIF
      ENDIF
      END
C
C
