c
c
      subroutine nxxbar (n,
     +                   x, xbar, xvar)
c
c action: one-pass version of nxxbar to supply x(n) then return sample mean and variance
c author: w.g.bardsley, university of manchester, u.k., 28/07/2011
c  
c Note: xbar = sum x(i)/n
c       xvar = sum (x(i) - xbar)**2/(n - 1) 
c   
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: n
      double precision, intent (in)  :: x(n)
      double precision, intent (out) :: xbar, xvar 
c
c locals
c            
      integer i
      double precision di_before, di_now
      double precision xbar_before, xbar_now
      double precision xdiff
      double precision xvar_before, xvar_now
      double precision zero, one, two
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00)
      if (n.lt.1) then
c
c special case n < 1
c        
         xbar = zero
         xvar = zero
      elseif (n.eq.1) then
c
c special case n = 1
c      
         xbar = x(1)
         xvar = zero
      elseif (n.eq.2) then
c
c special case n = 2
c      
         xbar = (x(1) + x(2))/two 
         xdiff = x(1) - x(2)
         xvar = xdiff*xdiff/two
      else  
c
c calculate if n > 2
c               
         xbar_before = x(1)
         xvar_before = zero
         di_now = one
         do i = 2, n - 1
           di_before = di_now
           di_now = di_now + one
           xdiff = (x(i) - xbar_before)/di_now
           xbar_now = xbar_before + xdiff
           xvar_now = xvar_before + di_now*di_before*xdiff*xdiff
           xbar_before = xbar_now
           xvar_before = xvar_now
         enddo
         di_before = di_now
         di_now = di_now + one 
         xdiff = (x(n) - xbar_before)/di_now
         xbar = xbar_before + xdiff
         xvar = xvar_before/di_before + di_now*xdiff*xdiff   
      endif    
      end   
c
c  
