c
c
      subroutine pderiv (nc, nd,
     +                   c, pd, x)
c
c action: evaluate a polynomial and derivatives at a given value of x 
c author: w.g.bardsley, university of manchester, u.k.
c         developed from the recipes example dpoly 21/04/2020
c
c nc = number of coefficients, i.e. degree = nc - 1   
c nd = number of derivatives required, e.g. 3 for polynomial and first two derivatives
c  c = coefficients
c pd = value of polynomial and derivatives
c  x = value for evaluation
c  The coefficients are in the form f(x) = c(1) + c(2)x + ... + c(nc)x^nc - 1
c  The values returned are pd(1) = f(x), pd(2) = f'(x), pd(3) = f''(x), etc.
c     
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: nc, nd
      double precision, intent (in)  :: c(nc), x 
      double precision, intent (out) :: pd(nd)
c
c locals
c      
      integer i, j, nnd
      double precision const 
      double precision zero, two
      parameter (zero = 0.0d+00, two = 2.0d+00)
      intrinsic dble, min
      pd(1) = c(nc) 
      do j = 2, nd
        pd(j) = zero
      enddo
      do i = nc - 1, 1, -1 
         nnd = min(nd, nc + 1 - i)  
         do j = nnd, 2, -1
            pd(j) = pd(j)*x + pd(j - 1)
         enddo
         pd(1) = pd(1)*x + c(i)  
      enddo
      const = two
      do i = 3, nd
        pd(i) = const*pd(i)
        const = const*dble(i)
      enddo 
      end
c
c                