      DOUBLE PRECISION FUNCTION FSTMED(X,N)
!Double precision version: bill.bardsley@man.ac.uk 16/06/2004
!  FAST ALGORITHM FOR COMPUTING MEDIAN OF SAMPLE OF SIZE N
!
!  ARGUMENTS
!  X   DOUBLE PRECISION VECTOR OF OBSERVATIONS
!  N   INTEGER NUMBER OF OBSERVATIONS
!
!  *** REQUIRED SUBPROGRAMS ***
!  SUBROUTINE PARTIT(X,LEFT,RGHT,NS,NT)    PARTITIONS SET
!  DOUBLE PRECISION FUNCTION RAN(IDUM)     UNIFORM(0,1) RANDOM NUMBERS
!
!  J F MONAHAN
!     RECODED MARCH, APRIL 2000 FOR FORTRAN 95
!
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: N
      DOUBLE PRECISION, DIMENSION(N), INTENT(IN OUT) :: X
      INTEGER J,K,KP,START,SPAN,NS,NT
      DOUBLE PRECISION RAN
      external partit, ran
!
!                   FIND MEDIAN -- K AND KP MAY OR MAY NOT BE DIFFERENT
      K = (N + 1) / 2
      KP = (N + 2) / 2
!                   INITIAL VALUES
      START = 1
      SPAN = N
!                   RESTART HERE
      DO            ! *** UNRESTRICTED DO ***
!                   RANDOM PARTITION ELEMENT (UNLESS TOO SHORT)
      NS = START
      IF( SPAN .GT. 2 ) NS = START + INT( RAN(SPAN)*DBLE(SPAN) )
!                   PARTITION X FROM START TO START+SPAN-1 WITH X(NS)
      CALL PARTIT(X,START,START+SPAN-1,NS,NT)
!                   NS = NUMBER SMALLER, NT = NUMBER TIED
!
!                   PARTITION MAKES TWO SUBLISTS
!
!                   ARE WE NEARLY DONE?
      IF( ( K .GE. START+NS-1 ) .AND. ( KP .LE. START+NS+NT ) ) EXIT
!                   LOOK AMONG SMALLER
      IF( K .LT. START + NS - 1 ) SPAN = NS
!                   LOOK AMONG LARGER
      IF( KP .GT. START + NS + NT ) THEN
      SPAN = SPAN - NS - NT
      START = START + NS + NT
                                    END IF ! ( KP .GT. START + NS + NT )
      END DO  ! *** END UNRESTRICTED DO ***
!                   NEARLY DONE -- MAY HAVE TO FIND MIN OR MAX
      IF( KP .EQ. START+NS+NT ) THEN
!                   FIND MIN OF LARGERS
      FSTMED = X(START+NS+NT)
      SPAN = SPAN - NS - NT
      DO J = 1,SPAN
      FSTMED = MIN( FSTMED, X(START+NS+NT+J-1) )
      END DO  ! LOOP ON J
      IF( K .NE. KP ) FSTMED = ( FSTMED + X(START+NS) ) / 2.
      RETURN
                                END IF ! ( KP .EQ. START+NS+NT )
!
      IF( K .EQ. START+NS-1 ) THEN
!                   FIND MAX OF SMALLERS
      FSTMED = X(START)
      DO J = 1,NS
      FSTMED = MAX( FSTMED, X(START+J-1) )
      END DO  ! LOOP ON J
      IF( K .NE. KP ) FSTMED = ( FSTMED + X(START+NS) ) / 2.
      RETURN
                              END IF ! ( K .EQ. START+NS-1 )
!                   DONE -- MEDIAN IN MIDDLE
      FSTMED = X(START+NS)
      RETURN
      END FUNCTION FSTMED
