      DOUBLE PRECISION FUNCTION HLQEST(X,N)
!double precision version bill.bardsley@man.ac.uk 16/06/2004
!
!    DOUBLE PRECISION FUNCTION HLQEST
!
!    PURPOSE       COMPUTES THE HODGES-LEHMANN LOCATION ESTIMATOR:
!                  MEDIAN OF ( X(I) + X(J) ) / 2   FOR 1 LE I LE J LE N
!
!    USAGE         RESULT = HLQEST(X,N)
!
!    ARGUMENTS  X   DOUBLE PRECISION ARRAY OF OBSERVATIONS  (INPUT)
!                 * VALUES OF X MUST BE IN NONDECREASING ORDER *
!
!               N   INTEGER NUMBER OF OBSERVATIONS  (INPUT)
!                 * N MUST NOT BE LESS THAN 1 *
!
!   EXTERNAL ROUTINE
!              RAN  FUNCTION PROVIDING UNIFORM RANDOM VARIABLES
!                   IN THE INTERVAL (0,1)
!                   RAN REQUIRES A DUMMY INTEGER ARGUMENT
!
!   NOTES           HLQEST HAS AN EXPECTED TIME COMPLEXITY ON
!                   THE ORDER OF N * LG( N )
!
!  J F MONAHAN, APRIL 1982, DEPT OF STAT, N C S U, RALEIGH, N C 27650
!  FINAL VERSION  JUNE 1983
!     RECODED MARCH, APRIL 2000 FOR FORTRAN 95
!
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: N
      DOUBLE PRECISION, DIMENSION(N), INTENT(IN) :: X
      DOUBLE PRECISION AMN,AMX,AM,D
      INTEGER, DIMENSION(N) :: LB,RB,Q
      INTEGER SM,SQ,I,J,K,K1,K2,L,NN,LBI,RBI,MDLROW,IQ,METHOD
      DOUBLE PRECISION RAN
      EXTERNAL RAN
!
!  TAKE CARE OF SPECIAL CASES: N=1 AND N=2
!
      IF( N .EQ. 1 ) THEN
      HLQEST = X(1)
      RETURN
                     END IF ! ( N .EQ. 1 )
      IF( N .EQ. 2 ) THEN
      HLQEST = ( X(1) + X(2) )/2.
      RETURN
                     END IF ! ( N .EQ. 2 )
!
!  FIND THE TOTAL NUMBER OF PAIRS (NN) AND THE MEDIAN(S) (K1,K2) NEEDED
!
      NN = (N*(N+1))/2
      K1 = (NN+1)/2
      K2 = (NN+2)/2
!
!  INITIALIZE LEFT AND RIGHT BOUNDS
!
           DO I = 1,N
           LB(I) = I
           RB(I) = N
           END DO  ! LOOP ON I
!  SM = NUMBER IN SET S AT STEP M
      SM = NN
!  L = NUMBER OF PAIRS LESS THAN THOSE IN SET S AT STEP M
      L = 0
!                   USE MEDIAN AS FIRST PARTITION ELEMENT
      METHOD = 1
!                   *** MAIN LOOP BEGINNING ***
      DO
!                   WHAT TO USE AS PARTITION ELEMENT?
      SELECT CASE(METHOD)
      CASE(1)
!
!  USE THE MEDIAN OF X(I)'S TO PARTITION ON THE FIRST STEP
!
      AM=X( (N+1)/2 ) + X( (N+2)/2 )
      CASE(2)
!
!  USE THE MIDRANGE OF SET S AS PARTITION ELEMENT WHEN TIES ARE LIKELY
!   -- OR GET THE AVERAGE OF THE LAST 2 ELEMENTS
!
           AMX = X(1)+X(1)
           AMN = X(N)+X(N)
                DO I = 1,N
!   SKIP THIS ROW IF NO ELEMENT IN IT IS IN SET S ON THIS STEP
                IF( LB(I) .LE. RB(I) ) THEN
                LBI = LB(I)
!                             GET THE SMALLEST IN THIS ROW
                AMN = MIN( AMN, X(LBI)+X(I) )
                RBI=RB(I)
!                             GET THE LARGEST IN THIS ROW
                AMX = MAX( AMX, X(RBI)+X(I) )
                                   END IF ! ( LB(I) .LE. RB(I) )
                END DO  ! LOOP ON I
           AM = (AMX+AMN)/2.
!  BE CAREFUL TO CUT OFF SOMETHING -- ROUNDOFF CAN DO WIERD THINGS
           IF( (AM.LE.AMN) .OR. (AM.GT.AMX) ) AM=AMX
!  UNLESS FINISHED, JUMP TO PARTITION STEP
           IF( (AMN.EQ.AMX) .OR. (SM.EQ.2) ) THEN
!  ALL DONE IF ALL OF S IS THE SAME -OR- IF ONLY 2 ELEMENTS ARE LEFT
           HLQEST = AM/2.
      RETURN
                                         END IF ! (BOTH)
      CASE DEFAULT
!
!                        USE RANDOM ROW MEDIAN AS PARTITION ELEMENT
           K = INT(DBLE(SM)*RAN(SM))
!                        K IS A RANDOM INTEGER FROM O TO SM-1
                DO I = 1,N
                J = I
                IF( K .LE. RB(I)-LB(I) ) EXIT
                K = K-RB(I)+LB(I)-1
                END DO  ! LOOP ON I
!                        J IS A RANDOM ROW --- NOW GET ITS MEDIAN
           MDLROW = (LB(J)+RB(J))/2
           AM = X(J)+X(MDLROW)
      END SELECT ! (HOW TO PARTITION)
!
!       *****   PARTITION STEP   *****
!
!  USE AM TO PARTITION S0 INTO 2 GROUPS: THOSE .LT. AM, THOSE .GE. AM
!  Q(I)= HOW MANY PAIRS (X(I)+X(J)) IN ROW I LESS THAN AM
           J = N
!                              START IN UPPER RIGHT CORNER
           SQ = 0
!                              I COUNTS ROWS
                DO I = 1,N
                Q(I) = 0
!                              HAVE WE HIT THE DIAGONAL ?
                IF( J .GE. I ) THEN
!                              SHALL WE MOVE LEFT ?
                DO WHILE ( J .GE. I )
                D = X(I) + X(J)         ! AVOID OPTIMIZATION/ARITHMETIC
                IF( D .LT. AM ) EXIT    !  ANOMALIES -- BEWARE!
                J = J-1
                END DO ! WHILE ( J .GE. I )
!                              WE'RE DONE IN THIS ROW
                Q(I) = J-I+1
!  SQ = TOTAL NUMBER OF PAIRS LESS THAN AM
                SQ = SQ+Q(I)
                           END IF ! ( J .GE. I )
                END DO  ! LOOP ON I
!
!  ***  FINISHED PARTITION --- START BRANCHING  ***
!
!  IF CONSECUTIVE PARTITIONS ARE THE SAME WE PROBABLY HAVE TIES
      IF( SQ .EQ. L ) THEN
           METHOD = 2         ! USE MIDRANGE
                  ELSE
!
!  ARE WE NEARLY DONE, WITH THE VALUES WE WANT ON THE BORDER?
!  IF(WE NEED  MAX OF THOSE .LT. AM -OR- MIN OF THOSE .GE. AM) EXIT
!
      IF( SQ .EQ. K2-1 ) EXIT
      IF( SQ .EQ. K1 ) EXIT
!
!  THE SET S IS SPLIT, WHICH PIECE DO WE KEEP?
!  SECOND= CUT OFF BOTTOM,  EXIT =  NEARLY DONE,  FIRST=  CUT OFF TOP
!
      IF(SQ .GT. K1) THEN
!
!  NEW S = (OLD S) .INTERSECT. (THOSE .LT. AM)
!                            RESET RIGHT BOUNDS FOR EACH ROW
           DO I = 1,N
           RB(I) = I+Q(I)-1
           END DO  ! LOOP ON I
                     ELSE
!  NEW S = (OLD S) .INTERSECT. (THOSE .GE. AM)
!                            RESET LEFT BOUNDS FOR EACH ROW
           DO I = 1,N
           LB(I) = I+Q(I)
           END DO  ! LOOP ON I
                     END IF ! ( SQ .GT. K1 )
!
!  COUNT   SM = NUMBER OF PAIRS STILL IN NEW SET S
!           L = NUMBER OF PAIRS LESS THAN THOSE IN NEW SET S
           L = 0
           SM = 0
           DO I = 1,N
           L = L+LB(I)-I
           SM = SM+RB(I)-LB(I)+1
           END DO  ! LOOP ON I
           METHOD = 3         ! NORMAL
!
                  END IF ! ( SQ .EQ. L )
      IF( SM .EQ. 2 ) METHOD = 2
!  CAN ONLY GET TO 2 LEFT IF K1.NE.K2  -- GO GET THEIR AVERAGE
      END DO        !  *** END OF MAIN LOOP ***
!
!  FIND:   MAX OF THOSE .LT. AM
!          MIN OF THOSE .GE. AM
!
           AMN = X(N)+X(N)
           AMX = X(1)+X(1)
                DO I = 1,N
                IQ = Q(I)
                IF( IQ.GT.0) AMX = MAX( AMX, X(I)+X(I+IQ-1) )
                IF( IQ.LT.N-I+1) AMN = MIN( AMN, X(I)+X(I+IQ) )
                END DO  ! LOOP ON I
           HLQEST = (AMN+AMX)/4.
!  WE ARE DONE, BUT WHICH SITUATION ARE WE IN?
      IF( K1 .LT. K2 ) RETURN
      IF( SQ .EQ. K1 ) HLQEST = AMX/2.
      IF( SQ .EQ. K1-1 ) HLQEST = AMN/2.
      RETURN
      END FUNCTION HLQEST
