      SUBROUTINE PARTIT(X,LEFT,RGHT,NS,NT)
!double precision version bill.bardsley@man.ac.uk 16/06/2004
!  ALGORITHM FOR PARTITIONING LIST OF KEYS K FROM X(LEFT) TO X(RGHT)
!   INTO THREE GROUPS: THOSE < X*, THOSE = X*, THOSE > X*
!
!  ARGUMENTS
!  X      IN    DOUBLE PRECISION  LIST OF KEYS TO BE PARTITIONED
!         OUT            PARTITIONED LIST
!                        X(LEFT) ... X(LEFT+NS-1) < X*
!                        X(LEFT+NS) ... X(LEFT+NS+NT-1) = X*
!                        X(LEFT+NS+NT) ... X(RGHT) > X*
!
!  LEFT   IN    INTEGER  LEFT ENDPOINT OF LIST
!  RGHT   IN    INTEGER  RIGHT ENDPOINT OF LIST
!  NS     IN    INTEGER  POINTS TO PARTITION ELEMENT X* = X(NS) (IN)
!         OUT            NUMBER IN LIST < X*
!  NT     OUT   INTEGER  NUMBER IN LIST = X*
!
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: LEFT,RGHT
      INTEGER, INTENT(IN OUT) :: NS
      INTEGER, INTENT(OUT) :: NT
      DOUBLE PRECISION, DIMENSION(RGHT) :: X
      DOUBLE PRECISION XCUT,XX
      INTEGER I,J
!                   USE X(NS) TO SPLIT X
      XCUT = X(NS)
!                   DO NOTHING IF THERE'S NOTHING TO DO
      NS = 0
      NT = 1
      IF( RGHT - LEFT .LE. 0 ) RETURN
!                   FIRST PARITITION TO TWO GROUPS: LT AND GE
!
!                   INITIALIZE POINTERS I (LEFT) AND J (RIGHT)
      I = LEFT
      J = RGHT
      DO WHILE( I .LE. J )
      DO WHILE( X(I) .LT. XCUT )
      I = I + 1
      IF( I .GT. J ) EXIT     ! LAST ONE LT IS I-1
      END DO  ! WHILE ( X(I) .LT. XCUT )
      IF( I .GT. J ) EXIT     ! FINISH
!                   HAVE X(I) OUT OF PLACE
      DO WHILE ( X(J) .GE. XCUT )
      J = J - 1
      IF( I .GE. J ) EXIT
      END DO  ! WHILE ( X(J) .GE. XCUT )
      IF( I .GE. J ) EXIT
!                   HAVE X(J) OUT OF PLACE
!                   EXCHANGE I AND J
      XX = X(I)
      X(I) = X(J)
      X(J) = XX
      I = I + 1
      J = J - 1
      END DO  ! FIRST MAIN WHILE
!                   HALFWAY DONE -- X(I-1) IS END OF SMALLER
      NS = I - LEFT
!                   NOW SEPARATE THE TIED FROM THE LARGER
!
!
!                   INITIALIZE POINTERS I (LEFT) AND J (RIGHT)
      J = RGHT
      DO WHILE( I .LE. J )
      DO WHILE( X(I) .EQ. XCUT )
      I = I + 1
      IF( I .GT. J ) EXIT     ! LAST ONE EQ IS I-1
      END DO  ! WHILE ( X(I) .EQ. XCUT )
      IF( I .GT. J ) EXIT     ! FINISH
!                   HAVE X(I) OUT OF PLACE
      DO WHILE( X(J) .GT. XCUT )
      J = J - 1
      IF( I .GE. J ) EXIT
      END DO  ! WHILE ( X(J) .GT. XCUT )
      IF( I .GE. J ) EXIT
!                   HAVE X(J) OUT OF PLACE
!                   EXCHANGE I AND J
      XX = X(I)
      X(I) = X(J)
      X(J) = XX
      I = I + 1
      J = J - 1
      END DO  ! SECOND MAIN WHILE
      NT = I - LEFT - NS
      RETURN
      END SUBROUTINE PARTIT
