      SUBROUTINE QSORT(K,N)
!double precision version bill.bardsley@man.ac.uk 16/06/2004
!  QUICKSORT ALGORITHM FOR SORTING ON VECTOR OF KEYS K OF LENGTH N
!
!  ARGUMENTS
!  K   DOUBLE PRECISION VECTOR OF KEYS TO BE SORTED
!  N   NUMBER OF ITEMS TO BE SORTED
!
!  *** REQUIRED SUBPROGRAMS ***
!  SUBROUTINE PARTIT(X,LEFT,RGHT,NS,NT)    PARTITIONS SET
!  DOUBLE PRECISION FUNCTION RAN(IDUM)     UNIFORM(0,1) RANDOM NUMBERS
!
!  *** HAS STACK LENGTH OF ONLY 100 *** SHOULD BE PLENTY ***
!  J F MONAHAN
!     RECODED MARCH, APRIL 2000 FOR FORTRAN 95
!
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: N
      DOUBLE PRECISION, DIMENSION(N) :: K
      INTEGER, DIMENSION(100) :: STARTS,SPANS
      INTEGER LSTACK,START,SPAN,NS,NT
      DOUBLE PRECISION RAN
      external partit, ran
!                   START STACK
      LSTACK = 1
      STARTS(LSTACK) = 1
      SPANS(LSTACK) = N
!                   RESTART HERE
      DO WHILE ( LSTACK .GT. 0 )
      START = STARTS(LSTACK)
      SPAN = SPANS(LSTACK)
!                   RANDOM PARTITION ELEMENT (UNLESS TOO SHORT)
      NS = START
      IF( SPAN .GT. 2 ) NS = START + INT( RAN(LSTACK)*DBLE(SPAN) )
!                   PARTITION X FROM START TO START+SPAN-1 WITH X(NS)
      CALL PARTIT(K,START,START+SPAN-1,NS,NT)
      LSTACK = LSTACK - 1
!                   NS = NUMBER SMALLER, NT = NUMBER TIED
!
!                   PARTITION MAKES TWO SUBLISTS, STORE IN STACK
!
!                   THOSE SMALLER THAN PARTITION ELEMENT X(NS) (IN)
      IF( NS .GT. 1 ) THEN
      LSTACK = LSTACK + 1
      STARTS(LSTACK) = START
      SPANS(LSTACK) = NS
                      END IF ! ( NS .GT. 1 )
!                   THOSE LARGER THAN PARTITION ELEMENT X(NS) (IN)
      SPAN = SPAN - NS - NT
      IF( SPAN .GT. 1 ) THEN
      LSTACK = LSTACK + 1
      STARTS(LSTACK) = START + NS + NT
      SPANS(LSTACK) = SPAN
                        END IF ! ( SPAN .GT. 1 )
!                   STACK LENGTH OF 100 SHOULD BE GRACIOUS PLENTY
      IF( LSTACK .GT. 100 ) THEN
      WRITE(*) 'STACK OVERFLOW IN QSORT'
      STOP
                            END IF ! ( LSTACK .GT. 100 )
      END DO  ! WHILE ( LSTACK .GT. 0 )
      RETURN
      END SUBROUTINE QSORT
