C
C
C QUADPACK ROUTINES (ACMTOMS 691)
C ===============================
C DQXGE  (321)
C DQXLQM (118)
C DQXRUL (189)
C DQXRRD (95)
C DQXCPY (20)
C
C
C
CFTN95$OPTIONS(SILENT)
      SUBROUTINE DQXGE(F,A,B,EPSABS,EPSREL,KEY,LIMIT,RESULT,ABSERR,
     *   IER,ALIST,BLIST,RLIST,ELIST,IORD,LAST,VALP,VALN,LP,LN)
C
C
C            THE ROUTINE CALCULATES AN APPROXIMATION RESULT TO A GIVEN
C            DEFINITE INTEGRAL   I = INTEGRAL OF F OVER (A,B),
C            HOPEFULLY SATISFYING FOLLOWING CLAIM FOR ACCURACY
C            ABS(I-RESLT).LE.MAX(EPSABS,EPSREL*ABS(I)).
C
C        PARAMETERS
C         ON ENTRY
C            F      - DOUBLE PRECISION
C                     FUNCTION SUBPROGRAM DEFINING THE INTEGRAND
C                     FUNCTION F(X). THE ACTUAL NAME FOR F NEEDS TO BE
C                     DECLARED E X T E R N A L IN THE DRIVER PROGRAM.
C
C            A      - DOUBLE PRECISION
C                     LOWER LIMIT OF INTEGRATION
C
C            B      - DOUBLE PRECISION
C                     UPPER LIMIT OF INTEGRATION
C
C            EPSABS - DOUBLE PRECISION
C                     ABSOLUTE ACCURACY REQUESTED
C
C            EPSREL - DOUBLE PRECISION
C                     RELATIVE ACCURACY REQUESTED
C                     IF  EPSABS.LE.0
C                     AND EPSREL.LT.MAX(50*REL.MACH.ACC.,0.5D-28),
C                     THE ROUTINE WILL END WITH IER = 6.
C
C            KEY    - INTEGER
C                     KEY FOR CHOICE OF LOCAL INTEGRATION RULE
C                     RMS FORMULAS ARE USED WITH
C                      13 - 19               POINTS IF KEY.LT.1,
C                      13 - 19 - (27)        POINTS IF KEY = 1,
C                      13 - 19 - (27) - (41) POINTS IF KEY = 2,
C                           19 -  27  - (41) POINTS IF KEY = 3,
C                                 27  -  41  POINTS IF KEY.GT.3.
C
C                         (RULES) USED IF THE FUNCTION APPEARS
C                         ENOUGH REGULAR IN THE SUBINTERVAL
C
C            LIMIT  - INTEGER
C                     GIVES AN UPPERBOUND ON THE NUMBER OF SUBINTERVALS
C                     IN THE PARTITION OF (A,B), LIMIT.GE.1.
C
C         ON RETURN
C            RESULT - DOUBLE PRECISION
C                     APPROXIMATION TO THE INTEGRAL
C
C            ABSERR - DOUBLE PRECISION
C                     ESTIMATE OF THE MODULUS OF THE ABSOLUTE ERROR,
C                     WHICH SHOULD EQUAL OR EXCEED ABS(I-RESULT)
C
C            IER    - INTEGER
C                     IER = 0 NORMAL AND RELIABLE TERMINATION OF THE
C                             ROUTINE. IT IS ASSUMED THAT THE REQUESTED
C                             ACCURACY HAS BEEN ACHIEVED.
C                     IER.GT.0 ABNORMAL TERMINATION OF THE ROUTINE
C                             THE ESTIMATES FOR RESULT AND ERROR ARE
C                             LESS RELIABLE. IT IS ASSUMED THAT THE
C                             REQUESTED ACCURACY HAS NOT BEEN ACHIEVED.
C            ERROR MESSAGES
C                     IER = 1 MAXIMUM NUMBER OF SUBDIVISIONS ALLOWED
C                             HAS BEEN ACHIEVED. ONE CAN ALLOW MORE
C                             SUBDIVISIONS BY INCREASING THE VALUE
C                             OF LIMIT.
C                             HOWEVER, IF THIS YIELDS NO IMPROVEMENT IT
C                             IS RATHER ADVISED TO ANALYZE THE INTEGRAND
C                             IN ORDER TO DETERMINE THE INTEGRATION
C                             DIFFICULTIES. IF THE POSITION OF A LOCAL
C                             DIFFICULTY CAN BE DETERMINED(E.G.
C                             SINGULARITY, DISCONTINUITY WITHIN THE
C                             INTERVAL) ONE WILL PROBABLY GAIN FROM
C                             SPLITTING UP THE INTERVAL AT THIS POINT
C                             AND CALLING THE INTEGRATOR ON THE
C                             SUBRANGES. IF POSSIBLE, AN APPROPRIATE
C                             SPECIAL-PURPOSE INTEGRATOR SHOULD BE USED
C                             WHICH IS DESIGNED FOR HANDLING THE TYPE OF
C                             DIFFICULTY INVOLVED.
C                         = 2 THE OCCURRENCE OF ROUNDOFF ERROR IS
C                             DETECTED, WHICH PREVENTS THE REQUESTED
C                             TOLERANCE FROM BEING ACHIEVED.
C                         = 3 EXTREMELY BAD INTEGRAND BEHAVIOUR OCCURS
C                             AT SOME POINTS OF THE INTEGRATION
C                             INTERVAL.
C                         = 6 THE INPUT IS INVALID, BECAUSE
C                             (EPSABS.LE.0 AND
C                              EPSREL.LT.MAX(50*REL.MACH.ACC.,0.5D-28),
C                             RESULT, ABSERR, LAST, RLIST(1) ,
C                             ELIST(1) AND IORD(1) ARE SET TO ZERO.
C                             ALIST(1) AND BLIST(1) ARE SET TO A AND B
C                             RESPECTIVELY.
C
C            ALIST   - DOUBLE PRECISION
C                      VECTOR OF DIMENSION AT LEAST LIMIT, THE FIRST
C                       LAST  ELEMENTS OF WHICH ARE THE LEFT
C                      END POINTS OF THE SUBINTERVALS IN THE PARTITION
C                      OF THE GIVEN INTEGRATION RANGE (A,B)
C
C            BLIST   - DOUBLE PRECISION
C                      VECTOR OF DIMENSION AT LEAST LIMIT, THE FIRST
C                       LAST  ELEMENTS OF WHICH ARE THE RIGHT
C                      END POINTS OF THE SUBINTERVALS IN THE PARTITION
C                      OF THE GIVEN INTEGRATION RANGE (A,B)
C
C            RLIST   - DOUBLE PRECISION
C                      VECTOR OF DIMENSION AT LEAST LIMIT, THE FIRST
C                       LAST  ELEMENTS OF WHICH ARE THE
C                      INTEGRAL APPROXIMATIONS ON THE SUBINTERVALS
C
C            ELIST   - DOUBLE PRECISION
C                      VECTOR OF DIMENSION AT LEAST LIMIT, THE FIRST
C                       LAST  ELEMENTS OF WHICH ARE THE MODULI OF THE
C                      ABSOLUTE ERROR ESTIMATES ON THE SUBINTERVALS
C
C            IORD    - INTEGER
C                      VECTOR OF DIMENSION AT LEAST LIMIT, THE FIRST K
C                      ELEMENTS OF WHICH ARE POINTERS TO THE
C                      ERROR ESTIMATES OVER THE SUBINTERVALS,
C                      SUCH THAT ELIST(IORD(1)), ...,
C                      ELIST(IORD(K)) FORM A DECREASING SEQUENCE,
C                      WITH K = LAST IF LAST.LE.(LIMIT/2+2), AND
C                      K = LIMIT+1-LAST OTHERWISE
C
C            LAST    - INTEGER
C                      NUMBER OF SUBINTERVALS ACTUALLY PRODUCED IN THE
C                      SUBDIVISION PROCESS
C
C            VALP   - DOUBLE PRECISION
C            VALN     ARRAYS OF DIMENSION AT LEAST (21,LIMIT) USED TO
C                     SAVE THE FUNCTIONAL VALUES
C
C            LP     - INTEGER
C            LN       VECTORS OF DIMENSION AT LEAST LIMIT, USED TO
C                     STORE THE ACTUAL NUMBER OF FUNCTIONAL VALUES
C                     SAVED IN THE CORRESPONDING COLUMN
C                     OF VALP,VALN
C
C***ROUTINES CALLED  F,D1MACH,DQXLQM,DQXRRD,DQPSRT,DQXCPY
C
      DOUBLE PRECISION A,ABSERR,ALIST,AREA,AREA1,AREA12,AREA2,A1,A2,B,
     *  BLIST,B1,B2,DABS,DEFABS,DEFAB1,DEFAB2,DMAX1,D1MACH,ELIST,EPMACH,
     *  EPSABS,EPSREL,ERRBND,ERRMAX,ERROR1,ERROR2,ERRO12,ERRSUM,F,
     *  RESABS,RESULT,RLIST,UFLOW,VALP,VALN,VP1,VP2,VN1,VN2
      INTEGER KEY,IER,IORD,IROFF1,IROFF2,K,LAST,LIMIT,MAXERR,
     *  NRMAX,LP,LN,LP1,LP2,LN1,LN2
C
      DIMENSION ALIST(LIMIT),BLIST(LIMIT),ELIST(LIMIT),IORD(LIMIT),
     *  RLIST(LIMIT),VALP(21,LIMIT),VALN(21,LIMIT),LP(LIMIT),LN(LIMIT),
     * VP1(21),VP2(21),VN1(21),VN2(21)
C
      EXTERNAL F
      external dqxlqm, dqpsrt, dqxrrd, dqxcpy, d1mach
      intrinsic dmax1, dabs
C
C            MACHINE DEPENDENT CONSTANTS
C            ---------------------------
C
C          EPMACH IS THE LARGEST RELATIVE SPACING.
C          UFLOW IS THE SMALLEST POSITIVE MAGNITUDE.
C
C***FIRST EXECUTABLE STATEMENT  DQXGE
      EPMACH = D1MACH(4)
      UFLOW = D1MACH(1)
C
C           TEST ON VALIDITY OF PARAMETERS
C           ------------------------------
C
      IER = 0
      LAST = 0
      RESULT = 0.0D+00
      ABSERR = 0.0D+00
      ALIST(1) = A
      BLIST(1) = B
      RLIST(1) = 0.0D+00
      ELIST(1) = 0.0D+00
      IORD(1) = 0
      IF(EPSABS.LE.0.0D+00.AND.
     *  EPSREL.LT.DMAX1(0.5D+02*EPMACH,0.5D-28)) IER = 6
      IF(IER.EQ.6) GO TO 999
C
C           FIRST APPROXIMATION TO THE INTEGRAL
C           -----------------------------------
C
      LP(1)=1
      LN(1)=1
      VALP(1,1)=F((A+B)*0.5D0)
      VALN(1,1)=VALP(1,1)
      CALL DQXLQM(F,A,B,RESULT,ABSERR,DEFABS,RESABS,
     *           VALP(1,1),VALN(1,1),LP(1),LN(1),KEY)
      LAST = 1
      RLIST(1) = RESULT
      ELIST(1) = ABSERR
      IORD(1) = 1
C
C           TEST ON ACCURACY.
C
      ERRBND = DMAX1(EPSABS,EPSREL*DABS(RESULT))
      IF(ABSERR.LE.0.5D+02*EPMACH*DEFABS.AND.ABSERR.GT.ERRBND) IER = 2
      IF(LIMIT.EQ.1) IER = 1
      IF(IER.NE.0.OR.(ABSERR.LE.ERRBND.AND.ABSERR.NE.RESABS)
     *  .OR.ABSERR.EQ.0.0D+00) GO TO 999
C
C           INITIALIZATION
C           --------------
C
C
      ERRMAX = ABSERR
      MAXERR = 1
      AREA = RESULT
      ERRSUM = ABSERR
      NRMAX = 1
      IROFF1 = 0
      IROFF2 = 0
C
C           MAIN DO-LOOP
C           ------------
C
      DO 30 LAST = 2,LIMIT
C
C           BISECT THE SUBINTERVAL WITH THE LARGEST ERROR ESTIMATE.
C
        A1 = ALIST(MAXERR)
        B1 = 0.5D+00*(ALIST(MAXERR)+BLIST(MAXERR))
        A2 = B1
        B2 = BLIST(MAXERR)
        CALL DQXRRD(F,VALN(1,MAXERR),LN(MAXERR),B1,A1,VN1,VP1,LN1,LP1)
        CALL DQXLQM(F,A1,B1,AREA1,ERROR1,RESABS,DEFAB1,VP1,VN1,LP1,LN1,
     *              KEY)
        CALL DQXRRD(F,VALP(1,MAXERR),LP(MAXERR),A2,B2,VP2,VN2,LP2,LN2)
        CALL DQXLQM(F,A2,B2,AREA2,ERROR2,RESABS,DEFAB2,VP2,VN2,LP2,LN2,
     *              KEY)
C
C           IMPROVE PREVIOUS APPROXIMATIONS TO INTEGRAL
C           AND ERROR AND TEST FOR ACCURACY.
C
        AREA12 = AREA1+AREA2
        ERRO12 = ERROR1+ERROR2
        ERRSUM = ERRSUM+ERRO12-ERRMAX
        AREA = AREA+AREA12-RLIST(MAXERR)
        IF(DEFAB1.EQ.ERROR1.OR.DEFAB2.EQ.ERROR2) GO TO 5
        IF(DABS(RLIST(MAXERR)-AREA12).LE.0.1D-04*DABS(AREA12)
     *  .AND.ERRO12.GE.0.99D+00*ERRMAX) IROFF1 = IROFF1+1
        IF(LAST.GT.10.AND.ERRO12.GT.ERRMAX) IROFF2 = IROFF2+1
    5   RLIST(MAXERR) = AREA1
        RLIST(LAST) = AREA2
        ERRBND = DMAX1(EPSABS,EPSREL*DABS(AREA))
        IF(ERRSUM.LE.ERRBND) GO TO 8
C
C           TEST FOR ROUNDOFF ERROR AND EVENTUALLY SET ERROR FLAG.
C
        IF(IROFF1.GE.6.OR.IROFF2.GE.20) IER = 2
C
C           SET ERROR FLAG IN THE CASE THAT THE NUMBER OF SUBINTERVALS
C           EQUALS LIMIT.
C
        IF(LAST.EQ.LIMIT) IER = 1
C
C           SET ERROR FLAG IN THE CASE OF BAD INTEGRAND BEHAVIOUR
C           AT A POINT OF THE INTEGRATION RANGE.
C
        IF(DMAX1(DABS(A1),DABS(B2)).LE.(0.1D+01+0.1D+03*
     *  EPMACH)*(DABS(A2)+0.1D+04*UFLOW)) IER = 3
C
C           APPEND THE NEWLY-CREATED INTERVALS TO THE LIST.
C
    8   IF(ERROR2.GT.ERROR1) GO TO 10
        ALIST(LAST) = A2
        BLIST(MAXERR) = B1
        BLIST(LAST) = B2
        ELIST(MAXERR) = ERROR1
        ELIST(LAST) = ERROR2
        CALL DQXCPY(VALP(1,MAXERR),VP1,LP1)
        LP(MAXERR)=LP1
        CALL DQXCPY(VALN(1,MAXERR),VN1,LN1)
        LN(MAXERR)=LN1
        CALL DQXCPY(VALP(1,LAST),VP2,LP2)
        LP(LAST)=LP2
        CALL DQXCPY(VALN(1,LAST),VN2,LN2)
        LN(LAST)=LN2
        GO TO 20
   10   ALIST(MAXERR) = A2
        ALIST(LAST) = A1
        BLIST(LAST) = B1
        RLIST(MAXERR) = AREA2
        RLIST(LAST) = AREA1
        ELIST(MAXERR) = ERROR2
        ELIST(LAST) = ERROR1
        CALL DQXCPY(VALP(1,MAXERR),VP2,LP2)
        LP(MAXERR)=LP2
        CALL DQXCPY(VALN(1,MAXERR),VN2,LN2)
        LN(MAXERR)=LN2
        CALL DQXCPY(VALP(1,LAST),VP1,LP1)
        LP(LAST)=LP1
        CALL DQXCPY(VALN(1,LAST),VN1,LN1)
        LN(LAST)=LN1
C
C           CALL SUBROUTINE DQPSRT TO MAINTAIN THE DESCENDING ORDERING
C           IN THE LIST OF ERROR ESTIMATES AND SELECT THE SUBINTERVAL
C           WITH THE LARGEST ERROR ESTIMATE (TO BE BISECTED NEXT).
C
   20   CALL DQPSRT(LIMIT,LAST,MAXERR,ERRMAX,ELIST,IORD,NRMAX)
C ***JUMP OUT OF DO-LOOP
        IF(IER.NE.0.OR.ERRSUM.LE.ERRBND) GO TO 40
   30 CONTINUE
C
C           COMPUTE FINAL RESULT.
C           ---------------------
C
   40 RESULT = 0.0D+00
      DO 50 K=1,LAST
        RESULT = RESULT+RLIST(K)
   50 CONTINUE
      ABSERR = ERRSUM
  999 RETURN
      END
C
C
      SUBROUTINE DQXLQM(F,A,B,RESULT,ABSERR,RESABS,RESASC,VR,VS,LR,LS,
     *                  KEY)
C
C            TO COMPUTE I = INTEGRAL OF F OVER (A,B), WITH ERROR
C                           ESTIMATE
C                       J = INTEGRAL OF ABS(F) OVER (A,B)
C
C           PARAMETERS
C            ON ENTRY
C              F      - DOUBLE PRECISION
C                       FUNCTION SUBPROGRAM DEFINING THE INTEGRAND
C                       FUNCTION F(X). THE ACTUAL NAME FOR F NEEDS TO BE
C                       DECLARED E X T E R N A L IN THE DRIVER PROGRAM.
C
C              A      - DOUBLE PRECISION
C                       LOWER LIMIT OF INTEGRATION
C
C              B      - DOUBLE PRECISION
C                       UPPER LIMIT OF INTEGRATION
C
C              VR     - DOUBLE PRECISION
C                       VECTOR OF LENGTH LR CONTAINING THE
C                       SAVED  FUNCTIONAL VALUES OF POSITIVE ABSCISSAS
C
C              VS     - DOUBLE PRECISION
C                       VECTOR OF LENGTH LS CONTAINING THE
C                       SAVED  FUNCTIONAL VALUES OF NEGATIVE ABSCISSAS
C
C              LR     - INTEGER
C              LS       NUMBER OF ELEMENTS IN
C                       VR,VS RESPECTIVELY
C
C            KEY    - INTEGER
C                     KEY FOR CHOICE OF LOCAL INTEGRATION RULE
C                     RMS FORMULAS ARE USED WITH
C                      13 - 19               POINTS IF KEY.LT.1,
C                      13 - 19 - (27)        POINTS IF KEY = 1,
C                      13 - 19 - (27) - (41) POINTS IF KEY = 2,
C                           19 -  27  - (41) POINTS IF KEY = 3,
C                                 27  -  41  POINTS IF KEY.GT.3.
C
C                         (RULES) USED IF THE FUNCTION APPEARS
C                         ENOUGH REGULAR
C
C            ON RETURN
C              RESULT - DOUBLE PRECISION
C                       APPROXIMATION TO THE INTEGRAL I
C
C              ABSERR - DOUBLE PRECISION
C                       ESTIMATE OF THE MODULUS OF THE ABSOLUTE ERROR,
C                       WHICH SHOULD NOT EXCEED ABS(I-RESULT)
C
C              RESABS - DOUBLE PRECISION
C                       APPROXIMATION TO THE INTEGRAL J
C
C              RESASC - DOUBLE PRECISION
C                       APPROXIMATION TO THE INTEGRAL OF ABS(F-I/(B-A))
C                       OVER (A,B)
C
C              VR     - DOUBLE PRECISION
C                       VECTOR OF LENGTH LR CONTAINING THE
C                       SAVED  FUNCTIONAL VALUES OF POSITIVE ABSCISSAS
C
C              VS     - DOUBLE PRECISION
C                       VECTOR OF LENGTH LS CONTAINING THE
C                       SAVED  FUNCTIONAL VALUES OF NEGATIVE ABSCISSAS
C
C              LR     - INTEGER
C              LS       NUMBER OF ELEMENTS IN
C                       VR,VS RESPECTIVELY
C
C***ROUTINES CALLED  D1MACH,DQXRUL
C
      DOUBLE PRECISION F,A,B,RESULT,ABSERR,RESABS,RESASC,
     *          D1MACH,EPMACH,RESG,RESK,UFLOW,ERROLD,VR(21),VS(21)
      INTEGER K,K0,K1,K2,KEY,KEY1,LR,LS
      EXTERNAL F
      external dqxrul, d1mach
      intrinsic max, min, dabs, dmin1, dmax1
C
C            MACHINE DEPENDENT CONSTANTS
C            ---------------------------
C
C          EPMACH IS THE LARGEST RELATIVE SPACING.
C          UFLOW IS THE SMALLEST POSITIVE MAGNITUDE.
C          ERROLD IS THE LARGEST MAGNITUDE.
C
C***FIRST EXECUTABLE STATEMENT DQXLQM
      EPMACH = D1MACH(4)
      UFLOW  = D1MACH(1)
      ERROLD = D1MACH(2)
C
      KEY1 = MAX(KEY ,  0)
      KEY1 = MIN(KEY1,  4)
      K0   = MAX(KEY1-2,0)
      K1   = K0+1
      K2   = MIN(KEY1+1,3)
C
      CALL DQXRUL(F,A,B,RESG,RESABS,RESASC,K0,K1,VR,VS,LR,LS)
      DO 99 K=K1,K2
        CALL DQXRUL(F,A,B,RESK,RESABS,RESASC,K,K1,VR,VS,LR,LS)
        RESULT=RESK
        ABSERR = DABS((RESK-RESG))
        IF(RESASC.NE.0.0D+00.AND.ABSERR.NE.0.0D+00)
     *  ABSERR = RESASC*DMIN1(1.D0,(200D0*ABSERR/RESASC)**1.5D+00)
        IF(RESABS.GT.UFLOW/(10D0*EPMACH)) ABSERR = DMAX1
     *  ((EPMACH*10D0)*RESABS,ABSERR)
        RESG=RESK
        IF(ABSERR.GT.ERROLD*0.16)GOTO 3000
        IF(ABSERR.LT.1000*EPMACH*RESABS)GOTO 3000
        ERROLD=ABSERR
99    CONTINUE
3000  CONTINUE
      RETURN
      END
C
C
C
C
      SUBROUTINE DQXRUL(F,XL,XU,Y,YA,YM,KE,K1,FV1,FV2,L1,L2)
C
C            TO COMPUTE I = INTEGRAL OF F OVER (A,B), WITH ERROR
C                           ESTIMATE
C            AND CONDITIONALLY COMPUTE
C                       J = INTEGRAL OF ABS(F) OVER (A,B)
C                       BY USING AN  RMS RULE
C           PARAMETERS
C            ON ENTRY
C              F      - DOUBLE PRECISION
C                       FUNCTION SUBPROGRAM DEFINING THE INTEGRAND
C                       FUNCTION F(X). THE ACTUAL NAME FOR F NEEDS TO BE
C                       DECLARED E X T E R N A L IN THE DRIVER PROGRAM.
C
C              XL     - DOUBLE PRECISION
C                       LOWER LIMIT OF INTEGRATION
C
C              XU     - DOUBLE PRECISION
C                       UPPER LIMIT OF INTEGRATION
C
C
C              KE     - INTEGER
C                     KEY FOR CHOICE OF LOCAL INTEGRATION RULE
C                     AN RMS RULE IS USED WITH
C                         13      POINTS IF KE  = 2,
C                         19      POINTS IF KE  = 3,
C                         27      POINTS IF KE  = 4,
C                         42      POINTS IF KE  = 5
C
C              K1     INTEGER
C                     VALUE OF KEY FOR WHICH THE ADDITIONAL ESTIMATES
C                     YA, YM ARE TO BE COMPUTED
C
C              FV1    - DOUBLE PRECISION
C                       VECTOR CONTAINING L1
C                       SAVED  FUNCTIONAL VALUES OF POSITIVE ABSCISSAS
C
C              FV2    - DOUBLE PRECISION
C                       VECTOR CONTAINING L2
C                       SAVED  FUNCTIONAL VALUES OF NEGATIVE ABSCISSAS
C
C              L1     - INTEGER
C              L2       NUMBER OF ELEMENTS IN FV1,FV2  RESPECTIVELY
C
C            ON RETURN
C              Y      - DOUBLE PRECISION
C                       APPROXIMATION TO THE INTEGRAL I
C                       RESULT IS COMPUTED BY APPLYING THE
C                       REQUESTED RMS RULE
C
C              YA     - DOUBLE PRECISION
C                       IF KEY = K1  APPROXIMATION TO THE INTEGRAL J
C                       ELSE UNCHANGED
C
C              YM     - DOUBLE PRECISION
C                       IF KEY = K1  APPROXIMATION TO THE INTEGRAL OF
C                                      ABS(F-I/(XU-XL)   OVER (XL,XU)
C                       ELSE UNCHANGED
C
C              FV1    - DOUBLE PRECISION
C                       VECTOR L1 CONTAINING L1
C                       SAVED  FUNCTIONAL VALUES OF POSITIVE ABSCISSAS
C
C              FV2    - DOUBLE PRECISION
C                       VECTOR CONTAINING L2
C                       SAVED  FUNCTIONAL VALUES OF NEGATIVE ABSCISSAS
C
C              L1     - INTEGER
C              L2       NUMBER OF ELEMENTS IN FV1,FV2  RESPECTIVELY
C
C***ROUTINES CALLED  F
C
      DOUBLE PRECISION F,XL,XU,LDL,Y,YA,YM,Y2,XX(41),WW(52),
     *                 FV1(21),FV2(21),AA,BB,C
      EXTERNAL F
      INTEGER ISTART(4),LEN(4),KE,K1,L1,L2
      integer i, is, k, ks
      intrinsic dabs
      SAVE ISTART,LEN,XX,WW
      DATA ISTART/0, 7, 17, 31/,LEN/7, 10, 14, 21/
      DATA XX(  1)/.0                       /
      DATA XX(  2)/.25000000000000000000D+00/
      DATA XX(  3)/.50000000000000000000D+00/
      DATA XX(  4)/.75000000000000000000D+00/
      DATA XX(  5)/.87500000000000000000D+00/
      DATA XX(  6)/.93750000000000000000D+00/
      DATA XX(  7)/.10000000000000000000D+01/
      DATA XX(  8)/.37500000000000000000D+00/
      DATA XX(  9)/.62500000000000000000D+00/
      DATA XX( 10)/.96875000000000000000D+00/
      DATA XX( 11)/.12500000000000000000D+00/
      DATA XX( 12)/.68750000000000000000D+00/
      DATA XX( 13)/.81250000000000000000D+00/
      DATA XX( 14)/.98437500000000000000D+00/
      DATA XX( 15)/.18750000000000000000D+00/
      DATA XX( 16)/.31250000000000000000D+00/
      DATA XX( 17)/.43750000000000000000D+00/
      DATA XX( 18)/.56250000000000000000D+00/
      DATA XX( 19)/.84375000000000000000D+00/
      DATA XX( 20)/.90625000000000000000D+00/
      DATA XX( 21)/.99218750000000000000D+00/
C   NUMBER OF NODES 13
      DATA WW(1)/1.303262173284849021810473057638590518409112513421D-1/
      DATA WW(2)/2.390632866847646220320329836544615917290026806242D-1/
      DATA WW(3)/2.630626354774670227333506083741355715758124943143D-1/
      DATA WW(4)/2.186819313830574175167853094864355208948886875898D-1/
      DATA WW(5)/2.757897646642836865859601197607471574336674206700D-2/
      DATA WW(6)/1.055750100538458443365034879086669791305550493830D-1/
      DATA WW(7)/1.571194260595182254168429283636656908546309467968D-2/
C   NUMBER OF NODES 19
      DATA WW(8)/1.298751627936015783241173611320651866834051160074D-1/
      DATA WW(9)/2.249996826462523640447834514709508786970828213187D-1/
      DATA WW(15)/5.542699233295875168406783695143646338274805359780D-2/
      DATA WW(10)/1.680415725925575286319046726692683040162290325505D-1/
      DATA WW(16)/9.986735247403367525720377847755415293097913496236D-2/
      DATA WW(11)/1.415567675701225879892811622832845252125600939627D-1/
      DATA WW(12)/1.006482260551160175038684459742336605269707889822D-1/
      DATA WW(13)/2.510604860724282479058338820428989444699235030871D-2/
      DATA WW(17)/4.507523056810492466415880450799432587809828791196D-2/
      DATA WW(14)/9.402964360009747110031098328922608224934320397592D-3/
C   NUMBER OF NODES 27
      DATA WW(18)/6.300942249647773931746170540321811473310938661469D-2/
      DATA WW(28)/1.239572396231834242194189674243818619042280816640D-1/
      DATA WW(19)/1.261383225537664703012999637242003647020326905948D-1/
      DATA WW(25)/1.235837891364555000245004813294817451524633100256D-1/
      DATA WW(20)/1.273864433581028272878709981850307363453523117880D-1/
      DATA WW(26)/1.148933497158144016800199601785309838604146040215D-1/
      DATA WW(29)/2.501306413750310579525950767549691151739047969345D-2/
      DATA WW(21)/8.576500414311820514214087864326799153427368592787D-2/
      DATA WW(30)/4.915957918146130094258849161350510503556792927578D-2/
      DATA WW(22)/7.102884842310253397447305465997026228407227220665D-2/
      DATA WW(23)/5.026383572857942403759829860675892897279675661654D-2/
      DATA WW(27)/1.252575774226122633391477702593585307254527198070D-2/
      DATA WW(31)/2.259167374956474713302030584548274729936249753832D-2/
      DATA WW(24)/4.683670010609093810432609684738393586390722052124D-3/
C   NUMBER OF NODES 41
      DATA WW(32)/6.362762978782724559269342300509058175967124446839D-2/
      DATA WW(42)/1.187141856692283347609436153545356484256869129472D-1/
      DATA WW(46)/1.533126874056586959338368742803997744815413565014D-2/
      DATA WW(33)/9.950065827346794643193261975720606296171462239514D-2/
      DATA WW(47)/3.527159369750123100455704702965541866345781113903D-2/
      DATA WW(39)/8.140326425945938045967829319725797511040878579808D-2/
      DATA WW(48)/5.000556431653955124212795201196389006184693561679D-2/
      DATA WW(34)/7.048220002718565366098742295389607994441704889441D-2/
      DATA WW(49)/5.744164831179720106340717579281831675999717767532D-2/
      DATA WW(40)/6.583213447600552906273539578430361199084485578379D-2/
      DATA WW(43)/5.999947605385971985589674757013565610751028128731D-2/
      DATA WW(35)/6.512297339398335645872697307762912795346716454337D-2/
      DATA WW(44)/5.500937980198041736910257988346101839062581489820D-2/
      DATA WW(50)/1.598823797283813438301248206397233634639162043386D-2/
      DATA WW(36)/3.998229150313659724790527138690215186863915308702D-2/
      DATA WW(51)/2.635660410220884993472478832884065450876913559421D-2/
      DATA WW(37)/3.456512257080287509832054272964315588028252136044D-2/
      DATA WW(41)/2.592913726450792546064232192976262988065252032902D-2/
      DATA WW(45)/5.264422421764655969760271538981443718440340270116D-3/
      DATA WW(52)/1.196003937945541091670106760660561117114584656319D-2/
      DATA WW(38)/2.212167975884114432760321569298651047876071264944D-3/
C
C***FIRST EXECUTABLE STATEMENT DQXRUL
      K=KE+1
      IS=ISTART(K)
      KS=LEN(K)
      LDL= XU-XL
      BB= LDL*0.5D0
      AA= XL+BB
      Y =0.D0
      DO 100 I=1,KS
         IF(I.GT.L1.OR.I.GT.L2)   C=BB*XX(I)
         IF(I.GT.L1)              FV1(I)=F(AA+C)
         IF(I.GT.L2)              FV2(I)=F(AA-C)
100      Y=Y+(FV1(I)+FV2(I))*WW(IS+I)
      Y2=Y
      Y=Y*BB
      IF(L1.LT.KS)L1=KS
      IF(L2.LT.KS)L2=KS
      IF(KE.NE.K1)RETURN
      YA=0.D0
      DO 25 I=1,KS
  25    YA=YA+(DABS(FV1(I))+DABS(FV2(I)))*WW(IS+I)
      Y2=Y2*0.5D0
      YM=0.D0
      YA=YA*DABS(BB)
      DO 27 I=1,KS
   27 YM=YM+(DABS(FV1(I)-Y2)+DABS(FV2(I)-Y2))*WW(IS+I)
      YM=YM*DABS(BB)
      RETURN
      END
C
C
C
C
      SUBROUTINE DQXRRD(F,Z,LZ,XL,XU,R,S,LR,LS)
C
C            TO REORDER THE COMPUTED FUNCTIONAL VALUES BEFORE
C            THE BISECTION OF AN INTERVAL
C           PARAMETERS
C            ON ENTRY
C              F      - DOUBLE PRECISION
C                       FUNCTION SUBPROGRAM DEFINING THE INTEGRAND
C                       FUNCTION F(X). THE ACTUAL NAME FOR F NEEDS TO BE
C                       DECLARED E X T E R N A L IN THE DRIVER PROGRAM.
C
C              XL     - DOUBLE PRECISION
C                       LOWER LIMIT OF INTERVAL
C
C              XU     - DOUBLE PRECISION
C                       UPPER LIMIT OF INTERVAL
C
C              Z      - DOUBLE PRECISION
C                       VECTOR CONTAINING LZ
C                       SAVED  FUNCTIONAL VALUES
C
C              LZ     - INTEGER
C                       NUMBER OF ELEMENTS IN LZ
C
C
C            ON RETURN
C              R      - DOUBLE PRECISION
C              S        VECTORS CONTAINING LR, LS
C                       SAVED  FUNCTIONAL VALUES FOR THE NEW INTERVALS
C
C              LR     - INTEGER
C              LS       NUMBER OF ELEMENTES IN R,S RESPECTIVELY
C
C***ROUTINES CALLED  F
C
      DOUBLE PRECISION F,R,S,Z,XU,XL,DLEN,CENTR
      INTEGER LR,LS,LZ
      DIMENSION R(21),S(21),Z(21)
C***FIRST EXECUTABLE STATEMENT DQXRRD
      DLEN= (XU-XL)*0.5D0
      CENTR= XL+DLEN
      R(1)=  Z(3)
      R(2)=  Z(9)
      R(3)=  Z(4)
      R(4)=  Z(5)
      R(5)=  Z(6)
      R(6)=  Z(10)
      R(7)=  Z(7)
      S(1)=  Z(3)
      S(2)=  Z(8)
      S(3)=  Z(2)
      S(7)=  Z(1)
      IF(LZ.GT.11)GOTO 2
      R(8)=  F(CENTR+DLEN*0.37500000D0)
      R(9)=  F(CENTR+DLEN*0.62500000D0)
      R(10)=  F(CENTR+DLEN*0.96875000D0)
      LR=  10
      IF(LZ.NE.11)S(4)=  F(CENTR-DLEN*0.75000000D0)
      IF(LZ.EQ.11)S(4)=  Z(11)
      S(5)=  F(CENTR-DLEN*0.87500000D0)
      S(6)=  F(CENTR-DLEN*0.93750000D0)
      S(8)=  F(CENTR-DLEN*0.37500000D0)
      S(9)=  F(CENTR-DLEN*0.62500000D0)
      S(10)=  F(CENTR-DLEN*0.96875000D0)
      LS=  10
      GOTO 3000
2     R(8)= Z(12)
      R(9)= Z(13)
      R(10)= Z(14)
      LR=  10
      S(4)= Z(11)
      S(5)= F(CENTR-DLEN*0.87500000D0)
      S(6)= F(CENTR-DLEN*0.93750000D0)
      IF(LZ.GT.14)GOTO3
      S(8)= F(CENTR-DLEN*0.37500000D0)
      S(9)= F(CENTR-DLEN*0.62500000D0)
      S(10)= F(CENTR-DLEN*0.96875000D0)
      LS=  10
      GOTO 3000
3     R(11)= Z(18)
      R(12)= Z(19)
      R(13)= Z(20)
      R(14)= Z(21)
      LR=  14
      S(8)= Z(16)
      S(9)= Z(15)
      S(10)= F(CENTR-DLEN*0.96875000D0)
      S(11)= Z(17)
      LS=  11
3000  RETURN
      END
C
C
C
C
      SUBROUTINE DQXCPY(A,B,L)
C
C  TO COPY THE DOUBLE PRECISION VECTOR B OF LENGTH L   I N T O
C          THE DOUBLE PRECISION VECTOR A OF LENGTH L
C
C***REMARK  THIS ROUTINE CAN BE IMPROVED, BY CODING IT IN THE
C           ASSEMBLER LANGUAGE OF THE USED MACHINE
C***ROUTINES CALLED  (NONE)
C
      INTEGER L
      integer i
      DOUBLE PRECISION A(L),B(L)
C***FIRST EXECUTABLE STATEMENT DQXCPY
      DO 1 I=1,L
1     A(I)=B(I)
      RETURN
      END
C
C
